ActionQueue_RegularSpellRunning = false;
ActionQueue_ChannelSpellRunningStarted = 0;
ActionQueue_ChannelSpellRunning = false;
ActionQueue_RegularSpellRunningStarted = 0;
ActionQueue_TimeSpellStopped = 0;

function ActionQueue_IsSomeSpellRunning(name, maxTime)
	if ( not maxTime ) then
		maxTime = 15;
	end
	local boolName = format("ActionQueue_%sSpellRunning", name);
	local startedName = format("ActionQueue_%sSpellRunningStarted", name);
	local boolValue = getglobal(boolName);
	local startedValue = getglobal(startedName);
	if ( boolValue == true ) then
		local curTime = GetTime();
		if ( ( startedValue + 15 ) < curTime ) then
			boolValue = false;
			setglobal(boolName, false);
		end
	end
	return boolValue;
end

function ActionQueue_IsChannelSpellRunning()
	return ActionQueue_IsSomeSpellRunning("Channel");
end

function ActionQueue_IsRegularSpellRunning()
	return ActionQueue_IsSomeSpellRunning("Regular");
end

function ActionQueue_IsAnySpellRunning()
	if ( ActionQueue_IsSomeSpellRunning("Channel") ) then
		return true;
	elseif ( ActionQueue_IsSomeSpellRunning("Regular") ) then
		return true;
	else
		return false;
	end
end

function ActionQueueUtil_OnLoad()
	local f = ActionQueueUtilFrame;
	f:RegisterEvent("PLAYER_DEAD");
	f:RegisterEvent("SPELLCAST_STOP");
	f:RegisterEvent("SPELLCAST_START");
	f:RegisterEvent("SPELLCAST_CHANNEL_START");
	f:RegisterEvent("SPELLCAST_INTERRUPTED");
	f:RegisterEvent("SPELLCAST_FAILED");
end

function ActionQueueUtil_OnEvent(event)
	if ( event == "PLAYER_DEAD" ) then
		ActionQueue_ChannelSpellRunning = false;
		ActionQueue_ChannelSpellRunningStarted = 0;
		ActionQueue_RegularSpellRunning = false;
		ActionQueue_TimeSpellStopped = GetTime();
	end
	if ( event == "SPELLCAST_STOP" ) then
		ActionQueue_ChannelSpellRunning = false;
		ActionQueue_ChannelSpellRunningStarted = 0;
		ActionQueue_RegularSpellRunning = false;
		ActionQueue_RegularSpellRunningStarted = 0;
		ActionQueue_TimeSpellStopped = GetTime();	
	end
	if ( event == "SPELLCAST_START" ) then
		ActionQueue_RegularSpellRunning = true;	
		ActionQueue_RegularSpellRunningStarted = GetTime();
	end
	if ( event == "SPELLCAST_CHANNEL_START") then
		ActionQueue_ChannelSpellRunning = true;
		ActionQueue_ChannelSpellRunningStarted = GetTime();
	end
	if ( event == "SPELLCAST_INTERRUPTED" ) or ( event == "SPELLCAST_FAILED" ) then
		ActionQueue_RegularSpellRunning = false;
		ActionQueue_RegularSpellRunningStarted = 0;
		ActionQueue_ChannelSpellRunning = false;	
		ActionQueue_ChannelSpellRunningStarted = 0;
	end	
end

ActionQueue_GlobalStringTranslated = {
};

ActionQueue_GlobalStringTranslations = {
	["%%s"] = "%(%.+%)",
	["%%d"] = "%(%%d%)",
};
function ActionQueue_GlobalStringTogfind(str)
	if ( not str ) then
		return nil;
	end
	if ( ActionQueue_GlobalStringTranslated[str] ) then
		return ActionQueue_GlobalStringTranslated[str];
	end
	local retStr = str;
	for k, v in ActionQueue_GlobalStringTranslations do
		retStr = string.gsub(retStr, k, v);
	end
	ActionQueue_GlobalStringTranslated[str] = retStr;
	return retStr;
end

ActionQueue_ShowMessageDefaultParams = {
	r = 1.0,
	g = 0.2,
	b = 0.2,
	sound = "MapPing",
};

function ActionQueue_ShowMessage(msg, r, g, b, extraParams)
	local params = {};
	for k, v in ActionQueue_ShowMessageDefaultParams do
		params[k] = v;
	end
	if ( r ) and ( type(r) == "table" ) then
		extraParams = r;
		r = nil;
	end
	if ( r ) and ( g ) and ( b ) then
		params.r = r;
		params.g = g;
		params.b = b;
	end
	if ( extraParams ) then
		for k, v in extraParams do
			params[k] = v;
		end
	end
	ActionQueueMessageFrameText:SetTextColor(params.r, params.g, params.b);
	ActionQueueMessageFrameText:SetText(message);
    ActionQueueMessageFrame.startTime = GetTime();
	PlaySound(params.sound);
    ActionQueueMessageFrame:Show();
end
