-- CONSTANTS START

ALWAYSFIND_ACTIONQUEUE_ID = "AlwaysFind";

-- CONSTANTS END

-- SETTINGS START

-- how often it should check if Perception has cooled down (in seconds)
-- this could be subject to adjustment
AlwaysFind_UpdateFrequency = 1;

-- SETTINGS END

-- VARIABLES START

AlwaysFind_ListOfSpells = {
	ALWAYSFIND_FIND_HERBS_NAME,
	ALWAYSFIND_FIND_MINERALS_NAME,
	ALWAYSFIND_FIND_TREASURE_NAME
};

AlwaysFind_LastSpellName = nil;

AlwaysFind_LastUpdate = 0;
AlwaysFind_LastId = nil;

-- SETTINGS END


-- FUNCTIONS START

-- entry to add to the ActionQueue. Prepared with some concern.
AlwaysFind_Queue_Entry = {
	id = ALWAYSFIND_ACTIONQUEUE_ID;
	spellId = nil; -- not known until we first try to cast it
	shouldExecuteFunc = ActionQueue_ShouldExecuteFunction_ASAP;
	executeFunc = ActionQueue_ExecuteFunction_Spell;
	name = ALWAYSFIND_PERCEPTION_NAME;
};


function AQ_AlwaysFind_OnLoad()
	-- make sure we get to know when the client variables are all loaded in and pretty
	local frame = AQ_AlwaysFindFrame;
	frame:RegisterEvent("VARIABLES_LOADED");
	frame:RegisterEvent("SPELLS_CHANGED");
	frame:RegisterEvent("LEARNED_SPELL_IN_TAB");
end

function AQ_AlwaysFind_OnEvent(event)
	-- when client variables are loaded, start using Perception
	if ( event == "VARIABLES_LOADED" ) then
		local frame = AQ_AlwaysFindFrame;
		frame:UnregisterEvent(event);
		AQ_AlwaysFind_Enable();
		return;
	end
	if ( event == "SPELLS_CHANGED" ) or ( event == "LEARNED_SPELL_IN_TAB" ) then
		AlwaysFind_LastSpellName = nil;
		local spellName = AQ_AlwaysFind_GetSpellName();
		if ( spellName ) then
			AQ_AlwaysFind_Enable();
		else
			AQ_AlwaysFind_Disable();
		end
	end
end

-- Enable AQ_AlwaysFind.
function AQ_AlwaysFind_Enable()
	-- show the frame to allow OnUpdates to occur
	local frame = AQ_AlwaysFindFrame;
	frame:Show();
end

-- Disable AQ_AlwaysFind.
function AQ_AlwaysFind_Disable()
	-- hide the frame to prevent OnUpdates from occurring (saving a few cycles)
	local frame = AQ_AlwaysFindFrame;
	frame:Hide();
end

-- Retrive the desired spell name.
function AQ_AlwaysFind_GetSpellName()
	if ( not AlwaysFind_LastSpellName ) then
		local id = nil;
		for k, spellName in AlwaysFind_ListOfSpells do
			id = ActionQueue_FindSpellId(spellName); 
			if ( id ) and ( id > 0 ) then
				AlwaysFind_LastId = id;
				AlwaysFind_LastSpellName = spellName;
				break;
			end
		end
	end
	return AlwaysFind_LastSpellName;
end

function AQ_AlwaysFind_OnUpdate(elapsed)
	local curTime = GetTime();
	-- if more than AlwaysFind_UpdateFrequency seconds has passed
	if ( ( curTime - AlwaysFind_LastUpdate ) > AlwaysFind_UpdateFrequency ) then
		AlwaysFind_LastUpdate = curTime;
		-- tracking is already present
		if ( GetTrackingTexture() ) then
			return false;
		end
		-- skill not in queue: see if it's time to re-queue it
		if ( not ActionQueue_IsQueued(ALWAYSFIND_ACTIONQUEUE_ID) ) then
			local id = nil;
			local spellName = AQ_AlwaysFind_GetSpellName();
			if ( not spellName ) then
				AQ_AlwaysFind_Disable();
				return false;
			end
			-- optimization: if we retrieved the id before and it has not changed, why re-retrive it?
			if ( AlwaysFind_LastId ) then
				local name = GetSpellName(AlwaysFind_LastId, "spell");
				if ( name == spellName ) then
					id = AlwaysFind_LastId;
				end
			end
			if ( not id ) then 
				id = ActionQueue_FindSpellId(spellName); 
			end
			-- OK, did we find a valid id?
			if ( id ) and ( id > 0 ) then
				-- make sure we cache the found spell
				AlwaysFind_LastId = id;
				-- skill found: queue it up
				AlwaysFind_Queue_Entry.spellId = id;
				local start, duration, enable = GetSpellCooldown(id, "spell");
				if ( start + duration <= 0 ) then
					ActionQueue_QueueAction(AlwaysFind_Queue_Entry);
				end
			else
				-- skill not found: disable the addon
				AQ_AlwaysFind_Disable()
			end
		end
	end
end

-- FUNCTIONS END
