-- default options
AQ_BuffBot_Options = {
	["enabled"] = true,
	["links"] = {
		--[[
			allowed fields:
			health - decimal value, amount of current health that is required to trigger
			mana - decimal value, amount of current mana that is required to trigger
			healthPercentage - decimal value, percentage of total health that is required to trigger
			manaPercentage - decimal value, percentage of total mana that is required to trigger
			notInCombat - boolean, if true will not be triggered in combat
			onlyInCombat - boolean, if true will only be triggered in combat
			applyOncePerPartyMember - boolean, if true will execute funcName with 6 times, with a proper party/self/pet unit
			iterativeParameters - will cause funcName to be called once per every table in it until it returns true
		]]--
		[1] = {
			["manaPercentage"] = 5,
			["healthPercentage"] = 10,
			["funcName"] = "BuffBot_JustCure",
			["applyOncePerPartyMember"] = true,
			["onlySelf"] = false
		},
		[2] = {
			["manaPercentage"] = 10,
			["healthPercentage"] = 15,
			["funcName"] = "BuffBot_JustBuff",
			["applyOncePerPartyMember"] = true,
			["onlySelf"] = false
		},
	}
};

AQ_BuffBot_applyOncePerPartyMemberList = {
	"player",
	"pet",
	"party1",
	"party2",
	"party3",
	"party4"
};

function AQ_BuffBot_SetNewState(enabled)
	local isQueued = ActionQueue_IsQueued(AQBUFFBOT_ID);
	if ( enabled ) then
		if ( not isQueued ) then
			ActionQueue_QueueSpellAdvanced(AQ_BuffBot_Entry);
		end
	end
	AQ_BuffBot_Options.enabled = enabled;
end

function AQ_BuffBot_ActionQueueShouldBeRemovedCallback(entry)
	if ( AQ_BuffBot_Options.enabled ) then
		return false;
	else
		return true;
	end
end

function AQ_BuffBot_ExecuteFunction_Rebuff(unit)
	local list = Rebuff_Problem_Units[unit];
	if ( list ) then
		for k, v in list do
			if ( Rebuff_RebuffUnit(unit, v) ) then
				return true;
			end
		end
	end
	return false;
end

function AQ_BuffBot_DoExecute(entry, link)
	local func = getglobal(link.funcName);
	if ( func ) then
		if ( link.onlySelf ) then
			if ( func("player") ) then
				return true;
			end
		else
			if ( link.applyOncePerPartyMember ) then
				for key, value in AQ_BuffBot_applyOncePerPartyMemberList do
					if ( UnitExists(value) ) and ( not UnitIsDead(value) ) then
						if ( func(value) ) then
							return true;
						end
					end
				end
			end
			if ( not link.iterativeParameters ) or ( table.getn(link.iterativeParameters) <= 0 ) then
				args = link.args;
				if ( not args ) then args = {}; end
				if ( func(unpack(args)) ) then
					return true;
				end
			else
				for key, value in link.iterativeParameters do
					args = value;
					if ( not args ) then args = {}; end
					if ( func(unpack(args)) ) then
						return true;
					end
				end
			end
		end
	end
	return false;
end

function AQ_BuffBot_IsBuffSelfBuff(spell)
	for k, v in AQ_BuffBot_SelfBuffs do
		if ( v == spell ) then
			return true;
		end
	end
	return false;
end


function AQ_BuffBot_BuffSelf()
	local buffs = BuffBot_Data.spell_predata[_class];
	if ( not buffs ) then
		return false;
	end
	local selfBuffs = buffs['Self Buffs'];
	if ( not selfBuffs ) then
		return false;
	end
	local tmpBuff = nil;
	local lesserOf = nil;
	local Buff_Duration = nil;
	local Buff_Refresh  = nil;
	local Time_Since_Buff = nil;
	local buff_id = nil;
	local shouldContinue = true;
	for k, v in selfBuffs do
		shouldContinue = true;
		if ( v ~= 1 ) then
			shouldContinue = false;
		end
		if ( shouldContinue ) then
			tmpBuff = buffs[k];
			if ( not AQ_BuffBot_IsBuffSelfBuff(k) ) then
				shouldContinue = false;
			end
		end
		if ( shouldContinue ) then
			lesserOf = buffs[k]['Lesser of'];
			if ( lesserOf ) then
				buff_id = Spell_ID_By_Level(lesserOf,UnitLevel("player"));
				if ( buff_id ) then
					shouldContinue = false;
				end
			end
		end
		if ( shouldContinue ) then
			local shouldBuff = false;
			if ( not Find_Buff(buff, "player") ) then
				shouldBuff = true;
			else
				Time_Since_Buff = GetTime() - buffs_cast["player"][k];
				Buff_Duration = buffs[k]['Duration'];
				Buff_Refresh  = buffs[k]['Refresh'];
				if (Buff_Duration - Time_Since_Buff < Buff_Refresh  ) then
					shouldBuff = true;
				end
			end
			if ( shouldBuff ) then
				buff_id = Spell_ID_By_Level(k,UnitLevel("player"));
				if ( buff_id ) then
					CastSpell(buff_id, SpellBookFrame.bookType);
					Casting_Buff = true
					Casting_Buff_Unit = "player";
					Casting_Buff_Buff = k;
					return true;
				end
			end
		end
	end
	-- handle weapon buffs
	if buffs['Weapon Buffs'] then
		for buff,data in buffs['Weapon Buffs'] do
			if Apply_Buff("player",buff) then return true end
		end
	end
	return false;
end

function AQ_BuffBot_ActionQueueCallback(entry)
	if ( not AQ_BuffBot_Options.enabled ) then
		return false;
	end
	if ( entry ) then
		ActionQueue_QueueSpellAdvanced(entry);
	end
	if ( AQ_BuffBot_IsAnySpellRunning() ) then
		return false;
	end
	if ( IsResting() ) and ( not UnitIsPVPFreeForAll("player") ) and ( not UnitIsPVP("player") ) then
		return false;
	end
	if ( ActionQueue_IsShapeshifter ) then
		if ( ActionQueue_Shapeshifted ) then
			return false;
		end
		if ( ActionQueue_LastShapeshifted ) and ( curTime - ActionQueue_LastShapeshifted < ACTIONQUEUE_SHAPESHIFT_INHIBIT_TIME ) then
			return false;
		else
			ActionQueue_LastShapeshifted = nil;
		end
	end
	if ( ActionQueue_IsMounted() ) or ( UnitOnTaxi("player") ) then
		return false;
	end
	if ( not BuffBot_Installed ) then
		return false;
	end
	if ( AQ_BuffBot_BuffSelf() ) then
		return true;
	end
	if ( UnitExists("target") ) and ( not UnitCanAttack("target", "player") ) then
		return false;
	end
	local playerHealth = UnitHealth("player");
	local playerHealthPercentage = (UnitHealth("player")/UnitHealthMax("player"))*100;
	local playerMana = UnitMana("player");
	local playerManaPercentage = (UnitMana("player")/UnitManaMax("player"))*100;
	local executeFunc = false;
	local isInCombat = false;
	if ( PlayerFrame.inCombat ) then
		isInCombat = true;
	end
	for k, v in AQ_BuffBot_Options.links do
		executeFunc = true;
		if ( v.notInCombat ) and ( isInCombat ) then
			executeFunc = false;
		end
		if ( v.onlyInCombat ) and ( not isInCombat ) then
			executeFunc = false;
		end
		if ( v.health ) and ( playerHealth < v.health ) then
			executeFunc = false;
		end
		if ( v.healthPercentage ) and ( playerHealthPercentage < v.healthPercentage ) then
			executeFunc = false;
		end
		if ( v.mana ) and ( playerMana < v.mana ) then
			executeFunc = false;
		end
		if ( v.manaPercentage ) and ( playerManaPercentage < v.manaPercentage ) then
			executeFunc = false;
		end
		if ( executeFunc ) then
			if ( AQ_BuffBot_DoExecute(entry, v) ) then
				return true;
			end
		end
	end
	return false;
end

AQ_BuffBot_Entry = {
	["id"] = AQBUFFBOT_ID,
	["name"] = AQBUFFBOT_NAME,
	["shouldBeRemovedFunc"] = AQ_BuffBot_ActionQueueShouldBeRemovedCallback,
	["shouldExecuteFunc"] = ActionQueue_ShouldExecuteFunction_ASAP,
	["executeFunc"] = AQ_BuffBot_ActionQueueCallback,
	["priority"] = ACTIONQUEUE_LOWEST_PRIORITY,
};

function AQ_BuffBot_OnLoad()
	ActionQueue_QueueSpellAdvanced(AQ_BuffBot_Entry);
	local f = AQ_BuffBotFrame;
	f:RegisterEvent("PLAYER_DEAD");
	f:RegisterEvent("SPELLCAST_STOP");
	f:RegisterEvent("SPELLCAST_START");
	f:RegisterEvent("SPELLCAST_CHANNEL_START");
	f:RegisterEvent("SPELLCAST_INTERRUPTED");
	f:RegisterEvent("SPELLCAST_FAILED");
end

AQ_BuffBot_RegularSpellRunning = false;
AQ_BuffBot_ChannelSpellRunningStarted = 0;
AQ_BuffBot_ChannelSpellRunning = false;
AQ_BuffBot_RegularSpellRunningStarted = 0;
AQ_BuffBot_TimeSpellStopped = 0;

function AQ_BuffBot_IsSomeSpellRunning(name, maxTime)
	if ( not maxTime ) then
		maxTime = 15;
	end
	local boolName = format("AQ_BuffBot_%sSpellRunning", name);
	local startedName = format("AQ_BuffBot_%sSpellRunningStarted", name);
	local boolValue = getglobal(boolName);
	local startedValue = getglobal(startedName);
	if ( boolValue == true ) then
		local curTime = GetTime();
		if ( ( startedValue + 15 ) < curTime ) then
			boolValue = false;
			setglobal(boolName, false);
		end
	end
	return boolValue;
end

function AQ_BuffBot_IsChannelSpellRunning()
	return AQ_BuffBot_IsSomeSpellRunning("Channel");
end

function AQ_BuffBot_IsRegularSpellRunning()
	return AQ_BuffBot_IsSomeSpellRunning("Regular");
end

function AQ_BuffBot_IsAnySpellRunning()
	if ( AQ_BuffBot_IsSomeSpellRunning("Channel") ) then
		return true;
	elseif ( AQ_BuffBot_IsSomeSpellRunning("Regular") ) then
		return true;
	else
		return false;
	end
end

function AQ_BuffBot_OnEvent(event)
	if ( event == "PLAYER_DEAD" ) then
		AQ_BuffBot_ChannelSpellRunning = false;
		AQ_BuffBot_ChannelSpellRunningStarted = 0;
		AQ_BuffBot_RegularSpellRunning = false;
		AQ_BuffBot_TimeSpellStopped = GetTime();
	end
	if ( event == "SPELLCAST_STOP" ) then
		AQ_BuffBot_ChannelSpellRunning = false;
		AQ_BuffBot_ChannelSpellRunningStarted = 0;
		AQ_BuffBot_RegularSpellRunning = false;
		AQ_BuffBot_RegularSpellRunningStarted = 0;
		AQ_BuffBot_TimeSpellStopped = GetTime();	
	end
	if ( event == "SPELLCAST_START" ) then
		AQ_BuffBot_RegularSpellRunning = true;	
		AQ_BuffBot_RegularSpellRunningStarted = GetTime();
	end
	if ( event == "SPELLCAST_CHANNEL_START") then
		AQ_BuffBot_ChannelSpellRunning = true;
		AQ_BuffBot_ChannelSpellRunningStarted = GetTime();
	end
	if ( event == "SPELLCAST_INTERRUPTED" ) or ( event == "SPELLCAST_FAILED" ) then
		AQ_BuffBot_RegularSpellRunning = false;
		AQ_BuffBot_RegularSpellRunningStarted = 0;
		AQ_BuffBot_ChannelSpellRunning = false;	
		AQ_BuffBot_ChannelSpellRunningStarted = 0;
	end	
end
