ACTIONQUEUE_MINIMUM_TIME_BETWEEN_UPDATES = 0.1;

ACTIONQUEUE_LOWEST_PRIORITY			= -1000;
ACTIONQUEUE_NORMAL_PRIORITY			= 0;
ACTIONQUEUE_HIGHEST_PRIORITY		= 5000;

ACTIONQUEUE_SHAPESHIFT_ICONS		= {
	"Interface\\Icons\\Ability_Druid_CatForm",
	"Interface\\Icons\\Ability_Druid_TravelForm",
	"Interface\\Icons\\Ability_Racial_BearForm",
	"Interface\\Icons\\Ability_Druid_AquaticForm",
	"Interface\\Icons\\Spell_Nature_SpiritWolf",
};

ACTIONQUEUE_SHAPESHIFT_INHIBIT_TIME = 7;

ACTIONQUEUE_CLASS_SHAPESHIFTERS		= {
	ACTIONQUEUE_CLASS_DRUID,
	ACTIONQUEUE_CLASS_SHAMAN,
};


ActionQueue_LastUpdated = nil;

ActionQueue_Queue = {};

function ActionQueue_OnLoad()
	ActionQueue_Queue = {};
	local f = ActionQueueFrame;
	f:RegisterEvent("VARIABLES_LOADED");
	f:RegisterEvent("UNIT_AURA");
	f:RegisterEvent("PLAYER_AURAS_CHANGED");
end

function ActionQueue_IsUnitShapeshifter(unit)
	local class = UnitClass(unit);
	for k, v in ACTIONQUEUE_CLASS_SHAPESHIFTERS do
		if ( v == class ) then
			return true;
		end
	end
	return false;
end

function ActionQueue_UpdateShapeshift()
	ActionQueue_WasShapeshifted = ActionQueue_Shapeshifted;
	ActionQueue_Shapeshifted = ActionQueue_IsShapeshifted();
	if ( ActionQueue_Shapeshifted ) or ( ( ActionQueue_WasShapeshifted ) and ( not ActionQueue_Shapeshifted ) ) then
		ActionQueue_LastShapeshifted = curTime;
	end
end

ActionQueue_IsShapeshifter_Value = false;

function ActionQueue_IsShapeshifter()
	if ( ActionQueue_IsShapeshifter_Value ) then
		return true;
	end
	ActionQueue_IsShapeshifter_Value = ActionQueue_IsUnitShapeshifter("player");
	return ActionQueue_IsShapeshifter_Value;
end

function ActionQueue_OnEvent(event)
	local curTime = GetTime();
	if ( event == "VARIABLES_LOADED" ) then
		if ( ActionQueue_SetupOverrideBinding ) then
			ActionQueue_SetupOverrideBinding();
		end
	end
	if ( event == "UNIT_AURA" ) then
		if ( arg1 == "player" ) then
			if ( ActionQueue_IsShapeshifter() ) then
				ActionQueue_UpdateShapeshift();
			end
		end
	end
	if ( event == "PLAYER_AURAS_CHANGED" ) then
		if ( ActionQueue_IsShapeshifter() ) then
			ActionQueue_UpdateShapeshift();
		end
	end
end


-- Cast as soon as possible. Never expires.
function ActionQueue_ShouldExecuteFunction_ASAP(t)
	return true;
end

-- used to see if a certain time has passed and/or has yet to come.
function ActionQueue_ShouldExecuteFunction_Time(t)
	local curTime = GetTime();
	if ( ( not t.before ) or ( t.before < t ) ) and
		( ( not t.after ) or ( t.after > t ) ) then
		return true;
	else
		return false;
	end
end

-- Used to see if a certain time has passed and/or has yet to come.
function ActionQueue_ShouldBeRemovedFunction_Time(t)
	if ( not t.before ) and ( not t.after ) then
		return true;
	end
	local curTime = GetTime();
	if ( ( t.before ) and ( t.before >= t ) ) then
		return true;
	end
	return false;
end

-- Returns the spell id or nil .
function ActionQueue_FindSpellId(spellName, spellRank, spellBook, startId)
	if ( not startId ) then
		startId = 1;
	end
	if ( not spellBook ) then
		spellBook = "spell";
	end
	if ( DynamicData ) and ( DynamicData.spell ) and ( DynamicData.spell.getMatchingSpellId ) then
		return DynamicData.spell.getMatchingSpellId(spellName, spellRank, spellBook, nil, startId);
	end
	spellName = string.lower(spellName);
	if ( spellRank ) then
		spellRank = string.lower(spellRank);
	end
	local ok = true;
	local name, rank;
	local i = startId;
	local tmp = nil;
	local highestId = nil;
	while ( ok ) do
		name, rank = GetSpellName(i, spellBook);
		if ( not name ) then
			break;
		end
		name = string.lower(name);
		if ( name == spellName ) then
			if ( spellRank ) then
				if ( rank ) then
					rank = string.lower(rank);
					if ( rank == spellRank ) then
						return i;
					end
				end
			else
				highestId = i;
			end	
		end
		i = i + 1;
	end
	return highestId;
end

-- Queues a spell. 
-- It defaults to using shouldExecuteFunc = ActionQueue_ShouldExecuteFunction_ASAP 
-- and executeFunc = ActionQueue_ExecuteFunction_Spell.
-- extraParams can contain a table with key => values to override the defaults.
function ActionQueue_QueueSpell(spellId, spellBook, target, extraParams)
	local t = {};
	t.spellId = spellId;
	t.spellBook = spellBook;
	t.shouldExecuteFunc = ActionQueue_ShouldExecuteFunction_ASAP;
	t.executeFunc = ActionQueue_ExecuteFunction_Spell;
	t.target = target;
	if ( DynamicData ) and ( DynamicData.spell ) and ( DynamicData.spell.getSpellInfo ) then
		t.nameFunc = ActionQueue_NameFunction_DDSpellName;
	else
		t.nameFunc = ActionQueue_NameFunction_SpellName;
	end
	if ( extraParams ) and ( type(extraParams) == "table" ) then
		for k, v in extraParams do
			t[k] = v;
		end
	end
	return ActionQueue_QueueSpellAdvanced(t);
end

function ActionQueue_QueueSpellTable(t)
	return ActionQueue_QueueSpellAdvanced(t);
end

function ActionQueue_NameFunction_DDSpellName(t)
	if ( DynamicData ) and ( DynamicData.spell ) and ( DynamicData.spell.getSpellInfo ) then
		local info = DynamicData.spell.getSpellInfo(t.spellId, t.spellBook);
		if ( info ) and ( info.name ) and ( strlen(info.name) > 0 ) then
			return info.name;
		end
	end
	return nil;
end

function ActionQueue_NameFunction_SpellName(t)
	local id = t.spellId;
	if ( not id ) then
		return nil;
	end
	local spellBook = t.spellBook;
	if ( not spellBook ) then spellBook = "spell"; end
	local name, rank = GetSpellName(id, spellBook);
	return name;
end

function ActionQueue_NameFunction_SpellNameAndRank(t)
	local id = t.spellId;
	if ( not id ) then
		return nil;
	end
	local spellBook = t.spellBook;
	if ( not spellBook ) then spellBook = "spell"; end
	local name, rank = GetSpellName(id, spellBook);
	if ( name ) and ( rank ) and ( strlen(rank) > 0 ) then
		return name.." "..rank;
	else
		return name;
	end
end

function ActionQueue_OnUpdate()
	local curTime = GetTime();
	if ( not ActionQueue_LastUpdated ) or ( curTime - ActionQueue_LastUpdated >= ACTIONQUEUE_MINIMUM_TIME_BETWEEN_UPDATES ) then
		ActionQueue_LastUpdated = curTime;
		ActionQueue_DoUpdate();
	end
end

function ActionQueue_GetEntryName(entry)
	if ( not entry ) then
		return nil;
	end
	if ( entry.name ) then
		return entry.name;
	end
	local name = nil;
	if ( entry.nameFunc ) then
		name = entry.nameFunc(entry);
		if ( name ) then
			return name;
		end
	end
	if ( entry.spellId ) then
		name = ActionQueue_NameFunction_DDSpellName(entry);
		if ( not name ) then
			name = ActionQueue_NameFunction_SpellName(entry)
		end
		if ( name ) then
			entry.name = name;
			return name;
		end
	end
	return TEXT(ACTIONQUEUE_UNKNOWN_ENTRY_NAME);
end


-- Not yet used. 
-- Meant to remove "expired" entries.
-- if brief is not nil, it will only remove one expired entry.
function ActionQueue_DoMaintenence(brief)
	local ok = true;
	local keyValue = nil;
	while ( ok ) do
		ok = false;
		for k, v in ActionQueue_Queue do
			if ( v.shouldBeRemovedFunc ) and ( v.shouldBeRemovedFunc(v) ) then
				keyValue = k;
			end
		end
		if ( keyValue ) then
			table.remove(ActionQueue_Queue, keyValue);
			if ( not brief ) then
				ok = true;
			end
		end
	end
end

function ActionQueue_ExecuteFunction_Spell(t)
	local spellBook = "spell";
	if ( t.spellBook ) then
		spellBook = t.spellBook;
	end
	if ( t.spellId ) then
		CastSpell(t.spellId, spellBook);
		if ( t.target ) then
			SpellTargetUnit(t.target);
		end
		return true;
	end
	return false;
end

ACTIONQUEUE_MAX_ITERATIONS_PER_UPDATE = 100;

function ActionQueue_DoUpdate()
	local curTime = GetTime();
	if ( UnitIsDeadOrGhost("player") ) then
		return false;
	end
	local ok = true;
	local iters = 0;
	local maxIters = ACTIONQUEUE_MAX_ITERATIONS_PER_UPDATE;
	local n = table.getn(ActionQueue_Queue);
	if ( maxIters > n ) then
		maxIters = n;
	end
	while ( ok ) and ( iters < maxIters ) do
		ok = false;
		local keyValue = nil;
		for k, v in ActionQueue_Queue do
			if ( not v.shouldExecuteFunc ) or ( v.shouldExecuteFunc(v) ) then
				keyValue = k;
				break;
			end
		end
		if ( keyValue ) then
			local spellBook = "spell";
			local tmp = ActionQueue_Queue[keyValue];
			table.remove(ActionQueue_Queue, keyValue);
			if ( tmp.spellBook ) then
				spellBook = tmp.spellBook;
			end
			if ( tmp.executeFunc ) then
				tmp.lastExecuted = curTime;
				local retVal, timeFix = tmp.executeFunc(tmp);
				if ( retVal ) then
					if ( timeFix ) then
						ActionQueue_LastUpdated = curTime+timeFix;
					end
					return true;
				else
					ok = true;
				end
			elseif ( tmp.spellId ) then
				tmp.lastExecuted = curTime;
				if ( ActionQueue_ExecuteFunction_Spell(tmp) ) then
					return true;
				end
			else
				-- do nothing as it does not have recognized parameters.
			end
		end
		iters = iters + 1;
	end
	return false;
end

function ActionQueue_QueueItemComparator(item1, item2)
	if ( not item1 ) and ( not item2 ) then
		return true;
	elseif ( not item1 ) then
		return false;
	elseif ( not item2 ) then
		return true;
	end
	if ( item1.lastExecuted ) and ( item2.lastExecuted ) then
		if ( item1.lastExecuted < item2.lastExecuted ) then
			return true;
		else
			return false;
		end
	elseif ( item1.lastExecuted ) then
		return false;
	elseif ( item2.lastExecuted ) then
		return true;
	end
	if ( not item1.priority ) then item1.priority = ACTIONQUEUE_NORMAL_PRIORITY; end
	if ( not item2.priority ) then item2.priority = ACTIONQUEUE_NORMAL_PRIORITY; end
	if ( item1.priority == item2.priority ) then
	end
	if ( item1.priority > item2.priority ) then
		return true;
	else
		return false;
	end
end

function ActionQueue_QueueSpellAdvanced(info)
	if ( not info ) or ( not info.executeFunc ) then
		return false;
	end
	if ( not info.shouldBeRemovedFunc ) then
		if ( info.shouldExecuteFunc == ActionQueue_ShouldExecuteFunction_Time ) then
			info.shouldBeRemovedFunc = ActionQueue_ShouldBeRemovedFunction_Time;
		end
	end
	if ( info.priority ) then
		if ( info.priority > ACTIONQUEUE_HIGHEST_PRIORITY ) then
			info.priority = ACTIONQUEUE_HIGHEST_PRIORITY;
		elseif ( info.priority < ACTIONQUEUE_LOWEST_PRIORITY ) then
			info.priority = ACTIONQUEUE_LOWEST_PRIORITY;
		end
	end
	table.insert(ActionQueue_Queue, info);
	table.sort(ActionQueue_Queue, ActionQueue_QueueItemComparator);
	return true;
end
ActionQueue_QueueAction = ActionQueue_QueueSpellAdvanced;

function ActionQueue_IsQueued(identifier)
	local lId = identifier;
	if ( not lId ) then
		return false;
	end
	for k, v in ActionQueue_Queue do
		if ( v.id ) then
			if ( v.id == lId ) then
				return true;
			end
		end
	end
	return false;
end

ActionQueue_AutoMount_Mount_List={
"Spell_Nature_Swiftness",
"Ability_Mount",
"INV_Misc_Foot_Kodo",
}
function ActionQueue_AutoMount_GetMountBuffPosition()
	for i = 0, 15 do
		if not AutoMount_Texture then
			for k, v in ActionQueue_AutoMount_Mount_List do
				if GetPlayerBuffTexture(i) ~= nil then
					if (string.find(GetPlayerBuffTexture(i),v)) then
						AutoMount_Texture = GetPlayerBuffTexture(i);
						return i;
					end
				end
			end
		else
			if GetPlayerBuffTexture(i) == AutoMount_Texture then
				return i;
			end
		end
	end
	return -1;
end

function ActionQueue_IsMounted()
	if ( ActionQueue_AutoMount_GetMountBuffPosition() > -1 ) then
		return true;
	else
		return false;
	end
end

