
function AQ_AutoReactiveClass_HandleBeginAction_MAGE(performer, action, target, actionType, p1, p2, p3, p4, p5)
	if ( AQ_AutoReactiveClass_HandleBeginAction_Wards(performer, action, target, actionType, p1, p2, p3, p4, p5) ) then
		return true;
	end
	
	if ( not AQ_AutoReactiveClass_Options.shouldInterrupt ) then
		return AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
	end
	if ( not arg ) then arg = {}; end
	local name = performer;
	if ( not name ) then name = target; end
	if ( UnitExists("target") ) then
		if ( UnitName("target") ~= name ) then
			return AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
		end
	end
	
	if ( ActionQueue_IsQueued(AUTOREACTIVECLASS_ACTIONQUEUE_INTERRUPT_ID) ) then
		AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
		return false;
	end
	
	if ( not target ) or ( target == UnitName("player") ) then
		for k, v in AutoReactiveClass_SpellsThatShouldNotBeInterrupted do
			if ( v == action ) then
				AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
				return false;
			end
		end
	end
	
	local canUseCounterspell = true;
	for k, v in AutoReactiveClass_SpellsThatCanNotBeInterrupted do
		if ( v == action ) then
			canUseCounterspell = false;
			break;
		end
	end
	
	if ( canUseCounterspell ) then
		local skillName = AUTOREACTIVECLASS_COUNTERSPELL_NAME;
		local skillId = AutoReactiveClass_Mage_Counterspell_LastId;
		local id = nil;
		if ( skillId ) then
			local name = GetSpellName(skillId, "spell");
			if ( name == skillName ) then
				id = skillId;
			end
		end
		if ( not id ) then
			id = ActionQueue_GetHighestSpellRankId(skillName);
		end
		if ( id ) then
			AutoReactiveClass_Mage_Counterspell_LastId = id;
			AutoReactiveClass_Queue_Interrupt_Entry.spellId = id;
			ActionQueue_QueueAction(AutoReactiveClass_Queue_Interrupt_Entry);
		end
	end

	AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
end

