function AQ_AutoReactiveClass_HandleBeginAction_WARRIOR(performer, action, target, actionType, p1, p2, p3, p4, p5)
	if ( not AQ_AutoReactiveClass_Options.shouldInterrupt ) then
		return AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
	end
	if ( not arg ) then arg = {}; end
	local name = performer;
	if ( not name ) then name = target; end
	if ( UnitExists("target") ) then
		if ( UnitName("target") ~= name ) then
			return AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
		end
	end
	if ( AQ_AutoReactiveClass_Options.doNotInterruptIfLowerLevel ) then
		if ( UnitLevel("player") - UnitLevel("target") >= AQ_AutoReactiveClass_Options.doNotInterruptIfLowerLevel ) then
			return AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
		end
	end
	if ( ActionQueue_IsShadowmelded() ) then
		return AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
	end
	
	if ( ActionQueue_IsQueued(AUTOREACTIVECLASS_ACTIONQUEUE_INTERRUPT_ID) ) then
		AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
		return false;
	end
	
		
	for k, v in AutoReactiveClass_SpellsThatShouldNotBeInterrupted do
		if ( v == action ) then
			AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
			return false;
		end
	end
	local canUseShieldBash = true;
	for k, v in AutoReactiveClass_SpellsThatCanNotBeInterrupted do
		if ( v == action ) then
			canUseShieldBash = false;
			break;
		end
	end

	local skillName = AUTOREACTIVECLASS_SHIELD_BASH_NAME;
	local skillId = AutoReactiveClass_Warrior_Shield_Bash_LastId;

	local activeStance = AutoReactiveClass_GetActiveStance();
	if ( activeStance == AUTOREACTIVE_STANCE_BERSERKER ) then
		skillName = AUTOREACTIVECLASS_PUMMEL_NAME;
		skillId = AutoReactiveClass_Warrior_Pummel_LastId;
	end

	local id = nil;
	if ( skillId ) then
		local name = GetSpellName(skillId, "spell");
		if ( name == skillName ) then
			id = skillId;
		end
	end
	if ( not id ) then 
		id = ActionQueue_FindSpellId(skillName); 
	end
	-- OK, did we find a valid id?
	if ( id ) and ( id > 0 ) then
		local start, duration, enable = GetSpellCooldown(id, "spell");
		if ( start+duration > 0 ) or ( enable ~= 1 ) then
			local left = start+duration-GetTime();
			if ( skillName == AUTOREACTIVECLASS_SHIELD_BASH_NAME ) and (left>3) then
				AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
				return false;
			end
		end
		if ( canUseShieldBash ) then
			if ( skillName == AUTOREACTIVECLASS_PUMMEL_NAME ) then
				AutoReactiveClass_Warrior_Pummel_LastId = id;
			else
				AutoReactiveClass_Warrior_Shield_Bash_LastId = id;
			end
			if ( not ActionQueue_IsQueued(AUTOREACTIVECLASS_ACTIONQUEUE_INTERRUPT_ID) ) then
			-- skill found: queue it up
				AutoReactiveClass_Queue_Interrupt_Entry.spellId = id;
				ActionQueue_QueueAction(AutoReactiveClass_Queue_Interrupt_Entry);
			end
		end
	end
	AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
end

function AQ_AutoReactiveClass_Warrior_CheckExecute()
	local skillName = AUTOREACTIVECLASS_EXECUTE_NAME;
	local skillId = AutoReactiveClass_Warrior_Execute_LastId;
	local id = nil;
	if ( skillId ) then
		local name = GetSpellName(skillId, "spell");
		if ( name == skillName ) then
			id = skillId;
		end
	end
	if ( not id ) then 
		id = ActionQueue_FindSpellId(skillName); 
	end
	if ( not id ) then
		return;
	end
	local start, duration, enable = GetSpellCooldown(id, "spell");
	if ( enable == 1 ) then
		return;
	end
	AutoReactiveClass_Warrior_Execute_LastId = id;
	if ( not ActionQueue_IsQueued(AUTOREACTIVECLASS_ACTIONQUEUE_ID) ) then
	-- skill found: queue it up
		AutoReactiveClass_Queue_Entry.spellId = id;
		ActionQueue_QueueAction(AutoReactiveClass_Queue_Entry);
	end
	local curTime = GetTime();
	if ( not AutoReactiveClass_Warrior_Execute_LastMessage ) 
		or ( curTime-AutoReactiveClass_Warrior_Execute_LastMessage >= 5 ) then
		AutoReactiveClass_Warrior_Execute_LastMessage = curTime;
		AQ_AutoReactiveClass_ShowMessage(AUTOREACTIVECLASS_MSG_EXECUTE);
		AQ_AutoReactiveClass_PlaySoundFile(AUTOREACTIVECLASS_SND_EXECUTE);
	end
end

function AQ_AutoReactiveClass_OnEvent_WARRIOR()
	if ( event == "UPDATE_BONUS_ACTIONBAR" ) then
		-- re-enables autoreactive if it should've been disabled 
		-- (as it is if you switch to a stance without having the associated skill)
		AQ_AutoReactiveClass_EnableUpdate();
		return;
	end
	if ( event == "UNIT_HEALTH" ) then
		if ( arg1 == "target" ) then
			AQ_AutoReactiveClass_Warrior_CheckExecute();
			return;
		end
	end
end

