
AUTOREACTIVE_CLASS_WARRIOR					= "WARRIOR";
AUTOREACTIVE_CLASS_HUNTER					= "HUNTER";
AUTOREACTIVE_CLASS_ROGUE					= "ROGUE";
AUTOREACTIVE_CLASS_SHAMAN					= "SHAMAN";

-- Warrior

AUTOREACTIVE_STANCE_BATTLE					= "Battle Stance";
AUTOREACTIVE_STANCE_DEFENSIVE				= "Defensive Stance";
AUTOREACTIVE_STANCE_BERSERKER				= "Berserker Stance";

AUTOREACTIVECLASS_OVERPOWER_NAME			= "Overpower";
AUTOREACTIVECLASS_REVENGE_NAME				= "Revenge";
AUTOREACTIVECLASS_SHIELD_BASH_NAME			= "Shield Bash";
AUTOREACTIVECLASS_PUMMEL_NAME				= "Pummel";
AUTOREACTIVECLASS_EXECUTE_NAME				= "Execute";

AUTOREACTIVECLASS_MSG_EXECUTE				= "EXECUTE NOW!";

-- Hunter

AUTOREACTIVECLASS_MONGOOSE_BITE_NAME		= "Mongoose Bite";

-- Mage

AUTOREACTIVECLASS_COUNTERSPELL_NAME			= "Counterspell";

AUTOREACTIVECLASS_FIRE_WARD_NAME			= "Fire Ward";
AUTOREACTIVECLASS_FROST_WARD_NAME			= "Frost Ward";


AUTOREACTIVECLASS_MAGE_CLEARCAST_NAME		= "Clearcasting";
AUTOREACTIVECLASS_MAGE_CLEARCAST_TEXTURE	= "Interface\\Icons\\Spell_Shadow_Manaburn";

-- Rogue

AUTOREACTIVECLASS_RIPOSTE_NAME				= "Riposte";
AUTOREACTIVECLASS_KICK_NAME					= "Kick";
AUTOREACTIVECLASS_KIDNEY_SHOT_NAME			= "Kidney Shot";

-- Shaman

AUTOREACTIVECLASS_EARTH_SHOCK_NAME			= "Earth Shock";

AUTOREACTIVECLASS_SHAMAN_CLEARCAST_NAME		= "Clearcasting";
AUTOREACTIVECLASS_SHAMAN_CLEARCAST_TEXTURE	= "Interface\\Icons\\Spell_Shadow_Manaburn";

-- Warlock

AUTOREACTIVECLASS_SHADOW_WARD_NAME			= "Shadow Ward";

-- Message format

AUTOREACTIVECLASS_MESSAGE_FORMAT			= "Use %s!";

AUTOREACTIVECLASS_PERFORMED_BY_ON_FORMAT	= "%s is doing %s on %s";
AUTOREACTIVECLASS_PERFORMED_BY_FORMAT		= "%s is doing %s";
AUTOREACTIVECLASS_INVOLVING_FORMAT			= "%s gets %s";

AUTOREACTIVECLASS_CAST_BY_ON_FORMAT			= "%s is casting %s on %s";
AUTOREACTIVECLASS_CAST_BY_FORMAT			= "%s is casting %s";
AUTOREACTIVECLASS_CAST_FORMAT				= "%s gets %s";

-- Options

AUTOREACTIVECLASS_CONFIG_HEADER				= "[AQ] AutoReactiveClass";
AUTOREACTIVECLASS_CONFIG_HEADER_INFO		= "Contains settings for the AutoReactiveClass AddOn. This addon allows the user to see when certain abilities are available and for queueing them up for execution.";

AUTOREACTIVECLASS_CONFIG_ENABLED			= "Enabled";
AUTOREACTIVECLASS_CONFIG_ENABLED_INFO		= "Enables/disables AQ_AutoReactiveClass. This allows for complete disabling of the addon. The addon will still remain in memory, but will not take any actions if disabled.";

AUTOREACTIVECLASS_CONFIG_SHOW_MESSAGE		= "Show message";
AUTOREACTIVECLASS_CONFIG_SHOW_MESSAGE_INFO	= "Controls whether a message should appear when a monitored ability is ready to be used.";

AUTOREACTIVECLASS_CONFIG_QUEUE_ACTION		= "Queue action";
AUTOREACTIVECLASS_CONFIG_QUEUE_ACTION_INFO	= "Controls whether an action should be queued when a monitored ability is ready to be used.";


AUTOREACTIVECLASS_CONFIG_SHAMAN_USE_HIGHEST_EARTH_SHOCK_ALWAYS = "Use highest rank Earth Shock Always";
AUTOREACTIVECLASS_CONFIG_SHAMAN_USE_HIGHEST_EARTH_SHOCK_ALWAYS_INFO = "Will make sure that the highest rank of the Earth Shock spell is used. This is not recommended for normal casting interruption (PvE).";

AUTOREACTIVECLASS_CONFIG_SHAMAN_USE_HIGHEST_EARTH_SHOCK_WHEN_CLEARCASTING = "Use highest rank ES when Clearcasting active";
AUTOREACTIVECLASS_CONFIG_SHAMAN_USE_HIGHEST_EARTH_SHOCK_WHEN_CLEARCASTING_INFO = "Will make sure that the highest rank of the Earth Shock spell is used when Clearcasting is active.";

-- Khaos 

AUTOREACTIVECLASS_STATE_ENABLED				= "enabled";
AUTOREACTIVECLASS_STATE_DISABLED			= "disabled";
AUTOREACTIVECLASS_STATE_TEXT				= "Option";


-- Spell interruption specific stuff

AutoReactiveClass_SpellsThatShouldNotBeInterrupted = {
	"Frost Breath", -- not worth it and not easy to trigger in time
	"Shoot",
	"Shoot Gun",
	"Shoot Bow",
	"Shoot Crossbow",
	"Hearthstone",
	"Opening",
	"Throw"
};


AutoReactiveClass_SpellsThatCanNotBeInterrupted = {
	"Black Sludge", -- used by Tar Beasts/Lords in Un'goro
	"Clone", -- used by Primal Oozes in Un'goro
	"Dire Growl", -- used by some wolves in Winterspring
	"Encasing Webs", -- used by some spiders
	"Frost Breath", -- used by yetis
	"Healing Ward", -- used by shaman type mobs
	"Melt Ore", -- used by goblins in Deadmines
	"Summon Remote-Controlled Golem", -- used by goblin engineers in Deadmines
	"Fire Shield II" -- used by a lot of mobs, fire elementals among them, causes fire damage on each hit
};


-- Spell lists for different elements, used for Wards.

AQ_AutoReactiveClass_ShadowSpells = {
	"shadow bolt",
	"shadowburn",
	"mind blast",
	"touch of weakness",
	"devouring plague",
	"shadow word: pain",
	"mind flay"
};

AQ_AutoReactiveClass_ShadowSpellKeyWords = {
	"shadow",
	"dark",
	"consuming"
};

AQ_AutoReactiveClass_NotShadowSpells = {
	"shadow resistance aura", -- once again... not truly correct
	"shadow protection",
	"shadow ward",
	"shadowguard", -- debatable
	"curse of shadow", -- also debatable
	"dark pact",
	"mind soothe",
	"mind-numbing poison",
	"mind control", -- not entirely true
	"mind vision"
};

AQ_AutoReactiveClass_FireSpells = {
	"fireball",
	"fire blast",
	"fire nova totem",
	"rain of fire",
	"holy fire",
	"hellfire",
	"searing pain",
	"soul fire",
	"pyroblast",
	"scorch",
	"immolate",
	"torch burst",
	"torch toss"
};

AQ_AutoReactiveClass_NotFireSpells = {
	"moonfire",
	"faerie fire",
	"fire ward", -- not really true, but used in the context it will be...
	"starfire",
	"rapid fire",
	"fire resistance totem",
	"inner fire",
	"searing totem"
};

AQ_AutoReactiveClass_FireSpellKeyWords = {
	"pyro",
	"fire",
	"searing",
	"scorch"
};

AQ_AutoReactiveClass_FrostSpells = {
	"frostbolt",
	"frost nova", -- should this be here or in not frost spells? we can't do anything, so...
	"frostbrand weapon",
	"cone of cold",
	"blizzard"
};

AQ_AutoReactiveClass_FrostSpellKeyWords = {
	"frost",
	"cold",
	"ice"
};

AQ_AutoReactiveClass_NotFrostSpells = {
	--"frost nova", -- should this be here or in frost spells? we can't do anything, so...
	"frost armor",
	"frost shock", -- thottbot says nothing about frost damage, so...
	"frost ward",
	"ice armor", -- not entirely true
	"ice barrier", -- not entirely true
	"frost resistance totem",
	"frost resistance aura"
};

AQ_AutoReactiveClass_Class_Wards = {
	MAGE = {
		[AUTOREACTIVECLASS_FIRE_WARD_NAME] = {
			spells = AQ_AutoReactiveClass_FireSpells;
			notSpells = AQ_AutoReactiveClass_NotFireSpells;
			keywords = AQ_AutoReactiveClass_FireSpellKeyWords;
		};
		[AUTOREACTIVECLASS_FROST_WARD_NAME] = {
			spells = AQ_AutoReactiveClass_FrostSpells;
			notSpells = AQ_AutoReactiveClass_NotFrostSpells;
			keywords = AQ_AutoReactiveClass_FrostSpellKeyWords;
		};
	};
	WARLOCK = {
		[AUTOREACTIVECLASS_SHADOW_WARD_NAME] = {
			spells = AQ_AutoReactiveClass_ShadowSpells;
			notSpells = AQ_AutoReactiveClass_NotShadowSpells;
			keywords = AQ_AutoReactiveClass_ShadowSpellKeyWords;
		};
	};
};