-- Variables
AQ_AlwaysDetectTraps_Options = {};

AQ_AlwaysDetectTraps_DetectTrapsLastId = nil;

function AQ_AlwaysDetectTraps_OnLoad()
	AQ_AlwaysDetectTraps_Queue_Entry = {
		id = AQ_ALWAYSDETECTTRAPS_ID;
		shouldExecuteFunc = AQ_AlwaysDetectTraps_ShouldExecute;
		executeFunc = AQ_AlwaysDetectTraps_HandleRequeuing;
		priority = 15;
		name = ALWAYSDETECTTRAPS_QUEUE_NAME;
	};
	
	this:RegisterFrame("VARIABLES_LOADED");
end

function AQ_AlwaysDetectTraps_OnEvent()
	if ( event == "VARIABLES_LOADED" ) then
		ActionQueue_LoadDefaultsHandleArray(AQ_ALWAYSDETECTTRAPS_OPTIONS_DEFAULT, AQ_AlwaysDetectTraps_Options);
		local _, class = UnitClass("player");
		if ( class == "ROGUE" ) then
			local id = AQ_AlwaysDetectTraps_RefreshSpell();
			if ( not id ) then
				this:RegisterEvent("SPELLS_CHANGED");
			else
				AQ_AlwaysDetectTraps_AddToQueue();
			end
		end
		return;
	elseif ( event == "SPELLS_CHANGED" ) then
		local id = AQ_AlwaysDetectTraps_RefreshSpell();
		if ( id ) then
			this:UnregisterEvent("SPELLS_CHANGED");
			AQ_AlwaysDetectTraps_AddToQueue();
		end
	end
end



function AQ_AlwaysDetectTraps_RefreshSpell()
	local id = AQ_AlwaysDetectTraps_DetectTrapsLastId;
	if ( id ) then
		local name = GetSpellName(lastId, "spell");
		if ( name ~= AQ_AlwaysDetectTraps_SPELL_DETECTTRAPS ) then
			id = nil;
		end
	end
	if ( not id ) then 
		id = ActionQueue_FindSpellId(AQ_AlwaysDetectTraps_SPELL_DETECTTRAPS); 
	end
	return id;
end

function AQ_AlwaysDetectTraps_ShouldExecute()
	if ( UnitOnTaxi("player") ) or ( UnitIsDeadOrGhost("player") ) then
		return false;
	end
	if ( PlayerFrame.inCombat ) and ( not AQ_AlwaysDetectTraps_Options.refreshInCombat ) then
		return false;
	end
	if ( ActionQueue_IsAnySpellRunning() ) then
		return false;
	end
	local pos = ActionQueue_GetBuffPosition(AQ_ALWAYSDETECTTRAPS_TEXTURE, ALWAYSDETECTTRAPS_SPELL_DETECTTRAPS);
	if ( pos ) then
		local maxTimeLeft = AQ_AlwaysDetectTraps_Options.refreshWhenAmountOfTimeLeft;
		if ( maxTimeLeft ) then
			local timeLeft = GetPlayerBuffTimeLeft(pos);
			if ( timeLeft > maxTimeLeft ) then
				return false;
			end
		else
			return false;
		end
	end
	local id = AQ_AlwaysDetectTraps_RefreshSpell();
	if ( id ) and ( id > 0 ) then
		local start, duration, enable = GetSpellCooldown(id, "spell");
		if ( start + duration <= 0 ) then
			CastSpell(id, "spell");
			return true;
		end
	end
	return false;
end

function AQ_AlwaysDetectTraps_AddToQueue()
	if ( not ActionQueue_IsQueued(AQ_AlwaysDetectTraps_Queue_Entry.id ) ) then 
		ActionQueue_QueueAction(AQ_AlwaysDetectTraps_Queue_Entry);
	end
end

function AQ_AlwaysDetectTraps_HandleRequeuing()
	if ( AQ_AlwaysDetectTraps_ShouldExecute() ) then
		local id = AQ_AlwaysDetectTraps_RefreshSpell();
		if ( id ) and ( id > 0 ) then
			local start, duration, enable = GetSpellCooldown(id, "spell");
			if ( start + duration <= 0 ) then
				CastSpell(id, "spell");
			end
		end
	end
	AQ_AlwaysDetectTraps_AddToQueue();
end
