
function AQ_AutoReactiveClass_HandleBeginAction_PALADIN(performer, action, target, actionType, p1, p2, p3, p4, p5)
	if ( not AQ_AutoReactiveClass_Options.enabled ) or ( not AQ_AutoReactiveClass_Options.shouldInterrupt ) then
		return AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
	end
	if ( not arg ) then arg = {}; end
	local name = performer;
	if ( not name ) then name = target; end
	if ( ActionQueue_IsKnownFriendly(name) ) then
		return false;
	end
	if ( AQ_AutoReactiveClass_Options.paladin.useConsecrationAntiStealth) then
		local isStealthAction = false;
		for k, v in AUTOREACTIVECLASS_STEALTH_SPELLS do
			if ( action == v ) then
				isStealthAction = true;
				break;
			end
		end
		if ( isStealthAction ) then
			if ( not AQ_AutoReactiveClass_Options.interruption.antiAoEInterruptOnlyInPvP ) or ( UnitIsPVPFreeForAll("player") ) or ( UnitIsPVP("player") ) then
				local spellId, actionId = ActionQueue_GetSpellAndActionIdForSpell(AUTOREACTIVECLASS_PALADIN_CONSECRATION_NAME, nil);
				if ( spellId ) then
					AutoReactiveClass_Queue_Interrupt_Entry.spellId = spellId;
					AutoReactiveClass_Queue_Interrupt_Entry.caster = name;
					ActionQueue_QueueAction(AutoReactiveClass_Queue_Interrupt_Entry);
					return AQ_AutoReactiveClass_HandleBeginAction_ShowMessage_Interrupt(performer, action, target, actionType, p1, p2, p3, p4, p5);
				end
			end
		end
	end
	if ( AQ_AutoReactiveClass_Options.paladin.useConsecrationAntiFirstAid) then
		local isHealingAction = false;
		for k, v in AUTOREACTIVECLASS_FIRST_AID_SPELLS do
			if ( action == v ) then
				isHealingAction = true;
				break;
			end
		end
		if ( isHealingAction ) then
			if ( not AQ_AutoReactiveClass_Options.interruption.antiAoEInterruptOnlyInPvP ) or ( UnitIsPVPFreeForAll("player") ) or ( UnitIsPVP("player") ) then
				local spellId, actionId = ActionQueue_GetSpellAndActionIdForSpell(AUTOREACTIVECLASS_PALADIN_CONSECRATION_NAME, nil);
				if ( spellId ) then
					AutoReactiveClass_Queue_Interrupt_Entry.spellId = spellId;
					AutoReactiveClass_Queue_Interrupt_Entry.caster = name;
					ActionQueue_QueueAction(AutoReactiveClass_Queue_Interrupt_Entry);
					return AQ_AutoReactiveClass_HandleBeginAction_ShowMessage_Interrupt(performer, action, target, actionType, p1, p2, p3, p4, p5);
				end
			end
		end
	end
	if ( AQ_AutoReactiveClass_Options.paladin.useConsecrationAntiHealingSpells) then
		local isHealingAction = false;
		for k, v in AUTOREACTIVECLASS_HEALING_SPELLS do
			if ( action == v ) then
				isHealingAction = true;
				break;
			end
		end
		if ( not isHealingAction ) then
			local lAction = strlower(action);
			for k, v in AUTOREACTIVECLASS_HEALING_KEYWORDS do
				if ( strfind(lAction, v) ) then
					isHealingAction = true;
					break;
				end
			end
		end
		if ( isHealingAction ) then
			if ( not AQ_AutoReactiveClass_Options.interruption.antiAoEInterruptOnlyInPvP ) or ( UnitIsPVPFreeForAll("player") ) or ( UnitIsPVP("player") ) then
				local spellId, actionId = ActionQueue_GetSpellAndActionIdForSpell(AUTOREACTIVECLASS_PALADIN_CONSECRATION_NAME, nil);
				if ( spellId ) then
					AutoReactiveClass_Queue_Interrupt_Entry.spellId = spellId;
					AutoReactiveClass_Queue_Interrupt_Entry.caster = name;
					ActionQueue_QueueAction(AutoReactiveClass_Queue_Interrupt_Entry);
					return AQ_AutoReactiveClass_HandleBeginAction_ShowMessage_Interrupt(performer, action, target, actionType, p1, p2, p3, p4, p5);
				end
			end
		end
	end
	if ( not AQ_AutoReactiveClass_Options.paladin.useHammerToInterruptSpells ) then
		AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
		return false;
	end
	for k, v in AQ_AutoReactiveClass_Options.interruption.spellsThatShouldBeIgnoredForInterruption do
		if ( v == action ) then
			AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
			return false;
		end
	end
	local skillName = AUTOREACTIVECLASS_PALADIN_HAMMER_OF_JUSTICE_NAME;
	local spellId, actionId = ActionQueue_GetSpellAndActionIdForSpell(skillName, nil);

	-- OK, did we find a valid id?
	if ( spellId ) and ( spellId > 0 ) then
		local start, duration, enable = GetSpellCooldown(spellId, "spell");
		if ( start+duration > 3 ) or ( enable ~= 1 ) then
			AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
			return false;
		end
		if ( not ActionQueue_IsQueued(AUTOREACTIVECLASS_ACTIONQUEUE_INTERRUPT_ID) ) then
		-- skill found: queue it up
			AutoReactiveClass_Queue_Interrupt_Entry.spellId = spellId;
			AutoReactiveClass_Queue_Interrupt_Entry.caster = name;
			ActionQueue_QueueAction(AutoReactiveClass_Queue_Interrupt_Entry);
			return AQ_AutoReactiveClass_HandleBeginAction_ShowMessage_Interrupt(performer, action, target, actionType, p1, p2, p3, p4, p5);
		end
	end
	AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
end

