function AQ_AutoReactiveClassGUI_Avoid()
	local arr = AQ_AutoReactiveClass_Options.interruption.spellsThatShouldBeIgnoredForInterruption;
	if (InterruptionDatabaseFrame:IsVisible()) and ( InterruptionDatabase_CurrentArr == arr ) then
		HideUIPanel(InterruptionDatabaseFrame);
	else
		InterruptionDatabase_InitiateInterruptions(arr);
		ShowUIPanel(InterruptionDatabaseFrame);
	end
end

function AQ_AutoReactiveClassGUI_Stun()
	local arr = AQ_AutoReactiveClass_Options.interruption.spellsThatNeedStunInterrupt;
	if (InterruptionDatabaseFrame:IsVisible()) and ( InterruptionDatabase_CurrentArr == arr ) then
		HideUIPanel(InterruptionDatabaseFrame);
	else
		InterruptionDatabase_InitiateInterruptions(arr);
		ShowUIPanel(InterruptionDatabaseFrame);
	end
end

function AQ_AutoReactiveClassGUI_OnLoad()
	if ( EarthFeature_AddButton ) then
		EarthFeature_AddButton (
			{ 
				id = "AQ_ARC_AVOID";
				name = AQ_ARC_GUI_BUTTON_AVOID_NAME;
				subtext = AQ_ARC_GUI_BUTTON_AVOID_SUBTEXT;
				tooltip = AQ_ARC_GUI_BUTTON_AVOID_TOOLTIP;
				icon = AQ_ARC_GUI_BUTTON_AVOID_ICON;
				callback = AQ_AutoReactiveClassGUI_Avoid;
				test = 	function()
					return true;
				end
			});
		EarthFeature_AddButton (
			{ 
				id = "AQ_ARC_STUN";
				name = AQ_ARC_GUI_BUTTON_STUN_NAME;
				subtext = AQ_ARC_GUI_BUTTON_STUN_SUBTEXT;
				tooltip = AQ_ARC_GUI_BUTTON_STUN_TOOLTIP;
				icon = AQ_ARC_GUI_BUTTON_STUN_ICON;
				callback = AQ_AutoReactiveClassGUI_Stun;
				test = 	function()
					return true;
				end
			});
	end
	local cmd = "AQ_ARC_GUICOMMAND";
	SlashCmdList[cmd] = AQ_AutoReactiveClassGUI_SlashCommand;
	for k, v in AQ_ARC_GUI_SLASHCOMMANDS do
		setglobal("SLASH_"..cmd..k, v);
	end
end

function AQ_AutoReactiveClassGUI_OnEvent()
end

function AQ_AutoReactiveClassGUI_SlashCommand(msg)
	if ( msg ) and ( strlen(msg) > 0 ) then
		msg = strlower(msg);
		for k, v in AQ_ARC_GUI_AVOID_SLASH_COMMANDS do
			if ( v == msg ) then
				return AQ_AutoReactiveClassGUI_Avoid();
			end
		end
		for k, v in AQ_ARC_GUI_STUN_SLASH_COMMANDS do
			if ( v == msg ) then
				return AQ_AutoReactiveClassGUI_Stun();
			end
		end
	end
	for k, v in AQ_ARC_GUI_SLASH_COMMAND_USAGE do
		ChatFrame1:AddMessage(v, 1, 1, 0.1, 1);
	end
end
