InterruptionDatabase_CurrentSelection = "";
Interruption_Order = {};

InterruptionDatabase_CurrentArr = nil;

function InterruptionDatabase_InitiateInterruptions(arr)
	Interruption_Order = {};
	for k, v in arr do 
		table.insert(Interruption_Order, v);
	end
	InterruptionDatabase_RemoveDupes();
	InterruptionDatabase_CurrentArr = arr;
	InterruptionDatabase_CurrentSelection = nil;
	InterruptionDatabase_Update();
end


function InterruptionDatabase_Update()
	local maxItems = table.getn(Interruption_Order);
	FauxScrollFrame_Update(InterruptionDatabaseFrameScrollFrame, maxItems, INTERRUPTIONDATABASE_ITEMS_SHOWN, INTERRUPTIONDATABASE_ITEM_HEIGHT);
	for iItem = 1, INTERRUPTIONDATABASE_ITEMS_SHOWN, 1 do
		local itemIndex = iItem + FauxScrollFrame_GetOffset(InterruptionDatabaseFrameScrollFrame);
		local InterruptionDatabaseItemSlot = getglobal("InterruptionDatabaseItem"..iItem);
		if( itemIndex <= maxItems) then
			local name = Interruption_Order[itemIndex];
			if name == InterruptionDatabase_CurrentSelection then
				InterruptionDatabaseItemSlot:SetTextColor(1,1,0);
			else
				InterruptionDatabaseItemSlot:SetTextColor(1,1,1);
			end
			InterruptionDatabaseItemSlot:SetText(name);
			InterruptionDatabaseItemSlot:Show();
		else
			InterruptionDatabaseItemSlot:Hide();
		end
	end
end

function InterruptionDatabase_RemoveDupes()
	local dirty = true;
	local foundId = nil;
	local iterations = 0;
	while ( dirty ) do
		dirty = false;
		for k, v in Interruption_Order do
			for key, value in Interruption_Order do
				if ( value == v ) and ( key ~= k ) then
					foundId = key;
					dirty = true;
					break;
				end
			end
			if ( dirty ) then
				break;
			end
		end
		if ( foundId ) then
			table.remove(Interruption_Order, foundId);
			foundId = nil;
		end
		iterations = iterations + 1;
		if ( iterations > 1000 ) then
			ChatFrame1:AddMessage("AQ_ARC_GUI: Too many iterations. Breaking...");
			break;
		end
	end
end

function InterruptionDatabase_SaveArray()
	local maxSize = table.getn(InterruptionDatabase_CurrentArr);
	for i = maxSize, 1, -1 do
		table.remove(InterruptionDatabase_CurrentArr, i);
	end
	for k, v in Interruption_Order do
		table.insert(InterruptionDatabase_CurrentArr, v);
	end
end

function MoveUpInterruption()
	for i = 2, table.getn(Interruption_Order), 1 do
		if Interruption_Order[i] == InterruptionDatabase_CurrentSelection then
			local temp = Interruption_Order[i - 1];
			Interruption_Order[i - 1] = Interruption_Order[i];
			Interruption_Order[i] = temp;
			return;
		end
	end
end

function MakeFirstInterruption()
	for i = table.getn(Interruption_Order), 2, -1 do
		if Interruption_Order[i] == InterruptionDatabase_CurrentSelection then
			local temp = Interruption_Order[i - 1];
			Interruption_Order[i - 1] = Interruption_Order[i];
			Interruption_Order[i] = temp;
		end
	end
end

function MakeLastInterruption()
	for i = 1,table.getn(Interruption_Order) -1, 1 do
		if Interruption_Order[i] == InterruptionDatabase_CurrentSelection then
			local temp = Interruption_Order[i + 1];
			Interruption_Order[i + 1] = Interruption_Order[i];
			Interruption_Order[i] = temp;
		end
	end
end

function MoveDownInterruption()
	for i = 1, table.getn(Interruption_Order) - 1, 1 do
		if Interruption_Order[i] == InterruptionDatabase_CurrentSelection then
			local temp = Interruption_Order[i + 1];
			Interruption_Order[i + 1] = Interruption_Order[i];
			Interruption_Order[i] = temp;
			return;
		end
	end
end

function InterruptionDatabase_SortInterrupts()
	table.sort(Interruption_Order);
	InterruptionDatabase_Update();
end

function InterruptionDatabaseItemButton_OnEnter()
	DebuffName = this:GetText();
	GameTooltip:SetOwner(this, "ANCHOR_RIGHT");
	GameTooltip:SetText(DebuffName,1,1,1);
end


function InterruptionDatabase_AddInterrupt()
	StaticPopup_Show("AQ_ARC_GUI_ADD_INTERRUPT");
end

function InterruptionDatabase_RemoveInterrupt()
	if ( not InterruptionDatabase_CurrentSelection ) then
		return;
	end
	local maxItems = table.getn(Interruption_Order);
	local foundIndex = nil;
	for k, v in pairs(Interruption_Order) do
		if v == InterruptionDatabase_CurrentSelection then
			foundIndex = k;
			break;
		end
	end
	if ( foundIndex ) then
		table.remove(Interruption_Order, foundIndex);
		InterruptionDatabase_CurrentSelection = nil;
		InterruptionDatabase_Update();
	end
end

function InterruptionDatabase_AddInterrupt_Callback(name)
	if ( name ) and ( strlen(name) > 0 ) then
		for k, v in Interruption_Order do
			if ( v == name ) then
				ChatFrame1:AddMessage(AQ_ARC_GUI_MSG_PRESENT_IN_LIST, 1, 1, 0);
				return;
			end
		end
		table.insert(Interruption_Order, name);
		InterruptionDatabase_Update();
	end
end

StaticPopupDialogs["AQ_ARC_GUI_ADD_INTERRUPT"] = {
	text = TEXT(AQ_ARC_GUI_ADD_INTERRUPT_TEXT),
	button1 = TEXT(OKAY),
	button2 = TEXT(CANCEL),
	OnAccept = function()
		InterruptionDatabase_AddInterrupt_Callback(getglobal(this:GetParent():GetName().."EditBox"):GetText());
	end,
	EditBoxOnEnterPressed = function()
		InterruptionDatabase_AddInterrupt_Callback(getglobal(this:GetParent():GetName().."EditBox"):GetText());
		getglobal(this:GetParent():GetName().."EditBox"):SetText("");
		this:GetParent():Hide();
	end,
	OnShow = function()
		getglobal(this:GetName().."EditBox"):SetFocus();
	end,
	OnHide = function()
		if ( ChatFrameEditBox:IsVisible() ) then
			ChatFrameEditBox:SetFocus();
		end
		getglobal(this:GetName().."EditBox"):SetText("");
	end,
	hasEditBox = 1,
	timeout = 0,
	whileDead = 1,
	hideOnEscape = 1
};


UIPanelWindows["InterruptionDatabaseFrame"] = { area = left; pushable = 1; whileDead = 1; };
