-- default options
AQ_AlwaysBerserk_Options = {
};

AQ_AlwaysBerserk_Setup = {
	hasBerserkingSkill = false;
	hasBerserking = false;
	lastMessage = nil;
};

function AQ_AlwaysBerserk_ActionQueueShouldBeRemovedCallback(entry)
	if ( AQ_AlwaysBerserk_Options.enabled ) and ( AQ_AlwaysBerserk_Setup.hasBerserking ) then
		return false;
	else
		return true;
	end
end

function AQ_AlwaysBerserk_UpdateSkill()
	local skillId = AQ_AlwaysBerserk_BerserkingSkillId;
	if ( skillId ) then
		local name = GetSpellName(skillId, "spell");
		if ( name ~= AQ_ALWAYSBERSERK_BERSERKING_NAME ) then
			skillId = nil;
		end
	end
	if ( not skillId ) then
		skillId = ActionQueue_FindSpellId(AQ_ALWAYSBERSERK_BERSERKING_NAME); 
	end
	if ( not skillId ) then
		AQ_AlwaysBerserk_Setup.hasBerserkingSkill = false;
		AQ_AlwaysBerserk_Setup.hasBerserking = false;
		AQ_AlwaysBerserk_BerserkingSkillId = nil;
		return false;
	end
	AQ_AlwaysBerserk_BerserkingSkillId = skillId;
	return true;
end

function AQ_AlwaysBerserk_UpdateAction()
	if ( not AQ_AlwaysBerserk_BerserkingSkillId ) then
		return false;
	end
	local actionId = AQ_AlwaysBerserk_BerserkingActionId;
	if ( not actionId ) then 
		actionId = ActionQueue_Util_RetrieveActionIdFromSpellId(skillId, "spell");
	end
	if ( actionId ) then
		AQ_AlwaysBerserk_BerserkingActionId = actionId;
		AQ_AlwaysBerserk_Setup.hasBerserking = true;
	else
		if ( AQ_AlwaysBerserk_Setup.hasBerserking ) then
			ActionQueue_ShowMessage(AQ_ALWAYSBERSERK_MSG_NO_BERSERK);
			AQ_AlwaysBerserk_Setup.hasBerserking = false;
		end
		AQ_AlwaysBerserk_BerserkingActionId = nil;
	end
end


function AQ_AlwaysBerserk_ExecuteBerserk()
	if ( AQ_AlwaysBerserk_Setup.hasBerserking ) then
		local isUsable, notEnoughMana = IsUsableAction(AQ_AlwaysBerserk_BerserkingActionId);
		if ( isUsable ) then
			CastSpell(AQ_AlwaysBerserk_BerserkingSkillId, "spell");
			return true;
		end
	end
	return false;
end

function AQ_AlwaysBerserk_Queue()
	if ( not ActionQueue_IsQueued(AQ_AlwaysBerserk_Entry.id) ) then
		AQ_AlwaysBerserk_Entry.before = GetTime()+5;
		ActionQueue_Queue(AQ_AlwaysBerserk_Entry);
	end
end

function AQ_AlwaysBerserk_ActionQueueCallback(entry)
	if ( not AQ_AlwaysBerserk_Options.enabled ) or ( not AQ_AlwaysBerserk_Setup.hasBerserking ) then
		return false;
	else
		local ok = AQ_AlwaysBerserk_ActionQueueCallbackFunc(entry);
		if ( not ok ) and ( entry ) then
			AQ_AlwaysBerserk_Queue();
		end
		return ok;
	end
end

function AQ_AlwaysBerserk_ActionQueueCallbackFunc(entry)
	if ( not AQ_AlwaysBerserk_Options.enabled ) or ( not AQ_AlwaysBerserk_Setup.hasBerserking ) then
		return false;
	end
	if ( ActionQueue_IsAnySpellRunning() ) then
		return false;
	end
	if ( ActionQueue_IsMounted() ) or ( UnitOnTaxi("player") ) then
		return false;
	end
	return AQ_AlwaysBerserk_ExecuteBerserk();
end

AQ_AlwaysBerserk_Entry = {
	["id"] = AQ_ALWAYSBERSERK_ID,
	["name"] = AQ_ALWAYSBERSERK_NAME,
	["shouldBeRemovedFunc"] = AQ_AlwaysBerserk_ActionQueueShouldBeRemovedCallback,
	["shouldExecuteFunc"] = ActionQueue_ShouldExecuteFunction_Time,
	["executeFunc"] = AQ_AlwaysBerserk_ActionQueueCallback,
	["priority"] = ACTIONQUEUE_HIGHEST_PRIORITY,
};

function AQ_AlwaysBerserk_OnLoad()
	--ActionQueue_QueueAction(AQ_AlwaysBerserk_Entry);
	
	local f = AQ_AlwaysBerserkFrame;
	f:RegisterEvent("VARIABLES_LOADED");
end

function AQ_AlwaysBerserk_OnEvent()
	if ( event == "VARIABLES_LOADED" ) then
		ActionQueue_LoadDefaultsHandleArray(AQ_ALWAYSBERSERK_OPTIONS_DEFAULT, AQ_AlwaysBerserk_Options);
		AQ_AlwaysBerserk_UpdateSkill();
		if ( AQ_AlwaysBerserk_Setup.hasBerserkingSkill ) then
			local f = AQ_AlwaysBerserkFrame;
			f:RegisterEvent("ACTIONBAR_SLOT_CHANGED");
			f:RegisterEvent("ACTIONBAR_UPDATE_USABLE");
		end
		return;
	elseif ( event == "ACTIONBAR_SLOT_CHANGED" ) then
		if ( not AQ_AlwaysBerserk_Setup.hasBerserkingSkill ) then
			this:UnregisterEvent(event);
			return;
		end
		if ( arg1 == -1 ) or ( not AQ_AlwaysBerserk_BerserkingActionId ) or ( arg1 == AQ_AlwaysBerserk_BerserkingSkillId ) then
			AQ_AlwaysBerserk_UpdateAction();
		end
		return;
	elseif( event == "ACTIONBAR_UPDATE_USABLE" ) then
		if ( not AQ_AlwaysBerserk_Setup.hasBerserkingSkill ) then
			this:UnregisterEvent(event);
			return;
		end
		if ( AQ_AlwaysBerserk_BerserkingActionId ) then
			local isUsable, notEnoughMana = IsUsableAction(AQ_AlwaysBerserk_BerserkingActionId);
			if ( isUsable ) then
				if ( AQ_AlwaysBerserk_Options.showMessage ) then
					local curTime = GetTime();
					if ( not AQ_AlwaysBerserk_Setup.lastMessage ) or ( curTime-AQ_AlwaysBerserk_Setup.lastMessage > AQ_AlwaysBerserk_Options.minimumTimeBetweenMessages ) then
						AQ_AlwaysBerserk_Setup.lastMessage = curTime;
						ActionQueue_ShowMessage(AQ_ALWAYSBERSERK_MESSAGE);
					end
				end
				if ( AQ_AlwaysBerserk_Options.doAction ) then
					AQ_AlwaysBerserk_Queue();
				end
			end
		end
	end
end
