
function AQ_AutoReactiveClass_HandleBeginAction_MAGE(performer, action, target, actionType, p1, p2, p3, p4, p5)
	if ( AQ_AutoReactiveClass_HandleBeginAction_Wards(performer, action, target, actionType, p1, p2, p3, p4, p5) ) then
		return true;
	end
	
	if ( not AQ_AutoReactiveClass_Options.enabled ) or ( not AQ_AutoReactiveClass_Options.shouldInterrupt ) then
		return AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
	end
	if ( not arg ) then arg = {}; end
	local name = performer;
	if ( not name ) then name = target; end
	if ( ActionQueue_IsKnownFriendly(name) ) then
		return false;
	end
	if ( AQ_AutoReactiveClass_Options.mage.useArcaneExplosionAntiStealth) then
		local isStealthAction = false;
		for k, v in AUTOREACTIVECLASS_STEALTH_SPELLS do
			if ( action == v ) then
				isStealthAction = true;
				break;
			end
		end
		if ( isStealthAction ) then
			if ( not AQ_AutoReactiveClass_Options.interruption.antiAoEInterruptOnlyInPvP ) or ( UnitIsPVPFreeForAll("player") ) or ( UnitIsPVP("player") ) then
				local spellId, actionId = ActionQueue_GetSpellAndActionIdForSpell(AUTOREACTIVECLASS_MAGE_ARCANE_EXPLOSION_NAME, nil);
				if ( spellId ) then
					AutoReactiveClass_Queue_Interrupt_Entry.spellId = spellId;
					AutoReactiveClass_Queue_Interrupt_Entry.caster = name;
					ActionQueue_QueueAction(AutoReactiveClass_Queue_Interrupt_Entry);
					return AQ_AutoReactiveClass_HandleBeginAction_ShowMessage_Interrupt(performer, action, target, actionType, p1, p2, p3, p4, p5);
				end
			end
		end
	end
	if ( AQ_AutoReactiveClass_Options.mage.useArcaneExplosionAntiFirstAid) then
		local isHealingAction = false;
		for k, v in AUTOREACTIVECLASS_FIRST_AID_SPELLS do
			if ( action == v ) then
				isHealingAction = true;
				break;
			end
		end
		if ( isHealingAction ) then
			if ( not AQ_AutoReactiveClass_Options.interruption.antiAoEInterruptOnlyInPvP ) or ( UnitIsPVPFreeForAll("player") ) or ( UnitIsPVP("player") ) then
				local spellId, actionId = ActionQueue_GetSpellAndActionIdForSpell(AUTOREACTIVECLASS_MAGE_ARCANE_EXPLOSION_NAME, nil);
				if ( spellId ) then
					AutoReactiveClass_Queue_Interrupt_Entry.spellId = spellId;
					AutoReactiveClass_Queue_Interrupt_Entry.caster = name;
					ActionQueue_QueueAction(AutoReactiveClass_Queue_Interrupt_Entry);
					return AQ_AutoReactiveClass_HandleBeginAction_ShowMessage_Interrupt(performer, action, target, actionType, p1, p2, p3, p4, p5);
				end
			end
		end
	end
	if ( AQ_AutoReactiveClass_Options.mage.useArcaneExplosionAntiHealingSpells) then
		local isHealingAction = false;
		for k, v in AUTOREACTIVECLASS_HEALING_SPELLS do
			if ( action == v ) then
				isHealingAction = true;
				break;
			end
		end
		if ( not isHealingAction ) then
			local lAction = strlower(action);
			for k, v in AUTOREACTIVECLASS_HEALING_KEYWORDS do
				if ( strfind(lAction, v) ) then
					isHealingAction = true;
					break;
				end
			end
		end
		if ( isHealingAction ) then
			if ( not AQ_AutoReactiveClass_Options.interruption.antiAoEInterruptOnlyInPvP ) or ( UnitIsPVPFreeForAll("player") ) or ( UnitIsPVP("player") ) then
				local spellId, actionId = ActionQueue_GetSpellAndActionIdForSpell(AUTOREACTIVECLASS_MAGE_ARCANE_EXPLOSION_NAME, nil);
				if ( spellId ) then
					AutoReactiveClass_Queue_Interrupt_Entry.spellId = spellId;
					AutoReactiveClass_Queue_Interrupt_Entry.caster = name;
					ActionQueue_QueueAction(AutoReactiveClass_Queue_Interrupt_Entry);
					return AQ_AutoReactiveClass_HandleBeginAction_ShowMessage_Interrupt(performer, action, target, actionType, p1, p2, p3, p4, p5);
				end
			end
		end
	end
	if ( UnitExists("target") ) then
		if ( UnitName("target") ~= name ) then
			return AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
		end
	end
	if ( ActionQueue_IsQueued(AUTOREACTIVECLASS_ACTIONQUEUE_INTERRUPT_ID) ) then
		AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
		return false;
	end
	
	if ( not target ) then
		for k, v in AQ_AutoReactiveClass_Options.interruption.spellsThatShouldBeIgnoredForInterruption do
			if ( v == action ) then
				AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
				return false;
			end
		end
	end
	
	local canUseCounterspell = true;
	for k, v in AQ_AutoReactiveClass_Options.interruption.spellsThatNeedStunInterrupt do
		if ( v == action ) then
			canUseCounterspell = false;
			break;
		end
	end
	
	if ( canUseCounterspell ) then
		local skillName = AUTOREACTIVECLASS_COUNTERSPELL_NAME;
		local spellId, actionId = ActionQueue_GetSpellAndActionIdForSpell(skillName, nil, "mage_"..skillName);
		if ( spellId ) and ( ActionQueue_SpellHasCooldownLessThan(spellId, nil, 3) ) then
			AutoReactiveClass_Queue_Interrupt_Entry.spellId = spellId;
			AutoReactiveClass_Queue_Interrupt_Entry.caster = name;
			ActionQueue_QueueAction(AutoReactiveClass_Queue_Interrupt_Entry);
			return AQ_AutoReactiveClass_HandleBeginAction_ShowMessage_Interrupt(performer, action, target, actionType, p1, p2, p3, p4, p5);
		end
	end
	return AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
end

