function AQ_AutoReactiveClass_HandleBeginAction_ROGUE(performer, action, target, actionType, p1, p2, p3, p4, p5)
	if ( not AQ_AutoReactiveClass_Options.enabled ) or ( not AQ_AutoReactiveClass_Options.shouldInterrupt ) then
		return AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
	end
	if ( not arg ) then arg = {}; end
	local name = performer;
	if ( not name ) then name = target; end
	if ( UnitExists("target") ) then
		if ( UnitName("target") ~= name ) then
			return AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
		end
	end
	if ( AQ_AutoReactiveClass_Options.doNotInterruptIfLowerLevel ) then
		if ( UnitLevel("player") - UnitLevel("target") >= AQ_AutoReactiveClass_Options.doNotInterruptIfLowerLevel ) then
			return AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
		end
	end
	if ( ActionQueue_IsStealthed() ) then
		return AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
	end
	if ( ActionQueue_IsShadowmelded() ) then
		return AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
	end
	
	if ( ActionQueue_IsQueued(AUTOREACTIVECLASS_ACTIONQUEUE_INTERRUPT_ID) ) then
		AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
		return false;
	end
	for k, v in AQ_AutoReactiveClass_Options.interruption.spellsThatShouldBeIgnoredForInterruption do
		if ( v == action ) then
			AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
			return false;
		end
	end
	local canUseKick = true;
	for k, v in AQ_AutoReactiveClass_Options.interruption.spellsThatNeedStunInterrupt do
		if ( v == action ) then
			canUseKick = false;
			break;
		end
	end

	local skillName = AUTOREACTIVECLASS_KICK_NAME;
	if ( not canUseKick ) then
		skillName = AUTOREACTIVECLASS_KIDNEY_SHOT_NAME;
	end
	local spellId, actionId = ActionQueue_GetSpellAndActionIdForSpell(skillName, nil, "rogue_"..skillName);
	-- OK, did we find a valid id?
	if ( spellId ) and ( spellId > 0 ) then
		if ( not ActionQueue_SpellHasCooldownLessThan(spellId, nil, 3)) then
			if ( skillName == AUTOREACTIVECLASS_KICK_NAME ) then
				canUseKick = false;
				skillName = AUTOREACTIVECLASS_KIDNEY_SHOT_NAME;
				spellId, actionId = ActionQueue_GetSpellAndActionIdForSpell(skillName, nil, "rogue_"..skillName);
			else
				spellId = nil;
			end
		end
		if ( not spellId ) then
			AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
			return false;
		elseif (not ActionQueue_SpellHasCooldownLessThan(spellId, nil, 0)) then
			AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
			return false;
		end

		if ( not ActionQueue_IsQueued(AUTOREACTIVECLASS_ACTIONQUEUE_INTERRUPT_ID) ) then
		-- skill found: queue it up
			AutoReactiveClass_Queue_Interrupt_Entry.spellId = spellId;
			AutoReactiveClass_Queue_Interrupt_Entry.caster = name;
			ActionQueue_QueueAction(AutoReactiveClass_Queue_Interrupt_Entry);
		end
	end
	AQ_AutoReactiveClass_HandleBeginAction_ShowMessage_Interrupt(performer, action, target, actionType, p1, p2, p3, p4, p5);
end

