
function AQ_AutoReactiveClass_HandleBeginAction_SHAMAN(performer, action, target, actionType, p1, p2, p3, p4, p5)
	if ( not AQ_AutoReactiveClass_Options.enabled ) or ( not AQ_AutoReactiveClass_Options.shouldInterrupt ) then
		return AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
	end
	if ( not arg ) then arg = {}; end
	local name = performer;
	if ( not name ) then name = target; end
	if ( UnitExists("target") ) then
		if ( UnitName("target") ~= name ) then
			return AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
		end
	end
	
	if ( ActionQueue_IsQueued(AUTOREACTIVECLASS_ACTIONQUEUE_INTERRUPT_ID) ) then
		AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
		return false;
	end
	
		
	for k, v in AQ_AutoReactiveClass_Options.interruption.spellsThatShouldBeIgnoredForInterruption do
		if ( v == action ) then
			AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
			return false;
		end
	end
	local canUseEarthShock = true;
	for k, v in AQ_AutoReactiveClass_Options.interruption.spellsThatNeedStunInterrupt do
		if ( v == action ) then
			canUseEarthShock = false;
			break;
		end
	end
	
	if ( canUseEarthShock ) then
		local skillName = AUTOREACTIVECLASS_EARTH_SHOCK_NAME;
		local skillId = nil;
		if ( AQ_AutoReactiveClass_Options.useHighestEarthShockAlways ) then
			skillId = AutoReactiveClass_Shaman_Earth_Shock_Highest_LastId;
		else
			skillId = AutoReactiveClass_Shaman_Earth_Shock_Lowest_LastId;
		end
		local index = "shaman_"..skillName;
		local useHighest = AQ_AutoReactiveClass_Options.useHighestEarthShockAlways;
		if ( not useHighest ) and ( AQ_AutoReactiveClass_Options.useHighestEarthShockWhenClearcastingActive ) then
			if ( ActionQueue_GetBuffPosition(AUTOREACTIVECLASS_SHAMAN_CLEARCAST_TEXTURE, AUTOREACTIVECLASS_SHAMAN_CLEARCAST_NAME) ) then
				useHighest = true;
			end
		end
		if ( useHighest ) then
			index = index.."_highest";
		end
		local spellId, actionId = ActionQueue_GetSpellAndActionIdForSpell(skillName, nil, index, useHighest);
		if ( spellId ) and ( ActionQueue_SpellHasCooldownLessThan(spellId, nil, 3) ) then
			AutoReactiveClass_Queue_Interrupt_Entry.spellId = spellId;
			AutoReactiveClass_Queue_Interrupt_Entry.caster = name;
			ActionQueue_QueueAction(AutoReactiveClass_Queue_Interrupt_Entry);
			return AQ_AutoReactiveClass_HandleBeginAction_ShowMessage_Interrupt(performer, action, target, actionType, p1, p2, p3, p4, p5);
		end
	end
	return AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
end

