 AutoReactiveClass_Warrior_Queue_Entry = {
	id = AUTOREACTIVECLASS_ACTIONQUEUE_WARRIOR_ID;
	spellId = nil; -- not known until we first try to cast it
	shouldExecuteFunc = ActionQueue_ShouldExecuteFunction_ASAP;
	executeFunc = ActionQueue_ExecuteFunction_Spell;
	name = AUTOREACTIVECLASS_ACTIONQUEUE_WARRIOR_ID;
};



function AQ_AutoReactiveClass_HandleBeginAction_WARRIOR(performer, action, target, actionType, p1, p2, p3, p4, p5)
	if ( not AQ_AutoReactiveClass_Options.enabled ) or ( not AQ_AutoReactiveClass_Options.shouldInterrupt ) then
		return AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
	end
	if ( not arg ) then arg = {}; end
	local name = performer;
	if ( not name ) then name = target; end
	if ( UnitExists("target") ) then
		if ( UnitName("target") ~= name ) then
			return AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
		end
	end
	if ( AQ_AutoReactiveClass_Options.doNotInterruptIfLowerLevel ) then
		if ( UnitLevel("player") - UnitLevel("target") >= AQ_AutoReactiveClass_Options.doNotInterruptIfLowerLevel ) then
			return AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
		end
	end
	if ( ActionQueue_IsShadowmelded() ) then
		return AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
	end
	
	if ( ActionQueue_IsQueued(AUTOREACTIVECLASS_ACTIONQUEUE_INTERRUPT_ID) ) then
		AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
		return false;
	end
	for k, v in AQ_AutoReactiveClass_Options.interruption.spellsThatShouldBeIgnoredForInterruption do
		if ( v == action ) then
			AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
			return false;
		end
	end
	local canUseShieldBash = true;
	for k, v in AQ_AutoReactiveClass_Options.interruption.spellsThatNeedStunInterrupt do
		if ( v == action ) then
			canUseShieldBash = false;
			break;
		end
	end
	local skillName = AUTOREACTIVECLASS_SHIELD_BASH_NAME;

	local activeStance = AutoReactiveClass_GetActiveStance();
	if ( activeStance == AUTOREACTIVE_STANCE_BERSERKER ) then
		skillName = AUTOREACTIVECLASS_PUMMEL_NAME;
	end

	local spellId, actionId = ActionQueue_GetSpellAndActionIdForSpell(skillName, nil, "warrior_interrupt"..skillName);

	-- OK, did we find a valid id?
	if ( spellId ) and ( spellId > 0 ) then
		local start, duration, enable = GetSpellCooldown(spellId, "spell");
		if ( start+duration > 0 ) or ( enable ~= 1 ) then
			local left = start+duration-GetTime();
			if ( skillName == AUTOREACTIVECLASS_SHIELD_BASH_NAME ) and (left>3) then
				AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
				return false;
			end
		end
		if ( canUseShieldBash ) then
			if ( not ActionQueue_IsQueued(AUTOREACTIVECLASS_ACTIONQUEUE_INTERRUPT_ID) ) then
			-- skill found: queue it up
				AutoReactiveClass_Queue_Interrupt_Entry.spellId = spellId;
				AutoReactiveClass_Queue_Interrupt_Entry.caster = name;
				ActionQueue_QueueAction(AutoReactiveClass_Queue_Interrupt_Entry);
				return AQ_AutoReactiveClass_HandleBeginAction_ShowMessage_Interrupt(performer, action, target, actionType, p1, p2, p3, p4, p5);
			end
		end
	end
	AQ_AutoReactiveClass_HandleBeginAction_ShowMessage(performer, action, target, actionType, p1, p2, p3, p4, p5);
end

function AQ_AutoReactiveClass_Warrior_CheckExecute()
	if ( not AQ_AutoReactiveClass_Options.enabled ) then
		return false;
	end
	local spellId, actionId = ActionQueue_GetSpellAndActionIdForSpell(AUTOREACTIVECLASS_EXECUTE_NAME, nil);
	if ( not spellId ) then
		return false;
	end
	if ( not actionId ) then
		-- DEBUG: notify user that he has to have Execute on his action buttons... somewhere.
		return false;
	end

	local isUsable, notEnoughMana = IsUsableAction(actionId);
	if ( not isUsable ) then
		return false;
	end

	if ( not ActionQueue_IsQueued(AutoReactiveClass_Warrior_Queue_Entry.id) ) and
		( AQ_AutoReactiveClass_Options.warrior.useExecuteAutomatically ) then
	-- skill found: queue it up
		local shouldQueue = true;
		if ( AQ_AutoReactiveClass_Options.warrior.onlyUseExecuteInPvP ) then
			if ( not UnitIsPVP("player") ) and ( not UnitIsPVPFreeForAll("player") ) then
				if ( UnitExists("target") ) then
					if ( not UnitIsPlayer("target") ) or ( not UnitIsEnemy("target", "player") ) then
						shouldQueue = false;
					end
				else
					shouldQueue = false;
				end
			end
		end
		if ( shouldQueue ) then
			AutoReactiveClass_Warrior_Queue_Entry.spellId = spellId;
			ActionQueue_QueueAction(AutoReactiveClass_Warrior_Queue_Entry);
		end
	end
	if ( AQ_AutoReactiveClass_Options.warrior.haveExecuteReminders ) then
		local curTime = GetTime();
		if ( not AutoReactiveClass_Warrior_Execute_LastMessage ) 
			or ( curTime-AutoReactiveClass_Warrior_Execute_LastMessage >= 
				AQ_AutoReactiveClass_Options.warrior.executeTimeBetweenReminders ) then
			
			AutoReactiveClass_Warrior_Execute_LastMessage = curTime;
			AQ_AutoReactiveClass_ShowMessage(AUTOREACTIVECLASS_MSG_EXECUTE);
			AQ_AutoReactiveClass_PlaySoundFile(AUTOREACTIVECLASS_SND_EXECUTE);
		end
	end
end

function AQ_AutoReactiveClass_OnEvent_WARRIOR()
	if ( event == "UPDATE_BONUS_ACTIONBAR" ) then
		-- re-enables autoreactive if it should've been disabled 
		-- (as it is if you switch to a stance without having the associated skill)
		AQ_AutoReactiveClass_EnableUpdate();
		return;
	end
	if ( event == "UNIT_HEALTH" ) then
		if ( arg1 == "target" ) and ( UnitIsEnemy("target", "player") ) then
			AQ_AutoReactiveClass_Warrior_CheckExecute();
			return;
		else
			--if ( not arg1 ) then arg1 = "<nil>"; end
			--ChatFrame1:AddMessage("arg was "..arg1);
		end
	end
end

