--[[
	Cooldown Count

	By sarf

	This mod allows you to see the amount of time left until the cooldown expires on an action button.

	Thanks goes to Drex of the #cosmostesters channel for suggesting this!
	
	CosmosUI URL:
	http://www.cosmosui.org/forums/viewtopic.php?t=
	
   ]]


-- Constants
COOLDOWNCOUNT_HOUR_MINUTES_FORMAT_LIMIT = 3600;
COOLDOWNCOUNT_MINUTES_SECONDS_FORMAT_LIMIT = 60;

-- Variables
CooldownCount_Enabled = 0;

CooldownCount_Saved_CooldownFrame_SetTimer = nil;
CooldownCount_Cosmos_Registered = 0;

-- executed on load, calls general set-up functions
function CooldownCount_OnLoad()
	CooldownCount_Register();
end

-- registers the mod with Cosmos
function CooldownCount_Register_Cosmos()
	if ( ( Cosmos_RegisterConfiguration ) and ( CooldownCount_Cosmos_Registered == 0 ) ) then
		Cosmos_RegisterConfiguration(
			"COS_COOLDOWNCOUNT_HEADER",
			"SEPARATOR",
			COOLDOWNCOUNT_CONFIG_HEADER,
			COOLDOWNCOUNT_CONFIG_HEADER_INFO
		);
		Cosmos_RegisterConfiguration(
			"COS_COOLDOWNCOUNT_ENABLED",
			"CHECKBOX",
			COOLDOWNCOUNT_ENABLED,
			COOLDOWNCOUNT_ENABLED_INFO,
			CooldownCount_Toggle_Enabled,
			0
		);
		CooldownCount_Cosmos_Registered = 1;
	end
end

-- registers the mod with the system, integrating it with slash commands and "master" AddOns
function CooldownCount_Register()
	if ( Cosmos_RegisterConfiguration ) then
		CooldownCount_Register_Cosmos();
	else
		SlashCmdList["COOLDOWNCOUNTSLASHENABLE"] = CooldownCount_Enable_ChatCommandHandler;
		SLASH_COOLDOWNCOUNTSLASHENABLE1 = "/cooldowncountenable";
		SLASH_COOLDOWNCOUNTSLASHENABLE2 = "/ccenable";
		SLASH_COOLDOWNCOUNTSLASHENABLE3 = "/cce";
		SLASH_COOLDOWNCOUNTSLASHENABLE4 = "/cooldowncountdisable";
		SLASH_COOLDOWNCOUNTSLASHENABLE5 = "/ccdisable";
		SLASH_COOLDOWNCOUNTSLASHENABLE6 = "/ccd";
		SLASH_COOLDOWNCOUNTSLASHENABLE7 = "/cooldowncounttoggle";
		SLASH_COOLDOWNCOUNTSLASHENABLE8 = "/cctoggle";
		SLASH_COOLDOWNCOUNTSLASHENABLE9 = "/cct";
		this:RegisterEvent("VARIABLES_LOADED");
	end

	if ( Cosmos_RegisterChatCommand ) then
		local CooldownCountEnableCommands = {"/cooldowncountenable", "/ccenable", "/cce", "/cooldowncountdisable", "/ccdisable", "/ccd","/cooldowncounttoggle","/cctoggle","/cct"};
		Cosmos_RegisterChatCommand (
			"COOLDOWNCOUNT_ENABLE_COMMANDS", -- Some Unique Group ID
			CooldownCountEnableCommands, -- The Commands
			CooldownCount_Enable_ChatCommandHandler,
			COOLDOWNCOUNT_CHAT_COMMAND_ENABLE_INFO -- Description String
		);
	end
end

-- Handles chat - e.g. slashcommands - enabling/disabling the CooldownCount
function CooldownCount_Enable_ChatCommandHandler(msg)
	msg = string.lower(msg);
	
	-- Toggle appropriately
	if ( (string.find(msg, 'on')) or ((string.find(msg, '1')) and (not string.find(msg, '-1')) ) ) then
		CooldownCount_Toggle_Enabled(1);
	else
		if ( (string.find(msg, 'off')) or (string.find(msg, '0')) ) then
			CooldownCount_Toggle_Enabled(0);
		else
			CooldownCount_Toggle_Enabled(-1);
		end
	end
end

function CooldownCount_CooldownFrame_SetTimer(this, start, duration, enable)
	CooldownCount_Saved_CooldownFrame_SetTimer(this, start, duration, enable);
	CooldownCount_UpdateCooldownCount(this, start, duration, enable);
end

function CooldownCount_GetFormattedNumber(number)
	if (strlen(number) < 2 ) then
		return "0"..number;
	else
		return number;
	end
end

-- thanks to vjeux and QuestMinion for this one!
function CooldownCount_Round(x)
	if(x - math.floor(x) > 0.5) then
		x = x + 0.5;
	end
	return math.floor(x);
end

function CooldownCount_GetFormattedTime(time)
	local newTime = CooldownCount_Round(time);
	
	local formattedTime = "";
	
	if ( newTime >= COOLDOWNCOUNT_HOUR_MINUTES_FORMAT_LIMIT ) then
		local hours = math.floor(newTime / 3600);
		local minutes = math.floor( ( newTime - ( 3600 * hours ) ) / 60);
		formattedTime = format(COOLDOWNCOUNT_HOUR_MINUTES_FORMAT, hours, CooldownCount_GetFormattedNumber(minutes));
	elseif ( newTime >= COOLDOWNCOUNT_HOUR_MINUTES_FORMAT_LIMIT ) then
		local minutes = math.floor( newTime  / 60);
		local seconds = math.floor( newTime - ( 60 * minutes ));
		formattedTime = format(COOLDOWNCOUNT_MINUTES_SECONDS_FORMAT, minutes, CooldownCount_GetFormattedNumber(seconds));
	else
		formattedTime = format(COOLDOWNCOUNT_SECONDS_FORMAT, newTime);
	end
	
	return formattedTime;
end	


function CooldownCount_UpdateCooldownCount(this, start, duration, enable)
	if ( (CooldownCount_Enabled == 1) and ( start > 0 and duration > 0 and enable > 0) ) then
		if ( not this ) then
			return;
		end
		
		local remainingTimeCutOff = 5;
		local remainingTime = -1;
		
		if ( start <= 0 ) then
			remainingTime = -1;
		else
			remainingTime = ( start + duration ) - GetTime();
		end
		
		local cooldownCount = getglobal(this:GetName().."Count");
		if ( cooldownCount ~= nil ) then
			if ( ( not cooldownCount:IsVisible() ) and ( remainingTime < remainingTimeCutOff ) ) then
				return;
			end
			if ( ( remainingTime <= 0 ) ) then
				if ( cooldownCount:IsVisible() ) then
					cooldownCount:Hide();
				end
			else
				local newTime = CooldownCount_GetFormattedTime(remainingTime)
				
				local oldTime = cooldownCount:GetText();
				if ( newTime ~= oldTime ) then
					cooldownCount:SetText(newTime);
				end
				if ( not cooldownCount:IsVisible() ) then
					cooldownCount:Show();
				end
			end
		end
	else
		cooldownCount:Hide();
	end
end



-- Hooks/unhooks functions. If toggle is 1, hooks functions, otherwise it unhooks functions.
--  Hooking functions mean that you replace them with your own functions and then call the 
--  original function at your leisure.
function CooldownCount_Setup_Hooks(toggle)
	if ( toggle == 1 ) then
		if ( ( CooldownFrame_SetTimer ~= CooldownCount_CooldownFrame_SetTimer ) and (CooldownCount_Saved_CooldownFrame_SetTimer == nil) ) then
			CooldownCount_Saved_CooldownFrame_SetTimer = CooldownFrame_SetTimer;
			CooldownFrame_SetTimer = CooldownCount_CooldownFrame_SetTimer;
		end
	else
		if ( CooldownFrame_SetTimer == CooldownCount_CooldownFrame_SetTimer) then
			CooldownFrame_SetTimer = CooldownCount_Saved_CooldownFrame_SetTimer;
			CooldownCount_Saved_CooldownFrame_SetTimer = nil;
		end
	end
end

-- Handles events
function CooldownCount_OnEvent(event)
	if ( event == "VARIABLES_LOADED" ) then
		if ( CooldownCount_Cosmos_Registered == 0 ) then
			local value = getglobal("COS_COOLDOWNCOUNT_ENABLED_X");
			if (value == nil ) then
				-- defaults to off
				value = 0;
			end
			CooldownCount_Toggle_Enabled(value);
		end
	end
end

-- Toggles the enabled/disabled state of the CooldownCount
--  if toggle is 1, it's enabled
--  if toggle is 0, it's disabled
--   otherwise, it's toggled
function CooldownCount_Toggle_Enabled(toggle)
	local oldvalue = CooldownCount_Enabled;
	local newvalue = toggle;
	if ( ( toggle ~= 1 ) and ( toggle ~= 0 ) ) then
		if (oldvalue == 1) then
			newvalue = 0;
		elseif ( oldvalue == 0 ) then
			newvalue = 1;
		else
			newvalue = 0;
		end
	end
	CooldownCount_Enabled = newvalue;
	setglobal("COS_COOLDOWNCOUNT_ENABLED_X", newvalue);
	CooldownCount_Setup_Hooks(newvalue);
	if ( newvalue ~= oldvalue ) then
		if ( newvalue == 1 ) then
			CooldownCount_Print(COOLDOWNCOUNT_CHAT_ENABLED);
		else
			CooldownCount_Print(COOLDOWNCOUNT_CHAT_DISABLED);
		end
	end
	CooldownCount_Register_Cosmos();
	if ( CooldownCount_Cosmos_Registered == 0 ) then 
		RegisterForSave("COS_COOLDOWNCOUNT_ENABLED_X");
	end
end

-- Prints out text to a chat box.
function CooldownCount_Print(msg,r,g,b,frame,id,unknown4th)
	if(unknown4th) then
		local temp = id;
		id = unknown4th;
		unknown4th = id;
	end
				
	if (not r) then r = 1.0; end
	if (not g) then g = 1.0; end
	if (not b) then b = 1.0; end
	if ( frame ) then 
		frame:AddMessage(msg,r,g,b,id,unknown4th);
	else
		if ( DEFAULT_CHAT_FRAME ) then 
			DEFAULT_CHAT_FRAME:AddMessage(msg, r, g, b,id,unknown4th);
		end
	end
end
