--[[
	Cooldown Count

	By sarf

	This mod allows you to see the amount of time left until the cooldown expires on an action button.

	Thanks goes to Drex of the #cosmostesters channel for suggesting this!
	
	CosmosUI URL:
	http://www.cosmosui.org/forums/viewtopic.php?t=
	
   ]]


-- Constants
COOLDOWNCOUNT_HOUR_MINUTES_FORMAT_LIMIT = 3600;
COOLDOWNCOUNT_MINUTES_SECONDS_FORMAT_LIMIT = 60;

-- Variables
CooldownCount_Enabled = 0;
CooldownCount_SideBarsSideCount = 0;

CooldownCount_Saved_CooldownFrame_SetTimer = nil;
CooldownCount_Cosmos_Registered = 0;

CooldownCount_LastUpdate = 0;

CooldownCount_ButtonNames = {
	"ActionButton", "SecondActionButton", "BonusActionButton", "ShapeshiftButton"
};



-- executed on load, calls general set-up functions
function CooldownCount_OnLoad()
	CooldownCount_Register();
end

-- registers the mod with Cosmos
function CooldownCount_Register_Cosmos()
	if ( ( Cosmos_RegisterConfiguration ) and ( CooldownCount_Cosmos_Registered == 0 ) ) then
		Cosmos_RegisterConfiguration(
			"COS_COOLDOWNCOUNT_HEADER",
			"SEPARATOR",
			COOLDOWNCOUNT_CONFIG_HEADER,
			COOLDOWNCOUNT_CONFIG_HEADER_INFO
		);
		Cosmos_RegisterConfiguration(
			"COS_COOLDOWNCOUNT_ENABLED",
			"CHECKBOX",
			COOLDOWNCOUNT_ENABLED,
			COOLDOWNCOUNT_ENABLED_INFO,
			CooldownCount_Toggle_Enabled,
			CooldownCount_Enabled
		);
		Cosmos_RegisterConfiguration(
			"COS_COOLDOWNCOUNT_SIDECOUNT",
			"CHECKBOX",
			COOLDOWNCOUNT_SIDECOUNT,
			COOLDOWNCOUNT_SIDECOUNT_INFO,
			CooldownCount_Toggle_SideCount,
			CooldownCount_SideBarsSideCount
		);
		CooldownCount_Cosmos_Registered = 1;
	end
end

-- registers the mod with the system, integrating it with slash commands and "master" AddOns
function CooldownCount_Register()
	if ( Cosmos_RegisterConfiguration ) then
		CooldownCount_Register_Cosmos();
	else
		SlashCmdList["COOLDOWNCOUNTSLASHENABLE"] = CooldownCount_Enable_ChatCommandHandler;
		SLASH_COOLDOWNCOUNTSLASHENABLE1 = "/cooldowncountenable";
		SLASH_COOLDOWNCOUNTSLASHENABLE2 = "/ccenable";
		SLASH_COOLDOWNCOUNTSLASHENABLE3 = "/cce";
		SLASH_COOLDOWNCOUNTSLASHENABLE4 = "/cooldowncountdisable";
		SLASH_COOLDOWNCOUNTSLASHENABLE5 = "/ccdisable";
		SLASH_COOLDOWNCOUNTSLASHENABLE6 = "/ccd";
		SLASH_COOLDOWNCOUNTSLASHENABLE7 = "/cooldowncounttoggle";
		SLASH_COOLDOWNCOUNTSLASHENABLE8 = "/cctoggle";
		SLASH_COOLDOWNCOUNTSLASHENABLE9 = "/cct";
		SlashCmdList["COOLDOWNCOUNTSLASHSIDEBARCOUNTENABLE"] = CooldownCount_SideBarsSideCount_ChatCommandHandler;
		SLASH_COOLDOWNCOUNTSLASHSIDEBARCOUNTENABLE1 = "/cooldowncountsidebarcountenable";
		SLASH_COOLDOWNCOUNTSLASHSIDEBARCOUNTENABLE2 = "/ccsbcenable";
		SLASH_COOLDOWNCOUNTSLASHSIDEBARCOUNTENABLE3 = "/ccsbce";
		SLASH_COOLDOWNCOUNTSLASHSIDEBARCOUNTENABLE4 = "/cooldowncountsidebarcountdisable";
		SLASH_COOLDOWNCOUNTSLASHSIDEBARCOUNTENABLE5 = "/ccsbcdisable";
		SLASH_COOLDOWNCOUNTSLASHSIDEBARCOUNTENABLE6 = "/ccsbcd";
		SLASH_COOLDOWNCOUNTSLASHSIDEBARCOUNTENABLE7 = "/cooldowncountsidebarcounttoggle";
		SLASH_COOLDOWNCOUNTSLASHSIDEBARCOUNTENABLE8 = "/ccsbctoggle";
		SLASH_COOLDOWNCOUNTSLASHSIDEBARCOUNTENABLE9 = "/ccsbct";
		this:RegisterEvent("VARIABLES_LOADED");
	end

	if ( Cosmos_RegisterChatCommand ) then
		local CooldownCountEnableCommands = {"/cooldowncountenable", "/ccenable", "/cce", "/cooldowncountdisable", "/ccdisable", "/ccd","/cooldowncounttoggle","/cctoggle","/cct"};
		Cosmos_RegisterChatCommand (
			"COOLDOWNCOUNT_ENABLE_COMMANDS", -- Some Unique Group ID
			CooldownCountEnableCommands, -- The Commands
			CooldownCount_Enable_ChatCommandHandler,
			COOLDOWNCOUNT_CHAT_COMMAND_ENABLE_INFO -- Description String
		);
		local CooldownCountSideBarCountEnableCommands = {"/cooldowncountsidebarcountenable", "/ccsbcenable", "/ccsbce", "/cooldowncountsidebarcountdisable", "/ccsbcdisable", "/ccsbcd","/cooldowncountsidebarcounttoggle","/ccsbctoggle","/ccsbct"};
		Cosmos_RegisterChatCommand (
			"COOLDOWNCOUNT_SIDEBARCOUNT_ENABLE_COMMANDS", -- Some Unique Group ID
			CooldownCountSideBarCountEnableCommands, -- The Commands
			CooldownCount_SideBarsSideCount_ChatCommandHandler,
			COOLDOWNCOUNT_CHAT_COMMAND_SIDECOUNT_ENABLE_INFO -- Description String
		);
	end
end

-- Handles chat - e.g. slashcommands - enabling/disabling the CooldownCount
function CooldownCount_Enable_ChatCommandHandler(msg)
	msg = string.lower(msg);
	
	-- Toggle appropriately
	if ( (string.find(msg, 'on')) or ((string.find(msg, '1')) and (not string.find(msg, '-1')) ) ) then
		CooldownCount_Toggle_Enabled(1);
	else
		if ( (string.find(msg, 'off')) or (string.find(msg, '0')) ) then
			CooldownCount_Toggle_Enabled(0);
		else
			CooldownCount_Toggle_Enabled(-1);
		end
	end
end

function CooldownCount_SideBarsSideCount_ChatCommandHandler(msg)
	msg = string.lower(msg);
	
	-- Toggle appropriately
	if ( (string.find(msg, 'on')) or ((string.find(msg, '1')) and (not string.find(msg, '-1')) ) ) then
		CooldownCount_Toggle_SideCount(1);
	else
		if ( (string.find(msg, 'off')) or (string.find(msg, '0')) ) then
			CooldownCount_Toggle_SideCount(0);
		else
			CooldownCount_Toggle_SideCount(-1);
		end
	end
end


function CooldownCount_CooldownFrame_SetTimer(this, start, duration, enable)
	CooldownCount_Saved_CooldownFrame_SetTimer(this, start, duration, enable);
	CooldownCount_UpdateCooldownCount(this, start, duration, enable);
end

function CooldownCount_OnUpdate(elapsed)
	if ( ( CooldownCount_LastUpdate ) and ( CooldownCount_LastUpdate > 0 ) ) then
		if ( ( CooldownCount_LastUpdate + 1) < GetTime() ) then
			for k, v in CooldownCount_ButtonNames do
				for i = 1, 12 do
					CooldownCount_DoUpdateCooldownCount(v..i);
				end
			end
			local sideBarFormatStr = "SideBar%sButton%d";
			local sideBarStr = "";
			local tmpSideBarButton = "";
			for i = 1, 12 do
				if ( i >= 7 ) then
					tmpSideBarButton = format(sideBarFormatStr, "2", i-6);
				else
					tmpSideBarButton = format(sideBarFormatStr, "", i);
				end
				CooldownCount_DoUpdateCooldownCount(tmpSideBarButton);
			end
			local popBarFormatStr = "PopBarButton%d%d";
			for i = 1, 12 do
				for j = 1, 12 do
					CooldownCount_DoUpdateCooldownCount(format(popBarFormatStr, i, j));
				end
			end
		end
	else
		CooldownCount_LastUpdate = GetTime();
	end
end

function CooldownCount_GetFormattedNumber(number)
	if (strlen(number) < 2 ) then
		return "0"..number;
	else
		return number;
	end
end

-- thanks to vjeux and QuestMinion for this one!
function CooldownCount_Round(x)
	if(x - math.floor(x) > 0.5) then
		x = x + 0.5;
	end
	return math.floor(x);
end

function CooldownCount_GetFormattedTime(time)
	local newTime = CooldownCount_Round(time);
	
	local formattedTime = "";
	
	if ( newTime >= COOLDOWNCOUNT_HOUR_MINUTES_FORMAT_LIMIT ) then
		local hours = math.floor(newTime / 3600);
		local minutes = math.floor( ( newTime - ( 3600 * hours ) ) / 60);
		formattedTime = format(COOLDOWNCOUNT_HOUR_MINUTES_FORMAT, hours, CooldownCount_GetFormattedNumber(minutes));
	elseif ( newTime >= COOLDOWNCOUNT_MINUTES_SECONDS_FORMAT_LIMIT ) then
		local minutes = math.floor( newTime  / 60);
		local seconds = math.floor( newTime - ( 60 * minutes ));
		formattedTime = format(COOLDOWNCOUNT_MINUTES_SECONDS_FORMAT, minutes, CooldownCount_GetFormattedNumber(seconds));
	else
		formattedTime = format(COOLDOWNCOUNT_SECONDS_FORMAT, newTime);
	end
	
	return formattedTime;
end	

--/script CooldownCount_CooldownFrame_SetTimer(getglobal("SecondActionButton3Cooldown"), 544630, 300, 1);
--/script getglobal("SecondActionButton3CooldownCount"):SetText("15"); getglobal("SecondActionButton3CooldownCount"):Show();
--/script Print(getglobal("SecondActionButton3CooldownCount"):GetText());

CooldownCount_OneLetterScale = 1.5;
CooldownCount_TwoLetterScale = 1;
CooldownCount_ThreeLetterScale = 0.66;
CooldownCount_FourLetterScale = 0.5;

function CooldownCount_GetAppropriateScale(newTime)
	local len = strlen(newTime);
	if ( len < 2 ) then len = 2; end;
	return (2 / len);
end



function CooldownCount_SetupSideBarFrames(onTop)
	local sideBarButton = getglobal("SideBarButton1");
	local offset = 36;
	if ( sideBarButton ) then
		offset = floor(sideBarButton:GetWidth());
	end
	local sideBarButtonFormatStr = "SideBar%sButton%d";
	local sideBarButtonStr = "SideBar%sButton%d";
	local countStrAppend = "CooldownCount";
	local frame = nil;
	local sideBarStr = "";
	local buttonId = 0;
	for i = 1, 12 do
		if ( i <= 6 ) then
			sideBarStr = "";
			buttonId = i;
		else
			sideBarStr = "2";
			buttonId = i-6;
		end
		sideBarButtonStr = format(sideBarButtonFormatStr, sideBarStr, buttonId);
		countName = sideBarButtonStr..countStrAppend;
		count = getglobal(countName);
		frame = getglobal(countName.."Frame");
		if ( ( frame ) and (count) ) then
			frame:ClearAllPoints();
			count:ClearAllPoints();
			if ( not onTop ) then
				if ( i <= 6 ) then
					frame:SetPoint("CENTER", sideBarButtonStr, "CENTER", (offset * -1), 0);
					count:SetPoint("CENTER", sideBarButtonStr, "CENTER", (offset * -1), 0);
				else
					frame:SetPoint("CENTER", sideBarButtonStr, "CENTER", offset, 0);
					count:SetPoint("CENTER", sideBarButtonStr, "CENTER", offset, 0);
				end
			else
				frame:SetPoint("CENTER", sideBarButtonStr, "CENTER", 0, 0);
				count:SetPoint("CENTER", sideBarButtonStr, "CENTER", 0, 0);
			end
		end
	end
end

function CooldownCount_DoUpdateCooldownCount(name)
	local cooldownName = name.."Cooldown";
	local parent = getglobal(name);
	local cooldownCount = getglobal(cooldownName.."Count");
	local cooldownCountFrame = getglobal(cooldownName.."CountFrame");
	
	local debug = false;
	
	if ( ( not parent ) or ( not parent:IsVisible() ) ) then
		if ( cooldownCount ) then
			cooldownCount:Hide();
		end
		if ( cooldownCountFrame ) then
			cooldownCountFrame:Hide();
		end
		return;
	else
		local frameLevel = parent:GetFrameLevel();
		if ( cooldownCountFrame ) then
			cooldownCountFrame:SetFrameLevel(frameLevel+2);
		end
	end

	local cooldownCountValuesName = (cooldownName.."CountValues");
	local cooldownCountValues = getglobal(cooldownCountValuesName);
	if ( not cooldownCountValues ) then
		if ( cooldownCount ) then
			cooldownCount:Hide();
		end
		if ( cooldownCountFrame ) then
			cooldownCountFrame:Hide();
		end
		return;
	end
	local start = cooldownCountValues[1];
	local duration = cooldownCountValues[2];
	local enable = cooldownCountValues[3];
	if ( (CooldownCount_Enabled == 1) and ( start > 0 and duration > 0) ) then
		local remainingTimeCutOff = 2;
		local remainingTime = -1;
		
		if ( start <= 0 ) then
			remainingTime = -1;
		else
			remainingTime = floor(( start + duration ) - GetTime());
		end
		
		if ( ( cooldownCount ) and ( cooldownCountFrame ) ) then
			--Print(format("Remaining time : %d", remainingTime));
			if ( ( not cooldownCount:IsVisible() ) and ( remainingTime < remainingTimeCutOff ) ) then
				--if ( debug ) then Print("cut off engaged lixom"); end
				return;
			end
			if ( ( remainingTime <= 0 ) ) then
				if ( cooldownCount:IsVisible() ) then
					cooldownCount:Hide();
				end
				if ( cooldownCountFrame:IsVisible() ) then
					cooldownCountFrame:Hide();
				end
			else
				local newTime = CooldownCount_GetFormattedTime(remainingTime)
				--Print(format("NewTime : %s", newTime));
				
				local oldTime = cooldownCount:GetText();
				
				if ( newTime ~= oldTime ) then
					cooldownCount:SetText(newTime);
					cooldownCountFrame:SetScale(CooldownCount_GetAppropriateScale(newTime));
				end
				
				if ( not cooldownCount:IsVisible() ) then
					cooldownCount:Show();
				end
				if ( not cooldownCountFrame:IsVisible() ) then
					cooldownCountFrame:Show();
				end
			end
		end
	else
		if ( cooldownCount ) then
			cooldownCount:Hide();
		end
		if ( cooldownCountFrame ) then
			cooldownCountFrame:Hide();
		end
	end
end

function CooldownCount_UpdateCooldownCount(this, start, duration, enable)
	local cooldownCount = getglobal(this:GetName().."Count");
	local cooldownCountFrame = getglobal(this:GetName().."CountFrame");
	local cooldownCountValuesName = (this:GetName().."CountValues");
	local cooldownCountValues = { start, duration, enable };
	if ( cooldownCount ) then
		setglobal(cooldownCountValuesName, cooldownCountValues);
	end
	--CooldownCount_DoUpdateCooldownCount(this:GetName());
end



-- Hooks/unhooks functions. If toggle is 1, hooks functions, otherwise it unhooks functions.
--  Hooking functions mean that you replace them with your own functions and then call the 
--  original function at your leisure.
function CooldownCount_Setup_Hooks(toggle)
	if ( toggle == 1 ) then
		if ( ( CooldownFrame_SetTimer ~= CooldownCount_CooldownFrame_SetTimer ) and (CooldownCount_Saved_CooldownFrame_SetTimer == nil) ) then
			CooldownCount_Saved_CooldownFrame_SetTimer = CooldownFrame_SetTimer;
			CooldownFrame_SetTimer = CooldownCount_CooldownFrame_SetTimer;
		end
	else
		if ( CooldownFrame_SetTimer == CooldownCount_CooldownFrame_SetTimer) then
			CooldownFrame_SetTimer = CooldownCount_Saved_CooldownFrame_SetTimer;
			CooldownCount_Saved_CooldownFrame_SetTimer = nil;
		end
	end
end

-- Handles events
function CooldownCount_OnEvent(event)
	if ( event == "VARIABLES_LOADED" ) then
		if ( CooldownCount_Cosmos_Registered == 0 ) then
			local value = CooldownCount_Enabled;
			if (value == nil ) then
				-- defaults to off
				value = 0;
			end
			CooldownCount_Toggle_Enabled(value);
			local value = CooldownCount_SideBarsSideCount;
			if (value == nil ) then
				-- defaults to off
				value = 0;
			end
			CooldownCount_Toggle_SideCount(value);
		end
	end
end

-- Toggles the enabled/disabled state of the CooldownCount
--  if toggle is 1, it's enabled
--  if toggle is 0, it's disabled
--   otherwise, it's toggled
function CooldownCount_Toggle_SideCount(toggle)
	local oldvalue = CooldownCount_SideBarsSideCount;
	local newvalue = toggle;
	if ( ( toggle ~= 1 ) and ( toggle ~= 0 ) ) then
		if (oldvalue == 1) then
			newvalue = 0;
		elseif ( oldvalue == 0 ) then
			newvalue = 1;
		else
			newvalue = 0;
		end
	end
	CooldownCount_SideBarsSideCount = newvalue;
	if ( newvalue == 1 ) then
		CooldownCount_SetupSideBarFrames(false);
	else
		CooldownCount_SetupSideBarFrames(true);
	end
	if ( newvalue ~= oldvalue ) then
		if ( newvalue == 1 ) then
			CooldownCount_Print(COOLDOWNCOUNT_CHAT_SIDECOUNT_ENABLED);
		else
			CooldownCount_Print(COOLDOWNCOUNT_CHAT_SIDECOUNT_DISABLED);
		end
	end
	CooldownCount_Register_Cosmos();
	if ( CooldownCount_Cosmos_Registered == 0 ) then 
		RegisterForSave("CooldownCount_SideBarsSideCount");
	end
end

-- Toggles the enabled/disabled state of the CooldownCount
--  if toggle is 1, it's enabled
--  if toggle is 0, it's disabled
--   otherwise, it's toggled
function CooldownCount_Toggle_Enabled(toggle)
	local oldvalue = CooldownCount_Enabled;
	local newvalue = toggle;
	if ( ( toggle ~= 1 ) and ( toggle ~= 0 ) ) then
		if (oldvalue == 1) then
			newvalue = 0;
		elseif ( oldvalue == 0 ) then
			newvalue = 1;
		else
			newvalue = 0;
		end
	end
	CooldownCount_Enabled = newvalue;
	CooldownCount_Setup_Hooks(newvalue);
	if ( newvalue ~= oldvalue ) then
		if ( newvalue == 1 ) then
			CooldownCount_Print(COOLDOWNCOUNT_CHAT_ENABLED);
		else
			CooldownCount_Print(COOLDOWNCOUNT_CHAT_DISABLED);
		end
	end
	CooldownCount_Register_Cosmos();
	if ( CooldownCount_Cosmos_Registered == 0 ) then 
		RegisterForSave("CooldownCount_Enabled");
	end
end

-- Prints out text to a chat box.
function CooldownCount_Print(msg,r,g,b,frame,id,unknown4th)
	if(unknown4th) then
		local temp = id;
		id = unknown4th;
		unknown4th = id;
	end
				
	if (not r) then r = 1.0; end
	if (not g) then g = 1.0; end
	if (not b) then b = 1.0; end
	if ( frame ) then 
		frame:AddMessage(msg,r,g,b,id,unknown4th);
	else
		if ( DEFAULT_CHAT_FRAME ) then 
			DEFAULT_CHAT_FRAME:AddMessage(msg, r, g, b,id,unknown4th);
		end
	end
end
