--[[
	CtrlGroupCast

	By sarf

	This mod allows you to use Ctrl and cast spells on your group members.

	Thanks goes to Qndrez on the CosmosUI.org forums which suggested this (kinda :) ).
	
	CosmosUI URL:
	http://www.cosmosui.org/forums/viewtopic.php?t=278
   ]]


-- Constants
CTRLGROUPCAST_MAX_NUMBER_OF_PARTY_MEMBERS = 4;

-- Variables
CtrlGroupCast_Saved_UseAction = nil;
CtrlGroupCast_CurrentTarget = 0;
CtrlGroupCast_Cosmos_Registered = 0;
CtrlGroupCast_CurrentNumberOfPartyMembers = 0;

CtrlGroupCast_Enabled = 0;
CtrlGroupCast_DebugEnabled = 1;

function CtrlGroupCast_OnLoad()
	CtrlGroupCast_Register();
end

function CtrlGroupCast_Register_Cosmos()
	if ( ( Cosmos_RegisterConfiguration ) and ( CtrlGroupCast_Cosmos_Registered == 0 ) ) then
		Cosmos_RegisterConfiguration(
			"COS_CTRLGROUPCAST_HEADER",
			"SEPARATOR",
			CTRLGROUPCAST_CONFIG_HEADER,
			CTRLGROUPCAST_CONFIG_HEADER_INFO
		);
		Cosmos_RegisterConfiguration(
			"COS_CTRLGROUPCAST_ENABLED",
			"CHECKBOX",
			CTRLGROUPCAST_ENABLED,
			CTRLGROUPCAST_ENABLED_INFO,
			CtrlGroupCast_Toggle_Enabled,
			0
		);
		CtrlGroupCast_Cosmos_Registered = 1;
	end
end

function CtrlGroupCast_Register()
	if ( Cosmos_RegisterConfiguration ) then
		CtrlGroupCast_Register_Cosmos();
	else
		SlashCmdList["CTRLGROUPCASTSLASHENABLE"] = CtrlGroupCast_Enable_ChatCommandHandler;
		SLASH_CTRLGROUPCASTSLASHENABLE1 = "/ctrlgroupcastenable";
		SLASH_CTRLGROUPCASTSLASHENABLE2 = "/cgcenable";
		SLASH_CTRLGROUPCASTSLASHENABLE3 = "/ctrlgroupcastdisable";
		SLASH_CTRLGROUPCASTSLASHENABLE4 = "/cgcdisable";
		this:RegisterEvent("VARIABLES_LOADED");
	end

	if ( Cosmos_RegisterChatCommand ) then
		local CtrlGroupCastEnableCommands = {"/ctrlgroupcastenable","/cgcenable","/ctrlgroupcastdisable","/cgcdisable"};
		Cosmos_RegisterChatCommand (
			"CTRLGROUPCAST_ENABLE_COMMANDS", -- Some Unique Group ID
			CtrlGroupCastEnableCommands, -- The Commands
			CtrlGroupCast_Enable_ChatCommandHandler,
			CTRLGROUPCAST_CHAT_COMMAND_ENABLE_INFO -- Description String
		);
	end

	this:RegisterEvent("PARTY_MEMBERS_CHANGED");
end

function CtrlGroupCast_Enable_ChatCommandHandler(msg)
	msg = string.lower(msg);
	
	-- Toggle appropriately
	if ( (string.find(msg, 'on')) or ((string.find(msg, '1')) and (not string.find(msg, '-1')) ) ) then
		CtrlGroupCast_Toggle_Enabled(1);
	else
		if ( (string.find(msg, 'off')) or (string.find(msg, '0')) ) then
			CtrlGroupCast_Toggle_Enabled(0);
		else
			CtrlGroupCast_Toggle_Enabled(-1);
		end
	end
end

function CtrlGroupCast_Setup_Hooks(toggle)
	if ( toggle == 1 ) then
		if ( ( UseAction ~= CtrlGroupCast_UseAction ) and (CtrlGroupCast_Saved_UseAction == nil) ) then
			CtrlGroupCast_Saved_UseAction = UseAction;
			UseAction = CtrlGroupCast_UseAction;
		end
	else
		if ( UseAction == CtrlGroupCast_UseAction) then
			UseAction = CtrlGroupCast_Saved_UseAction;
			CtrlGroupCast_Saved_UseAction = nil;
		end
	end
end

function CtrlGroupCast_HideAllIcons()
	local icon = nil;
	for i = 1, CTRLGROUPCAST_MAX_NUMBER_OF_PARTY_MEMBERS do
		icon = getglobal("PartyMemberFrame"..i.."CtrlTargetIcon");
		if ( icon ) then
			icon:Hide();
		else
			CtrlGroupCast_DebugPrint("CGC: Error - could not find PartyMemberFrame"..i.."CtrlTargetIcon.");
		end
	end
end

function CtrlGroupCast_SetCurrentTarget(member)
	if ( CtrlGroupCast_CurrentNumberOfPartyMembers == 0 ) then
		CtrlGroupCast_UpdateMembers();
	end
	if ( ( member >= 1 ) and ( member <= CtrlGroupCast_CurrentNumberOfPartyMembers ) ) then
		CtrlGroupCast_CurrentTarget = (member+0);
		CtrlGroupCast_Print(format(CTRLGROUPCAST_CHAT_TARGET_CHANGED, member));
	else
		CtrlGroupCast_Print(format(CTRLGROUPCAST_CHAT_TARGET_INVALID, member));
	end
end

function CtrlGroupCast_Target(member)
	CtrlGroupCast_HideAllIcons();
	if ( CtrlGroupCast_CurrentNumberOfPartyMembers == 0 ) then
		CtrlGroupCast_UpdateMembers();
	end
	local currentIcon = nil;
	currentIcon = getglobal("PartyMemberFrame"..member.."CtrlTargetIcon");
	if ( currentIcon ) then
		currentIcon:Show();
	end
	CtrlGroupCast_SetCurrentTarget(member);
end

function CtrlGroupCast_CycleTargetNext()
	local newTarget = nil;
	if ( CtrlGroupCast_CurrentTarget < 1 ) then
		newTarget = 1;
	elseif ( CtrlGroupCast_CurrentTarget >= CtrlGroupCast_CurrentNumberOfPartyMembers ) then
		newTarget = 1;
	else
		newTarget = CtrlGroupCast_CurrentTarget+1;
	end
	CtrlGroupCast_Target(newTarget);
end

function CtrlGroupCast_CycleTargetPrevious()
	local newTarget = nil;
	if ( CtrlGroupCast_CurrentTarget <= 1 ) then
		newTarget = CtrlGroupCast_CurrentNumberOfPartyMembers;
	elseif ( CtrlGroupCast_CurrentTarget > CtrlGroupCast_CurrentNumberOfPartyMembers ) then
		newTarget = CtrlGroupCast_CurrentNumberOfPartyMembers;
	else
		newTarget = CtrlGroupCast_CurrentTarget-1;
	end
	CtrlGroupCast_Target(newTarget);
end

function CtrlGroupCast_OnEvent(event)
	if ( event == "VARIABLES_LOADED" ) then
		if ( CtrlGroupCast_Cosmos_Registered == 0 ) then
			local value = getglobal("COS_CTRLGROUPCAST_ENABLED_X");
			if (value == nil ) then
				-- defaults to off
				value = 0;
			end
			CtrlGroupCast_Toggle_Enabled(value);
		end
		return;
	end
	if ( event == "PARTY_MEMBERS_CHANGED" ) then
		CtrlGroupCast_UpdateMembers();
		return;
	end
end

function CtrlGroupCast_UpdateMembers()
	CtrlGroupCast_CurrentNumberOfPartyMembers = 0;
	for i=1, CTRLGROUPCAST_MAX_NUMBER_OF_PARTY_MEMBERS, 1 do
		if ( GetPartyMember(i) ) then
			CtrlGroupCast_CurrentNumberOfPartyMembers = i;
		end
	end
	CtrlGroupCast_UpdateTarget();
end

function CtrlGroupCast_UpdateTarget()
	if ( CtrlGroupCast_CurrentNumberOfPartyMembers > CtrlGroupCast_CurrentTarget ) then
		CtrlGroupCast_Target(CtrlGroupCast_CurrentNumberOfPartyMembers);
	end
end


function CtrlGroupCast_Toggle_Enabled(toggle)
	local oldvalue = CtrlGroupCast_Enabled;
	local newvalue = toggle;
	if ( ( toggle ~= 1 ) and ( toggle ~= 0 ) ) then
		if (oldvalue == 1) then
			newvalue = 0;
		elseif ( oldvalue == 0 ) then
			newvalue = 1;
		else
			newvalue = 0;
		end
	end
	CtrlGroupCast_Enabled = newvalue;
	setglobal("COS_CTRLGROUPCAST_ENABLED_X", newvalue);
	CtrlGroupCast_Setup_Hooks(newvalue);
	if ( newvalue ~= oldvalue ) then
		if ( newvalue == 1 ) then
			CtrlGroupCast_Print(CTRLGROUPCAST_CHAT_ENABLED);
		else
			CtrlGroupCast_Print(CTRLGROUPCAST_CHAT_DISABLED);
		end
	end
	CtrlGroupCast_Register_Cosmos();
	--if ( CtrlGroupCast_Cosmos_Registered == 0 ) then 
		RegisterForSave("COS_CTRLGROUPCAST_ENABLED_X");
	--end
end




function CtrlGroupCast_UseAction_Call(id, number, onSelf, override)
	if ( (override == 1) and (AltSelfCast_UseAction) ) then
		if ( CtrlGroupCast_Saved_UseAction == AltSelfCast_UseAction ) then
			AltSelfCast_Saved_UseAction(id, number, onSelf);
		end
	else
		CtrlGroupCast_Saved_UseAction(id, number, onSelf);
	end
end

function CtrlGroupCast_IsCurrentTargetValid()
	if ( CtrlGroupCast_CurrentTarget >= 1 ) and ( CtrlGroupCast_CurrentTarget <= CtrlGroupCast_CurrentNumberOfPartyMembers ) then
		return true;
	else
		return false;
	end
end

function CtrlGroupCast_UseAction(id, number, onSelf)
	if ( (CtrlGroupCast_Enabled == 1) and ( IsCtrlKeyDown() ) and (CtrlGroupCast_IsCurrentTargetValid()) )  then
		local wantedTarget = "party"..CtrlGroupCast_CurrentTarget;
		local unitName;
		if( UnitIsFriend("player", "target") ) then
			unitName = UnitName("target");
			if ( unitName ~= wantedTarget ) then
				TargetUnit(wantedTarget);
			else
				unitName = nil;
			end
		end
		CtrlGroupCast_UseAction_Call(id, number, onSelf, 1);
		if( SpellIsTargeting() ) then
			SpellTargetUnit(wantedTarget);
		end
		if( unitName ) then
			TargetByName(unitName);
		end
	else
		CtrlGroupCast_UseAction_Call(id, number, onSelf);
	end
end

function CtrlGroupCast_DebugPrint(msg)
	if ( CtrlGroupCast_DebugEnabled == 1 ) then
		CtrlGroupCast_Print(msg);
	end
end

function CtrlGroupCast_Print(msg,r,g,b,frame,id,unknown4th)
	if(unknown4th) then
		local temp = id;
		id = unknown4th;
		unknown4th = id;
	end
				
	if (not r) then r = 1.0; end
	if (not g) then g = 1.0; end
	if (not b) then b = 1.0; end
	if ( frame ) then 
		frame:AddMessage(msg,r,g,b,id,unknown4th);
	else
		if ( DEFAULT_CHAT_FRAME ) then 
			DEFAULT_CHAT_FRAME:AddMessage(msg, r, g, b,id,unknown4th);
		end
	end
end
