-- SIMPLEMOUNT_COMBAT START

SIMPLEMOUNT_KHAOS_FOLDER_ID			= "SimpleMountID";
SIMPLEMOUNT_KHAOS_SET_EASY_ID			= "SimpleMountBasicSetID";
SIMPLEMOUNT_KHAOS_SET_ADVANCED_ID		= "SimpleMountAdvancedSetID";

function SimpleMount_UpdateValue(name, value, cosName)
	if ( not name ) then
		return false;
	end
	SimpleMount_Options[name] = value;
	if ( cosName ) then
		if ( value == true ) then
			AddOnHelper_Generic_CosmosUpdateCheckOnOff(cosName, 1);
		elseif ( value == false ) or ( value == nil ) then
			AddOnHelper_Generic_CosmosUpdateCheckOnOff(cosName, 0);
		else
			AddOnHelper_Generic_CosmosUpdateValue(cosName, value);
		end
	end
end

function SimpleMount_Get_Khaos_CheckBox(pid, pkey, ptext, phelptext, pcheck, cb)
	local option1 = {
		id = pid;
		key = pkey;
		text = ptext;
		helptext = phelptext;
		check = true;
		callback = cb;
		type = K_TEXT;
		feedback = function(state) local s = SIMPLEMOUNT_STATE_ENABLED; if ( not state.checked ) then s = SIMPLEMOUNT_STATE_DISABLED; end return SIMPLEMOUNT_KHAOS_GATHERING_TEXT.." "..s; end;
		default = {
			checked = pcheck;
		};
		disabled = {
			checked = false;
		};
	};
	return option1;
end

SimpleMount_Folder = {
	id = SIMPLEMOUNT_KHAOS_FOLDER_ID;
	text = SIMPLEMOUNT_KHAOS_FOLDER_TEXT;
	helptext = SIMPLEMOUNT_KHAOS_FOLDER_HELP;
	difficulty = 1;
};
function SimpleMount_Register_Khaos()
	if ( not Khaos ) then
		return false;
	end
	Khaos.registerFolder(SimpleMount_Folder);

	local optionSetEasy = {
		id = SIMPLEMOUNT_KHAOS_SET_EASY_ID;
		text = SIMPLEMOUNT_KHAOS_EASYSET_TEXT;
		helptext = SIMPLEMOUNT_KHAOS_EASYSET_HELP;
		difficulty = 1;
		options = {};
		default = true;
	};

	local cb = function(state) SimpleMount_UpdateValue("enabled", state.checked, "COS_SIMPLEMOUNT_ENABLED"); end;
	table.insert(optionSetEasy.options, SimpleMount_Get_Khaos_CheckBox("CheckBoxEnabled", "enabled", SIMPLEMOUNT_KHAOS_ENABLE_TEXT, SIMPLEMOUNT_KHAOS_ENABLE_HELP, true, cb));
	local cb2 = function(state) SimpleMount_UpdateValue("handleGathering", state.checked, "COS_SIMPLEMOUNT_GATHERING"); end;
	table.insert(optionSetEasy.options, SimpleMount_Get_Khaos_CheckBox("CheckBoxGathering", "handleGathering", SIMPLEMOUNT_KHAOS_GATHERING_TEXT, SIMPLEMOUNT_KHAOS_GATHERING_HELP, true, cb2));
	local cb3 = function(state) SimpleMount_UpdateValue("handleMailbox", state.checked, "COS_SIMPLEMOUNT_MAILBOX"); end;
	table.insert(optionSetEasy.options, SimpleMount_Get_Khaos_CheckBox("CheckBoxMailbox", "handleMailbox", SIMPLEMOUNT_KHAOS_MAILBOX_TEXT, SIMPLEMOUNT_KHAOS_MAILBOX_HELP, true, cb3));
	-- SIMPLEMOUNT_COMBAT START
	local cb4 = function(state) SimpleMount_UpdateValue("mountAfterCombat", state.checked, "COS_SIMPLEMOUNT_COMBAT"); end;
	--table.insert(optionSetEasy.options, SimpleMount_Get_Khaos_CheckBox("CheckBoxMountAfterCombat", "mountAfterCombat", SIMPLEMOUNT_KHAOS_COMBAT_TEXT, SIMPLEMOUNT_KHAOS_COMBAT_HELP, false, cb3));
	-- SIMPLEMOUNT_COMBAT END

	local optionSetAdvanced = {
		id = SIMPLEMOUNT_KHAOS_SET_ADVANCED_ID;
		text = SIMPLEMOUNT_KHAOS_ADVANCEDSET_TEXT;
		helptext = SIMPLEMOUNT_KHAOS_ADVANCEDSET_HELP;
		difficulty = 3;
		options = {};
		default = true;
	};

	local cb5 = function(state) SimpleMount_UpdateValue("remountWhenClosingMailbox", state.checked); end;
	table.insert(optionSetAdvanced.options, SimpleMount_Get_Khaos_CheckBox("CheckBoxMailboxClose", "remountWhenClosingMailbox", SIMPLEMOUNT_KHAOS_MBREMOUNTCLOSE_TEXT, SIMPLEMOUNT_KHAOS_MBREMOUNTCLOSE_HELP, true, cb5));
	local cb6 = function(state) SimpleMount_UpdateValue("remountWhenClosingMailbox", state.checked); SimpleMount_Options.remountWithMailboxOpen = state.checked; end;
	table.insert(optionSetAdvanced.options, SimpleMount_Get_Khaos_CheckBox("CheckBoxMailboxOpen", "remountWithMailboxOpen", SIMPLEMOUNT_KHAOS_MBREMOUNTOPEN_TEXT, SIMPLEMOUNT_KHAOS_MBREMOUNTOPEN_HELP, true, cb6));

	local optionGatherRemountTimeout = {
		id = "SliderGatherRemountTimeout";
		key = "gatheringRemountTimeout";
		value = "15";
		text = SIMPLEMOUNT_KHAOS_GATHER_TIMEOUT_TEXT;
		helptext = SIMPLEMOUNT_KHAOS_GATHER_TIMEOUT_HELP;
		callback = function(state) SimpleMount_UpdateValue("gatheringRemountTimeout", state.value); end;
		type = K_SLIDER;
		feedback = function(state) if ( state.value == 0 ) then return SIMPLEMOUNT_KHAOS_GATHER_TIMEOUT_NONE; end return string.format(SIMPLEMOUNT_KHAOS_GATHER_TIMEOUT_FORMAT, state.value); end;
		setup = {
			sliderMin = 0;
			sliderMax = 60;
			sliderStep = 1;
		};
		default = {
			checked = true;
			value = "30";
		};
		disabled = {
			checked = false;
		};
	};
	table.insert(optionSetAdvanced.options, optionGatherRemountTimeout);
	local optionTimeAfterLoot = {
		id = "SliderTimeAfterLoot";
		key = "timeAfterLoot";
		value = "1";
		text = SIMPLEMOUNT_KHAOS_TIME_AFTER_LOOT_TEXT;
		helptext = SIMPLEMOUNT_KHAOS_TIME_AFTER_LOOT_HELP;
		callback = function(state) SimpleMount_UpdateValue("timeAfterLoot", state.value); end;
		type = K_SLIDER;
		feedback = function(state) return string.format(SIMPLEMOUNT_KHAOS_TIME_AFTER_LOOT_FORMAT, state.value); end;
		setup = {
			sliderMin = 0.5;
			sliderMax = 10;
			sliderStep = 0.5;
		};
		default = {
			checked = true;
			value = "1";
		};
		disabled = {
			checked = false;
		};
	};
	table.insert(optionSetAdvanced.options, optionTimeAfterLoot);
	local optionTimeAfterLootMult = {
		id = "SliderTimeAfterLootMult";
		key = "timeAfterLootMultiple";
		value = "3";
		text = SIMPLEMOUNT_KHAOS_TIME_AFTER_LOOT_MULT_TEXT;
		helptext = SIMPLEMOUNT_KHAOS_TIME_AFTER_LOOT_MULT_HELP;
		callback = function(state) SimpleMount_UpdateValue("timeAfterLootMultiple", state.value); end;
		type = K_SLIDER;
		feedback = function(state) return string.format(SIMPLEMOUNT_KHAOS_TIME_AFTER_LOOT_MULT_FORMAT, state.value); end;
		setup = {
			sliderMin = 0.5;
			sliderMax = 15;
			sliderStep = 0.5;
		};
		default = {
			checked = true;
			value = "3";
		};
		disabled = {
			checked = false;
		};
	};
	table.insert(optionSetAdvanced.options, optionTimeAfterLootMult);
	local optionCombatTimeToWaitBeforeRemount = {
		id = "SliderTimeToMountAfterCombat";
		key = "timeToMountAfterCombat";
		value = "5";
		text = SIMPLEMOUNT_KHAOS_COMBAT_TIMEOUT_TEXT;
		helptext = SIMPLEMOUNT_KHAOS_COMBAT_TIMEOUT_HELP;
		callback = function(state) SimpleMount_UpdateValue("timeToMountAfterCombat", state.value); end;
		type = K_SLIDER;
		feedback = function(state) return string.format(SIMPLEMOUNT_KHAOS_COMBAT_TIMEOUT_FORMAT, state.value); end;
		setup = {
			sliderMin = 1;
			sliderMax = 30;
			sliderStep = 1;
		};
		default = {
			checked = true;
			value = "5";
		};
		disabled = {
			checked = false;
		};
	};
	table.insert(optionSetAdvanced.options, optionCombatTimeToWaitBeforeRemount);
	Khaos.registerOptionSet( SimpleMount_Folder.id, optionSetEasy );
	Khaos.registerOptionSet( SimpleMount_Folder.id, optionSetAdvanced );
	return true;
end

-- /script Old_SimpleMount_DoToggle_Checkbox = SimpleMount_DoToggle_Checkbox; SimpleMount_DoToggle_Checkbox = function(a, b, c, d, ...) PrintTable({a, b, d}); return Old_SimpleMount_DoToggle_Checkbox(a, b, c, d, unpack(arg)); end;
-- /script SimpleMount_DoToggle_Checkbox = Old_SimpleMount_DoToggle_Checkbox

function SimpleMount_DoToggle_Checkbox(cosName, varName, chatFormat, toggle, nochat)
	local newValue = nil;
	if ( toggle == 1 ) then
		newValue = true;
	else
		newValue = false;
	end
	SimpleMount_Options[varName] = newValue;
	AddOnHelper_Generic_CosmosUpdateCheckOnOff(cosName, toggle);
	if ( Khaos ) and ( varName ) then
		local v = Khaos.getSetKey(SIMPLEMOUNT_KHAOS_SET_EASY_ID, varName);
		if ( v ) then
			Khaos.setSetKeyParameter(SIMPLEMOUNT_KHAOS_SET_EASY_ID, varName, "checked", newValue);
			Khaos.updateFolder(SimpleMount_Folder);
		end
	end
	if ( not nochat ) then
		if ( SimpleMount_Options[varName] ) then
			AddOnHandler_Print(string.format(chatFormat), SIMPLEMOUNT_STATE_ENABLED);
		else
			AddOnHandler_Print(string.format(chatFormat), SIMPLEMOUNT_STATE_DISABLED);
		end
	end
	return newValue;
end

function SimpleMount_DoToggle_Enabled(toggle, nochat)
	return SimpleMount_DoToggle_Checkbox("COS_SIMPLEMOUNT_ENABLED", "enabled", SIMPLEMOUNT_CHAT_STATE, toggle, nochat);
end

function SimpleMount_Toggle_Enabled(toggle)
	return SimpleMount_DoToggle_Enabled(toggle);
end

function SimpleMount_Toggle_Enabled_NoChat(toggle)
	return SimpleMount_DoToggle_Enabled(toggle, true);
end

function SimpleMount_DoToggle_Gathering(toggle, nochat)
	return SimpleMount_DoToggle_Checkbox("COS_SIMPLEMOUNT_GATHERING", "handleGathering", SIMPLEMOUNT_CHAT_GATHERING, toggle, nochat);
end

function SimpleMount_Toggle_Gathering(toggle)
	return SimpleMount_DoToggle_Gathering(toggle);
end

function SimpleMount_Toggle_Gathering_NoChat(toggle)
	return SimpleMount_DoToggle_Gathering(toggle, true);
end

function SimpleMount_DoToggle_Mailbox(toggle, nochat)
	return SimpleMount_DoToggle_Checkbox("COS_SIMPLEMOUNT_MAILBOX", "handleMailbox", SIMPLEMOUNT_CHAT_MAILBOX, toggle, nochat);
end

function SimpleMount_Toggle_Mailbox(toggle)
	return SimpleMount_DoToggle_Mailbox(toggle);
end

function SimpleMount_Toggle_Mailbox_NoChat(toggle)
	return SimpleMount_DoToggle_Mailbox(toggle, true);
end

function SimpleMount_DoToggle_Combat(toggle, nochat)
	return SimpleMount_DoToggle_Checkbox("COS_SIMPLEMOUNT_COMBAT", "mountAfterCombat", SIMPLEMOUNT_CHAT_COMBAT, toggle, nochat);
end

function SimpleMount_Toggle_Combat(toggle)
	return SimpleMount_DoToggle_Combat(toggle);
end

function SimpleMount_Toggle_Combat_NoChat(toggle)
	return SimpleMount_DoToggle_Combat(toggle, true);
end



function SimpleMount_GetCosmosCheckboxState(var)
	if ( SimpleMount_Options[var] ) then
		return 1;
	else
		return 0;
	end
end

function SimpleMount_Register_Cosmos()
	if ( Cosmos_RegisterConfiguration ) and ( Cosmos_UpdateValue ) then
		Cosmos_RegisterConfiguration(
			"COS_SIMPLEMOUNT",
			"SECTION",
			TEXT(SIMPLEMOUNT_CONFIG_HEADER),
			TEXT(SIMPLEMOUNT_CONFIG_HEADER_INFO)
		);
		Cosmos_RegisterConfiguration(
			"COS_SIMPLEMOUNT_HEADER",
			"SEPARATOR",
			TEXT(SIMPLEMOUNT_CONFIG_HEADER),
			TEXT(SIMPLEMOUNT_CONFIG_HEADER_INFO)
		);
		Cosmos_RegisterConfiguration(
			"COS_SIMPLEMOUNT_ENABLED",
			"CHECKBOX",
			TEXT(SIMPLEMOUNT_KHAOS_ENABLE_TEXT),
			TEXT(SIMPLEMOUNT_KHAOS_ENABLE_HELP),
			SimpleMount_Toggle_Enabled_NoChat,
			SimpleMount_GetCosmosCheckboxState("enabled")
		);
		Cosmos_RegisterConfiguration(
			"COS_SIMPLEMOUNT_GATHERING",
			"CHECKBOX",
			TEXT(SIMPLEMOUNT_KHAOS_GATHERING_TEXT),
			TEXT(SIMPLEMOUNT_KHAOS_GATHERING_HELP),
			SimpleMount_Toggle_Gathering_NoChat,
			SimpleMount_GetCosmosCheckboxState("handleGathering")
		);
		Cosmos_RegisterConfiguration(
			"COS_SIMPLEMOUNT_MAILBOX",
			"CHECKBOX",
			TEXT(SIMPLEMOUNT_KHAOS_MAILBOX_TEXT),
			TEXT(SIMPLEMOUNT_KHAOS_MAILBOX_HELP),
			SimpleMount_Toggle_Mailbox_NoChat,
			SimpleMount_GetCosmosCheckboxState("handleMailbox")
		);
	-- SIMPLEMOUNT_COMBAT START
		--[[
		Cosmos_RegisterConfiguration(
			"COS_SIMPLEMOUNT_COMBAT",
			"CHECKBOX",
			TEXT(SIMPLEMOUNT_KHAOS_COMBAT_TEXT),
			TEXT(SIMPLEMOUNT_KHAOS_COMBAT_HELP),
			SimpleMount_Toggle_Combat_NoChat,
			SimpleMount_GetCosmosCheckboxState("mountAfterCombat")
		);
		]]--
	-- SIMPLEMOUNT_COMBAT END
	end
end


function SimpleMount_Usage()
	for k, v in SIMPLEMOUNT_OPTIONS_CMD_USAGE do
		AddOnHelper_Print(v);
	end
end

function SimpleMount_SlashCommand_Set(msg)
	local featString, params = AddOnHelper_Extract_NextParameter(msg);
	local feat = nil;
	for k, v in SIMPLEMOUNT_OPTIONS_SLASH_FEAT do
		if ( AddOnHelper_IsValueInList(featString, v) ) then
			feat = k;
			break;
		end
	end
	if ( not feat ) then
		AddOnHelper_Print(SIMPLEMOUNT_ERROR_ILLEGAL_FEAT, 1, 0.2, 0.2);
		SimpleMount_Usage()
		return false;
	end
	local valueString;
	valueString, params = AddOnHelper_Extract_NextParameter(params);
	local value = tonumber(valueString);
	if ( not value ) then
		AddOnHelper_Print(SIMPLEMOUNT_ERROR_NO_VALUE_TO_SET);
		return false;
	end
	
	if ( not AddOnHelper_IsValueInList(feat, SIMPLEMOUNT_CMD_FEAT_VALID[cmd]) ) then
		for k, v in SIMPLEMOUNT_SET_FEAT_VALID_VALUE do
			if ( value == v ) then
				local featFunc = SimpleMount_SlashCommandArray[k];
				if ( featFunc ) then
					return featFunc(msg);
				end
			end
		end
		AddOnHelper_Print(string.format(SIMPLEMOUNT_ERROR_WRONG_CMD_FEAT, SIMPLEMOUNT_WRONG_CMD_FEAT[cmd]));
		return false;
	end
	SimpleMount_Options[optionsPtr] = newState;
	if ( Cosmos_UpdateValue ) then
		local cosName = SIMPLEMOUNT_FEAT_COSMOS_MAP[feat];
		if ( cosName ) then
			AddOnHelper_Generic_CosmosUpdateValue(cosName, value);
		end
	end
	if ( Khaos ) then
		local v = Khaos.getSetKey(SIMPLEMOUNT_KHAOS_SET_EASY_ID, optionsPtr);
		if ( v ) then
			Khaos.setSetKeyParameter(SIMPLEMOUNT_KHAOS_SET_EASY_ID, optionsPtr, "value", value);
			Khaos.updateFolder(SimpleMount_Folder);
		end
	end

	AddOnHelper_Print(string.format(SIMPLEMOUNT_CMD_SET_CHAT_STATE[feat], value));
	return true;
end

function SimpleMount_SlashCommand_CheckBox(msg, cmd, newValue)
	local featString, params = AddOnHelper_Extract_NextParameter(msg);
	local feat = nil;
	for k, v in SIMPLEMOUNT_OPTIONS_SLASH_FEAT do
		if ( AddOnHelper_IsValueInList(featString, v) ) then
			feat = k;
			break;
		end
	end
	if ( not feat ) and ( strlen(featString) <= 0 ) then
		feat = "main";
	end
	if ( not feat ) then
		AddOnHelper_Print(SIMPLEMOUNT_ERROR_ILLEGAL_FEAT, 1, 0.2, 0.2);
		SimpleMount_Usage()
		return false;
	end
	if ( not AddOnHelper_IsValueInList(feat, SIMPLEMOUNT_CMD_FEAT_VALID[cmd]) ) then
		AddOnHelper_Print(string.format(SIMPLEMOUNT_ERROR_WRONG_CMD_FEAT, SIMPLEMOUNT_WRONG_CMD_FEAT[cmd]));
		return false;
	end
	
	local optionsPtr = SIMPLEMOUNT_FEAT_OPTIONS_MAP[feat];
	local oldState = SimpleMount_Options[optionsPtr];
	local newState = true;
	if ( newValue == -1 ) then
		if ( oldState ) then
			newState = false;
		end
	elseif( newValue == 0 ) then
		newState = false;
	end
	SimpleMount_Options[optionsPtr] = newState;
	if ( Cosmos_UpdateValue ) then
		local cosName = SIMPLEMOUNT_FEAT_COSMOS_MAP[feat];
		if ( cosName ) then
			AddOnHelper_Generic_CosmosUpdateCheckOnOff(cosName, SimpleMount_GetCosmosCheckboxState(optionsPtr));
		end
	end
	if ( Khaos ) then
		local v = Khaos.getSetKey(SIMPLEMOUNT_KHAOS_SET_EASY_ID, optionsPtr);
		if ( v ) then
			Khaos.setSetKeyParameter(SIMPLEMOUNT_KHAOS_SET_EASY_ID, optionsPtr, "checked", newValue);
			Khaos.updateFolder(SimpleMount_Folder);
		end
	end
	local stateStr = SIMPLEMOUNT_STATE_ENABLED;
	if ( not newState ) then
		stateStr = SIMPLEMOUNT_STATE_DISABLED;
	end
	AddOnHelper_Print(string.format(SIMPLEMOUNT_CMD_CHECKBOX_CHAT_STATE[feat], stateStr));
	return true;
end

function SimpleMount_SlashCommand_Toggle(msg)
	return SimpleMount_SlashCommand_CheckBox(msg, "toggle", -1);
end

function SimpleMount_SlashCommand_Enable(msg)
	return SimpleMount_SlashCommand_CheckBox(msg, "enable", 1);
end

function SimpleMount_SlashCommand_Disable(msg)
	return SimpleMount_SlashCommand_CheckBox(msg, "disable", 0);
end

SimpleMount_SlashCommandArray = {};
SimpleMount_SlashCommandArray["help"] = SimpleMount_Usage;
SimpleMount_SlashCommandArray["toggle"] = SimpleMount_SlashCommand_Toggle;
SimpleMount_SlashCommandArray["enable"] = SimpleMount_SlashCommand_Enable;
SimpleMount_SlashCommandArray["disable"] = SimpleMount_SlashCommand_Disable;
SimpleMount_SlashCommandArray["set"] = SimpleMount_SlashCommand_Set;

function SimpleMount_SlashCommand_Acknowledge(msg)
	local chat = SIMPLEMOUNT_CHAT_ACKNOWLEDGED;
	SimpleMount_HasAcknowledged = true;
	local lmsg = string.lower(msg);
	if ( lmsg == SIMPLEMOUNT_CMD_ACKNOWLEDGE_OPT_PERM ) then
		SimpleMount_Options.ignoreClass = true;
		chat = SIMPLEMOUNT_CHAT_ACKNOWLEDGED_PERM;
	elseif ( lmsg == SIMPLEMOUNT_CMD_ACKNOWLEDGE_OPT_EXPLAIN ) then
		chat = SIMPLEMOUNT_CHAT_ACKNOWLEDGE_EXPLAIN;
	end
	if ( type(chat) == "table" ) then
		for k, v in chat do
			AddOnHelper_Print(v);
		end
	else
		AddOnHelper_Print(chat);
	end
	return true;
end

function SimpleMount_SlashCommand(msg)
	local cmd, params = AddOnHelper_Extract_NextParameter(msg);
	local lcmd = nil;
	if ( cmd ) then lcmd = string.lower(cmd); end
	if ( lcmd ) and ( lcmd == SIMPLEMOUNT_CMD_ACKNOWLEDGE ) then
		return SimpleMount_SlashCommand_Acknowledge(params);
	end
	if ( not SimpleMount_CheckAcknowledgement() ) then
		return false;
	end
	if ( not msg ) or ( strlen(msg) <= 0 ) then
		SimpleMount_Usage();
		return false;
	end
	if ( not lcmd ) or ( strlen(lcmd) <= 0 ) then
		SimpleMount_Usage();
		return false;
	else
		for k, v in SimpleMount_SlashCommandArray do
			if ( AddOnHelper_IsValueInList(lcmd, SIMPLEMOUNT_OPTIONS_SLASH_CMDS[k] ) ) then
				return v(params);
			end
		end
		SimpleMount_Usage();
		return false;
	end
end

function SimpleMount_Register_SlashCommands()
	local arr = {
		identifier = "SIMPLEMOUNTSLASHCMD",
		slashcommands = SIMPLEMOUNT_OPTIONS_CMD,
		func = SimpleMount_SlashCommand,
		description = SIMPLEMOUNT_OPTIONS_CMD_DESC,
	};
	AddOnHelper_AddSlashCommandTable(arr);
end


function SimpleMount_Options_OnLoad()
	SimpleMount_Register_SlashCommands();
	SimpleMount_Register_Khaos();
	SimpleMount_Register_Cosmos();
end
