INVENTORY_ALERT_STATUS_SLOTS = {};
INVENTORY_ALERT_STATUS_SLOTS[1] = {slot = "Head"};
INVENTORY_ALERT_STATUS_SLOTS[2] = {slot ="Shoulders"};
INVENTORY_ALERT_STATUS_SLOTS[3] = {slot ="Chest"};
INVENTORY_ALERT_STATUS_SLOTS[4] = {slot ="Waist"};
INVENTORY_ALERT_STATUS_SLOTS[5] = {slot ="Legs"};
INVENTORY_ALERT_STATUS_SLOTS[6] = {slot ="Feet"};
INVENTORY_ALERT_STATUS_SLOTS[7] = {slot ="Wrists"};
INVENTORY_ALERT_STATUS_SLOTS[8] = {slot ="Hands"};
INVENTORY_ALERT_STATUS_SLOTS[9] = {slot ="Weapon", showSeparate = 1};
INVENTORY_ALERT_STATUS_SLOTS[10] = {slot ="Shield", showSeparate = 1};
INVENTORY_ALERT_STATUS_SLOTS[11] = {slot ="Ranged", showSeparate = 1};

INVENTORY_ALERT_COLORS = {};
INVENTORY_ALERT_COLORS[0] = nil;
INVENTORY_ALERT_COLORS[1] = nil;
INVENTORY_ALERT_COLORS[2] = {r = 0.18, g = 0.72, b = 1};
INVENTORY_ALERT_COLORS[3] = {r = 1, g = 0.82, b = 0.18};
INVENTORY_ALERT_COLORS[4] = {r = 0.93, g = 0.07, b = 0.07};

function DurabilityFrame_SetAlerts()
	local texture, color, showDurability;
	for index, value in INVENTORY_ALERT_STATUS_SLOTS do
		texture = getglobal("Durability"..value.slot);
		if ( value.slot == "Shield" ) then
			if ( OffhandHasWeapon() ) then
				DurabilityShield:Hide();
				texture = DurabilityOffWeapon;
			else
				DurabilityOffWeapon:Hide();
				texture = DurabilityShield;
			end
		end

		color = INVENTORY_ALERT_COLORS[GetInventoryAlertStatus(index)];
		if ( color ) then
			texture:SetVertexColor(color.r, color.g, color.b, 1.0);
			if ( value.showSeparate ) then
				texture:Show();			
			else
				showDurability = 1;
			end
		else
			texture:SetVertexColor(1.0, 1.0, 1.0, 0.5);
			if ( value.showSeparate ) then
				texture:Hide();			
			end
		end
	end
	for index, value in INVENTORY_ALERT_STATUS_SLOTS do
		if ( not value.showSeparate ) then
			if ( showDurability ) then
				getglobal("Durability"..value.slot):Show();
			else
				getglobal("Durability"..value.slot):Hide();
			end
		end
	end
end

-- added to support loading/saving of the new position

function DurabilityFrame_HandleVariablesLoaded()
	local newX = -1;
	local newY = -1;
	if ( Cosmos_GetCVar ) then
		local tmpNewX = Cosmos_GetCVar("DURABILITYFRAME_NEWX");
		local tmpNewY = Cosmos_GetCVar("DURABILITYFRAME_NEWY");
		if ( ( tmpNewX ~= nil ) and ( tmpNewY ~= nil ) ) then
			DurabilityFrame_NewX = tmpNewX;
			DurabilityFrame_NewY = tmpNewY;
		end
	end
	if ( ( DurabilityFrame_NewX ~= nil ) and ( DurabilityFrame_NewX >= 0 ) ) then
		newX = DurabilityFrame_NewX;
	end
	if ( ( DurabilityFrame_NewY ~= nil ) and ( DurabilityFrame_NewY >= 0 ) ) then
		newY = DurabilityFrame_NewY;
	end
	if ( ( newX ~= -1 ) and ( newY ~= -1 ) ) then
		this:SetPoint("TOPLEFT", "UIParent", "BOTTOMLEFT", newX, newY);
	end

	if ( Cosmos_RegisterConfiguration ) then

		Cosmos_RegisterConfiguration("COS_DURABILITYFRAME",
			"SECTION",
			"Durability frame modification",
			"Contains options for the modified durability frame"
			);
		Cosmos_RegisterConfiguration("COS_DURABILITYFRAME_HEADER",
			"SEPERATOR",
			"Durability frame modification",
			"Contains options for the modified durability frame"
			);
		Cosmos_RegisterConfiguration("COS_DURABILITYFRAME_RESET_POSITION",
			"BUTTON",
			"Reset durability frame position",
			"Reset the position of the durability frame to its default.",
			DurabilityFrame_ResetPosition(),
			0,
			0,
			0,
			0,
			"Reset"
			);
	end
end

function DurabilityFrame_ResetPosition()
	DurabilityFrame:SetPoint("TOP", "MinimapCluster", "BOTTOM", 40, 15);
	DurabilityFrame_NewX = -1;
	DurabilityFrame_NewY = -1;
	
	DurabilityFrame_SaveCurrentPosition();
end

function DurabilityFrame_SaveCurrentPosition()
	if ( CosmosMaster_RegisterCVar ) then
		CosmosMaster_RegisterCVar("DURABILITYFRAME_NEWX", DurabilityFrame_NewX);
		CosmosMaster_RegisterCVar("DURABILITYFRAME_NEWY", DurabilityFrame_NewY);
	end
	if ( Cosmos_RegisterCVar ) then
		Cosmos_RegisterCVar("DURABILITYFRAME_NEWX", DurabilityFrame_NewX);
		Cosmos_RegisterCVar("DURABILITYFRAME_NEWY", DurabilityFrame_NewY);
	end
	if ( Cosmos_SetCVar ) then
		Cosmos_SetCVar("DURABILITYFRAME_NEWX", DurabilityFrame_NewX);
		Cosmos_SetCVar("DURABILITYFRAME_NEWY", DurabilityFrame_NewY);
	end
	RegisterForSave("DurabilityFrame_NewX");
	RegisterForSave("DurabilityFrame_NewY");
end
