CHARACTER_FACING_INCREMENT = 2;
MAX_RACES = 8;
MAX_CLASSES_PER_RACE = 8;
NUM_CHAR_CUSTOMIZATIONS = 5;
MIN_CHAR_NAME_LENGTH = 2;
FACTION_BACKDROP_COLOR_TABLE = {
	["Alliance"] = {0.5, 0.5, 0.5, 0.09, 0.09, 0.19},
	["Horde"] = {0.5, 0.2, 0.2, 0.19, 0.05, 0.05}
};
FRAMES_TO_BACKDROP_COLOR = { 
	"CharacterCreateCharacterRace",
	"CharacterCreateCharacterClass",
	"CharacterCreateCharacterFaction",
	"CharacterCustomizationFrame",
	"CharacterCreateGenderFrame",
	"CharacterCreateRaceFrame",
	"CharacterCreateClassFrame"
};

function CharacterCreate_OnLoad()
	this:SetSequence(0);
	this:SetCamera(0);

	CharacterCreateGenderButton1Text:SetText(TEXT(MALE));
	CharacterCreateGenderButton2Text:SetText(TEXT(FEMALE));

	CharacterCreate.numRaces = 0;
	CharacterCreate.selectedRace = 0;
	CharacterCreate.numClasses = 0;
	CharacterCreate.selectedClass = 0;
	CharacterCreate.selectedGender = 0;

	SetCharCustomizeFrame("CharacterCreate");
	--CharCreateModel:SetLight(1, 0, 0, -0.707, -0.707, 0.7, 1.0, 1.0, 1.0, 0.8, 1.0, 1.0, 0.8);

	for i=1, NUM_CHAR_CUSTOMIZATIONS, 1 do
		getglobal("CharacterCustomizationButtonFrame"..i.."Text"):SetText(TEXT(getglobal("CHAR_CUSTOMIZATION"..i.."_DESC")));
	end
end

function CharacterCreate_OnShow()
	--randomly selects a combination
	ResetCharCustomize();

	CharacterCreateEnumerateRaces(GetAvailableRaces());
	SetCharacterRace(GetSelectedRace());

	--SetSelectedSex(GetSelectedSex());
	SetCharacterGender(GetSelectedSex());
	
	SetCharacterClass(1);
	CharacterCreateEnumerateClasses(GetClassesForRace());
	
	CharacterCreateNameEdit:SetText("");
	SetCharacterFacing(0);
end

function CharacterCreateEnumerateRaces(...)
	CharacterCreate.numRaces = arg.n;
	if ( arg.n > MAX_RACES ) then
		message("Too many races!  Update MAX_RACES");
		return;
	end

	for i=1, arg.n, 1 do
		getglobal("CharacterCreateRaceButton"..i.."Text"):SetText(arg[i]);
		getglobal("CharacterCreateRaceButton"..i):Show();
	end
	for i=arg.n + 1, MAX_RACES, 1 do
		getglobal("CharacterCreateRaceButton"..i):Hide();
	end

	CharacterCreateRaceFrame:SetHeight((ceil(arg.n / 2) * 32) + 16);
end

function CharacterCreateEnumerateClasses(...)
	CharacterCreate.numClasses = arg.n;
	if ( arg.n > MAX_CLASSES_PER_RACE ) then
		message("Too many classes!  Update MAX_CLASSES_PER_RACE");
		return;
	end

	for i=1, arg.n, 1 do
		getglobal("CharacterCreateClassButton"..i.."Text"):SetText(arg[i]);
		getglobal("CharacterCreateClassButton"..i):Show();
	end
	for i=arg.n + 1, MAX_CLASSES_PER_RACE, 1 do
		getglobal("CharacterCreateClassButton"..i):Hide();
	end

	CharacterCreateClassFrame:SetHeight((ceil(arg.n / 2) * 27) + 32);
end

function SetCharacterRace(id)
	CharacterCreate.selectedRace = id;
	for i=1, CharacterCreate.numRaces, 1 do
		local button = getglobal("CharacterCreateRaceButton"..i);
		if ( i == id ) then
			button:SetChecked(1);
		else
			button:SetChecked(0);
		end
	end

	--twain SetSelectedRace(id);
	local temp, faction = GetFactionForRace();
	if ( faction == "Alliance" ) then
		CharacterCreateAllianceLabel:Show();
		CharacterCreateHordeLabel:Hide();
		
	else
		CharacterCreateAllianceLabel:Hide();
		CharacterCreateHordeLabel:Show();
	end
	CharacterCreateFactionText:SetText(getglobal("FACTION_INFO_"..strupper(faction)));
	CharacterCreateCharacterFaction:SetHeight(CharacterCreateFactionText:GetHeight() + 40);

	local race, fileString = GetNameForRace();
	fileString = strupper(fileString);
	CharacterCreateRaceText:SetText(getglobal("RACE_INFO_"..fileString).."\n\n"..getglobal("ABILITY_INFO_"..fileString).."\n\n");
	CharacterCreateCharacterRace:SetHeight(CharacterCreateRaceText:GetHeight() + 40);

	-- Set backdrop colors based on faction
	local backdropColor = FACTION_BACKDROP_COLOR_TABLE[faction];
	local frame;
	for index, value in FRAMES_TO_BACKDROP_COLOR do
		frame = getglobal(value);
		frame:SetBackdropBorderColor(backdropColor[1], backdropColor[2], backdropColor[3]);
		frame:SetBackdropColor(backdropColor[4], backdropColor[5], backdropColor[6]);
	end

	SetBackgroundModel(CharacterCreate, fileString);
	--twainUpdateCustomizationBackground();
	
	CharacterCreateEnumerateClasses(GetClassesForRace());
	SetCharacterClass(1);

	-- Show or hide customization buttons as needed, just doing the facial hair button for now
	CharacterCreate_HideShowCustomizationButton(5);
end

function SetCharacterClass(id)
	CharacterCreate.selectedClass = id;
	for i=1, CharacterCreate.numClasses, 1 do
		local button = getglobal("CharacterCreateClassButton"..i);
		if ( i == id ) then
			button:SetChecked(1);
		else
			button:SetChecked(0);
		end
	end
	
	--twain SetSelectedClass(id);
	local classID, className = GetSelectedClass();
	CharacterCreateClassText:SetText(getglobal("CLASS_"..strupper(className)));
	CharacterCreateCharacterClass:SetHeight(CharacterCreateClassText:GetHeight() + 45);
end

function SetCharacterGender(id)
	if ( id == 1 ) then
		CharacterCreateGenderButton1:SetChecked(1);
		CharacterCreateGenderButton2:SetChecked(0);
	else
		CharacterCreateGenderButton1:SetChecked(0);
		CharacterCreateGenderButton2:SetChecked(1);
	end
	
	--twain SetSelectedSex(id);

	-- Show or hide customization buttons as needed, just doing the facial hair button for now
	CharacterCreate_HideShowCustomizationButton(5);
end

function CharacterCreate_OnChar()
end

function CharacterCreate_OnKeyDown()
	if ( arg1 == "ESCAPE" ) then
		CharacterCreate_Back();
	elseif ( arg1 == "ENTER" ) then
		CharacterCreate_Okay();
	elseif ( arg1 == "PRINTSCREEN" ) then
		Screenshot();
	end
end

function CharacterCreate_UpdateModel()
	UpdateCustomizationScene();
	this:AdvanceTime();
end

function CharacterCreate_Okay()
	PlaySound("gsCharacterCreationCreateChar");
	CreateCharacter(CharacterCreateNameEdit:GetText());
end

function CharacterCreate_Back()
	PlaySound("gsCharacterCreationCancel");
	SetGlueScreen("charselect");
end

function CharacterClass_OnClick(id)
	PlaySound("gsCharacterCreationClass");
	SetSelectedClass(id);
	SetCharacterClass(id);
end

function CharacterRace_OnClick(id)
	PlaySound("gsCharacterCreationClass");
	if ( not this:GetChecked() ) then
		this:SetChecked(1);
		return;
	end
	SetSelectedRace(id);
	SetCharacterRace(id);
	SetSelectedSex(GetSelectedSex());
	SetCharacterGender(GetSelectedSex());
	SetCharacterFacing(0);
end

function CharacterGender_OnClick(id)
	PlaySound("gsCharacterCreationGender");
	SetSelectedSex(id);
	SetCharacterGender(id);
end

function CharacterCustomization_Left(id)
	PlaySound("gsCharacterCreationLook");
	CycleCharCustomization(id, -1);
end

function CharacterCustomization_Right(id)
	PlaySound("gsCharacterCreationLook");
	CycleCharCustomization(id, 1);
end

function CharacterCreate_Randomize()
	PlaySound("gsCharacterCreationLook");
	RandomizeCharCustomization();
end

function CharacterCreateRotateRight_OnUpdate()
	if ( this:GetButtonState() == "PUSHED" ) then
		SetCharacterFacing(GetCharacterFacing() + CHARACTER_FACING_INCREMENT);
	end
end

function CharacterCreateRotateLeft_OnUpdate()
	if ( this:GetButtonState() == "PUSHED" ) then
		SetCharacterFacing(GetCharacterFacing() - CHARACTER_FACING_INCREMENT);
	end
end

function CharacterCreate_HideShowCustomizationButton(id)
	-- Right now this function is actually a hide show facial hair button, but will probably be generalized later
	local customizationButton = getglobal("CharacterCustomizationButtonFrame"..id);
	if ( HasCharCustomization(id) ) then
		customizationButton:Show();
		CharacterCustomizationFrame:SetHeight(250);
		CharCreateRandomizeButton:SetPoint("TOP", "CharacterCustomizationButtonFrame5", "BOTTOM", 0, 0);
	else
		customizationButton:Hide();
		CharacterCustomizationFrame:SetHeight(218);
		CharCreateRandomizeButton:SetPoint("TOP", "CharacterCustomizationButtonFrame4", "BOTTOM", 0, 0);
	end
end
