
ONEHITWONDER_ABILITY_EXPOSEARMOR_TEXTURE = "Interface\\Icons\\Ability_Warrior_Riposte";
ONEHITWONDER_ABILITY_SLICEDICE_TEXTURE = "Interface\\Icons\\Ability_Rogue_SliceDice";
ONEHITWONDER_ABILITY_STEALTH_TEXTURE = "Interface\\Icons\\Ability_Stealth";

ONEHITWONDER_ABILITY_EXPOSEARMOR_NAME = "Expose Armor";
ONEHITWONDER_ABILITY_AMBUSH_NAME = "Ambush";
ONEHITWONDER_ABILITY_GOUGE_NAME = "Gouge";
ONEHITWONDER_ABILITY_BACKSTAB_NAME = "Backstab";
ONEHITWONDER_ABILITY_EVISCERATE_NAME = "Eviscerate";
ONEHITWONDER_ABILITY_SLICEDICE_NAME = "Slice and Dice";
ONEHITWONDER_ABILITY_SINISTERSTRIKE_NAME = "Sinister Strike";
ONEHITWONDER_ABILITY_PICKPOCKET_NAME = "Pick Pocket";
ONEHITWONDER_ABILITY_KICK_NAME = "Kick";
ONEHITWONDER_ABILITY_FEINT_NAME = "Feint";
ONEHITWONDER_ABILITY_RUPTURE_NAME = "Rupture";
ONEHITWONDER_ABILITY_DISTRACT_NAME = "Distract";
ONEHITWONDER_ABILITY_GARROTTE_NAME = "Garrotte";
ONEHITWONDER_ABILITY_CHEAPSHOT_NAME = "Cheap Shot";
ONEHITWONDER_ABILITY_KIDNEYSHOT_NAME = "Kidney Shot";

ONEHITWONDER_TALENT_RIPOSTE_NAME = "Riposte";

ONEHITWONDER_ABILITY_STEALTH_OPENERS = {
	ONEHITWONDER_ABILITY_GARROTTE_NAME, 
	ONEHITWONDER_ABILITY_AMBUSH_NAME,
	ONEHITWONDER_ABILITY_BACKSTAB_NAME,
	ONEHITWONDER_ABILITY_CHEAPSHOT_NAME
};

ONEHITWONDER_ABILITY_FINISHING_MOVES = {
	ONEHITWONDER_ABILITY_EXPOSEARMOR_NAME,
	ONEHITWONDER_ABILITY_EVISCERATE_NAME, 
	ONEHITWONDER_ABILITY_SLICEDICE_NAME, 
	ONEHITWONDER_ABILITY_RUPTURE_NAME,
	ONEHITWONDER_ABILITY_KIDNEYSHOT_NAME
};

-- SS needs to be modified by talents 45 default, 40 min
ONEHITWONDER_ABILITY_ENERGYCOST = {
	[ONEHITWONDER_ABILITY_AMBUSH_NAME] = 60,
	[ONEHITWONDER_ABILITY_BACKSTAB_NAME] = 60,
	[ONEHITWONDER_ABILITY_EVISCERATE_NAME] = 35,
	[ONEHITWONDER_ABILITY_SLICEDICE_NAME] = 25,
	[ONEHITWONDER_ABILITY_SINISTERSTRIKE_NAME] = 40,
	[ONEHITWONDER_ABILITY_EXPOSEARMOR_NAME] = 25,
	[ONEHITWONDER_ABILITY_GOUGE_NAME] = 45,
	[ONEHITWONDER_ABILITY_KICK_NAME] = 25,
	[ONEHITWONDER_ABILITY_FEINT_NAME] = 20,
	[ONEHITWONDER_ABILITY_RUPTURE_NAME] = 25,
	[ONEHITWONDER_ABILITY_DISTRACT_NAME] = 30,
	[ONEHITWONDER_ABILITY_GARROTTE_NAME] = 50,
	[ONEHITWONDER_ABILITY_CHEAPSHOT_NAME] = 60,
	[ONEHITWONDER_ABILITY_KIDNEYSHOT_NAME] = 25,
	[ONEHITWONDER_TALENT_RIPOSTE_NAME] = 10,
	[ONEHITWONDER_ABILITY_PICKPOCKET_NAME] = 0
};

ONEHITWONDER_ACTIONID_SPELL = 1;

function OneHitWonder_GetEnergyConsumption(abilityName)
	return ONEHITWONDER_ABILITY_ENERGYCOST[abilityName];
end



-- verify this
ONEHITWONDER_QUEUE_KICK_CHAT_TYPES = {
	"SPELL_HOSTILEPLAYER_DAMAGE",
	"SPELL_HOSTILEPLAYER_BUFF",
	"SPELL_CREATURE_VS_SELF_DAMAGE",
	"SPELL_CREATURE_VS_SELF_BUFF",
};

-- verify this
ONEHITWONDER_QUEUE_RIPOSTE_CHAT_TYPES = {
	"COMBAT_MISC_INFO"
};

function OneHitWonder_IsTargetedUnit(name)
	if ( UnitName("target") == name ) then
		return true;
	else
		return false;
	end
end

function OneHitWonder_ExtractUnitNameFromCombatMessage(arg1, arg2)
	return arg2;
end

function OneHitWonder_ChatFrame_OnEvent(event)
	if ( OneHitWonder_Enabled ) then
		if ( strsub(event, 1, 8) == "CHAT_MSG" ) then
			local type = strsub(event, 10);
			local info = ChatTypeInfo[type];
			if ( OneHitWonder_IsTargetedUnit(OneHitWonder_ExtractUnitNameFromCombatMessage(arg1, arg2)) then
				for k, v in ONEHITWONDER_QUEUE_KICK_CHAT_TYPES do
					if ( v == type ) then
						OneHitWonder_AddActionToQueue(ONEHITWONDER_ACTIONID_SPELL, OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_KICK_NAME));
					end
				end
			end
			if ( strfind(arg1, "You parry") ) then
				local riposteId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_RIPOSTE_NAME);
				if ( riposteId > 0 ) then
					for k, v in ONEHITWONDER_QUEUE_RIPOSTE_CHAT_TYPES do
						if ( v == type ) then
								OneHitWonder_AddActionToQueue(ONEHITWONDER_ACTIONID_SPELL, riposteId);
							end
						end
					end
				end
			end
		end
	end
	OneHitWonder_Saved_ChatFrame_OnEvent(event);
end

function OneHitWonder_HasTargetBuffTexture(texture)
	local buff;
	for i=1, MAX_TARGET_DEBUFFS do
		buff = UnitBuff("target", i);
		if ( buff == texture ) then
			return true;
		end
	end
	return false;
end

function OneHitWonder_HasTargetDebuffTexture(texture)
	local debuff;
	local i = 0;
	for i=1, MAX_TARGET_DEBUFFS do
		debuff = UnitDebuff("target", i);
		if ( debuff == texture ) then
			return true;
		end
	end
	return false;
end

function OneHitWonder_HasTargetAnyBuffTexture(texture)
	if ( OneHitWonder_HasTargetBuffTexture(texture) ) then
		return true;
	else
		return OneHitWonder_HasTargetDebuffTexture(texture);
	end
end

function OneHitWonder_HasBuffTexture(texture)
	local id = 1;
	for id = 1, 15 do
		if ( GetPlayerBuffTexture(id) == texture ) then
			return true;
		end
	end
	return false;
end

ONEHITWONDER_BOOK_TYPE_SPELL = "spell";

function OneHitWonder_GetSpellId(spellName)
	local i = 1;
	local name, rankName;
	name, rankName = GetSpellName(i, ONEHITWONDER_BOOK_TYPE_SPELL)
	while name do
		if ( name == spellName) then
			return i;
		end
		i = i + 1;
		name, rankName = GetSpellName(i, ONEHITWONDER_BOOK_TYPE_SPELL)
	end
	return -1;
end

function OneHitWonder_HasEnoughEnergy(abilityName)
	local energy = PlayerFrameManaBar:GetValue();

	if ( OneHitWonder_GetEnergyConsumption(abilityName) <= energy ) then
		return true;
	else
		return false;
	end
end


function OneHitWonder_CheckIfInRangeAndUsableInActionBar(texture)
	if ( texture ) then
		local id = 1;
		local actionTexture;
		for id = 1, 120 do
			actionTexture = GetActionTexture(id);
			if ( ( actionTexture ) and ( actionTexture == texture ) ) then
				local isUsable, notEnoughMana = IsUsableAction(ActionButton_GetPagedID(this));
				if ( ( isUsable ) and ( not notEnoughMana ) and (IsActionInRange(id) ~= 0) ) then
					return true;
				else
					return false;
				end
			end
		end
	end
	return true;
end

function OneHitWonder_IsSpellAvailable(spellId, spellBook)
	local start, duration, enable = GetSpellCooldown(spellId, spellBook);
	if ( enable == 1 ) then
		if ( OneHitWonder_CheckIfInRangeAndUsableInActionBar(GetSpellTexture(spellId, spellBook)) ) then
			return true;
		end
	end
	return false;
end

function OneHitWonder_CastSpell(spellId, spellBook)
	if ( OneHitWonder_IsSpellAvailable(spellId, spellBook) ) then
		CastSpell(spellId, spellBook);
		return true;
	end
	return false;
end

function OneHitWonder_GetTargetHPPercentage()
	local unitMinHP, unitMaxHP, unitCurrHP;
	unitMinHP, unitMaxHP = TargetFrameHealthBar:GetMinMaxValues();
	unitCurrHP = TargetFrameHealthBar:GetValue();
	
	local unitHPPercent = TargetFrame.unitHPPercent;



	if ( not UnitIsPlayer("target") ) then
		unitHPPercent = unitCurrHP;
	else
		unitHPPercent = math.floor(unitHPPercent * 100);
	end
	return unitHPPercent;
end

function OneHitWonder_GetComboPointsNeededToEviscerate()
	local unitHPPercent = OneHitWonder_GetTargetHPPercentage();
	local playerLevel = UnitLevel("player");
	local targetLevel = UnitLevel("target");
	if ( targetLevel - playerLevel > 5 ) then
		-- does not matter, you're not going to do something good with it anyhow
		return 1;
	end
	if ( playerLevel - targetLevel >= 10 ) then
		-- will prolly kill it quick
		return 1;
	end
	if ( playerLevel - targetLevel >= 5 ) then
		if ( unitHPPercent <= 15 ) then
			return 1;
		elseif ( unitHPPercent <= 50 ) then
			return 2;
		else
			return 3;
		end
	end
	if ( playerLevel - targetLevel >= 3 ) then
		if ( unitHPPercent <= 20 ) then
			return 1;
		elseif ( unitHPPercent <= 50 ) then
			return 2;
		else
			return 4;
		end
	end
	if ( playerLevel - targetLevel >= -1 ) then
		if ( unitHPPercent <= 25 ) then
			return 1;
		elseif ( unitHPPercent <= 40 ) then
			return 2;
		elseif ( unitHPPercent <= 50 ) then
			return 3;
		else
			return 5;
		end
	else
		if ( unitHPPercent <= 10 ) then
			return 2;
		elseif ( unitHPPercent <= 25 ) then
			return 3;
		elseif ( unitHPPercent <= 50 ) then
			return 4;
		else
			return 5;
		end
	end
end

function OneHitWonder_HasPartyMembers()
	local partyMembers = 0;
	
	for i=1, MAX_PARTY_MEMBERS, 1 do
		if ( GetPartyMember(i) ) then
			partyMembers = partyMembers + 1;
		end
	end
	if ( partyMembers > 0 ) then
		return true;
	else
		return false;
	end
end

function OneHitWonder_DumpDebuffsOnce()
	if ( not DebuffsShown ) then
		DebuffsShown = {};
	end
	for i=1, MAX_TARGET_DEBUFFS do
		debuff = UnitDebuff("target", i);
		if ( ( debuff ) and ( not DebuffsShown[debuff] ) ) then
			ShapeshiftShadowform_Print(debuff);
			DebuffsShown[debuff] = true;
		end
	end
end

function OneHitWonder_ActionQueue = {};

function OneHitWonder_AddActionToQueue(actionId, actionParameter)
	local entry = { actionId, actionParameter);
	table.insert(OneHitWonder_ActionQueue, entry);
end

function OneHitWonder_RemoveActionFromQueue(actionId, actionParameter)
	local entry = table.remove(OneHitWonder_ActionQueue);
	return entry[1], entry[2];
end

function OneHitWonder_HandleActionQueue()
	if ( getn(OneHitWonder_ActionQueue) <= 0 ) then
		return false;
	end
	
	local actionId, actionParameter = OneHitWonder_RemoveActionFromQueue();
	
	if ( actionId == ONEHITWONDER_ACTIONID_SPELL ) then
		if ( OneHitWonder_CastSpell(actionParameter, ONEHITWONDER_BOOK_TYPE_SPELL ) ) then
			return true;
		else
			return false;
		end
	else
		return false;
	end
end

function OneHitWonder_Rogue(removeDefense)
	local targetName = UnitName("target");

	if ( (not targetName) or ( strlen(targetName) <= 0 ) ) then
		return;
	end
	
	if ( not removeDefense ) then removeDefense = false; end
	
	if ( OneHitWonder_HandleActionQueue() ) then
		return;
	end
	
	if ( OneHitWonder_HasBuffTexture(ONEHITWONDER_ABILITY_STEALTH_TEXTURE) ) then
		local spellId = 0;
		if ( ( not TargetFrame.hasBeenPickPocketed ) ) then
			spellId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_PICKPOCKET_NAME);
			if ( OneHitWonder_CastSpell(spellId, ONEHITWONDER_BOOK_TYPE_SPELL ) ) then
				-- should be replaced for check for "No pockets to pick" and "You loot XYZ Copper" at a latter stage
				TargetFrame.hasBeenPickPocketed = true;
			end
			return;
		else
			spellId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_AMBUSH_NAME);
			if ( spellId <= 0 ) then
				spellId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_BACKSTAB_NAME);
			end
		end
		OneHitWonder_CastSpell(spellId, ONEHITWONDER_BOOK_TYPE_SPELL);
		return;
	end
	
	TargetFrame.hasBeenPickPocketed = false;


	local comboPoints = GetComboPoints();
	
	local unitHPPercent = OneHitWonder_GetTargetHPPercentage();

	local comboPointsNeeded = OneHitWonder_GetComboPointsNeededToEviscerate();
	
	if ( unitHPPercent >= 80 ) then
		if ( ( comboPoints > 0 ) and ( comboPoints <= 2 ) ) then
			if ( not OneHitWonder_HasBuffTexture(ONEHITWONDER_ABILITY_SLICEDICE_TEXTURE) ) then
				if ( OneHitWonder_HasEnoughEnergy(ONEHITWONDER_ABILITY_SLICEDICE_NAME) ) then
					OneHitWonder_CastSpell(OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_SLICEDICE_NAME), ONEHITWONDER_BOOK_TYPE_SPELL);
				end
				return;
			end
		end
	end	
	
	local abilityName = ONEHITWONDER_ABILITY_EVISCERATE_NAME;

	if ( ( removeDefense ) and ( not OneHitWonder_HasTargetDebuffTexture(ONEHITWONDER_ABILITY_EXPOSEARMOR_TEXTURE) ) ) then
		abilityName = ONEHITWONDER_ABILITY_EXPOSEARMOR_NAME;
	end
	
	if ( comboPoints >= comboPointsNeeded ) then
		if ( OneHitWonder_HasEnoughEnergy(abilityName) ) then
			OneHitWonder_CastSpell(OneHitWonder_GetSpellId(abilityName), ONEHITWONDER_BOOK_TYPE_SPELL);
		end
		return;
	end
	if ( OneHitWonder_HasEnoughEnergy(ONEHITWONDER_ABILITY_SINISTERSTRIKE_NAME) ) then
		OneHitWonder_CastSpell(OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_SINISTERSTRIKE_NAME), ONEHITWONDER_BOOK_TYPE_SPELL);
	end
end

-- Prints out text to a chat box.
function OneHitWonder_Print(msg,r,g,b,frame,id,unknown4th)
	if(unknown4th) then
		local temp = id;
		id = unknown4th;
		unknown4th = id;
	end
				
	if (not r) then r = 1.0; end
	if (not g) then g = 1.0; end
	if (not b) then b = 1.0; end
	if ( frame ) then 
		frame:AddMessage(msg,r,g,b,id,unknown4th);
	else
		if ( DEFAULT_CHAT_FRAME ) then 
			DEFAULT_CHAT_FRAME:AddMessage(msg, r, g, b,id,unknown4th);
		end
	end
end



function OneHitWonder_OnLoad()
end

function OneHitWonder_OnEvent(event)
end
