ONEHITWONDER_ABILITY_SHOOT = "Shoot";

ONEHITWONDER_SPELL_DRAIN_SOUL = "Drain Soul";

ONEHITWONDER_SPELL_IMMOLATE = "Immolate";
ONEHITWONDER_EFFECT_IMMOLATE = "Immolate";

ONEHITWONDER_SPELL_CORRUPTION = "Corruption";
ONEHITWONDER_EFFECT_CORRUPTION = "Corruption";

ONEHITWONDER_SPELL_SHADOW_BURN = "Shadow Burn";

ONEHITWONDER_SPELL_CURSE_AGONY = "Curse of Agony";
ONEHITWONDER_SPELL_CURSE_DOOM = "Curse of Doom";
ONEHITWONDER_SPELL_CURSE_ELEMENTS = "Curse of the Elements";
ONEHITWONDER_SPELL_CURSE_RECKLESSNESS = "Curse of Recklessness";
ONEHITWONDER_SPELL_CURSE_SHADOW = "Curse of Shadow";
ONEHITWONDER_SPELL_CURSE_TONGUES = "Curse of Tongues";
ONEHITWONDER_SPELL_CURSE_WEAKNESS = "Curse of Weakness";

ONEHITWONDER_EFFECT_CURSE_AGONY = "Curse of Agony";
ONEHITWONDER_EFFECT_CURSE_TONGUES = "Curse of Tongues";
ONEHITWONDER_EFFECT_CURSE_RECKLESSNESS = "Curse of Recklessness";

ONEHITWONDER_WARLOCK_CURSE_EFFECTS = {
	ONEHITWONDER_EFFECT_CURSE_AGONY,
	ONEHITWONDER_EFFECT_CURSE_TONGUES,
	ONEHITWONDER_EFFECT_CURSE_RECKLESSNESS
};

ONEHITWONDER_WARLOCK_CURSE_TIMES = {
	[ONEHITWONDER_SPELL_CURSE_AGONY] = 30,
	[ONEHITWONDER_SPELL_CURSE_DOOM] = 60,
	[ONEHITWONDER_SPELL_CURSE_ELEMENTS] = 120,
	[ONEHITWONDER_SPELL_CURSE_RECKLESSNESS] = 120,
	[ONEHITWONDER_SPELL_CURSE_TONGUES] = 30,
	[ONEHITWONDER_SPELL_CURSE_WEAKNESS] = 120
};

OneHitWonder_ShadowBurnPercentage = 2;
OneHitWonder_SoulDrainPercentage = 20;
OneHitWonder_ShardCount = 0;
OneHitWonder_MinimumShards = 5;
OneHitWonder_CursedTargetTime = 0;
OneHitWonder_CurrentCurseTime = 0;
OneHitWonder_LastCurse = nil;

OneHitWonder_HandleCursing = false;

function OneHitWonder_WillUnitGiveSoulShard(unit)
	return OneHitWonder_WillUnitLevelGiveSoulShard(UnitLevel(unit));
end

function OneHitWonder_WillUnitLevelGiveSoulShard(unitLevel)
	local playerLevel = UnitLevel("player");
	if ( unitLevel > (playerLevel-5) ) then
		return true;
	else
		return false;
	end
end

function OneHitWonder_CastIfTargetNotHasEffect(spell, effect, stopCasting)
	return OneHitWonder_CastIfUnitNotHasEffect("target", spell, effect, stopCasting);
end

function OneHitWonder_CastIfUnitNotHasEffect(unit, spell, effect, stopCasting)
	local effects = {};
	if ( type(effect) ~= "table" ) then
		effects = { effect };
	else
		effects = effect;
	end
	for k, v in effects do
		if ( OneHitWonder_HasUnitEffect(unit, nil, effect) ) then
			return false;
		end
	end
	return OneHitWonder_CastSpellSpecial(spell, stopCasting);
end

function OneHitWonder_CastSpellSpecial(spell, stopCasting)
	if ( OneHitWonder_HasEnoughEnergy(spell) ) then
		if ( stopCasting ) then
			SpellStopCasting();
		end
		return OneHitWonder_CastSpell(OneHitWonder_GetSpellId(spell));
	else
		return false;
	end
end


function OneHitWonder_GetCurseForTarget()
	local spellName = ONEHITWONDER_SPELL_CURSE_AGONY;
	-- if caster
	if ( UnitPowerType("target") == 0 ) then
		spellName = ONEHITWONDER_SPELL_CURSE_TONGUES;
	end
	return spellName;
end

function OneHitWonder_Warlock(removeDefense)
	local targetName = UnitName("target");

	if ( (not targetName) or ( strlen(targetName) <= 0 ) ) then
		return;
	end
	
	if ( not removeDefense ) then removeDefense = false; end
	
	if ( OneHitWonder_HandleActionQueue() ) then
		return;
	end
	
	if (OneHitWonder_PetIsAttacking == false) then
		PetAttack();
	end
		
	if ( OneHitWonder_ChannelSpellRunning ) then
		return;
	end
	
	local timeSinceSpellStopped = GetTime() - OneHitWonder_TimeSpellStopped;
	local unitHPPercent = OneHitWonder_GetTargetHPPercentage();

	local shadowBurnId = OneHitWonder_GetSpellId(ONEHITWONDER_SPELL_SHADOW_BURN);
	if ( ( shadowBurnId > -1 ) and ( unitHPPercent <= OneHitWonder_ShadowBurnPercentage ) and ( OneHitWonder_WillUnitGiveSoulShard("target") ) ) then 
		OneHitWonder_CastSpell(shadowBurnId);
		return;
	end

	
	
	if ( ( unitHPPercent <= OneHitWonder_SoulDrainPercentage ) and ( OneHitWonder_WillUnitGiveSoulShard("target") ) )  then
		if (OneHitWonder_ShardCount < OneHitWonder_MinimumShards) then
			if ( OneHitWonder_CastSpellSpecial(ONEHITWONDER_SPELL_DRAIN_SOUL, true) ) then
				return;
			end			
		end
	end		

	if (timeSinceSpellStopped >= 0.5) then
		if ( OneHitWonder_CastIfTargetNotHasEffect(ONEHITWONDER_EFFECT_IMMOLATE, ONEHITWONDER_SPELL_IMMOLATE) ) then
			return;
		end				
	end	
	
	if ( OneHitWonder_CastIfTargetNotHasEffect(ONEHITWONDER_EFFECT_CORRUPTION, ONEHITWONDER_SPELL_CORRUPTION) ) then
		return;
	end

	if ( OneHitWonder_CastIfTargetNotHasEffect(ONEHITWONDER_WARLOCK_CURSES, ONEHITWONDER_SPELL_CORRUPTION) ) then
		return;
	end

	if ( OneHitWonder_HandleCursing ) then
		local effectName = nil;
		local spellName = nil;
		if ( OneHitWonder_IsInPartyOrRaid() ) then
			local warlocks = OneHitWonder_GetNumberOfClassInGroup(ONEHITWONDER_CLASS_WARLOCK);
			local priests = OneHitWonder_GetNumberOfClassInGroup(ONEHITWONDER_CLASS_PRIEST);
			local mages = OneHitWonder_GetNumberOfClassInGroup(ONEHITWONDER_CLASS_MAGE);
			-- prevent running
			if ( unitHPPercent <= 5 ) then
				spellName = ONEHITWONDER_SPELL_CURSE_RECKLESSNESS;
			elseif ( ( ( priests + warlocks ) > 1 ) and ( ( priests + warlocks ) >= mages ) ) then
				spellName = ONEHITWONDER_SPELL_CURSE_SHADOW;
			elseif ( mages > (priests+warlocks ) ) then
				spellName = ONEHITWONDER_SPELL_CURSE_ELEMENTS;
			end
		end
		if ( not spellName ) then
			spellName = ONEHITWONDER_SPELL_CURSE_AGONY;
		end
		if ( GetTime()-OneHitWonder_CursedTargetTime > OneHitWonder_CurrentCurseTime ) then
			spellName = OneHitWonder_GetCurseForTarget();
			if ( OneHitWonder_CastSpellSpecial(spellName) ) then
				return;
			end
		end
		if ( OneHitWonder_CastIfTargetNotHasEffect(effectName, spellName) ) then
			return;
		end
	else
		if ( OneHitWonder_CastIfTargetNotHasEffect(ONEHITWONDER_WARLOCK_CURSE_EFFECTS, ONEHITWONDER_SPELL_CURSE_AGONY) ) then
			return;
		end
	end

	
	if ( OneHitWonder_CastIfTargetNotHasEffect(ONEHITWONDER_ABILITY_SHOOT, ONEHITWONDER_ABILITY_SHOOT) ) then
		return;
	end
	
end

function OneHitWonder_SetMinimumShards(toggle, value)
	OneHitWonder_MinimumShards = value;
end

function OneHitWonder_SetSoulDrainPercentage(toggle, value)
	OneHitWonder_SoulDrainPercentage = value;
end

function OneHitWonder_Warlock_Cosmos()
	if ( Cosmos_RegisterConfiguration ) then
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_WARLOCK_SEPARATOR",
			"SEPARATOR",
			TEXT(ONEHITWONDER_WARLOCK_SEPARATOR),
			TEXT(ONEHITWONDER_WARLOCK_SEPARATOR_INFO)
		);
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_MINIMUM_SHARDS",
			"SLIDER",
			TEXT(ONEHITWONDER_MINIMUM_SHARDS),
			TEXT(ONEHITWONDER_MINIMUM_SHARDS_INFO),
			OneHitWonder_SetMinimumShards,
			1,
			OneHitWonder_MinimumShards, -- default
			0, -- min
			40, -- max
			"",
			1,
			1,
			TEXT(ONEHITWONDER_MINIMUM_SHARDS_APPEND)
		);
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_SOUL_DRAIN",
			"SLIDER",
			TEXT(ONEHITWONDER_SOUL_DRAIN),
			TEXT(ONEHITWONDER_SOUL_DRAIN_INFO),
			OneHitWonder_SetSoulDrainPercentage,
			1,
			OneHitWonder_SoulDrainPercentage, -- default
			0, -- min
			100, -- max
			"",
			1,
			1,
			TEXT(ONEHITWONDER_SOUL_DRAIN_APPEND)
		);
		
	end
	
end

function OneHitWonder_Warlock_CountShards()
	OneHitWonder_ShardCount = 0;
	--OneHitWonder_Print("Counting shards");
	for bag = 0,4 do
		for slot = 1,GetContainerNumSlots(bag) do
			if (OneHitWonder_GetItemName(bag,slot) == "Soul Shard") then
				OneHitWonder_ShardCount=OneHitWonder_ShardCount+1;
			end
		end
	end
end
