--[[

	TODO:
	
	Buff Share
	
	OHW on Target = buff / heal / whatnot?
	
	Well Buff nohow
	
	Appropriate buff? If not in party / raid, inexpensive buff?
	
	IsResting() => Buff til you DROP!
	
	Thanks to thez for his Warlock code!

]]--

ONEHITWONDER_RACE_TROLL = "Troll";
ONEHITWONDER_ABILITY_BERSERK_NAME = "Berserk";

ONEHITWONDER_HEALTH_UPDATE_DELAY = 0.5;

OneHitWonder_OnlyShowCurrentClassSettings = 0;


OneHitWonder_ShouldTryToInterruptSpell = true;
OneHitWonder_UseBlockCounter = true;
OneHitWonder_UseDodgeCounter = true;
OneHitWonder_UseParryCounter = true;
OneHitWonder_ShouldTryToAntiDodge = true;

ONEHITWONDER_ACTIONID_SPELL = 1;
ONEHITWONDER_ACTIONID_SPELL_TIMEOUT = 2;

OneHitWonder_ShouldKeepFindOn = true;

OneHitWonder_PetIsAttacking = false;
OneHitWonder_RegularSpellRunning = false;
OneHitWonder_ChannelSpellRunning = false;
OneHitWonder_TimeSpellStopped = 0;

OneHitWonder_BuffsToKeepUp = {};

ONEHITWONDER_MAXIMUM_NUMBER_OF_ACTION_IDS = 120;

ONEHITWONDER_MAXIMUM_TIME_SINCE_LAST_BUFF = 5;

OneHitWonder_ActionQueue = {};

OneHitWonder_Enabled = 1;


OneHitWonder_EnergyReservation = 0;

OneHitWonder_RageReservation = 0;

OneHitWonder_UnitHealthLastCalled = 0;


OneHitWonder_LastBuffed = 0;

OneHitWonder_WarlockDemonBuffNames = {
	"Demon Skin",
	"Demon Armor"
};

OneHitWonder_WarlockDetectInvisibilityBuffNames = {
	"Detect Lesser Invisibility",
	"Detect Invisibility",
	"Detect Greater Invisibility"
};

OneHitWonder_HunterAspects = {
	"Aspect of the Hawk",
	"Aspect of the Monkey",
	"Aspect of the Cheetah",
	"Aspect of the Beast",
	"Aspect of the Pack",
	"Aspect of the Wild"
};


ONEHITWONDER_WARRIOR_STANCE_BATTLE_NAME = "Battle Stance";
ONEHITWONDER_WARRIOR_STANCE_DEFENSIVE_NAME = "Defensive Stance";
ONEHITWONDER_WARRIOR_STANCE_AGGRESSIVE_NAME = "Berserk Stance";
ONEHITWONDER_WARRIOR_STANCE_BERZERK_NAME = "Unknown Stance";



--OneHitWonder_Saved_ChatFrame_OnEvent = nil;

OneHitWonder_WaitForFeedBack = false;
OneHitWonder_WaitForFeedBackTimeout = 0;
OneHitWonder_WaitForFeedBackDefaultTimeout = 2;
OneHitWonder_ChatFeedBack = "";

-- verify this
ONEHITWONDER_QUEUE_INTERRUPT_SPELL_CHAT_TYPES = {
	"SPELL_CREATURE_VS_SELF_DAMAGE",
	"SPELL_CREATURE_VS_SELF_BUFF",
	"SPELL_CREATURE_VS_CREATURE_DAMAGE",
	"SPELL_CREATURE_VS_CREATURE_BUFF"
};

ONEHITWONDER_QUEUE_INTERRUPT_SPELL_DODGEPARRYBLOCK_TYPES = {
	"COMBAT_SELF_HITS",
	"COMBAT_SELF_MISSES",
	"COMBAT_CREATURE_VS_SELF_HITS",
	"COMBAT_CREATURE_VS_SELF_MISSES"
};

ONEHITWONDER_CLASS_DRUID = "Druid";
ONEHITWONDER_CLASS_HUNTER = "Hunter";
ONEHITWONDER_CLASS_MAGE = "Mage";
ONEHITWONDER_CLASS_PALADIN = "Paladin";
ONEHITWONDER_CLASS_PRIEST = "Priest";
ONEHITWONDER_CLASS_ROGUE = "Rogue";
ONEHITWONDER_CLASS_SHAMAN = "Shaman";
ONEHITWONDER_CLASS_WARRIOR = "Warrior";
ONEHITWONDER_CLASS_WARLOCK = "Warlock";

ONEHITWONDER_WARRIOR_STANCE_BATTLE = 1;
ONEHITWONDER_WARRIOR_STANCE_DEFENSIVE = 2;
ONEHITWONDER_WARRIOR_STANCE_AGGRESSIVE = 3;
ONEHITWONDER_WARRIOR_STANCE_BERSERK = 4;

ONEHITWONDER_ABILITY_SHADOW_WARD_NAME = "Shadow Ward";

function OneHitWonder_ShowBigMessage(msg)
    ZoneTextString:SetText(msg);
    ZoneTextString:SetTextColor(1.0, 0.2, 0.2);
    ZoneTextFrame.startTime = GetTime();
    ZoneTextFrame:Show();
    PlaySound("MapPing");
end

function OneHitWonder_IsTargetedUnit(name)
	if ( UnitName("target") == name ) then
		return true;
	else
		return false;
	end
end

function OneHitWonder_ExtractUnitNameFromCombatMessage(msg, source, stringAfterName)
	if ( ( source ) and ( strlen(source) > 0 ) ) then 
		return source;
	else
		local index = strfind(msg, stringAfterName);
		local unitName = "";
		local spellName = "";
		if ( index ~= nil ) then
			local tmpStr = strsub(msg, 1, index-2);
			local cutAwayStr = "%. "; -- sigh. damn patterns
			local index2 = strfind(tmpStr, cutAwayStr);
			if ( index2 ) then
				tmpStr = strsub(tmpStr, index2+2);
			end
			unitName = tmpStr;
			local spellCutPoint = index+strlen(stringAfterName);
			if ( spellCutPoint < strlen(msg) ) then
				tmpStr = strsub(msg, spellCutPoint);
				spellName = tmpStr;
			end
		end
		return unitName, spellName;
	end
end

function OneHitWonder_Warrior_GetStance()
	local numForms = GetNumShapeshiftForms();
	local texture, name, isActive, isCastable;
	local button, icon, cooldown;
	local start, duration, enable;
	for i=1, NUM_SHAPESHIFT_SLOTS do
		if ( i <= numForms ) then
			texture, name, isActive, isCastable = GetShapeshiftFormInfo(i);
			if ( isActive ) then
				if ( name == ONEHITWONDER_WARRIOR_STANCE_BATTLE_NAME ) then
					return ONEHITWONDER_WARRIOR_STANCE_BATTLE;
				elseif ( name == ONEHITWONDER_WARRIOR_STANCE_AGGRESSIVE_NAME ) then
					return ONEHITWONDER_WARRIOR_STANCE_DEFENSIVE;
				elseif ( name == ONEHITWONDER_WARRIOR_STANCE_AGGRESSIVE_NAME ) then
					return ONEHITWONDER_WARRIOR_STANCE_AGGRESSIVE;
				elseif ( name == ONEHITWONDER_WARRIOR_STANCE_BERZERK_NAME ) then
					return ONEHITWONDER_WARRIOR_STANCE_BERSERK;
				else
					return -1;
				end
			end
		end
	end
	return -1;
end

function OneHitWonder_Warrior_GetStanceOld()
	local numForms = GetNumShapeshiftForms();
	local texture, name, isActive, isCastable;
	local button, icon, cooldown;
	local start, duration, enable;
	for i=1, NUM_SHAPESHIFT_SLOTS do
		if ( i <= numForms ) then
			texture, name, isActive, isCastable = GetShapeshiftFormInfo(i);
			if ( isActive ) then
				if ( numForms == 1 ) then
					return ONEHITWONDER_WARRIOR_STANCE_BATTLE;
				elseif ( numForms == 2 ) then
					if ( i == 2 ) then
						return ONEHITWONDER_WARRIOR_STANCE_BATTLE;
					else
						return ONEHITWONDER_WARRIOR_STANCE_DEFENSIVE;
					end
				elseif ( numForms == 3 ) then
					if ( i == 3 ) then	
						return ONEHITWONDER_WARRIOR_STANCE_BATTLE;
					elseif ( i == 2 ) then
						return ONEHITWONDER_WARRIOR_STANCE_DEFENSIVE;
					else
						return ONEHITWONDER_WARRIOR_STANCE_AGGRESSIVE;
					end
				elseif ( numForms == 4 ) then
					if ( i == 4 ) then
						return ONEHITWONDER_WARRIOR_STANCE_BATTLE;
					elseif ( i == 3 ) then
						return ONEHITWONDER_WARRIOR_STANCE_DEFENSIVE;
					elseif ( i == 2 ) then
						return ONEHITWONDER_WARRIOR_STANCE_AGGRESSIVE;
					else
						return ONEHITWONDER_WARRIOR_STANCE_BERSERK;
					end
				end
			end
		end
	end
	return -1;
end

function OneHitWonder_Warrior_GetGameStanceId(stanceId)
	local numForms = GetNumShapeshiftForms();
	if ( numForms == 1 ) then
		if ( stanceId == ONEHITWONDER_WARRIOR_STANCE_BATTLE ) then
			return 1;
		end
	elseif ( numForms == 2 ) then
		if ( stanceId == ONEHITWONDER_WARRIOR_STANCE_BATTLE ) then
			return 2;
		elseif ( stanceId == ONEHITWONDER_WARRIOR_STANCE_DEFENSIVE ) then
			return 1;
		end
	elseif ( numForms == 3 ) then
		if ( stanceId == ONEHITWONDER_WARRIOR_STANCE_BATTLE ) then
			return 3;
		elseif ( stanceId == ONEHITWONDER_WARRIOR_STANCE_DEFENSIVE ) then
			return 2;
		elseif ( stanceId == ONEHITWONDER_WARRIOR_STANCE_AGGRESSIVE ) then
			return 1;
		end
	elseif ( numForms == 4 ) then
		if ( stanceId == ONEHITWONDER_WARRIOR_STANCE_BATTLE ) then
			return 4;
		elseif ( stanceId == ONEHITWONDER_WARRIOR_STANCE_DEFENSIVE ) then
			return 3;
		elseif ( stanceId == ONEHITWONDER_WARRIOR_STANCE_AGGRESSIVE ) then
			return 2;
		elseif ( stanceId == ONEHITWONDER_WARRIOR_STANCE_BERSERK ) then
			return 1;
		end
	end
	return -1;
end

OneHitWonder_ShadowSpells = {
	"shadow bolt",
	"shadowburn",
	"mind blast",
	"touch of weakness",
	"devouring plague",
	"shadow word: pain",
	"mind flay"
};

OneHitWonder_ShadowSpellKeyWords = {
	"shadow",
	"dark",
	"consuming"
};

OneHitWonder_NotShadowSpells = {
	"shadow resistance aura", -- once again... not truly correct
	"shadow protection",
	"shadow ward",
	"shadowguard", -- debatable
	"curse of shadow", -- also debatable
	"dark pact",
	"mind soothe",
	"mind-numbing poison",
	"mind control", -- not entirely true
	"mind vision"
};

OneHitWonder_FireSpells = {
	"fireball",
	"fire blast",
	"fire nova totem",
	"rain of fire",
	"holy fire",
	"hellfire",
	"searing pain",
	"soul fire",
	"pyroblast",
	"scorch",
	"immolate",
};

OneHitWonder_NotFireSpells = {
	"moonfire",
	"faerie fire",
	"fire ward", -- not really true, but used in the context it will be...
	"starfire",
	"rapid fire",
	"fire resistance totem",
	"inner fire",
	"searing totem"
};

OneHitWonder_FireSpellKeyWords = {
	"pyro",
	"fire",
	"searing",
	"scorch"
};

OneHitWonder_FrostSpells = {
	"frostbolt",
	"frost nova", -- should this be here or in not frost spells? we can't do anything, so...
	"frostbrand weapon",
	"cone of cold",
	"blizzard"
};

OneHitWonder_FrostSpellKeyWords = {
	"frost",
	"cold",
	"ice"
};

OneHitWonder_NotFrostSpells = {
	--"frost nova", -- should this be here or in frost spells? we can't do anything, so...
	"frost armor",
	"frost shock", -- thottbot says nothing about frost damage, so...
	"frost ward",
	"ice armor", -- not entirely true
	"ice barrier", -- not entirely true
	"frost resistance totem",
	"frost resistance aura"
};

function OneHitWonder_IsSpellBased(spellName, exactMatch, keywordMatch, excludeExactMatch)
	local lowName = strlower(spellName);
	local index = strfind(lowName, "%(rank");
	if ( index ) then
		lowName = strsub(lowName, 1, index-1);
	end
	if ( excludeExactMatch ) then
		for k, v in excludeExactMatch do
			if ( v == lowName ) then
				return false;
			end
		end
	end
	for k, v in exactMatch do
		if ( v == lowName ) then
			return true;
		end
	end
	for k, v in keywordMatch do
		if ( strfind(lowName, v ) ) then
			return true;
		end
	end
	return false;
end

function OneHitWonder_IsSpellShadowBased(spellName)
	return OneHitWonder_IsSpellBased(spellName, OneHitWonder_ShadowSpells, OneHitWonder_ShadowSpellKeyWords, OneHitWonder_NotShadowSpells);
end

function OneHitWonder_IsSpellFireBased(spellName)
	return OneHitWonder_IsSpellBased(spellName, OneHitWonder_FireSpells, OneHitWonder_FireSpellKeyWords, OneHitWonder_NotFireSpells);
end

function OneHitWonder_IsSpellFrostBased(spellName)
	return OneHitWonder_IsSpellBased(spellName, OneHitWonder_FrostSpells, OneHitWonder_FrostSpellKeyWords, OneHitWonder_NotFrostSpells);
end

function OneHitWonder_TryToInterruptSpell(unitName, spellName)
	local interruptId = -1;
	local abilityName = "";
	if ( UnitClass("player") == ONEHITWONDER_CLASS_MAGE ) then
		abilityName, interruptId = OneHitWonder_TryToInterruptSpell_Mage(unitName, spellName);
	elseif ( UnitClass("player") == ONEHITWONDER_CLASS_WARLOCK ) then
		abilityName, interruptId = OneHitWonder_TryToInterruptSpell_Warlock(unitName, spellName);
	elseif ( UnitClass("player") == ONEHITWONDER_CLASS_ROGUE ) then
		abilityName, interruptId = OneHitWonder_TryToInterruptSpell_Rogue(unitName, spellName);
	elseif ( UnitClass("player") == ONEHITWONDER_CLASS_SHAMAN ) then
		abilityName, interruptId = OneHitWonder_TryToInterruptSpell_Shaman(unitName, spellName);
	elseif ( UnitClass("player") == ONEHITWONDER_CLASS_WARRIOR ) then
		abilityName, interruptId = OneHitWonder_TryToInterruptSpell_Warrior(unitName, spellName);
	end
	if ( interruptId > -1 ) then
		OneHitWonder_ShowBigMessage(format(ONEHITWONDER_IMPERATIVE_ABILITY_MESSAGE, abilityName));
		local parameters = { interruptId, GetTime() + 3};
		OneHitWonder_AddActionToQueue(ONEHITWONDER_ACTIONID_SPELL_TIMEOUT, parameters);
	end
end

function OneHitWonder_GetWarriorBlockDodgeParryCounter()
	local counterId = -1;
	local stance = OneHitWonder_Warrior_GetStance();
	if ( stance == ONEHITWONDER_WARRIOR_STANCE_BATTLE ) then
	elseif ( stance == ONEHITWONDER_WARRIOR_STANCE_DEFENSIVE ) then
		counterId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_REVENGE_NAME);
		if ( counterId > -1 ) then
			OneHitWonder_ShowBigMessage(format(ONEHITWONDER_IMPERATIVE_ABILITY_MESSAGE, ONEHITWONDER_ABILITY_REVENGE_NAME));
		end
	elseif ( stance == ONEHITWONDER_WARRIOR_STANCE_AGGRESSIVE ) then
	elseif ( stance == ONEHITWONDER_WARRIOR_STANCE_BERSERK ) then
	end
	return counterId;
end

function OneHitWonder_GetWarriorTargetDodgeCounter()
	local counterId = -1;
	local stance = OneHitWonder_Warrior_GetStance();
	if ( stance == ONEHITWONDER_WARRIOR_STANCE_BATTLE ) then
		counterId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_OVERPOWER_NAME);
		if ( counterId > -1 ) then
			OneHitWonder_ShowBigMessage(format(ONEHITWONDER_IMPERATIVE_ABILITY_MESSAGE, ONEHITWONDER_ABILITY_OVERPOWER_NAME));
		end
	elseif ( stance == ONEHITWONDER_WARRIOR_STANCE_DEFENSIVE ) then
	elseif ( stance == ONEHITWONDER_WARRIOR_STANCE_AGGRESSIVE ) then
	elseif ( stance == ONEHITWONDER_WARRIOR_STANCE_BERSERK ) then
	end
	return counterId;
end


function OneHitWonder_DoBlockCounter()
	local counterId = -1;
	if ( UnitClass("player") == ONEHITWONDER_CLASS_ROGUE ) then
	elseif ( UnitClass("player") == ONEHITWONDER_CLASS_WARRIOR ) then
		counterId = OneHitWonder_GetWarriorBlockDodgeParryCounter();
	end
	if ( counterId > -1 ) then
		local parameters = { counterId, GetTime() + 3};
		OneHitWonder_AddActionToQueue(ONEHITWONDER_ACTIONID_SPELL_TIMEOUT, parameters);
	end
end

function OneHitWonder_DoDodgeCounter()
	local counterId = -1;
	if ( UnitClass("player") == ONEHITWONDER_CLASS_ROGUE ) then
	elseif ( UnitClass("player") == ONEHITWONDER_CLASS_WARRIOR ) then
		counterId = OneHitWonder_GetWarriorBlockDodgeParryCounter();
	end
	if ( counterId > -1 ) then
		local parameters = { counterId, GetTime() + 3};
		OneHitWonder_AddActionToQueue(ONEHITWONDER_ACTIONID_SPELL_TIMEOUT, parameters);
	end
end

function OneHitWonder_DoParryCounter()
	local counterId = -1;
	if ( UnitClass("player") == ONEHITWONDER_CLASS_ROGUE ) then
		counterId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_RIPOSTE_NAME);
	elseif ( UnitClass("player") == ONEHITWONDER_CLASS_WARRIOR ) then
		counterId = OneHitWonder_GetWarriorBlockDodgeParryCounter();
	end
	if ( counterId > -1 ) then
		local parameters = { counterId, GetTime() + 3};
		OneHitWonder_AddActionToQueue(ONEHITWONDER_ACTIONID_SPELL_TIMEOUT, parameters);
	end
end

function OneHitWonder_DoTargetDodgeCounter()
	local counterId = -1;
	if ( UnitClass("player") == ONEHITWONDER_CLASS_ROGUE ) then
	elseif ( UnitClass("player") == ONEHITWONDER_CLASS_WARRIOR ) then
		counterId = OneHitWonder_GetWarriorTargetDodgeCounter();
	end
	if ( counterId > -1 ) then
		local parameters = { counterId, GetTime() + 3};
		OneHitWonder_AddActionToQueue(ONEHITWONDER_ACTIONID_SPELL_TIMEOUT, parameters);
	end
end


function OneHitWonder_ChatFrame_OnEvent(event)
	if ( arg1 ) then
		if ( strfind(arg1, "dodges") ) then
			unitName = OneHitWonder_ExtractUnitNameFromCombatMessage(arg1, arg2, "dodges");
			if ( (OneHitWonder_IsTargetedUnit(unitName)) and ( OneHitWonder_ShouldTryToAntiDodge ) ) then
				--OneHitWonder_DoTargetDodgeCounter();
			end
			if ( strfind(arg1, "You attack") ) then
				if (not unitName ) then
					unitName = "nil";
				end
				--Print(format("Found the event : %s   Extracted unitname : %s", event, unitName));
			end
		end
	end
	OneHitWonder_Saved_ChatFrame_OnEvent(event);
end

function OneHitWonder_Chat_OnEvent(event)
	if ( OneHitWonder_IsEnabled() ) then
		if ( strsub(event, 1, 8) == "CHAT_MSG" ) then
			local typeOfEvent = strsub(event, 10);
			local info = ChatTypeInfo[type];
			local unitName = nil;
			local spellName = nil;
			if ( strfind(arg1, "begins to cast" ) ) then
				unitName, spellName = OneHitWonder_ExtractUnitNameFromCombatMessage(arg1, arg2, "begins to cast");
				if ( (OneHitWonder_IsTargetedUnit(unitName)) and ( OneHitWonder_ShouldTryToInterruptSpell ) ) then
					local shouldInterrupt = false;
					for k, v in ONEHITWONDER_QUEUE_INTERRUPT_SPELL_CHAT_TYPES do
						if ( strfind(typeOfEvent, v) ) then
							shouldInterrupt = true;
						end
					end
					if ( shouldInterrupt ) then
						OneHitWonder_TryToInterruptSpell(unitName, spellName);
					end
				end
			end
			if ( strfind(arg1, "dodges") ) then
				unitName = OneHitWonder_ExtractUnitNameFromCombatMessage(arg1, arg2, "dodges");
				if ( ( strfind(arg1, "dodges" ) ) and (OneHitWonder_IsTargetedUnit(unitName)) and ( OneHitWonder_ShouldTryToAntiDodge ) ) then
					OneHitWonder_DoTargetDodgeCounter();
				end
			end
			if ( ( OneHitWonder_UseParryCounter ) and ( strfind(arg1, "You parry") ) ) then
				OneHitWonder_DoParryCounter();
			end
			if ( ( OneHitWonder_UseBlockCounter ) and ( strfind(arg1, "You block") ) ) then
				OneHitWonder_DoBlockCounter();
			end
			if ( ( OneHitWonder_UseDodgeCounter ) and ( strfind(arg1, "You dodge") ) ) then
				OneHitWonder_DoDodgeCounter();
			end
		end
	end
end

function OneHitWonder_HasTargetBuffTexture(texture)
	local buff;
	for i=1, MAX_TARGET_DEBUFFS do
		buff = UnitBuff("target", i);
		if ( buff == texture ) then
			return true;
		end
	end
	return false;
end

function OneHitWonder_HasTargetDebuffTexture(texture)
	local debuff;
	local i = 0;
	for i=1, MAX_TARGET_DEBUFFS do
		debuff = UnitDebuff("target", i);
		if ( debuff == texture ) then
			return true;
		end
	end
	return false;
end

function OneHitWonder_HasTargetAnyBuffTexture(texture)
	if ( OneHitWonder_HasTargetBuffTexture(texture) ) then
		return true;
	else
		return OneHitWonder_HasTargetDebuffTexture(texture);
	end
end

function OneHitWonder_HasUnitEffect(unitName, texture, name)
	if ( unitName == "player") then
		return OneHitWonder_HasPlayerEffect(texture, name);
	end
	local id = 1;
	local i, buffName;
	local buffIndex, untilCancelled;
	if ( name ) then
		for i = 0, MAX_PARTY_TOOLTIP_BUFFS do
			buffName = OneHitWonder_GetBuffNameUsingBuffIndex(unitName, i);
			if ( buffName == name ) then
				return true;
			end
		end
		for i = 0, MAX_PARTY_TOOLTIP_DEBUFFS do
			buffName = OneHitWonder_GetBuffNameUsingBuffIndex(unitName, i, true);
			if ( buffName == name ) then
				return true;
			end
		end
	end
	if ( texture ) then
		for i = 0, MAX_PARTY_TOOLTIP_BUFFS do
			if ( UnitBuff(unitName, i) == name ) then
				return true;
			end
		end
		for i = 0, MAX_PARTY_TOOLTIP_DEBUFFS do
			if ( UnitDebuff(unitName, i) == name ) then
				return true;
			end
		end
	end
	return false;
end

function OneHitWonder_GetPlayerTrackingBuffName()
	local tooltipName = "OneHitWonderTooltip";
	local tooltip = getglobal(tooltipName);
	if ( not tooltip ) then
		OneHitWonder_Print("OHW: Could not find tooltip to extract spell ID info from "..tooltipName, 1.0, 0.2, 0.2);
		return nil;
	end
	OneHitWonder_ClearTooltip(tooltipName);
	tooltip:SetTrackingSpell();
	
	local strings = OneHitWonder_ScanTooltip(tooltipName);
	
	if ( strings ) and ( strings[1] ) and ( strings[1].left ) then
		return strings[1].left;
	else
		return nil;
	end
end


function OneHitWonder_HasPlayerEffect(texture, name)
	local id = 1;
	local i, buffName;
	local buffIndex, untilCancelled;
	if ( texture ) then
		local isDebuff = false;
		for id = 1, 24 do
			if ( GetPlayerBuffTexture(id) == texture ) then
				if ( name ) then
					if ( id >= 20 ) then
						isDebuff = true;
					else
						isDebuff = false;
					end
					if ( name == OneHitWonder_GetBuffNameUsingBuffIndex("player", id, isDebuff) ) then
						return true;
					end
				else
					return true;
				end
			end
		end
		local icon = GetTrackingTexture();
		if ( icon == texture ) then 
			if ( name ) then
				local trackBuffName = OneHitWonder_GetPlayerTrackingBuffName()
				if ( trackBuffName == name) then
					return true;
				end
			else
				return true;
			end
		end
	end
	if ( name ) then
		for i = 0, MAX_PARTY_TOOLTIP_BUFFS do
			buffIndex, untilCancelled = GetPlayerBuff(i, "HELPFUL|PASSIVE");
			if ( buffIndex >= 0 ) then
				buffName = OneHitWonder_GetBuffNameUsingBuffIndex("player", buffIndex);
				if ( buffName == name ) then
					return true;
				end
			end
		end
		for i = 0, MAX_PARTY_TOOLTIP_DEBUFFS do
			buffIndex, untilCancelled = GetPlayerBuff(i, "HARMFUL");
			if ( buffIndex >= 0 ) then
				buffName = OneHitWonder_GetBuffNameUsingBuffIndex("player", buffIndex, true);
				if ( buffName == name ) then
					return true;
				end
			end
		end
		local trackBuffName = OneHitWonder_GetPlayerTrackingBuffName()
		if ( trackBuffName == name) then
			return true;
		end
	end
	return false;
end

function OneHitWonder_HasBuffTexture(texture)
	local id = 1;
	for id = 0, 15 do
		if ( GetPlayerBuffTexture(id) == texture ) then
			return true;
		end
	end
	return false;
end

ONEHITWONDER_BOOK_TYPE_SPELL = "spell";

function OneHitWonder_GetRankAsNumber(rankName)
	if ( rankName ) then
		local index, index2 = strfind(rankName, "Rank");
		if ( ( index ) and (index2 ) ) then
			local tmpStr = strsub(rankName, index2+1);
			while ( ( tmpStr) and ( strlen(tmpStr) > 1 ) and ( strsub(tmpStr, 1, 1) == " " ) ) do
				tmpStr = strsub(tmpStr, 2);
			end
			local i = tonumber(tmpStr);
			if ( i ) then
				return i;
			else
				return 0;
			end
		else
			return 0;
		end
	else
		return 0;
	end
end

function OneHitWonder_GetSpellName(spellId, spellBook, doNoUseCache)
	local name = nil;
	local rankName = nil;
	if ( ( doNoUseCache ) or 
		( ( not OneHitWonder_SpellIdInfo ) or ( not OneHitWonder_SpellIdInfo[spellBook]) or 
			( not OneHitWonder_SpellIdInfo[spellBook][spellId]) ) ) then
		name, rankName = GetSpellName(spellId, spellBook);
	else
		spellInfo = OneHitWonder_SpellIdInfo[spellBook][spellId];
		if ( spellInfo ) and ( getn(spellInfo) >= 1 ) then
			name = spellInfo[1].left;
			if ( getn(spellInfo) >= 2 ) then
				rankName = spellInfo["rank"];
			end
		end
	end
	return name, rankName;
end

function OneHitWonder_GetSpellId(spellName, spellRank, spellBook, doNotUseCache)
	local i = 1;
	local highestId = -1;
	local highestRankSoFar = -1;
	local rank;
	local spellRankNumber = 0;
	if (spellRank) then
		spellRankNumber = tonumber(spellRank);
		if (not spellRankNumber) then
			spellRankNumber = 0;
		end
	end
	if ( not spellBook ) then
		spellBook = OneHitWonder_GetSpellBook();
	end
	local name, rankName;
	name, rankName = OneHitWonder_GetSpellName(i, spellBook, doNotUseCache);
	while name do
		if ( name == spellName) then
			if ( spellRank == nil ) then
				rank = OneHitWonder_GetRankAsNumber(rankName);
				if ( rank ) then
					if ( rank > highestRankSoFar ) then
						highestRankSoFar = rank;
						highestId = i;
					end
				else
					return i;
				end
			else
				rank = OneHitWonder_GetRankAsNumber(rankName);
				if ( rank == spellRankNumber ) then
					highestId = i;
					break;
				elseif ( rank > highestRankSoFar ) then
					highestRankSoFar = rank;
					highestId = i;
				end
			end
		end
		i = i + 1;
		name, rankName = OneHitWonder_GetSpellName(i, spellBook)
	end
	return highestId;
end

function OneHitWonder_HasEnoughEnergy(abilityName, ignoreEnergyReservation)
	local energy = PlayerFrameManaBar:GetValue();
	
	if ( not ignoreEnergyReservation ) then
		energy = energy - OneHitWonder_EnergyReservation;
	end

	if ( OneHitWonder_GetEnergyConsumption(abilityName) <= energy ) then
		return true;
	else
		return false;
	end
end

function OneHitWonder_HasEnoughRage(abilityName, ignoreRageReservation)
	local rage = PlayerFrameManaBar:GetValue();

	if ( not ignoreRageReservation ) then
		rage = rage - OneHitWonder_RageReservation;
	end

	if ( OneHitWonder_GetRageConsumption(abilityName) <= rage ) then
		return true;
	else
		return false;
	end
end


function OneHitWonder_GetActionId(texture)
	if ( texture ) then
		local id = 1;
		local actionTexture;
		for id = 1, 120 do
			actionTexture = GetActionTexture(id);
			if ( ( actionTexture ) and ( actionTexture == texture ) ) then
				return id;
			end
		end
	end
	return -1;
end

function OneHitWonder_GetSpellBook(spellBook)
	if ( not spellBook ) then spellBook = ONEHITWONDER_BOOK_TYPE_SPELL; end;
	return spellBook;
end

function OneHitWonder_CheckIfInRangeSpellId(id, spellBook)
	local actionId = 0;
	spellBook = OneHitWonder_GetSpellBook(spellBook);
	actionId = OneHitWonder_GetActionIdFromSpellId(id, spellBook);
	return OneHitWonder_CheckIfInRangeActionId(actionId);
end

function OneHitWonder_CheckIfInRangeActionId(id)
	if ( ( id >= 1) and ( IsActionInRange(id) == 0) ) then
		return false;
	else	
		return true;
	end
end

function OneHitWonder_CheckIfUsableActionId(id)
	if ( id >= 1) then
		local isUsable, notEnoughMana = IsUsableAction(id);
		if ( ( isUsable ) and ( not notEnoughMana ) )  then
			return true;
		else
			return false;
		end
	else	
		return true;
	end
end

function OneHitWonder_CheckIfSpellIsCoolingdownById(id, spellBook)
	if ( id == -1 ) then
		return true;
	end
	spellBook = OneHitWonder_GetSpellBook(spellBook);
	local start, duration, enable = GetSpellCooldown(id, spellBook);
	--OneHitWonder_Log(spellId, spellBook, start, duration, enable);
	if ( enable == 1 ) then
		if ( ( (start + duration) < GetTime() ) or ( (start + duration) == 0 ) ) then
			return false;
		end
	end
	return true;
end

function OneHitWonder_CheckIfUsable(actionId, spellId, spellBook)
	spellBook = OneHitWonder_GetSpellBook(spellBook);
	if ( spellId > -1 ) then
		if ( OneHitWonder_CheckIfSpellIsCoolingdownById(spellId, spellBook) ) then
			return false;
		end
	end
	return OneHitWonder_CheckIfUsableActionId(actionId);
end

function OneHitWonder_CheckIfUsableSpellId(id, spellBook)
	if ( id == -1 ) then
		return false;
	end
	spellBook = OneHitWonder_GetSpellBook(spellBook);
	local actionId = -1;
	if ( not OneHitWonder_CheckIfSpellIsCoolingdownById(id, spellBook) ) then
		actionId = OneHitWonder_GetActionIdFromSpellId(id, spellBook);
		return OneHitWonder_CheckIfUsableActionId(actionId);
	end
	return false;
end

function OneHitWonder_CheckIfInRangeAndUsableInActionBar(texture)
	if ( texture ) then
		local id = OneHitWonder_GetActionId(texture);
		if ( (OneHitWonder_CheckIfUsableActionId(id) ) and ( OneHitWonder_CheckIfInRangeActionId(id) ) ) then
			return true;
		else
			return false;
		end
	end
	return false;
end

function OneHitWonder_CheckIfInRangeAndUsableInActionBarByActionId(actionId)
	if ( (OneHitWonder_CheckIfUsableActionId(actionId) ) and ( OneHitWonder_CheckIfInRangeActionId(actionId) ) ) then
		return true;
	else
		return false;
	end
end

-- /script PrintTable(OneHitWonder_SpellAvailability);
-- /script OneHitWonder_SpellAvailability = {};

OneHitWonder_SpellAvailability = {};

function OneHitWonder_Log(spellId, spellBook, start, duration, enable)
	if ( spellId <= -1 ) then
		return
	end
	if ( enable == 0 ) then
		return;
	end
	if ( not OneHitWonder_SpellAvailability[spellId]) then
		OneHitWonder_SpellAvailability[spellId] = {};
	end
	local currentTime = GetTime() * 1000;
	local cooldownTime = start * 1000 + duration * 1000;
	local available = "true";
	if ( cooldownTime > currentTime ) then
		available = "false";
	end
	local parameter = {start, duration, enable, GetTime(), available};
	table.insert(OneHitWonder_SpellAvailability[spellId], parameter);
end

function OneHitWonder_IsSpellAvailable(spellId, spellBook)
	if ( spellId <= -1 ) then
		return false;
	end
	spellBook = OneHitWonder_GetSpellBook(spellBook);
	local start, duration, enable = GetSpellCooldown(spellId, spellBook);
	--OneHitWonder_Log(spellId, spellBook, start, duration, enable);
	if ( enable == 1 ) then
		if ( ( (start + duration) < GetTime() ) or ( (start + duration) == 0 ) )then
			if ( OneHitWonder_CheckIfInRangeAndUsableInActionBar(GetSpellTexture(spellId, spellBook)) ) then
				return true;
			end
		end
	end
	return false;
end

function OneHitWonder_CastSpell(spellId, spellBook)
	if ( spellId <= -1 ) then
		return false;
	end
	spellBook = OneHitWonder_GetSpellBook(spellBook);
	if ( OneHitWonder_IsSpellAvailable(spellId, spellBook) ) then
		CastSpell(spellId, spellBook);
		return true;
	end
	return false;
end

function OneHitWonder_GetTargetHPPercentage()
	local unitMinHP, unitMaxHP, unitCurrHP;
	unitMinHP, unitMaxHP = TargetFrameHealthBar:GetMinMaxValues();
	unitCurrHP = TargetFrameHealthBar:GetValue();
	
	local unitHPPercent = TargetFrame.unitHPPercent;

	if ( not UnitIsPlayer("target") ) then
		unitHPPercent = unitCurrHP;
	else
		unitHPPercent = math.floor(unitHPPercent * 100);
	end
	return unitHPPercent;
end

function OneHitWonder_GetUnitHPPercentage(unit)
	local unitMaxHP, unitCurrHP;
	unitMaxHP = UnitHealthMax(unit);
	unitCurrHP = UnitHealth(unit);
	if ( unitCurrHP == 0 ) then
		return 0;
	else
		return ((unitMaxHP / unitCurrHP ) * 100);
	end
end

function OneHitWonder_GetPlayerHPPercentage()
	return OneHitWonder_GetUnitHPPercentage("player");
end

function OneHitWonder_GetUnitManaPercentage(unit)
	local unitMaxMana, unitCurrMana;
	unitMaxMana = UnitManaMax(unit);
	unitCurrMana = UnitMana(unit);
	if ( unitCurrMana == 0 ) then
		return 0;
	else
		return ((unitMaxMana / unitCurrMana ) * 100);
	end
end

function OneHitWonder_GetPlayerManaPercentage()
	return OneHitWonder_GetUnitManaPercentage("player");
end

function OneHitWonder_WiggleStop()
	MoveForwardStop();
end

function OneHitWonder_Wiggle()
	if ( CosmosSchedule ) then
		MoveForwardStart();
		CosmosSchedule(0.2, OneHitWonder_WiggleStop);
	end
end

function OneHitWonder_IsInPartyOrRaid()
	if ( ( GetNumPartyMembers() > 0 ) or ( GetNumRaidMembers() > 0  ) ) then
		return true;
	else
		return false;
	end
end

function OneHitWonder_HasPartyMembers()
	if ( GetNumPartyMembers() > 0 ) then
		return true;
	else
		return false;
	end
end

function OneHitWonder_DumpDebuffsOnce()
	if ( not DebuffsShown ) then
		DebuffsShown = {};
	end
	local debuff;
	for i=1, MAX_TARGET_DEBUFFS do
		debuff = UnitDebuff("target", i);
		if ( ( debuff ) and ( not DebuffsShown[debuff] ) ) then
			OneHitWonder_Print(debuff);
			DebuffsShown[debuff] = true;
		end
	end
end

function OneHitWonder_DumpTargetBuffs()
	local debuff;
	for i=1, MAX_TARGET_DEBUFFS do
		debuff = UnitBuff("target", i);
		if ( ( debuff ) ) then
			OneHitWonder_Print(debuff);
		end
	end
end

function OneHitWonder_DumpTargetDebuffs()
	local debuff;
	for i=1, MAX_TARGET_DEBUFFS do
		debuff = UnitDebuff("target", i);
		if ( ( debuff ) ) then
			OneHitWonder_Print(debuff);
		end
	end
end

function OneHitWonder_DumpOwnBuffs()
	local texture, buffIndex, untilCancelled;
	for i = 0, MAX_PARTY_TOOLTIP_BUFFS do
		buffIndex, untilCancelled = GetPlayerBuff(i, "HELPFUL|PASSIVE");
		if ( buffIndex >= 0 ) then
			texture = GetPlayerBuffTexture(buffIndex);
			OneHitWonder_Print(texture);
		end
	end
end

function OneHitWonder_GetBuffNameUsingBuffIndex(unitName, buffIndex, debuff)
	if (buffIndex ~= -1) then
		local tooltipName = "OneHitWonderTooltip";
		local tooltip = getglobal(tooltipName);
		local tooltiptext = getglobal(tooltipName.."TextLeft1");
		if ( tooltiptext ) then
			tooltiptext:SetText("");
		end
		if ( unitName == "player" ) then
			tooltip:SetPlayerBuff(buffIndex);
		else
			if ( not debuff ) then
				tooltip:SetUnitBuff(unitName, buffIndex);
			else
				tooltip:SetUnitDebuff(unitName, buffIndex);
			end
		end
		if ( tooltiptext ) then
			local name = tooltiptext:GetText();
			if ( ( name ~= nil ) and ( strlen(name) > 0 ) ) then
				return name;
			end
		end
	end
	return nil;
end

function OneHitWonder_DumpOwnBuffNames()
	local name, buffIndex, untilCancelled;
	for i = 0, MAX_PARTY_TOOLTIP_BUFFS do
		buffIndex, untilCancelled = GetPlayerBuff(i, "HELPFUL|PASSIVE");
		if ( buffIndex >= 0 ) then
			name = OneHitWonder_GetBuffNameUsingBuffIndex("player", buffIndex);
			if ( name ) then
				OneHitWonder_Print(name);
			end
		end
	end
end

function OneHitWonder_AddActionToQueue(actionId, actionParameter)
	local entry = { actionId, actionParameter};
	table.insert(OneHitWonder_ActionQueue, entry);
end

function OneHitWonder_RemoveActionFromQueue(actionId, actionParameter)
	local entry = table.remove(OneHitWonder_ActionQueue);
	return entry[1], entry[2];
end

-- /script PrintTable(OneHitWonder_ActionQueue);
function OneHitWonder_GetTimeRemaining(spellId, spellBook)
	spellBook = OneHitWonder_GetSpellBook(spellBook);
	local start, duration, enable = GetSpellCooldown(spellId, spellBook);
	if ( ( start > 0 ) and ( duration > 0 ) ) then
		return (( start + duration ) - GetTime());
	else
		return 0;
	end
end

function OneHitWonder_UseCountermeasures()
	if ( not OneHitWonder_IsEnabled() ) then return; end
	return OneHitWonder_HandleActionQueue();
end

function OneHitWonder_HandleActionQueue()
	if ( getn(OneHitWonder_ActionQueue) <= 0 ) then
		return false;
	end
	
	local actionId, actionParameter = OneHitWonder_RemoveActionFromQueue();
	
	if ( actionId == ONEHITWONDER_ACTIONID_SPELL ) then
		if ( OneHitWonder_CastSpell(actionParameter, ONEHITWONDER_BOOK_TYPE_SPELL ) ) then
			return true;
		else
			return false;
		end
	elseif ( actionId == ONEHITWONDER_ACTIONID_SPELL_TIMEOUT ) then
		local spellId = actionParameter[1];
		local timeout = actionParameter[2];
		if ( GetTime() >= timeout ) then
			return OneHitWonder_HandleActionQueue();
		else
			if ( OneHitWonder_IsSpellAvailable(spellId, ONEHITWONDER_BOOK_TYPE_SPELL) ) then
				if ( OneHitWonder_CastSpell(spellId, ONEHITWONDER_BOOK_TYPE_SPELL ) ) then
					return true;
				else
					return false;
				end
			else
				OneHitWonder_AddActionToQueue(actionId, actionParameter);
				local remainingTime = OneHitWonder_GetTimeRemaining(spellId, ONEHITWONDER_BOOK_TYPE_SPELL );
				if ( remainingTime <= 1 ) then
					return true;
				end
				return false;
			end
		end
	else
		return false;
	end
end

function OneHitWonder_ClearTooltipStrings(tooltipName)
	local tooltip = getglobal(tooltipName);
	if ( tooltip ) then
		local textObj = nil;
		for i = 1, 15 do
			textObj = getglobal(tooltipName.."TextLeft"..i);
			if ( textObj ) then
				textObj:SetText("");
			end
			textObj = getglobal(tooltipName.."TextRight"..i);
			if ( textObj ) then
				textObj:SetText("");
			end
		end
	end
end
function OneHitWonder_GetTooltipStrings(tooltipName)
	local strings = {};
	local tooltip = getglobal(tooltipName);
	if ( tooltip ) then
		local textObj = nil;
		local textLeft = nil;
		local textRight = nil;
		for i = 1, 15 do
			strings[i] = {};
			textObj = getglobal(tooltipName.."TextLeft"..i);
			if ( textObj ) then
				textLeft = textObj:GetText();
			else
				textLeft = nil;
			end
			strings[i].left = textLeft;
			textObj = getglobal(tooltipName.."TextRight"..i);
			if ( textObj ) then
				textRight = textObj:GetText();
			else
				textRight = nil;
			end
			strings[i].right = textRight;
		end
	end
	return strings;
end

-- Shamelessly stolen from SarfEquip - and modded by sarf.
-- http://www.fukt.bth.se/~k/wow/scripts/SarfEquip/Interface/AddOns/SarfEquip/SarfEquip.lua
function OneHitWonder_GetItemName(bag, slot)
	local name = "";
	local strings = nil;
	OneHitWonder_ClearTooltipStrings("OneHitWonderTooltip");
	if ( bag > -1 ) then
		OneHitWonderTooltip:SetBagItem(bag, slot);
		strings = OneHitWonder_GetTooltipStrings("OneHitWonderTooltip");
	else
		local hasItem, hasCooldown = OneHitWonderTooltip:SetInventoryItem("player", slot);
		strings = OneHitWonder_GetTooltipStrings("OneHitWonderTooltip");
		if ( not hasItem) then
			OneHitWonder_ClearTooltipStrings("OneHitWonderTooltip");
			if ( strings[1] ) then
				strings[1].left = "";
			end
		end
	end
	if ( strings[1] ) then
		name = strings[1].left;
	end
	return name;
end

function OneHitWonder_Init()
	OneHitWonder_UpdateSpellInfo();
	OneHitWonder_RetrieveAllActionIdInfo();

	OneHitWonder_SetupStuffContinously();
	OneHitWonder_SetupOverrideBinding();
end

function OneHitWonder_AfterInit()
	if ( Cosmos_ScheduleByName ) then
		Cosmos_ScheduleByName("OHW_AI", 5, OneHitWonder_Init);
	end
end

function OneHitWonder_OnLoad()
	--OneHitWonder_Saved_ChatFrame_OnEvent = ChatFrame_OnEvent;
	--ChatFrame_OnEvent = OneHitWonder_ChatFrame_OnEvent;
	
	OneHitWonder_TimeSpellStopped = GetTime();
	OneHitWonder_Warlock_CountShards();
	
	if ( Cosmos_AfterInit ) then
		Cosmos_AfterInit(OneHitWonder_AfterInit);
		-- TODO: add standalone OnUpdate code?
	end

	for k, v in ONEHITWONDER_QUEUE_INTERRUPT_SPELL_CHAT_TYPES do
		this:RegisterEvent("CHAT_MSG_"..v);
	end

	for k, v in ONEHITWONDER_QUEUE_INTERRUPT_SPELL_DODGEPARRYBLOCK_TYPES do
		this:RegisterEvent("CHAT_MSG_"..v);
	end
	
	this:RegisterEvent("UNIT_HEALTH");
	this:RegisterEvent("PLAYER_TARGET_CHANGED");
	this:RegisterEvent("CHARACTER_POINTS_CHANGED");
	this:RegisterEvent("ACTIONBAR_SLOT_CHANGED");
	this:RegisterEvent("LEARNED_SPELL_IN_TAB");
	this:RegisterEvent("SPELLS_CHANGED");
	this:RegisterEvent("VARIABLES_LOADED");

	this:RegisterEvent("SPELLCAST_CHANNEL_START");
	--this:RegisterEvent("SPELLCAST_CHANNEL_UPDATE");
	this:RegisterEvent("SPELLCAST_DELAYED");
	this:RegisterEvent("SPELLCAST_FAILED");
	this:RegisterEvent("SPELLCAST_INTERRUPTED");
	this:RegisterEvent("SPELLCAST_START");
	this:RegisterEvent("SPELLCAST_STOP");
	this:RegisterEvent("BAG_UPDATE");

	RegisterForSave("OneHitWonder_OnlyShowCurrentClassSettings");

end


function OneHitWonder_AddStuffToCosmos()
	if ( Cosmos_RegisterConfiguration ) then
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER",
			"SECTION",
			TEXT(ONEHITWONDER_CONFIG_HEADER),
			TEXT(ONEHITWONDER_CONFIG_HEADER_INFO)
		);
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_HEADER",
			"SEPARATOR",
			TEXT(ONEHITWONDER_CONFIG_HEADER),
			TEXT(ONEHITWONDER_CONFIG_HEADER_INFO)
		);
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_ENABLED",
			"CHECKBOX",
			TEXT(ONEHITWONDER_ENABLED),
			TEXT(ONEHITWONDER_ENABLED_INFO),
			OneHitWonder_SetEnabled,
			OneHitWonder_Enabled
		);
		if ( OneHitWonder_OnlyShowCurrentClassSettings == 1 ) then
			--(ugly hack)
			func = getglobal(format("OneHitWonder_%s_Cosmos", UnitClass("player")));
			if ( func ) then
				func();
			end
		else
			OneHitWonder_Druid_Cosmos();
			OneHitWonder_Hunter_Cosmos();
			OneHitWonder_Mage_Cosmos();
			OneHitWonder_Paladin_Cosmos();
			OneHitWonder_Priest_Cosmos();
			OneHitWonder_Rogue_Cosmos();
			OneHitWonder_Shaman_Cosmos();
			OneHitWonder_Warlock_Cosmos();
			OneHitWonder_Warrior_Cosmos();
		end
	end
end

function OneHitWonder_OnEvent(event)
	OneHitWonder_RandomEventStuff();
	if ( event == "VARIABLES_LOADED" ) then
		if ( ( OneHitWonder_OnlyShowCurrentClassSettings == 1 ) and ( Cosmos_AfterInit ) ) then
			Cosmos_AfterInit(OneHitWonder_AddStuffToCosmos);
		else
			OneHitWonder_AddStuffToCosmos();
		end
		return;
	end
	if ( ( event == "LEARNED_SPELL_IN_TAB" ) or ( event == "SPELLS_CHANGED" ) ) then
		OneHitWonder_UpdateSpellInfo();
		OneHitWonder_SetupStuffContinously();
	end
	if ( event == "ACTIONBAR_SLOT_CHANGED" ) then
		OneHitWonder_UpdateActionIdInfo(arg1);
		return;
	end
	if ( event == "PLAYER_TARGET_CHANGED" ) then
		TargetFrame.attemptsToBackstab = 0;
		TargetFrame.hasBeenPickPocketed = false;
		TargetFrame.isBeingSoulDrained = false;
		OneHitWonder_CursedTargetTime = 0;
		OneHitWonder_CurrentCurseTime = 0;
		OneHitWonder_LastCurse = nil;
		return;
	end
	if ( event == "CHARACTER_POINTS_CHANGED" ) then
		if ( UnitClass("player") == ONEHITWONDER_CLASS_ROGUE ) then
			OneHitWonder_UpdateRageConsumptionWithTalents("ONEHITWONDER_ABILITY_ENERGYCOST", ONEHITWONDER_ROGUE_TALENT_ENERGY_REDUCERS);
		elseif ( UnitClass("player") == ONEHITWONDER_CLASS_WARRIOR ) then
			OneHitWonder_UpdateRageConsumptionWithTalents("ONEHITWONDER_ABILITY_RAGECOST", ONEHITWONDER_WARRIOR_TALENT_RAGE_REDUCERS);
		end
		return;
	end
	if ( event == "UNIT_HEALTH" ) then
		if ( arg1 == "player" ) then
			local curTime = GetTime();
			if ( ( curTime - OneHitWonder_UnitHealthLastCalled ) > ONEHITWONDER_HEALTH_UPDATE_DELAY ) then
				OneHitWonder_UnitHealthCheck();
				OneHitWonder_UnitHealthLastCalled = curTime;
			end
		end
		return;
	end
	if ( strfind(event, "CHAT_MSG") ) then
		OneHitWonder_Chat_OnEvent(event);
	end

	if ( event == "PET_ATTACK_START" ) then
		OneHitWonder_PetIsAttacking = true;
	end
	
	if ( event == "PET_ATTACK_STOP" or event == "PET_BAR_HIDEGRID" or event == "PET_BAR_SHOWGRID" ) then
		OneHitWonder_PetIsAttacking = false;
	end

	--[[		
	if (strfind(event, "SPELLCAST_START")) then
		OneHitWonder_TimeSpellStarted = GetTime();
		OneHitWonder_Print("OneHitWonder_TimeSpellStarted="..OneHitWonder_TimeSpellStarted);
	end
	]]--
	
	if (event == "PLAYER_DEAD") then
		OneHitWonder_ChannelSpellRunning = false;
		OneHitWonder_RegularSpellRunning = false;
		OneHitWonder_TimeSpellStopped = GetTime();
	end

	if (event == "SPELLCAST_STOP") then
		OneHitWonder_ChannelSpellRunning = false;
		OneHitWonder_RegularSpellRunning = false;
		OneHitWonder_TimeSpellStopped = GetTime();	
	end
	if (event == "SPELLCAST_START") then
		OneHitWonder_RegularSpellRunning = true;	
	end
	if (event == "SPELLCAST_CHANNEL_START") then
		OneHitWonder_ChannelSpellRunning = true;		
	end
	if (event == "SPELLCAST_INTERRUPTED" or event == "SPELLCAST_FAILED") then
		OneHitWonder_RegularSpellRunning = false;
		OneHitWonder_ChannelSpellRunning = false;	
	end	

	if ( event == "BAG_UPDATE" ) then
		OneHitWonder_Warlock_CountShards();
	end
end

function OneHitWonder_UnitHealthCheck()
	local class = UnitClass("player");
	local hp = UnitHealth("player");
	local maxHP = UnitHealthMax("player");
	local spellId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_BERSERK_NAME);
	if ( ( spellId > -1 ) and ( OneHitWonder_IsSpellAvailable(spellId) ) ) then
		OneHitWonder_AddActionToQueue(ONEHITWONDER_ACTIONID_SPELL_TIMEOUT, { spellId, ( GetTime() + 2) }  );
	end
	if ( class == ONEHITWONDER_CLASS_MAGE ) then
		OneHitWonder_Mage_UnitHealthCheck();
	end
end

function OneHitWonder_RandomEventStuff()
	local spellId = OneHitWonder_GetSpellId(ONEHITWONDER_TALENT_RIPOSTE_NAME);
	if ( ( spellId > -1 ) and ( OneHitWonder_IsSpellAvailable(spellId) ) ) then
		OneHitWonder_AddActionToQueue(ONEHITWONDER_ACTIONID_SPELL_TIMEOUT, { spellId, ( GetTime() + 2) }  );
	end
end

function OneHitWonder_UpdateRageConsumptionWithTalents(costTableName, reducerTable)
	local costTable = getglobal(costTableName);
	local name, iconTexture, tier, column, rank, maxRank, isExceptional, meetsPrereq;
	local talentTable;
	local abilityName;
	local newCostTable;
	for k, v in reducerTable do
		talentTable = v[1];
		abilityName = v[2];
		newCostTable = v[3];
		name, iconTexture, tier, column, rank, maxRank = GetTalentInfo(talentTable[1], talentTable[2]);
		if ( ( rank > 0 ) and ( rank <= getn(newCostTable) ) ) then
			costTable[abilityName] = newCostTable[rank];
		end
	end
end

--OneHitWonder_Debug = true;

function OneHitWonder_DebugPrint(msg)
	if ( OneHitWonder_Debug ) then
		OneHitWonder_Print(msg, 1.0, 0.3, 0.3);
	end
end

-- Prints out text to a chat box.
function OneHitWonder_Print(msg,r,g,b,frame,id,unknown4th)
	if(unknown4th) then
		local temp = id;
		id = unknown4th;
		unknown4th = id;
	end
				
	if (not r) then r = 1.0; end
	if (not g) then g = 1.0; end
	if (not b) then b = 1.0; end
	if ( frame ) then 
		frame:AddMessage(msg,r,g,b,id,unknown4th);
	else
		if ( DEFAULT_CHAT_FRAME ) then 
			DEFAULT_CHAT_FRAME:AddMessage(msg, r, g, b,id,unknown4th);
		end
	end
end


function OneHitWonder_GetTimeLeft(buffTexture)
	local timeLeft, texture;
	local buffIndex, untilCancelled;
	for i = 0, MAX_PARTY_TOOLTIP_BUFFS do
		buffIndex, untilCancelled = GetPlayerBuff(i, "HELPFUL|PASSIVE");
		if ( buffIndex < 0 ) then
			return 0;
		end
		texture = GetPlayerBuffTexture(buffIndex);
		if ( texture == buffTexture ) then
			timeLeft = GetPlayerBuffTimeLeft(buffIndex);
			return timeLeft;
		end
	end
	return 0;
end

function OneHitWonder_ShouldCast(buffTexture, minimalTimeLeft)
	if ( not minimalTimeLeft ) then
		minimalTimeLeft = 0;
	end
	local timeLeft = OneHitWonder_GetTimeLeft(buffTexture);
	if ( minimalTimeLeft > 0 ) then
		timeLeft = GetPlayerBuffTimeLeft(buffIndex);
		if ( timeLeft < minimalTimeLeft ) then
			return true;
		else
			return false;
		end
	else
		return false;
	end
	return true;
end

OneHitWonder_Warrior_BattleShoutRageReservation = 0;
OneHitWonder_Warrior_BattleShoutStartRageReservation = 30;

function OneHitWonder_Warrior_BattleShoutRefresh()
	local timeLeft = OneHitWonder_GetTimeLeft(ONEHITWONDER_ABILITY_BATTLESHOUT_TEXTURE);
	OneHitWonder_RageReservation = OneHitWonder_RageReservation - OneHitWonder_Warrior_BattleShoutRageReservation;
	OneHitWonder_Warrior_BattleShoutRageReservation = 0;
	if ( timeLeft < OneHitWonder_Warrior_BattleShoutStartRageReservation ) then
		if ( OneHitWonder_HasEnoughRage(ONEHITWONDER_ABILITY_BATTLESHOUT_NAME, true) ) then
			local spellId = 0;
			spellId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_BATTLESHOUT_NAME);
			OneHitWonder_DebugPrint(format("Battleshout id = %d", spellId));
			if ( OneHitWonder_CastSpell(spellId, ONEHITWONDER_BOOK_TYPE_SPELL) ) then
				return true;
			end
		else
			OneHitWonder_DebugPrint("Not enough rage for BattleShout");
			OneHitWonder_DebugPrint("Allocating rage for BattleShout");
			OneHitWonder_Warrior_BattleShoutRageReservation = OneHitWonder_Warrior_BattleShoutStartRageReservation - timeLeft;
			local maxRageReserved = OneHitWonder_GetRageConsumption(ONEHITWONDER_ABILITY_BATTLESHOUT_NAME);
			if ( OneHitWonder_Warrior_BattleShoutRageReservation > maxRageReserved) then
				OneHitWonder_Warrior_BattleShoutRageReservation = maxRageReserved;
			end
			OneHitWonder_RageReservation = OneHitWonder_RageReservation + OneHitWonder_Warrior_BattleShoutRageReservation;
		end
	end
	return false;
end

ONEHITWONDER_WARRIOR_RANGE_UNKNOWN = 0;
ONEHITWONDER_WARRIOR_RANGE_MELEE = 1;
ONEHITWONDER_WARRIOR_RANGE_CHARGE = 2;
ONEHITWONDER_WARRIOR_RANGE_RANGED = 3;
ONEHITWONDER_WARRIOR_RANGE_BEYOND = 4;

function OneHitWonder_Warrior_GetCurrentRange()
	local stance = OneHitWonder_Warrior_GetStance();
	if ( stance == ONEHITWONDER_WARRIOR_STANCE_BATTLE ) then
		local chargeId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_CHARGE_NAME);
		local rangedId = -1;
		local meleeRangeId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_REND_NAME);
		if ( meleeRangeId <= -1 ) then OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_HAMSTRING_NAME); end

		if ( not OneHitWonder_CheckIfInRangeSpellId(chargeId) ) then
			if (not OneHitWonder_CheckIfInRangeSpellId(meleeRangeId)) then
				if ( rangedId > -1 ) then
					if (not OneHitWonder_CheckIfInRangeSpellId(rangedId)) then
						return ONEHITWONDER_WARRIOR_RANGE_BEYOND;
					else
						return ONEHITWONDER_WARRIOR_RANGE_RANGED;
					end
				else
					return ONEHITWONDER_WARRIOR_RANGE_BEYOND;
				end
			else
				return ONEHITWONDER_WARRIOR_RANGE_MELEE;
			end
		else
			return ONEHITWONDER_WARRIOR_RANGE_CHARGE;
		end
	end
	return ONEHITWONDER_WARRIOR_RANGE_UNKNOWN;
end

function OneHitWonder_GiveMeWonder(removeDefense)
	if ( not OneHitWonder_IsEnabled() ) then return; end
	local class = UnitClass("player");
	if ( class == ONEHITWONDER_CLASS_DRUID ) then
		OneHitWonder_Druid(removeDefense);
	elseif ( class == ONEHITWONDER_CLASS_HUNTER ) then
		OneHitWonder_Hunter(removeDefense);
	elseif ( class == ONEHITWONDER_CLASS_MAGE ) then
		OneHitWonder_Mage(removeDefense);
	elseif ( class == ONEHITWONDER_CLASS_PALADIN ) then
		OneHitWonder_Paladin(removeDefense);
	elseif ( class == ONEHITWONDER_CLASS_PRIEST ) then
		OneHitWonder_Priest(removeDefense);
	elseif ( class == ONEHITWONDER_CLASS_ROGUE ) then
		OneHitWonder_Rogue(removeDefense);
	elseif ( class == ONEHITWONDER_CLASS_SHAMAN ) then
		OneHitWonder_Shaman(removeDefense);
	elseif ( class == ONEHITWONDER_CLASS_WARLOCK ) then
		OneHitWonder_Warlock(removeDefense);
	elseif ( class == ONEHITWONDER_CLASS_WARRIOR ) then
		OneHitWonder_Warrior(removeDefense);
	else
		if ( not OneHitWonder_UseCountermeasures() ) then
			OneHitWonder_DoBuffs();
		end
		if ( not OneHitWonder_NoWonder ) then
			OneHitWonder_Print("Sorry, no wonder for you yet.");
			OneHitWonder_NoWonder = true;
		end
	end
end


OneHitWonder_Override_Binding_Pointers = {
	"MoveForwardStart",
	"MoveForwardStop",
	"MoveBackwardStart",
	"MoveBackwardStop",
	"TurnLeftStart",
	"TurnLeftStop",
	"TurnRightStart",
	"TurnRightStop",
	"StrafeLeftStart",
	"StrafeLeftStop",
	"StrafeRightStart",
	"StrafeRightStop",
	"ActionButtonDown",
	"ActionButtonUp",
	"BonusActionButtonDown",
	"BonusActionButtonUp",
	"CameraOrSelectOrMoveStart",
	"CameraOrSelectOrMoveStop",
	"TurnOrActionStart",
	"TurnOrActionStop"
};
OneHitWonder_Saved_Binding_Pointers = {};
-- /script OneHitWonder_SetupStuffContinously(); OneHitWonder_SetupOverrideBinding();
function OneHitWonder_SetupOverrideBinding()
	for k, v in OneHitWonder_Override_Binding_Pointers do
		if ( not OneHitWonder_Saved_Binding_Pointers[v] ) then
			OneHitWonder_Saved_Binding_Pointers[v] = getglobal(v);
			setglobal(v, getglobal("OneHitWonder_"..v));
		end
	end
end

function OneHitWonder_MoveForwardStart(...)
	OneHitWonder_Saved_Binding_Pointers["MoveForwardStart"](unpack(arg));
	OneHitWonder_DoStuffContinously();
end

function OneHitWonder_MoveForwardStop(...)
	OneHitWonder_Saved_Binding_Pointers["MoveForwardStop"](unpack(arg));
	OneHitWonder_DoStuffContinously();
end

function OneHitWonder_MoveBackwardStart(...)
	OneHitWonder_Saved_Binding_Pointers["MoveBackwardStart"](unpack(arg));
	OneHitWonder_DoStuffContinously();
end

function OneHitWonder_MoveBackwardStop(...)
	OneHitWonder_Saved_Binding_Pointers["MoveBackwardStop"](unpack(arg));
	OneHitWonder_DoStuffContinously();
end

function OneHitWonder_TurnLeftStart(...)
	OneHitWonder_Saved_Binding_Pointers["TurnLeftStart"](unpack(arg));
	OneHitWonder_DoStuffContinously();
end

function OneHitWonder_TurnLeftStop(...)
	OneHitWonder_Saved_Binding_Pointers["TurnLeftStop"](unpack(arg));
	OneHitWonder_DoStuffContinously();
end

function OneHitWonder_TurnRightStart(...)
	OneHitWonder_Saved_Binding_Pointers["TurnRightStart"](unpack(arg));
	OneHitWonder_DoStuffContinously();
end

function OneHitWonder_TurnRightStop(...)
	OneHitWonder_Saved_Binding_Pointers["TurnRightStop"](unpack(arg));
	OneHitWonder_DoStuffContinously();
end

function OneHitWonder_StrafeLeftStart(...)
	OneHitWonder_Saved_Binding_Pointers["StrafeLeftStart"](unpack(arg));
	OneHitWonder_DoStuffContinously();
end

function OneHitWonder_StrafeLeftStop(...)
	OneHitWonder_Saved_Binding_Pointers["StrafeLeftStop"](unpack(arg));
	OneHitWonder_DoStuffContinously();
end

function OneHitWonder_StrafeRightStart(...)
	OneHitWonder_Saved_Binding_Pointers["StrafeRightStart"](unpack(arg));
	OneHitWonder_DoStuffContinously();
end

function OneHitWonder_StrafeRightStop(...)
	OneHitWonder_Saved_Binding_Pointers["StrafeRightStop"](unpack(arg));
	OneHitWonder_DoStuffContinously();
end

function OneHitWonder_ActionButtonDown(...)
	OneHitWonder_Saved_Binding_Pointers["ActionButtonDown"](unpack(arg));
	OneHitWonder_DoStuffContinously();
end

function OneHitWonder_ActionButtonUp(...)
	OneHitWonder_Saved_Binding_Pointers["ActionButtonUp"](unpack(arg));
	OneHitWonder_DoStuffContinously();
end

function OneHitWonder_BonusActionButtonDown(...)
	OneHitWonder_Saved_Binding_Pointers["BonusActionButtonDown"](unpack(arg));
	OneHitWonder_DoStuffContinously();
end

function OneHitWonder_BonusActionButtonUp(...)
	OneHitWonder_Saved_Binding_Pointers["BonusActionButtonUp"](unpack(arg));
	OneHitWonder_DoStuffContinously();
end

function OneHitWonder_CameraOrSelectOrMoveStart(...)
	OneHitWonder_Saved_Binding_Pointers["CameraOrSelectOrMoveStart"](unpack(arg));
	OneHitWonder_DoStuffContinously();
end

function OneHitWonder_CameraOrSelectOrMoveStop(...)
	OneHitWonder_Saved_Binding_Pointers["CameraOrSelectOrMoveStop"](unpack(arg));
	OneHitWonder_DoStuffContinously();
end

function OneHitWonder_TurnOrActionStart(...)
	OneHitWonder_Saved_Binding_Pointers["TurnOrActionStart"](unpack(arg));
	OneHitWonder_DoStuffContinously();
end

function OneHitWonder_TurnOrActionStop(...)
	OneHitWonder_Saved_Binding_Pointers["TurnOrActionStop"](unpack(arg));
	OneHitWonder_DoStuffContinously();
end

OneHitWonder_ActionIdInfo = {};

OneHitWonder_SpellIdInfo = {};

function OneHitWonder_GetNumberOfSpellsInSpellBook(spellBook)
	local name, rankName;
	local i = 1;
	name, rankName = GetSpellName(i, spellBook)
	while ( name ) do
		i = i + 1;
		name, rankName = GetSpellName(i, spellBook)
	end
	return i - 1;
end

function OneHitWonder_UpdateSpellBookInfo(spellBook)
	local ok = true;
	local index = 1;
	OneHitWonder_SpellIdInfo[spellBook] = {};
	local strings = {};

	local numberOfSpells = OneHitWonder_GetNumberOfSpellsInSpellBook(spellBook);
	
	for index = 1, numberOfSpells do
		OneHitWonder_SpellIdInfo[spellBook][index] = OneHitWonder_GetSpellIdInfo(index, spellBook);
	end
end

function OneHitWonder_UpdateSpellInfo()
	OneHitWonder_UpdateSpellBookInfo("spell");
	OneHitWonder_UpdateSpellBookInfo("pet");
end



function OneHitWonder_RetrieveAllActionIdInfo()
	local strings = nil;
	for i = 1, ONEHITWONDER_MAXIMUM_NUMBER_OF_ACTION_IDS do
		OneHitWonder_ActionIdInfo[i] = OneHitWonder_GetActionIdInfo(i);
	end
end

function OneHitWonder_UpdateActionIdInfo(id)
	if ( id <= 0 ) then
		OneHitWonder_RetrieveAllActionIdInfo();
	else
		OneHitWonder_ActionIdInfo[id] = OneHitWonder_GetActionIdInfo(id);
	end
end

function OneHitWonder_GetActionIdFromSpellId(spellId, spellBook, doNotUseCache)
	if ( ( not spellId ) or ( spellId == -1 ) ) then return -1; end
	local name, rank = GetSpellName(spellId, OneHitWonder_GetSpellBook(spellBook));
	if ( not name ) then
		return -1;
	end
	
	local strings = nil;
	for i = 1, ONEHITWONDER_MAXIMUM_NUMBER_OF_ACTION_IDS do
		if ( doNotUseCache ) then
			strings = OneHitWonder_GetActionIdInfo(i);
		else
			strings = OneHitWonder_ActionIdInfo[i];
		end
		if ( ( (getn(strings) >= 1) and ( name == strings[1].left ) ) 
			and ( ( not rank ) or ( (getn(strings) >= 2) and ( rank == strings[2].left ) ) ) ) then
			return i;
		end
	end
	return -1;
end

function OneHitWonder_AddStuffContinously(pBuffName, pOnlySelf, pIsBuff, options)
	local element = {};
	if ( not pOnlySelf ) then
		pOnlySelf = false;
	elseif ( pOnlySelf == 1 ) then
		pOnlySelf = true;
	elseif ( pOnlySelf == "yes" ) then
		pOnlySelf = true;
	elseif ( pOnlySelf == "no" ) then
		pOnlySelf = false;
	end
	element.buffName = pBuffName;
	element.onlySelf = pOnlySelf;
	element.isBuff = pIsBuff;
	if ( options ) then
		for k, v in options do
			element[k] = v;
		end
	end
	tinsert(OneHitWonder_BuffsToKeepUp, element);
end

function OneHitWonder_GetHighestBuffName(buffNames, doNotUseCache)
	local highestBuffName = nil;
	local buffId = nil;
	for k, v in buffNames do
		buffId = OneHitWonder_GetSpellId(v, nil, nil, doNotUseCache);
		if ( buffId > -1 ) then
			highestBuffName = v;
		end
	end
	return highestBuffName;
end

OneHitWonder_ManaClassesArray = {
	ONEHITWONDER_CLASS_HUNTER, ONEHITWONDER_CLASS_MAGE, ONEHITWONDER_CLASS_WARLOCK, 
	ONEHITWONDER_CLASS_PALADIN, ONEHITWONDER_CLASS_PRIEST, ONEHITWONDER_CLASS_SHAMAN };

OneHitWonder_CasterClassesArray = {"Hunter", "Mage", "Warlock", "Priest", "Shaman"};
OneHitWonder_FighterClassesArray =  {"Warrior", "Rogue", "Paladin"};

ONEHITWONDER_POWERTYPE_MANA = 0;
ONEHITWONDER_POWERTYPE_RAGE = 1;
ONEHITWONDER_POWERTYPE_FOCUS = 2;
ONEHITWONDER_POWERTYPE_ENERGY = 3;
ONEHITWONDER_POWERTYPE_HAPPINESS = 4;

function OneHitWonder_SetupStuffContinously()
	local setup = false;
	OneHitWonder_BuffsToKeepUp = {};
	local currentClass = UnitClass("player");
	if ( currentClass == ONEHITWONDER_CLASS_MAGE ) then
		setup = true;
		OneHitWonder_SetupStuffContinously_Mage();
	elseif ( currentClass == ONEHITWONDER_CLASS_DRUID ) then
		setup = true;
		OneHitWonder_SetupStuffContinously_Druid();
	elseif ( currentClass == ONEHITWONDER_CLASS_PALADIN ) then
		setup = true;
		OneHitWonder_SetupStuffContinously_Paladin();
	elseif ( currentClass == ONEHITWONDER_CLASS_PRIEST ) then
		setup = true;
		OneHitWonder_SetupStuffContinously_Priest();
	elseif ( currentClass == ONEHITWONDER_CLASS_SHAMAN ) then
		setup = true;
		OneHitWonder_SetupStuffContinously_Shaman();
	elseif ( currentClass == ONEHITWONDER_CLASS_WARLOCK ) then
		setup = true;
		OneHitWonder_SetupStuffContinously_Warlock();
	end
	if ( ( setup ) and ( not OneHitWonder_ContBuffSetup) ) then
		OneHitWonder_ContBuffSetup = true;
		OneHitWonder_Print("Continous Buffs setup for "..currentClass, 1.0, 1.0, 0);
	end
end

function OneHitWonder_IsItOkayToCastSpell(buffData)
	local hasTarget = true;
	local targetName = UnitName("target");
	if ( ( not targetName ) or ( strlen(targetName) <= 0 ) ) then
		hasTarget = false;
	end
	local isDead = OneHitWonder_IsPlayerDead();
	local isOnTaxi = UnitOnTaxi("player");
	
	local isOkay = false;

	local buffId = -1;
	if ( type(buffData.buffName) == "table") then
		for k, v in buffData.buffName do
			buffId = OneHitWonder_GetSpellId(v);
			if ( buffId > -1 ) then
				break;
			end
		end
	else
		buffId = OneHitWonder_GetSpellId(buffData.buffName);
	end
	if ( buffId <= -1 ) then
		return false;
	end
	local actionId = OneHitWonder_GetActionIdFromSpellId(buffId);
	
	--Print(format("%s %d %d", buffData.buffName, buffId, actionId));

	
	local timeSinceLastBuff = GetTime() - OneHitWonder_LastBuffed;

	if ( ( not isDead) and ( not isOnTaxi ) and (
		( ( buffData.onlySelf) or ( not hasTarget ) or ( actionId > -1 ) ) or 
			( 
				( buffData.needsTarget ) and ( ( hasTarget ) or ( actionId > -1 ) ) and 
				( ( not buffData.needsHostileTarget ) or ( UnitCanAttack("player", "target") ) ) 
			) 
		) 
		and (
		( ( buffData.useAtAnyMana) or ( ( UnitMana("player") >= UnitManaMax("player") ) or (timeSinceLastBuff <= ONEHITWONDER_MAXIMUM_TIME_SINCE_LAST_BUFF)) )
		and ( ( not buffData.isBuff ) or ( not OneHitWonder_HasPlayerEffect(nil, buffData.buffName) ) )
		)
		) then
		isOkay = true;
	end
	return isOkay;
end

function OneHitWonder_DoHunterStuffContinously()
	if ( not OneHitWonder_IsEnabled() ) then return false; end
	local hasAnyAspect = false;
	local aspectName, aspectNameLower;
	local buffIndex, untilCancelled;
	local texture, name, isActive, isCastable;
	for i = 1, 10 do
		texture, aspectName, isActive, isCastable = GetShapeshiftFormInfo(i);
		aspectNameLower = strlower(buffName);
		if ( isActive ) then
			if ( strfind(aspectNameLower, "aspect") ) then
				hasAnyAspect = true;
				break;
			end
		end
	end
	if ( ( not hasAnyAspect ) and ( not OneHitWonder_IsPlayerDead() ) and ( not OneHitWonder_IsPlayerOnTaxi() ) ) then
		local aspectId = nil;
		for k, v in OneHitWonder_HunterAspects do
			aspectId = OneHitWonder_GetSpellId(v);
			if ( ( OneHitWonder_IsSpellAvailable(aspectId) ) and ( not OneHitWonder_HasPlayerEffect(nil, v) ) ) then
				OneHitWonder_CastSpell(aspectId);
				return true;
			end
		end
	end
	return false;
end

function OneHitWonder_DoPaladinStuffContinously()
	if ( not OneHitWonder_IsEnabled() ) then return false; end
	local hasAnyAura = false;
	local hasAnyBlessing = false;
	local buffIndex, untilCancelled;
	for i = 0, MAX_PARTY_TOOLTIP_BUFFS do
		buffIndex, untilCancelled = GetPlayerBuff(i, "HELPFUL|PASSIVE");
		if ( buffIndex >= 0 ) then
			buffName = OneHitWonder_GetBuffNameUsingBuffIndex("player", buffIndex);
			if ( strfind(buffName, "Aura") ) then
				hasAnyAura = true;
			end
			if ( strfind(buffName, "Blessing") ) then
				hasAnyBlessing = true;
			end
		end
	end
	if ( ( not OneHitWonder_IsPlayerDead() ) and ( not OneHitWonder_IsPlayerOnTaxi() ) ) then
		if ( not hasAnyAura ) then
			local auraId = OneHitWonder_GetSpellId("Devotion Aura");
			if ( OneHitWonder_IsSpellAvailable(auraId) ) then
				OneHitWonder_CastSpell(auraId);
				return true;
			end
		elseif ( not hasAnyBlessing ) then
			local blessingId = OneHitWonder_GetSpellId("Blessing of Might");
			if ( OneHitWonder_IsSpellAvailable(blessingId) ) then
				local actionId = OneHitWonder_GetActionIdFromSpellId(blessingId);
				if ( actionId > -1 ) then
					UseAction(actionId, 0, 1);
				else
					OneHitWonder_CastSpell(blessingId);
					if( SpellIsTargeting() ) then
						SpellTargetUnit("player");
					end
				end
				return true;
			end
		end
	end
	return false;
end

function OneHitWonder_IsPlayerDead()
	local isDead = OneHitWonder_HasPlayerEffect(nil, "Ghost");
	if ( ( not isDead ) and ( UnitIsDead("player") ) ) then
		isDead = true;
	end
	return isDead;
end

function OneHitWonder_IsPlayerOnTaxi()
	return UnitOnTaxi("player");
end

OneHitWonder_DoBuffsList = {"target", "party1", "party2", "party3", "party4"};
function OneHitWonder_DoBuffs()
	for k, v in OneHitWonder_DoBuffsList do
		if ( OneHitWonder_BuffUnit(v) ) then
			return true;
		end
	end
	return false;
end

function OneHitWonder_IsStringInList(str, list)
	for k, v in list do
		if ( v == str ) then
			return true;
		end
	end
	return false;
end

function OneHitWonder_CastBuff(castBuffName, v, unit, doNotDestroyTarget)
	local ok = true;
	local buffId = nil;
	if ( ( UnitIsDead(unit) ) or ( UnitCanAttack(unit, "player") ) ) then
		ok = false;
	elseif ( ( not v.onlySelf ) and ( v.isBuff ) and ( not OneHitWonder_HasUnitEffect(unit, nil, castBuffName) ) ) then
		if ( v.doNotBuffClass ) then
			local class = UnitClass(unit);
			if ( OneHitWonder_IsStringInList(class, v.doNotBuffClass) ) then
				ok = false;
			end
		end
		if ( v.onlyBuffClass ) then
			local class = UnitClass(unit);
			if ( not OneHitWonder_IsStringInList(class, v.onlyBuffClass) ) then
				ok = false;
			end
		end
		if ( v.validTarget ) then
			if ( not OneHitWonder_IsStringInList(unit, v.validTarget) ) then
				ok = false;
			end
		end
		if ( v.invalidTarget ) then
			if ( OneHitWonder_IsStringInList(unit, v.invalidTarget) ) then
				ok = false;
			end
		end
		if ( v.powerType ) then
			if ( not OneHitWonder_IsStringInList(UnitPowerType(unit), v.powerType) ) then
				ok = false;
			end
		end
		if ( v.notPowerType ) then
			if ( OneHitWonder_IsStringInList(UnitPowerType(unit), v.notPowerType) ) then
				ok = false;
			end
		end
		buffId = OneHitWonder_GetSpellId(castBuffName);
		if ( not OneHitWonder_IsSpellAvailable(buffId) ) then
			ok = false;
		end
		if ( ( ok ) and ( hasTarget ) and ( unit ~= "target" ) ) then
			if ( not doNotDestroyTarget ) then
				ok = false;
			else
				TargetUnit(unit);
			end
		end
		if ( ok ) then
			local buffName, buffRank = OneHitWonder_GetBuffName(UnitLevel(unit), castBuffName);
			buffId = OneHitWonder_GetSpellId(buffName, buffRank);
			if ( OneHitWonder_IsSpellAvailable(buffId) ) then
				if ( unit == "player" ) then
					local actionId = OneHitWonder_GetActionIdFromSpellId(buffId);
					if ( actionId > -1 ) then
						UseAction(actionId, 0, 1);
						return ok, true;
					end
				end
				OneHitWonder_CastSpell(buffId);
				if( SpellIsTargeting() ) then
					SpellTargetUnit(unit);
				end
				OneHitWonder_LastBuffed = GetTime();
				return ok, true;
			end
		end
	end
	return false, false;
end

function OneHitWonder_GetBuffName(unitLevel, buffName)
	local index = strfind(buffName, "%(");
	if ( index ) then
		buffName = strsub(buffName, index-1);
	end
	return OneHitWonder_GetAppropriateBuff(unitLevel, buffName);
end

OneHitWonder_RecentBuffees = {};

function OneHitWonder_CleanRecentBuffee()
	local curTime = GetTime();
	local removeIndices = {};
	for k, v in OneHitWonder_RecentBuffees do
		if ( v.time < curTime ) then
			table.insert(removeIndices, k);
		end
	end
	for k, v in removeIndices do
		table.remove(OneHitWonder_RecentBuffees, v);
	end
end

function OneHitWonder_GetRecentBuffee(buffeeName)
	OneHitWonder_CleanRecentBuffee();
	for k, v in OneHitWonder_RecentBuffees do
		if ( v.name == buffeeName ) then
			return v;
		end
	end
	return nil;
end

function OneHitWonder_IsRecentBuffee(buffeeName)
	if ( OneHitWonder_GetRecentBuffee(buffeeName) ) then
		return true;
	else
		return false;
	end
end

function OneHitWonder_AddRecentBuffee(buffeeName, extraTime)
	local buffee = OneHitWonder_CleanRecentBuffee();
	local newTime = GetTime() + extraTime;
	if ( not buffee ) then
		table.insert(OneHitWonder_RecentBuffees, { name = buffeeName, time = newTime } );
	else
		buffee.time = newTime;
	end
end

-- TODO: should add the amount of time before reapplying a buff to the same person

OneHitWonder_BuffTime = {
	["Blessing of Might"] = 301,
	["Blessing of Wisdom"] = 301,
	["Blessing of Protection"] = 7
};

function OneHitWonder_GetBuffTime(buffName)
	local value = OneHitWonder_BuffTime[buffName];
	if ( not value ) then value = 30; end
	return value;
end

function OneHitWonder_BuffUnit(unit, doNotDestroyTarget)
	if ( OneHitWonder_IsPlayerDead() ) then
		return false;
	end
	if ( OneHitWonder_IsPlayerOnTaxi() ) then
		return false;
	end
	local unitName = UnitName(unit);
	if ( ( not unitName ) or ( strlen(unitName) <= 0 ) ) then
		return false;
	end
	local targetName = UnitName("target");
	local hasTarget = true;
	if ( ( not targetName ) or ( strlen(targetName) <= 0 ) ) then
		hasTarget = false;
	end
	local ok = true;
	local currentBuffName = nil;
	local castBuff, shouldQuit;
	for k, v in OneHitWonder_BuffsToKeepUp do
		ok = true;
		if ( type(v.buffName) == "table" ) then
			local mx = OneHitWonder_GetNumberOfClassInGroup(ONEHITWONDER_CLASS_PALADIN);
			local cur = 1;
			local buffId = -1;
			local hasAnyBuff = false;
			for key, value in v.buffName do
				if ( OneHitWonder_HasUnitEffect(unit, nil, value) ) then
					hasAnyBuff = true;
					break;
				end
			end
			for key, value in v.buffName do
				currentBuffName = value;
				buffId = OneHitWonder_GetSpellId(currentBuffName);
				if ( buffId > -1 ) then
					if ( ( OneHitWonder_IsRecentBuffee(unitName) ) and (hasAnyBuff) ) then
						return false;
					end
					castBuff, shouldQuit = OneHitWonder_CastBuff(currentBuffName, v, unit, doNotDestroyTarget)
					if ( ( castBuff ) and ( UnitIsPlayer(unit) ) ) then
						OneHitWonder_AddRecentBuffee(unitName, OneHitWonder_GetBuffTime(currentBuffName));
					end
					if ( shouldQuit ) then
						return castBuff;
					end
					if ( castBuff ) then
						return castBuff;
					end
					cur = cur + 1;
					--[[
					if ( cur > mx) then
						break;
					end
					]]--
				end
			end
		else
			castBuff, shouldQuit = OneHitWonder_CastBuff(v.buffName, v, unit, doNotDestroyTarget);
			if ( shouldQuit ) then
				return castBuff;
			end
			if ( castBuff ) then
				return castBuff;
			end
		end
	end
	return false;
end


function OneHitWonder_DoStuffContinously()
	if ( not OneHitWonder_IsEnabled() ) then return false; end
	local targetName = UnitName("target");
	local isDead = OneHitWonder_IsPlayerDead();
	if ( ( not isDead ) and ( UnitRace("player") == ONEHITWONDER_RACE_TROLL ) ) then
		local berserkId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_BERSERK_NAME);
		if ( OneHitWonder_IsSpellAvailable(berserkId) ) then
			OneHitWonder_CastSpell(berserkId);
			return;
		end
	end
	if ( UnitClass("player") == ONEHITWONDER_CLASS_PALADIN ) then
		if ( OneHitWonder_DoPaladinStuffContinously() ) then
			return;
		end
	end
	if ( UnitClass("player") == ONEHITWONDER_CLASS_HUNTER ) then
		if ( OneHitWonder_DoHunterStuffContinously() ) then
			return;
		end
	end
	local fullMana = false;
	if ( UnitMana("player") >= UnitManaMax("player") ) then
		fullMana = true;
	end
	local isOKToBuff = false;
	local timeSinceLastBuff = GetTime() - OneHitWonder_LastBuffed;
	if ( (not isDead) and ( ( fullMana ) or ( timeSinceLastBuff <= 5 ) ) and ( not PlayerFrame.inCombat ) ) then
		isOKToBuff = true;
	end
	local buffId;
	if ( isOKToBuff ) then
		for k, v in OneHitWonder_BuffsToKeepUp do
			if ( OneHitWonder_IsItOkayToCastSpell(v) ) then
				buffId = OneHitWonder_GetSpellId(v.buffName);
				if ( OneHitWonder_IsSpellAvailable(buffId) ) then
					local actionId = OneHitWonder_GetActionIdFromSpellId(buffId);
					if ( actionId > -1 ) then
						UseAction(actionId, 0, 1);
					else
						OneHitWonder_CastSpell(buffId);
						if( SpellIsTargeting() ) then
							SpellTargetUnit("player");
						end
					end
					OneHitWonder_LastBuffed = GetTime();
					return;
				end
			end
		end
	end
	if ( ( OneHitWonder_ShouldKeepFindOn ) and ( (not isDead) ) )then
		local herbsId = OneHitWonder_GetSpellId("Find Herbs");
		local mineralsId = OneHitWonder_GetSpellId("Find Minerals");
		if ( herbsId ~= -1 ) then
			if ( not OneHitWonder_HasPlayerEffect(nil, "Find Herbs") ) then
				if ( OneHitWonder_IsSpellAvailable(herbsId) ) then
					OneHitWonder_CastSpell(herbsId);
					return;
				end
			end
		elseif ( mineralsId ~= -1 ) then
			if ( not OneHitWonder_HasPlayerEffect(nil, "Find Minerals") ) then
				if ( OneHitWonder_IsSpellAvailable(mineralsId) ) then
					OneHitWonder_CastSpell(mineralsId);
					return;
				end
			end
		end
	end
	OneHitWonder_HandleActionQueue();
end

function OneHitWonder_GetSpellIdInfo(spellId, spellBook, tooltipName)
	if ( ( not spellId ) or ( spellId <= -1 ) ) then
		return nil;
	end
	if ( not spellBook ) then
		spellBook = OneHitWonder_GetSpellBook(spellBook);
	end
	if ( not tooltipName ) then
		tooltipName = "OneHitWonderTooltip";
	end
	local tooltip = getglobal(tooltipName);
	if ( not tooltip ) then
		tooltipName = "OneHitWonderTooltip";
		tooltip = getglobal(tooltipName);
		if ( not tooltip ) then
			OneHitWonder_Print("OHW: Could not find tooltip to extract spell ID info from "..tooltipName, 1.0, 0.2, 0.2);
			return nil;
		end
	end
	OneHitWonder_ClearTooltip(tooltipName);
	tooltip:SetSpell(spellId, spellBook);
	
	local strings = OneHitWonder_ScanTooltip(tooltipName);
	
	local name, rankName = GetSpellName(spellId, spellBook);
	strings["rank"] = rankName;
	
	return strings;
end

function OneHitWonder_GetActionIdInfo(actionId, tooltipName)
	if ( ( not actionId ) or ( actionId <= -1 ) ) then
		return nil;
	end
	if ( not tooltipName ) then
		tooltipName = "OneHitWonderTooltip";
	end
	local tooltip = getglobal(tooltipName);
	if ( not tooltip ) then
		tooltipName = "OneHitWonderTooltip";
		tooltip = getglobal(tooltipName);
		if ( not tooltip ) then
			OneHitWonder_Print("OHW: Could not find tooltip to extract action ID info from.", 1.0, 0.2, 0.2);
			return nil;
		end
	end
	OneHitWonder_ClearTooltip(tooltipName);
	tooltip:SetAction(actionId);
	
	local strings = OneHitWonder_ScanTooltip(tooltipName);
	
	return strings;
end

-- Thanks to Cosmos for this one!
function OneHitWonder_ScanTooltip(TooltipNameBase)
	if ( not TooltipNameBase  ) then 
		TooltipNameBase = "OneHitWonderTooltip";
	end
	
	local strings = {};
	local ttext = nil;
	local textLeft = nil;
	local textRight = nil;
	for idx = 1, 20 do
		textLeft = nil;
		textRight = nil;
		ttext = getglobal(TooltipNameBase.."TextLeft"..idx);
		if(ttext and ttext:IsVisible() and ttext:GetText() ~= nil)
		then
			textLeft = ttext:GetText();
		end
		ttext = getglobal(TooltipNameBase.."TextRight"..idx);
		if(ttext and ttext:IsVisible() and ttext:GetText() ~= nil)
		then
			textRight = ttext:GetText();
		end
		if (textLeft or textRight)
		then
			strings[idx] = {};
			strings[idx].left = textLeft;
			strings[idx].right = textRight;
		end
	end

	return strings;
end

function OneHitWonder_ClearTooltip(TooltipNameBase)
	if ( not TooltipNameBase  ) then 
		TooltipNameBase = "OneHitWonderTooltip";
	end
	
	local textLeft = nil;
	local textRight = nil;
	for idx = 1, 20 do
		textLeft = nil;
		textRight = nil;
		textLeft = getglobal(TooltipNameBase.."TextLeft"..idx);
		if ( textLeft ) then
			textLeft:SetText("");
		end
		textRight = getglobal(TooltipNameBase.."TextRight"..idx);
		if ( textRight ) then
			textRight:SetText("");
		end
	end
	
	local tooltip = getglobal(TooltipNameBase);
	if ( tooltip ) then
		tooltip:SetText("");
	end

end


OneHitWonder_PartyUnits = { "player", "party1", "party2", "party3", "party4"};


function OneHitWonder_GetClassesInGroup()
	local classes = {};
	local class = "";
	for k, v in OneHitWonder_PartyUnits do
		class = UnitClass(v);
		if ( ( class ) and ( strlen(class) > 0 ) ) then
			if ( classes[class] ) then
				classes[class] = classes[class] + 1;
			else
				classes[class] = 1;
			end
		end
	end
	return classes;
end

function OneHitWonder_IsEnabled()
	if ( OneHitWonder_Enabled == 1 ) then
		return true;
	else
		return false;
	end
end

function OneHitWonder_SetEnabled(toggle)
	if ( OneHitWonder_Enabled ~= toggle ) then
		OneHitWonder_Enabled = toggle;
	end
end

function OneHitWonder_OverloadedCastSpell(spellId, spellBook)
	OneHitWonder_HandleSpellCast(OneHitWonder_GetSpellName(spellId, spellBook));
	return OneHitWonder_Saved_CastSpell(spellId, spellBook)
end

OneHitWonder_Saved_CastSpell = CastSpell;
CastSpell = OneHitWonder_OverloadedCastSpell;

function OneHitWonder_OverloadedUseAction(actionId, param1, param2)
	local arr = OneHitWonder_ActionIdInfo[actionId];
	if ( ( arr ) and ( arr[1] ) ) then
		OneHitWonder_HandleSpellCast(arr[1].left);
	end
	return OneHitWonder_Saved_UseAction(actionId, param1, param2);
end

OneHitWonder_Saved_UseAction = UseAction;
UseAction = OneHitWonder_OverloadedUseAction;

function OneHitWonder_HandleSpellCast(spellName)
	if ( ( spellName ) and ( strfind(spellName, "Curse") ) ) then
		OneHitWonder_CurrentCurseTime = ONEHITWONDER_WARLOCK_CURSE_TIMES[spellName];
		if ( not OneHitWonder_CurrentCurseTime ) then
			-- change this?
			OneHitWonder_CurrentCurseTime = 0;
		end
		OneHitWonder_LastCurse = spellName;
		OneHitWonder_CursedTargetTime = GetTime();
	end
end


function OneHitWonder_GetNumberOfClassInGroup(class)
	local classes = OneHitWonder_GetClassesInGroup();
	local nr = classes[class];
	if ( ( nr ) and ( nr >= 1 ) ) then
		return nr;
	else
		return 0;
	end
end

ONEHITWONDER_PETMODE_UNKNOWN = -1;
ONEHITWONDER_PETMODE_AGGRESSIVE = 0;
ONEHITWONDER_PETMODE_DEFENSIVE = 1;
ONEHITWONDER_PETMODE_PASSIVE = 2;

function OneHitWonder_GetPetMode()
	for i=1, NUM_PET_ACTION_SLOTS, 1 do
		petActionButton = getglobal("PetActionButton"..i);
		petActionIcon = getglobal("PetActionButton"..i.."Icon");
		petAutoCastableTexture = getglobal("PetActionButton"..i.."AutoCastable");
		petAutoCastModel = getglobal("PetActionButton"..i.."AutoCast");
		local name, subtext, texture, isToken, isActive, autoCastAllowed, autoCastEnabled = GetPetActionInfo(i);
		if ( isActive(name) ) then
			if ( strfind(name, "Mode") ) then
				if ( strfind(name, TEXT(PET_MODE_AGGRESSIVE)) ) then
					return ONEHITWONDER_PETMODE_AGGRESSIVE;
				elseif ( strfind(name, TEXT(PET_MODE_DEFENSIVE)) ) then
					return ONEHITWONDER_PETMODE_DEFENSIVE;
				elseif ( strfind(name, TEXT(PET_MODE_PASSIVE)) ) then
					return ONEHITWONDER_PETMODE_PASSIVE;
				end
			end
		end
	end
	return ONEHITWONDER_PETMODE_UNKNOWN;
end

function OneHitWonder_SmartPetAttack(shouldAttack)
	if ( shouldAttack == 1 ) then
		local petMode = OneHitWonder_GetPetMode();
		if ( ( petMode == ONEHITWONDER_PETMODE_AGGRESSIVE ) or ( petMode == ONEHITWONDER_PETMODE_DEFENSIVE ) ) then
			PetAttack();
		end
	end
end
