ONEHITWONDER_ABILITY_EARTHSHOCK_NAME = "Earth Shock";

OneHitWonder_Shaman_UseEarthShock = 1;

function OneHitWonder_SetupStuffContinously_Shaman()
	OneHitWonder_AddStuffContinously("Lightning Shield", true, true);
end

function OneHitWonder_TryToInterruptSpell_Shaman(unitName, spellName)
	local interruptId = -1;
	local abilityName = "";
	abilityName = ONEHITWONDER_ABILITY_EARTHSHOCK_NAME;
	if ( OneHitWonder_Shaman_UseEarthShock ~= 1 ) then
		abilityName = "";
	end
	if ( ( abilityName ) and 
		(strlen(abilityName) > 0) ) then
		interruptId = OneHitWonder_GetSpellId(abilityName, "highest");
		if ( not OneHitWonder_IsSpellAvailable(interruptId) ) then
			abilityName = "";
			interruptId = -1;
		end
	end
	return abilityName, interruptId;
end

function OneHitWonder_Shaman_SetUseEarthShock(toggle)
	OneHitWonder_Shaman_UseEarthShock = toggle;
end

function OneHitWonder_Shaman_Cosmos()
	if ( Cosmos_RegisterConfiguration ) then
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_SHAMAN_SEPARATOR",
			"SEPARATOR",
			TEXT(ONEHITWONDER_SHAMAN_SEPARATOR),
			TEXT(ONEHITWONDER_SHAMAN_SEPARATOR_INFO)
		);
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_SHAMAN_USE_EARTH_SHOCK",
			"CHECKBOX",
			TEXT(ONEHITWONDER_SHAMAN_USE_EARTH_SHOCK),
			TEXT(ONEHITWONDER_SHAMAN_USE_EARTH_SHOCK_INFO),
			OneHitWonder_Shaman_SetUseEarthShock,
			OneHitWonder_Shaman_UseEarthShock
		);
	end
end

function OneHitWonder_Shaman(removeDefense)
	local targetName = UnitName("target");

	if ( not removeDefense ) then removeDefense = false; end
	
	if ( OneHitWonder_ChannelSpellRunning ) then
		return;
	end
	
	if ( (not targetName) or ( strlen(targetName) <= 0 ) ) then
		if ( not OneHitWonder_UseCountermeasures() ) then
			OneHitWonder_DoBuffs();
		end
		return;
	end
	
	if ( not UnitCanAttack("player", "target") ) then
		if ( not OneHitWonder_UseCountermeasures() ) then
			OneHitWonder_DoBuffs();
		end
		return;
	end
	
	if ( OneHitWonder_HandleActionQueue() ) then
		return;
	end

	if ( PlayerFrame.inCombat ~= 1 ) then
		AttackTarget();
	end

	if ( not OneHitWonder_DoBuffs() ) then
		if ( OneHitWonder_CastIfTargetNotHasEffect(ONEHITWONDER_ABILITY_SHOOT, ONEHITWONDER_ABILITY_SHOOT) ) then
			return;
		end
	end
end
