ONEHITWONDER_ABILITY_EXPOSEARMOR_TEXTURE = "Interface\\Icons\\Ability_Warrior_Riposte";
ONEHITWONDER_ABILITY_SLICEDICE_TEXTURE = "Interface\\Icons\\Ability_Rogue_SliceDice";
ONEHITWONDER_ABILITY_STEALTH_TEXTURE = "Interface\\Icons\\Ability_Stealth";

ONEHITWONDER_ABILITY_STEALTH_BUFFNAME = "Stealth";
ONEHITWONDER_ABILITY_VANISH_BUFFNAME = "Vanish";
ONEHITWONDER_ABILITY_SLICEDICE_BUFFNAME = "Slice and Dice";
ONEHITWONDER_ABILITY_EXPOSEARMOR_BUFFNAME = "Expose Armor";

ONEHITWONDER_ABILITY_EXPOSEARMOR_NAME = "Expose Armor";
ONEHITWONDER_ABILITY_AMBUSH_NAME = "Ambush";
ONEHITWONDER_ABILITY_GOUGE_NAME = "Gouge";
ONEHITWONDER_ABILITY_BACKSTAB_NAME = "Backstab";
ONEHITWONDER_ABILITY_EVISCERATE_NAME = "Eviscerate";
ONEHITWONDER_ABILITY_SLICEDICE_NAME = "Slice and Dice";
ONEHITWONDER_ABILITY_SINISTERSTRIKE_NAME = "Sinister Strike";
ONEHITWONDER_ABILITY_PICKPOCKET_NAME = "Pick Pocket";
ONEHITWONDER_ABILITY_KICK_NAME = "Kick";
ONEHITWONDER_ABILITY_FEINT_NAME = "Feint";
ONEHITWONDER_ABILITY_RUPTURE_NAME = "Rupture";
ONEHITWONDER_ABILITY_DISTRACT_NAME = "Distract";
ONEHITWONDER_ABILITY_GARROTTE_NAME = "Garrotte";
ONEHITWONDER_ABILITY_CHEAPSHOT_NAME = "Cheap Shot";
ONEHITWONDER_ABILITY_KIDNEYSHOT_NAME = "Kidney Shot";

ONEHITWONDER_TALENT_RIPOSTE_NAME = "Riposte";

ONEHITWONDER_ABILITY_STEALTH_OPENERS = {
	ONEHITWONDER_ABILITY_GARROTTE_NAME, 
	ONEHITWONDER_ABILITY_AMBUSH_NAME,
	ONEHITWONDER_ABILITY_BACKSTAB_NAME,
	ONEHITWONDER_ABILITY_CHEAPSHOT_NAME
};

ONEHITWONDER_ABILITY_FINISHING_MOVES = {
	ONEHITWONDER_ABILITY_EXPOSEARMOR_NAME,
	ONEHITWONDER_ABILITY_EVISCERATE_NAME, 
	ONEHITWONDER_ABILITY_SLICEDICE_NAME, 
	ONEHITWONDER_ABILITY_RUPTURE_NAME,
	ONEHITWONDER_ABILITY_KIDNEYSHOT_NAME
};

ONEHITWONDER_ABILITY_ENERGYCOST = {
	[ONEHITWONDER_ABILITY_AMBUSH_NAME] = 60,
	[ONEHITWONDER_ABILITY_BACKSTAB_NAME] = 60,
	[ONEHITWONDER_ABILITY_EVISCERATE_NAME] = 35,
	[ONEHITWONDER_ABILITY_SLICEDICE_NAME] = 25,
	[ONEHITWONDER_ABILITY_SINISTERSTRIKE_NAME] = 45,
	[ONEHITWONDER_ABILITY_EXPOSEARMOR_NAME] = 25,
	[ONEHITWONDER_ABILITY_GOUGE_NAME] = 45,
	[ONEHITWONDER_ABILITY_KICK_NAME] = 25,
	[ONEHITWONDER_ABILITY_FEINT_NAME] = 20,
	[ONEHITWONDER_ABILITY_RUPTURE_NAME] = 25,
	[ONEHITWONDER_ABILITY_DISTRACT_NAME] = 30,
	[ONEHITWONDER_ABILITY_GARROTTE_NAME] = 50,
	[ONEHITWONDER_ABILITY_CHEAPSHOT_NAME] = 60,
	[ONEHITWONDER_ABILITY_KIDNEYSHOT_NAME] = 25,
	[ONEHITWONDER_TALENT_RIPOSTE_NAME] = 10,
	[ONEHITWONDER_ABILITY_PICKPOCKET_NAME] = 0
};

ONEHITWONDER_QUEUE_KICK_CHAT_TYPES_OLD = {
	"SPELL_HOSTILEPLAYER_DAMAGE",
	"SPELL_HOSTILEPLAYER_BUFF",
	"SPELL_CREATURE_VS_SELF_DAMAGE",
	"SPELL_CREATURE_VS_SELF_BUFF",
	"SPELL_CREATURE_VS_CREATURE_BUFF",
};

-- verify this
ONEHITWONDER_QUEUE_RIPOSTE_CHAT_TYPES = {
	"COMBAT_MISC_INFO"
};

function OneHitWonder_GetEnergyConsumption(abilityName)
	return ONEHITWONDER_ABILITY_ENERGYCOST[abilityName];
end


ONEHITWONDER_ROGUE_TALENT_ENERGY_REDUCERS = {
	{ 
		{ 2,2 },
		ONEHITWONDER_ABILITY_SINISTERSTRIKE_NAME,
		{ 42, 40 }
	},
};

OneHitWonder_Rogue_SliceDicePercentage = 80;
OneHitWonder_Rogue_SliceDiceComboPointsMin = 1;
OneHitWonder_Rogue_SliceDiceComboPointsMax = 2;

function OneHitWonder_Rogue(removeDefense)
	local targetName = UnitName("target");

	if ( (not targetName) or ( strlen(targetName) <= 0 ) ) then
		return;
	end
	
	if ( not removeDefense ) then removeDefense = false; end
	
	if ( OneHitWonder_HandleActionQueue() ) then
		return;
	end
	
	if ( ( OneHitWonder_HasPlayerEffect(nil, ONEHITWONDER_ABILITY_STEALTH_BUFFNAME) ) or ( OneHitWonder_HasPlayerEffect(nil, ONEHITWONDER_ABILITY_VANISH_BUFFNAME) ) ) then
		local spellId = 0;
		local pickPockId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_PICKPOCKET_NAME);

		if ( ( not TargetFrame.hasBeenPickPocketed )  and ( pickPockId > -1 ) ) then
			spellId = pickPockId;
			if ( OneHitWonder_CastSpell(spellId, ONEHITWONDER_BOOK_TYPE_SPELL ) ) then
				-- should be replaced for check for "No pockets to pick" and "You loot XYZ Copper" at a latter stage
				TargetFrame.hasBeenPickPocketed = true;
			end
			return;
		else
			spellId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_AMBUSH_NAME);
			if ( spellId <= 0 ) then
				spellId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_BACKSTAB_NAME);
			end
		end
		OneHitWonder_CastSpell(spellId, ONEHITWONDER_BOOK_TYPE_SPELL);
		return;
	end

	local comboPoints = GetComboPoints();
	
	local unitHPPercent = OneHitWonder_GetTargetHPPercentage();

	local comboPointsNeeded = OneHitWonder_GetComboPointsNeededToEviscerate();

	if ( unitHPPercent >= OneHitWonder_Rogue_SliceDicePercentage ) then
		if ( ( comboPoints >= OneHitWonder_Rogue_SliceDiceComboPointsMin ) and ( comboPoints <= OneHitWonder_Rogue_SliceDiceComboPointsMax ) ) then
			if ( not OneHitWonder_HasPlayerEffect(nil, ONEHITWONDER_ABILITY_SLICEDICE_BUFFNAME) ) then
				if ( OneHitWonder_HasEnoughEnergy(ONEHITWONDER_ABILITY_SLICEDICE_NAME) ) then
					OneHitWonder_CastSpell(OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_SLICEDICE_NAME), ONEHITWONDER_BOOK_TYPE_SPELL);
					return;
				end
			end
		end
	end	
	
	local abilityName = ONEHITWONDER_ABILITY_EVISCERATE_NAME;

	if ( ( removeDefense ) and ( not OneHitWonder_HasUnitEffect("target", nil, ONEHITWONDER_ABILITY_EXPOSEARMOR_BUFFNAME) ) ) then
		local tmp = ONEHITWONDER_ABILITY_EXPOSEARMOR_NAME;
		local tmpId = OneHitWonder_GetSpellId(tmp);
		if ( tmpId > -1 ) then
			abilityName = tmp;
		end

		comboPointsNeeded = OneHitWonder_GetComboPointsNeededToExposeArmor();

	end
	
	if ( comboPoints >= comboPointsNeeded ) then
		if ( OneHitWonder_HasEnoughEnergy(abilityName) ) then
			OneHitWonder_CastSpell(OneHitWonder_GetSpellId(abilityName), ONEHITWONDER_BOOK_TYPE_SPELL);
			return;
		end
	end
	if ( OneHitWonder_HasEnoughEnergy(ONEHITWONDER_ABILITY_SINISTERSTRIKE_NAME) ) then
		OneHitWonder_CastSpell(OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_SINISTERSTRIKE_NAME), ONEHITWONDER_BOOK_TYPE_SPELL);
	end
end

function OneHitWonder_GetComboPointsNeededToExposeArmor()
	local combo = OneHitWonder_GetComboPointsNeededToEviscerate();
	if ( combo < 5 ) then
		combo = combo + 1;
	end
	return combo;
end

function OneHitWonder_GetComboPointsNeededToEviscerate()
	local unitHPPercent = OneHitWonder_GetTargetHPPercentage();
	local playerLevel = UnitLevel("player");
	local targetLevel = UnitLevel("target");
	if ( targetLevel - playerLevel > 5 ) then
		-- does not matter, you're not going to do something good with it anyhow
		return 1;
	end
	if ( playerLevel - targetLevel >= 10 ) then
		-- will prolly kill it quick
		return 1;
	end
	if ( playerLevel - targetLevel >= 5 ) then
		if ( unitHPPercent <= 15 ) then
			return 1;
		elseif ( unitHPPercent <= 50 ) then
			return 2;
		else
			return 3;
		end
	end
	if ( playerLevel - targetLevel >= 3 ) then
		if ( unitHPPercent <= 20 ) then
			return 1;
		elseif ( unitHPPercent <= 50 ) then
			return 2;
		else
			return 4;
		end
	end
	if ( playerLevel - targetLevel >= -1 ) then
		if ( unitHPPercent <= 25 ) then
			return 1;
		elseif ( unitHPPercent <= 40 ) then
			return 2;
		elseif ( unitHPPercent <= 50 ) then
			return 3;
		else
			return 5;
		end
	else
		if ( unitHPPercent <= 10 ) then
			return 2;
		elseif ( unitHPPercent <= 25 ) then
			return 3;
		elseif ( unitHPPercent <= 50 ) then
			return 4;
		else
			return 5;
		end
	end
end



function OneHitWonder_SetSliceDicePercentage(toggle, value)
	OneHitWonder_Rogue_SliceDicePercentage = value;
end

function OneHitWonder_SetSliceDiceComboPointsMin(toggle, value)
	OneHitWonder_Rogue_SliceDiceComboPointsMin = value;
end

function OneHitWonder_SetSliceDiceComboPointsMax(toggle, value)
	OneHitWonder_Rogue_SliceDiceComboPointsMax = value;
end

function OneHitWonder_Rogue_Cosmos()
	if ( Cosmos_RegisterConfiguration ) then
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_ROGUE_SEPARATOR",
			"SEPARATOR",
			TEXT(ONEHITWONDER_ROGUE_SEPARATOR),
			TEXT(ONEHITWONDER_ROGUE_SEPARATOR_INFO)
		);
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_SLICE_DICE",
			"SLIDER",
			TEXT(ONEHITWONDER_SLICE_DICE),
			TEXT(ONEHITWONDER_SLICE_DICE_INFO),
			OneHitWonder_SetSliceDicePercentage,
			1,
			OneHitWonder_Rogue_SliceDicePercentage, -- default
			0, -- min
			100, -- max
			"",
			1,
			1,
			TEXT(ONEHITWONDER_SLICE_DICE_APPEND)
		);
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_SLICE_DICE_COMBO_POINTS_MIN",
			"SLIDER",
			TEXT(ONEHITWONDER_SLICE_DICE_COMBO_POINTS_MIN),
			TEXT(ONEHITWONDER_SLICE_DICE_COMBO_POINTS_MIN_INFO),
			OneHitWonder_SetSliceDiceComboPointsMin,
			1,
			OneHitWonder_Rogue_SliceDiceComboPointsMin, -- default
			1, -- min
			5, -- max
			"",
			1,
			1,
			TEXT(ONEHITWONDER_SLICE_DICE_COMBO_POINTS_MIN_APPEND)
		);
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_SLICE_DICE_COMBO_POINTS_MAX",
			"SLIDER",
			TEXT(ONEHITWONDER_SLICE_DICE_COMBO_POINTS_MAX),
			TEXT(ONEHITWONDER_SLICE_DICE_COMBO_POINTS_MAX_INFO),
			OneHitWonder_SetSliceDiceComboPointsMax,
			1,
			OneHitWonder_Rogue_SliceDiceComboPointsMax, -- default
			1, -- min
			5, -- max
			"",
			1,
			1,
			TEXT(ONEHITWONDER_SLICE_DICE_COMBO_POINTS_MAX_APPEND)
		);
	end
	
end