--[[

	TODO:
	
	Buff Share
	
	OHW on Target = buff / heal / whatnot?
	
	Well Buff nohow
	
	Appropriate buff? If not in party / raid, inexpensive buff?
	
	IsResting() => Buff til you DROP!
	
	Thanks to thez for his Warlock code!

]]--

-- obsolete as OHW will no longer overwrite your tracking buff.
OneHitWonder_ShouldKeepFindOn = true;

OneHitWonder_TrackingSpellsList = {
	ONEHITWONDER_ABILITY_FIND_HERBS_NAME,
	ONEHITWONDER_ABILITY_FIND_MINERALS_NAME,
	ONEHITWONDER_ABILITY_FIND_TREASURE_NAME,
	ONEHITWONDER_ABILITY_SENSE_DEMONS_NAME,
	ONEHITWONDER_ABILITY_SENSE_UNDEAD_NAME,
	ONEHITWONDER_ABILITY_TRACK_BEASTS_NAME,
	ONEHITWONDER_ABILITY_TRACK_HUMANOIDS_NAME,
	ONEHITWONDER_ABILITY_TRACK_UNDEAD_NAME,
	ONEHITWONDER_ABILITY_TRACK_HIDDEN_NAME,
	ONEHITWONDER_ABILITY_TRACK_ELEMENTALS_NAME,
	ONEHITWONDER_ABILITY_TRACK_HUMANOID_NAME,
	ONEHITWONDER_ABILITY_TRACK_DEMONS_NAME,
	ONEHITWONDER_ABILITY_TRACK_GIANTS_NAME,
	ONEHITWONDER_ABILITY_TRACK_DRAGONKIN_NAME
};

OneHitWonder_CurrentAuras = {};

ONEHITWONDER_HEALTH_UPDATE_DELAY = 0.5;

OneHitWonder_OnlyShowCurrentClassSettings = 0;


OneHitWonder_ShouldTryToInterruptSpell = true;
OneHitWonder_UseBlockCounter = true;
OneHitWonder_UseDodgeCounter = true;
OneHitWonder_UseParryCounter = true;
OneHitWonder_ShouldTryToAntiDodge = true;

OneHitWonder_ShouldKeepBuffsUp = 1;
OneHitWonder_ShouldKeepBuffsUpParty = 1;



ONEHITWONDER_ACTIONID_SPELL = 1;
ONEHITWONDER_ACTIONID_SPELL_TIMEOUT = 2;

-- could be replaced with appropriate spells, of course
ONEHITWONDER_ACTIONID_BUFF = 3;
ONEHITWONDER_ACTIONID_DEBUFF = 4;

OneHitWonder_PetIsAttacking = false;
OneHitWonder_RegularSpellRunning = false;
OneHitWonder_ChannelSpellRunning = false;
OneHitWonder_TimeSpellStopped = 0;

OneHitWonder_BuffsToKeepUp = {};

ONEHITWONDER_MAXIMUM_NUMBER_OF_ACTION_IDS = 120;

ONEHITWONDER_MAXIMUM_TIME_SINCE_LAST_BUFF = 5;

OneHitWonder_ActionQueue = {};

OneHitWonder_Enabled = 1;


OneHitWonder_EnergyReservation = 0;

OneHitWonder_RageReservation = 0;

OneHitWonder_UnitHealthLastCalled = 0;

OneHitWonder_PlayerClass = nil;

OneHitWonder_PlayerRace = nil;

OneHitWonder_LastBuffed = 0;

OneHitWonder_WarlockDemonBuffNames = {
	"Demon Skin",
	"Demon Armor"
};

OneHitWonder_WarlockDetectInvisibilityBuffNames = {
	"Detect Lesser Invisibility",
	"Detect Invisibility",
	"Detect Greater Invisibility"
};

OneHitWonder_HunterAspects = {
	"Aspect of the Hawk",
	"Aspect of the Monkey",
	"Aspect of the Cheetah",
	"Aspect of the Beast",
	"Aspect of the Pack",
	"Aspect of the Wild"
};


OneHitWonder_Items = {};

--OneHitWonder_Saved_ChatFrame_OnEvent = nil;

OneHitWonder_WaitForFeedBack = false;
OneHitWonder_WaitForFeedBackTimeout = 0;
OneHitWonder_WaitForFeedBackDefaultTimeout = 2;
OneHitWonder_ChatFeedBack = "";

-- verify this
ONEHITWONDER_QUEUE_INTERRUPT_SPELL_CHAT_TYPES = {
	"SPELL_CREATURE_VS_SELF_DAMAGE",
	"SPELL_CREATURE_VS_SELF_BUFF",
	"SPELL_CREATURE_VS_PARTY_DAMAGE",
	"SPELL_CREATURE_VS_PARTY_BUFF",
	"SPELL_CREATURE_VS_CREATURE_DAMAGE",
	"SPELL_CREATURE_VS_CREATURE_BUFF"
};

ONEHITWONDER_QUEUE_INTERRUPT_SPELL_DODGEPARRYBLOCK_TYPES = {
	"COMBAT_SELF_HITS",
	"COMBAT_SELF_MISSES",
	"COMBAT_CREATURE_VS_SELF_HITS",
	"COMBAT_CREATURE_VS_SELF_MISSES"
};

ONEHITWONDER_WARRIOR_STANCE_BATTLE = 1;
ONEHITWONDER_WARRIOR_STANCE_DEFENSIVE = 2;
ONEHITWONDER_WARRIOR_STANCE_AGGRESSIVE = 3;
ONEHITWONDER_WARRIOR_STANCE_BERSERK = 4;

ONEHITWONDER_ABILITY_SHADOW_WARD_NAME = "Shadow Ward";

-- taken from ItemBuff - thanks, Telo!
OneHitWonder_InventorySlotNames = {
	{ name = "HeadSlot" },
	{ name = "NeckSlot" },
	{ name = "ShoulderSlot" },
	{ name = "BackSlot" },
	{ name = "ChestSlot" },
	{ name = "ShirtSlot" },
	{ name = "TabardSlot" },
	{ name = "WristSlot" },
	{ name = "HandsSlot" },
	{ name = "WaistSlot" },
	{ name = "LegsSlot" },
	{ name = "FeetSlot" },
	{ name = "Finger0Slot" },
	{ name = "Finger1Slot" },
	{ name = "Trinket0Slot" },
	{ name = "Trinket1Slot" },
	{ name = "MainHandSlot" },
	{ name = "SecondaryHandSlot" },
	{ name = "RangedSlot" },
};

function OneHitWonder_ShowBigMessage(msg)
    ZoneTextString:SetText(msg);
    ZoneTextString:SetTextColor(1.0, 0.2, 0.2);
    ZoneTextFrame.startTime = GetTime();
    ZoneTextFrame:Show();
    PlaySound("MapPing");
end

function OneHitWonder_IsTargetedUnit(name)
	if ( UnitName("target") == name ) then
		return true;
	else
		return false;
	end
end

function OneHitWonder_ExtractUnitNameFromCombatMessage(msg, source, stringAfterName)
	if ( ( source ) and ( strlen(source) > 0 ) ) then 
		return source;
	else
		local index = strfind(msg, stringAfterName);
		local unitName = "";
		local spellName = "";
		if ( index ~= nil ) then
			local tmpStr = strsub(msg, 1, index-2);
			local cutAwayStr = "%. "; -- sigh. damn patterns
			local index2 = strfind(tmpStr, cutAwayStr);
			if ( index2 ) then
				tmpStr = strsub(tmpStr, index2+2);
			end
			unitName = tmpStr;
			local spellCutPoint = index+strlen(stringAfterName);
			if ( spellCutPoint < strlen(msg) ) then
				tmpStr = strsub(msg, spellCutPoint);
				spellName = tmpStr;
			end
		end
		return unitName, spellName;
	end
end

OneHitWonder_ShadowSpells = {
	"shadow bolt",
	"shadowburn",
	"mind blast",
	"touch of weakness",
	"devouring plague",
	"shadow word: pain",
	"mind flay"
};

OneHitWonder_ShadowSpellKeyWords = {
	"shadow",
	"dark",
	"consuming"
};

OneHitWonder_NotShadowSpells = {
	"shadow resistance aura", -- once again... not truly correct
	"shadow protection",
	"shadow ward",
	"shadowguard", -- debatable
	"curse of shadow", -- also debatable
	"dark pact",
	"mind soothe",
	"mind-numbing poison",
	"mind control", -- not entirely true
	"mind vision"
};

OneHitWonder_FireSpells = {
	"fireball",
	"fire blast",
	"fire nova totem",
	"rain of fire",
	"holy fire",
	"hellfire",
	"searing pain",
	"soul fire",
	"pyroblast",
	"scorch",
	"immolate",
	"torch burst"
};

OneHitWonder_NotFireSpells = {
	"moonfire",
	"faerie fire",
	"fire ward", -- not really true, but used in the context it will be...
	"starfire",
	"rapid fire",
	"fire resistance totem",
	"inner fire",
	"searing totem"
};

OneHitWonder_FireSpellKeyWords = {
	"pyro",
	"fire",
	"searing",
	"scorch"
};

OneHitWonder_FrostSpells = {
	"frostbolt",
	"frost nova", -- should this be here or in not frost spells? we can't do anything, so...
	"frostbrand weapon",
	"cone of cold",
	"blizzard"
};

OneHitWonder_FrostSpellKeyWords = {
	"frost",
	"cold",
	"ice"
};

OneHitWonder_NotFrostSpells = {
	--"frost nova", -- should this be here or in frost spells? we can't do anything, so...
	"frost armor",
	"frost shock", -- thottbot says nothing about frost damage, so...
	"frost ward",
	"ice armor", -- not entirely true
	"ice barrier", -- not entirely true
	"frost resistance totem",
	"frost resistance aura"
};

function OneHitWonder_IsSpellBased(spellName, exactMatch, keywordMatch, excludeExactMatch)
	if ( not spellName ) then
		return false;
	end
	local lowName = strlower(spellName);
	local index = strfind(lowName, "%(rank");
	if ( index ) then
		lowName = strsub(lowName, 1, index-1);
	end
	if ( excludeExactMatch ) then
		for k, v in excludeExactMatch do
			if ( v == lowName ) then
				return false;
			end
		end
	end
	for k, v in exactMatch do
		if ( v == lowName ) then
			return true;
		end
	end
	for k, v in keywordMatch do
		if ( strfind(lowName, v ) ) then
			return true;
		end
	end
	return false;
end

function OneHitWonder_IsSpellShadowBased(spellName)
	return OneHitWonder_IsSpellBased(spellName, OneHitWonder_ShadowSpells, OneHitWonder_ShadowSpellKeyWords, OneHitWonder_NotShadowSpells);
end

function OneHitWonder_IsSpellFireBased(spellName)
	return OneHitWonder_IsSpellBased(spellName, OneHitWonder_FireSpells, OneHitWonder_FireSpellKeyWords, OneHitWonder_NotFireSpells);
end

function OneHitWonder_IsSpellFrostBased(spellName)
	return OneHitWonder_IsSpellBased(spellName, OneHitWonder_FrostSpells, OneHitWonder_FrostSpellKeyWords, OneHitWonder_NotFrostSpells);
end

function OneHitWonder_TryToInterruptSpell(unitName, spellName)
	return OneHitWonder_DoGenericActionAdding("TryToInterruptSpell", unitName, spellName);
end

function OneHitWonder_DoGenericActionAdding(addFuncName, arg1, arg2, arg3, arg4)
	local counterId = -1;
	local abilityName = "";
	local timeout = 3;
	local funcName = format("OneHitWonder_%s_%s", addFuncName, OneHitWonder_GetPlayerClass());
	local func = getglobal(funcName);
	if ( func ) then
		--[[
		if ( args ) then
			counterId, abilityName, timeout = func(unpack(args));
		else
			counterId, abilityName, timeout = func();
		end
		]]--
		counterId, abilityName, timeout = func(arg1, arg2, arg3, arg4);
	end
	if ( counterId > -1 ) then
		OneHitWonder_ShowImperativeMessage(abilityName);
		if ( ( not timeout ) or ( timeout <= 0 ) ) then
			timeout = 3;
		end
		local parameters = { counterId, GetTime() + timeout};
		OneHitWonder_AddActionToQueue(ONEHITWONDER_ACTIONID_SPELL_TIMEOUT, parameters);
	end
end

function OneHitWonder_DoBlockCounter()
	return OneHitWonder_DoGenericActionAdding("GetBlockCounter");
end

function OneHitWonder_DoDodgeCounter()
	return OneHitWonder_DoGenericActionAdding("GetDodgeCounter");
end

function OneHitWonder_DoParryCounter()
	return OneHitWonder_DoGenericActionAdding("GetParryCounter");
end

function OneHitWonder_ShowImperativeMessage(name)
	if ( ( name ) and ( strlen(name) > 0 ) ) then
		OneHitWonder_ShowBigMessage(format(ONEHITWONDER_IMPERATIVE_ABILITY_MESSAGE, name));
	end
end

function OneHitWonder_DoTargetDodgeCounter()
	return OneHitWonder_DoGenericActionAdding("GetTargetDodgeCounter");
end


OneHitWonder_Chat_SpellCastingStartingStrings = {
	"begins to cast"
};

OneHitWonder_Chat_DodgingStrings = {
	"dodges"
};

OneHitWonder_Chat_ParryStrings = {
	"You parry"
};

OneHitWonder_Chat_BlockStrings = {
	"You block"
};

OneHitWonder_Chat_DodgeStrings = {
	"You dodge"
};

function OneHitWonder_Chat_OnEvent(event)
	if ( OneHitWonder_IsEnabled() ) then
		if ( strsub(event, 1, 8) == "CHAT_MSG" ) then
			local typeOfEvent = strsub(event, 10);
			local info = ChatTypeInfo[type];
			local unitName = nil;
			local spellName = nil;
			local shouldInterrupt = false;
			for k, spellStartStr in OneHitWonder_Chat_SpellCastingStartingStrings do
				if ( strfind(arg1, spellStartStr ) ) then
					unitName, spellName = OneHitWonder_ExtractUnitNameFromCombatMessage(arg1, arg2, spellStartStr);
					local qweqwe = "No unit found";
					if ( unitName ) then
						qweqwe = unitName;
					end
					if ( spellName ) then
						qweqwe = qweqwe..":"..spellName;
					end
					if ( (OneHitWonder_IsTargetedUnit(unitName)) and ( OneHitWonder_ShouldTryToInterruptSpell ) ) then
						for k, v in ONEHITWONDER_QUEUE_INTERRUPT_SPELL_CHAT_TYPES do
							if ( strfind(event, v) ) then
								shouldInterrupt = true;
								break;
							end
						end
						if ( shouldInterrupt ) then
							OneHitWonder_TryToInterruptSpell(unitName, spellName);
							break;
						end
					end
					if ( shouldInterrupt ) then break; end
				end
			end
			for k, dodgeStr in OneHitWonder_Chat_DodgingStrings do
				if ( strfind(arg1, dodgeStr) ) then
					unitName = OneHitWonder_ExtractUnitNameFromCombatMessage(arg1, arg2, dodgeStr);
					if ( ( strfind(arg1, dodgeStr ) ) and (OneHitWonder_IsTargetedUnit(unitName)) and ( OneHitWonder_ShouldTryToAntiDodge ) ) then
						OneHitWonder_DoTargetDodgeCounter();
						break;
					end
				end
			end
			for k, parryStr in OneHitWonder_Chat_ParryStrings do
				if ( ( OneHitWonder_UseParryCounter ) and ( strfind(arg1, parryStr) ) ) then
					OneHitWonder_DoParryCounter();
					break;
				end
			end
			for k, str in OneHitWonder_Chat_BlockStrings do
				if ( ( OneHitWonder_UseBlockCounter ) and ( strfind(arg1, str) ) ) then
					OneHitWonder_DoBlockCounter();
					break;
				end
			end
			for k, str in OneHitWonder_Chat_DodgeStrings do
				if ( ( OneHitWonder_UseDodgeCounter ) and ( strfind(arg1, str) ) ) then
					OneHitWonder_DoDodgeCounter();
					break;
				end
			end
		end
	end
end

function OneHitWonder_HasTargetBuffTexture(texture)
	local buff;
	for i=1, MAX_TARGET_DEBUFFS do
		buff = UnitBuff("target", i);
		if ( buff == texture ) then
			return true;
		end
	end
	return false;
end

function OneHitWonder_HasTargetDebuffTexture(texture)
	local debuff;
	local i = 0;
	for i=1, MAX_TARGET_DEBUFFS do
		debuff = UnitDebuff("target", i);
		if ( debuff == texture ) then
			return true;
		end
	end
	return false;
end

function OneHitWonder_HasTargetAnyBuffTexture(texture)
	if ( OneHitWonder_HasTargetBuffTexture(texture) ) then
		return true;
	else
		return OneHitWonder_HasTargetDebuffTexture(texture);
	end
end

-- OneHitWonder_HasUnitEffect (unitName, texture, name) 
--
--  determines if the specified unit has an effect (buff/debuff) with the specified texture(s) and name(s)
--
--  unitName - the unit name to check for buffs - accepts pet/player/partyX/target
--  
function OneHitWonder_HasUnitEffect(unitName, texture, name)
	if ( OneHitWonder_GetUnitEffect(unitName, texture, name) ) then
		return true;
	else
		return false;
	end
end

function OneHitWonder_GetUnitEffect(unitName, texture, name)
	return DynamicData.effect.getEffectInfo(unitName, name, texture);
end

function OneHitWonder_HasUnitEffectOld(unitName, texture, name)
	if ( unitName == "player") then
		return OneHitWonder_HasPlayerEffectOld(texture, name);
	end
	local id = 1;
	local i, buffName;
	local buffIndex, untilCancelled;
	local textureList = {};
	if ( type(texture) == "table" ) then
		textureList = texture;
	else
		textureList = { texture };
	end
	local nameList = {};
	if ( type(name) == "table" ) then
		nameList = name;
	else
		nameList = { name };
	end
	if ( name ) then
		for i = 0, MAX_PARTY_TOOLTIP_BUFFS do
			buffName = OneHitWonder_GetBuffNameUsingBuffIndex(unitName, i);
			if ( OneHitWonder_IsStringInList(buffName, nameList) ) then
				return true;
			end
		end
		for i = 0, MAX_PARTY_TOOLTIP_DEBUFFS do
			buffName = OneHitWonder_GetBuffNameUsingBuffIndex(unitName, i, true);
			if ( OneHitWonder_IsStringInList(buffName, nameList) ) then
				return true;
			end
		end
	end
	if ( texture ) then
		local buffTexture = nil;
		for i = 0, MAX_PARTY_TOOLTIP_BUFFS do
			buffTexture = UnitBuff(unitName, i);
			if ( OneHitWonder_IsStringInList(buffTexture, textureList) ) then
				return true;
			end
		end
		for i = 0, MAX_PARTY_TOOLTIP_DEBUFFS do
			buffTexture = UnitDebuff(unitName, i);
			if ( OneHitWonder_IsStringInList(buffTexture, textureList) ) then
				return true;
			end
		end
	end
	return false;
end

function OneHitWonder_GetPlayerTrackingBuffStrings()
	local tooltipName = "OneHitWonderTooltip";
	local tooltip = getglobal(tooltipName);
	if ( not tooltip ) then
		OneHitWonder_Print("OHW: Could not find tooltip to extract spell ID info from "..tooltipName, 1.0, 0.2, 0.2);
		return nil;
	end
	OneHitWonder_ClearTooltip(tooltipName);
	if ( DynamicData ) and ( DynamicData.util ) and ( DynamicData.util.protectTooltipMoney ) then
		DynamicData.util.protectTooltipMoney();
	end 
	tooltip:SetTrackingSpell();
	if ( DynamicData ) and ( DynamicData.util ) and ( DynamicData.util.unprotectTooltipMoney ) then
		DynamicData.util.unprotectTooltipMoney();
	end 
	
	local strings = OneHitWonder_ScanTooltip(tooltipName);
	return strings;
end

function OneHitWonder_GetPlayerTrackingBuffName()
	local tooltipName = "OneHitWonderTooltip";
	local tooltip = getglobal(tooltipName);
	if ( not tooltip ) then
		OneHitWonder_Print("OHW: Could not find tooltip to extract spell ID info from "..tooltipName, 1.0, 0.2, 0.2);
		return nil;
	end
	OneHitWonder_ClearTooltip(tooltipName);
	if ( DynamicData ) and ( DynamicData.util ) and ( DynamicData.util.protectTooltipMoney ) then
		DynamicData.util.protectTooltipMoney();
	end 
	tooltip:SetTrackingSpell();
	if ( DynamicData ) and ( DynamicData.util ) and ( DynamicData.util.unprotectTooltipMoney ) then
		DynamicData.util.unprotectTooltipMoney();
	end 
	
	local strings = OneHitWonder_ScanTooltip(tooltipName);
	
	if ( strings ) and ( strings[1] ) and ( strings[1].left ) then
		return strings[1].left;
	else
		return nil;
	end
end

function OneHitWonder_HasPlayerEffect(texture, name)
	return OneHitWonder_HasUnitEffect("player", texture, name);
end

function OneHitWonder_HasPlayerEffectOld(texture, name)
	local id = 1;
	local i, buffName;
	local buffIndex, untilCancelled;
	local textureList = {};
	if ( type(texture) == "table" ) then
		textureList = texture;
	else
		textureList = { texture };
	end
	local nameList = {};
	if ( type(name) == "table" ) then
		nameList = name;
	else
		nameList = { name };
	end
	if ( texture ) then
		local isDebuff = false;
		local buffTexture = nil;
		local buffName = nil;
		for id = 1, 24 do
			buffTexture = GetPlayerBuffTexture(id);
			if ( OneHitWonder_IsStringInList(buffTexture, textureList) ) then
				if ( name ) then
					if ( id >= 20 ) then
						isDebuff = true;
					else
						isDebuff = false;
					end
					buffName = OneHitWonder_GetBuffNameUsingBuffIndex("player", id, isDebuff);
					if ( OneHitWonder_IsStringInList(buffName, nameList) ) then
						return true;
					end
				else
					return true;
				end
			end
		end
		local icon = GetTrackingTexture();
		if ( icon == texture ) then 
			if ( name ) then
				local trackBuffName = OneHitWonder_GetPlayerTrackingBuffName()
				if ( trackBuffName == name) then
					return true;
				end
			else
				return true;
			end
		end
	end
	if ( name ) then
		for i = 0, MAX_PARTY_TOOLTIP_BUFFS do
			buffIndex, untilCancelled = GetPlayerBuff(i, "HELPFUL|PASSIVE");
			if ( buffIndex >= 0 ) then
				buffName = OneHitWonder_GetBuffNameUsingBuffIndex("player", buffIndex);
				if ( OneHitWonder_IsStringInList(buffName, nameList) ) then
					return true;
				end
			end
		end
		for i = 0, MAX_PARTY_TOOLTIP_DEBUFFS do
			buffIndex, untilCancelled = GetPlayerBuff(i, "HARMFUL");
			if ( buffIndex >= 0 ) then
				buffName = OneHitWonder_GetBuffNameUsingBuffIndex("player", buffIndex, true);
				if ( OneHitWonder_IsStringInList(buffName, nameList) ) then
					return true;
				end
			end
		end
		local trackBuffName = OneHitWonder_GetPlayerTrackingBuffName()
		if ( trackBuffName == name) then
			return true;
		end
	end
	return false;
end

function OneHitWonder_HasBuffTexture(texture)
	local id = 1;
	for id = 0, 15 do
		if ( GetPlayerBuffTexture(id) == texture ) then
			return true;
		end
	end
	return false;
end

ONEHITWONDER_BOOK_TYPE_SPELL = "spell";

function OneHitWonder_GetRankAsNumber(rankName)
	if ( rankName ) then
		local index, index2 = strfind(rankName, "Rank");
		if ( ( index ) and (index2 ) ) then
			local tmpStr = strsub(rankName, index2+1);
			while ( ( tmpStr) and ( strlen(tmpStr) > 1 ) and ( strsub(tmpStr, 1, 1) == " " ) ) do
				tmpStr = strsub(tmpStr, 2);
			end
			local i = tonumber(tmpStr);
			if ( i ) then
				return i;
			else
				return 0;
			end
		else
			return 0;
		end
	else
		return 0;
	end
end

function OneHitWonder_GetSpellName(spellId, spellBook, doNoUseCache)
	local name = nil;
	local rankName = nil;
	if ( ( doNoUseCache ) or 
		( ( not OneHitWonder_SpellIdInfo ) or ( not OneHitWonder_SpellIdInfo[spellBook]) or 
			( not OneHitWonder_SpellIdInfo[spellBook][spellId]) ) ) then
		name, rankName = GetSpellName(spellId, spellBook);
	else
		spellInfo = OneHitWonder_SpellIdInfo[spellBook][spellId];
		if ( spellInfo ) and ( getn(spellInfo) >= 1 ) then
			name = spellInfo[1].left;
			if ( getn(spellInfo) >= 2 ) then
				rankName = spellInfo["rank"];
			end
		end
	end
	return name, rankName;
end

function OneHitWonder_GetSpellId(spellName, spellRank, spellBook, doNotUseCache)
	local i = 1;
	local highestId = -1;
	local highestRankSoFar = -1;
	local rank;
	local spellRankNumber = 0;
	if (spellRank) then
		spellRankNumber = tonumber(spellRank);
		if (not spellRankNumber) then
			spellRankNumber = 0;
		end
	end
	if ( not spellBook ) then
		spellBook = OneHitWonder_GetSpellBook();
	end
	local name, rankName;
	name, rankName = OneHitWonder_GetSpellName(i, spellBook, doNotUseCache);
	while name do
		if ( name == spellName) then
			if ( spellRank == nil ) then
				rank = OneHitWonder_GetRankAsNumber(rankName);
				if ( rank ) then
					if ( rank > highestRankSoFar ) then
						highestRankSoFar = rank;
						highestId = i;
					end
				else
					return i;
				end
			else
				rank = OneHitWonder_GetRankAsNumber(rankName);
				if ( rank == spellRankNumber ) then
					highestId = i;
					break;
				elseif ( rank > highestRankSoFar ) then
					highestRankSoFar = rank;
					highestId = i;
				end
			end
		end
		i = i + 1;
		name, rankName = OneHitWonder_GetSpellName(i, spellBook)
	end
	return highestId;
end

function OneHitWonder_HasEnoughEnergy(abilityName, ignoreEnergyReservation)
	local energy = PlayerFrameManaBar:GetValue();
	
	if ( not ignoreEnergyReservation ) then
		energy = energy - OneHitWonder_EnergyReservation;
	end

	if ( OneHitWonder_GetEnergyConsumption(abilityName) <= energy ) then
		return true;
	else
		return false;
	end
end

function OneHitWonder_HasEnoughRage(abilityName, ignoreRageReservation)
	local rage = PlayerFrameManaBar:GetValue();

	if ( not ignoreRageReservation ) then
		rage = rage - OneHitWonder_RageReservation;
	end

	if ( OneHitWonder_GetRageConsumption(abilityName) <= rage ) then
		return true;
	else
		return false;
	end
end


function OneHitWonder_GetActionId(texture)
	if ( texture ) then
		local id = 1;
		local actionTexture;
		for id = 1, 120 do
			actionTexture = GetActionTexture(id);
			if ( ( actionTexture ) and ( actionTexture == texture ) ) then
				return id;
			end
		end
	end
	return -1;
end

function OneHitWonder_GetSpellBook(spellBook)
	if ( not spellBook ) then spellBook = ONEHITWONDER_BOOK_TYPE_SPELL; end;
	return spellBook;
end

function OneHitWonder_CheckIfInRangeSpellId(id, spellBook)
	local actionId = 0;
	spellBook = OneHitWonder_GetSpellBook(spellBook);
	actionId = OneHitWonder_GetActionIdFromSpellId(id, spellBook);
	return OneHitWonder_CheckIfInRangeActionId(actionId);
end

function OneHitWonder_CheckIfInRangeActionId(id)
	if ( ( id >= 1) and ( IsActionInRange(id) == 0) ) then
		return false;
	else	
		return true;
	end
end

function OneHitWonder_CheckIfUsableActionId(id)
	if ( id >= 1) then
		local isUsable, notEnoughMana = IsUsableAction(id);
		if ( ( isUsable ) and ( not notEnoughMana ) )  then
			return true;
		else
			return false;
		end
	else	
		return true;
	end
end

function OneHitWonder_CheckIfSpellIsCoolingdownById(id, spellBook)
	if ( id == -1 ) then
		return true;
	end
	spellBook = OneHitWonder_GetSpellBook(spellBook);
	local start, duration, enable = GetSpellCooldown(id, spellBook);
	--OneHitWonder_Log(spellId, spellBook, start, duration, enable);
	if ( enable == 1 ) then
		if ( ( (start + duration) < GetTime() ) or ( (start + duration) == 0 ) ) then
			return false;
		end
	end
	return true;
end

function OneHitWonder_CheckIfUsable(actionId, spellId, spellBook)
	spellBook = OneHitWonder_GetSpellBook(spellBook);
	if ( spellId > -1 ) then
		if ( OneHitWonder_CheckIfSpellIsCoolingdownById(spellId, spellBook) ) then
			return false;
		end
	end
	return OneHitWonder_CheckIfUsableActionId(actionId);
end

function OneHitWonder_CheckIfUsableSpellId(id, spellBook)
	if ( id == -1 ) then
		return false;
	end
	spellBook = OneHitWonder_GetSpellBook(spellBook);
	local actionId = -1;
	if ( not OneHitWonder_CheckIfSpellIsCoolingdownById(id, spellBook) ) then
		actionId = OneHitWonder_GetActionIdFromSpellId(id, spellBook);
		return OneHitWonder_CheckIfUsableActionId(actionId);
	end
	return false;
end

function OneHitWonder_CheckIfInRangeAndUsableInActionBar(texture)
	if ( texture ) then
		local id = OneHitWonder_GetActionId(texture);
		if ( (OneHitWonder_CheckIfUsableActionId(id) ) and ( OneHitWonder_CheckIfInRangeActionId(id) ) ) then
			return true;
		else
			return false;
		end
	end
	return false;
end

function OneHitWonder_CheckIfInRangeAndUsableInActionBarByActionId(actionId)
	if ( (OneHitWonder_CheckIfUsableActionId(actionId) ) and ( OneHitWonder_CheckIfInRangeActionId(actionId) ) ) then
		return true;
	else
		return false;
	end
end

-- /script PrintTable(OneHitWonder_SpellAvailability);
-- /script OneHitWonder_SpellAvailability = {};

OneHitWonder_SpellAvailability = {};

function OneHitWonder_Log(spellId, spellBook, start, duration, enable)
	if ( spellId <= -1 ) then
		return
	end
	if ( enable == 0 ) then
		return;
	end
	if ( not OneHitWonder_SpellAvailability[spellId]) then
		OneHitWonder_SpellAvailability[spellId] = {};
	end
	local currentTime = GetTime() * 1000;
	local cooldownTime = start * 1000 + duration * 1000;
	local available = "true";
	if ( cooldownTime > currentTime ) then
		available = "false";
	end
	local parameter = {start, duration, enable, GetTime(), available};
	table.insert(OneHitWonder_SpellAvailability[spellId], parameter);
end

function OneHitWonder_IsSpellAvailable(spellId, spellBook)
	if ( spellId <= -1 ) then
		return false;
	end
	spellBook = OneHitWonder_GetSpellBook(spellBook);
	if( OneHitWonder_IsSpellCoolingDown(spellId, spellBook ) ) then
		return false;
	elseif( OneHitWonder_CheckIfInRangeAndUsableInActionBar(GetSpellTexture(spellId, spellBook)) ) then
		return true;
	end
	return false;
end

function OneHitWonder_IsSpellCoolingDown(spellId, spellBook)
	if ( spellId <= -1 ) then
		return false;
	end
	spellBook = OneHitWonder_GetSpellBook(spellBook);
	local start, duration, enable = GetSpellCooldown(spellId, spellBook);
	local sd = start + duration;
	if ( enable == 1 ) then
		if ( ( sd == 0 ) or ( sd < GetTime() ) ) then
			return false;
		end
	end
	return true;
end

function OneHitWonder_GetSpellCooldown(spellId, spellBook)
	if ( spellId <= -1 ) then
		return -1;
	end
	spellBook = OneHitWonder_GetSpellBook(spellBook);
	local start, duration, enable = GetSpellCooldown(spellId, spellBook);
	if ( enable == 1 ) then
		local dur = start + duration;
		if ( dur > 0 ) then
			dur = dur - GetTime();
		end
		if ( dur < 0 ) then
			dur = 0;
		end
		return dur;
	end
	return 0;
end

function OneHitWonder_CastSpell(spellId, spellBook)
	if ( spellId <= -1 ) then
		return false;
	end
	spellBook = OneHitWonder_GetSpellBook(spellBook);
	if ( OneHitWonder_IsSpellAvailable(spellId, spellBook) ) then
		CastSpell(spellId, spellBook);
		return true;
	end
	return false;
end

function OneHitWonder_GetTargetHPPercentage()
	local unitMinHP, unitMaxHP, unitCurrHP;
	unitMinHP, unitMaxHP = TargetFrameHealthBar:GetMinMaxValues();
	unitCurrHP = TargetFrameHealthBar:GetValue();
	
	local unitHPPercent = TargetFrame.unitHPPercent;

	if ( not UnitIsPlayer("target") ) then
		unitHPPercent = unitCurrHP;
	else
		unitHPPercent = math.floor(unitHPPercent * 100);
	end
	return unitHPPercent;
end

function OneHitWonder_GetUnitHPPercentage(unit)
	local unitMaxHP, unitCurrHP;
	unitMaxHP = UnitHealthMax(unit);
	unitCurrHP = UnitHealth(unit);
	if ( unitCurrHP == 0 ) then
		return 0;
	else
		return ((unitCurrHP / unitMaxHP ) * 100);
	end
end

function OneHitWonder_GetPlayerHPPercentage()
	return OneHitWonder_GetUnitHPPercentage("player");
end

function OneHitWonder_GetUnitManaPercentage(unit)
	local unitMaxMana, unitCurrMana;
	unitMaxMana = UnitManaMax(unit);
	unitCurrMana = UnitMana(unit);
	if ( unitCurrMana == 0 ) then
		return 0;
	else
		return ((unitCurrMana / unitMaxMana ) * 100);
	end
end

function OneHitWonder_GetPlayerManaPercentage()
	return OneHitWonder_GetUnitManaPercentage("player");
end

function OneHitWonder_WiggleStop()
	MoveForwardStop();
end

function OneHitWonder_Wiggle()
	if ( CosmosSchedule ) then
		MoveForwardStart();
		CosmosSchedule(0.2, OneHitWonder_WiggleStop);
	end
end

function OneHitWonder_IsInPartyOrRaid()
	if ( ( GetNumPartyMembers() > 0 ) or ( GetNumRaidMembers() > 0  ) ) then
		return true;
	else
		return false;
	end
end

function OneHitWonder_HasPartyMembers()
	if ( GetNumPartyMembers() > 0 ) then
		return true;
	else
		return false;
	end
end

function OneHitWonder_DumpDebuffsOnce()
	if ( not DebuffsShown ) then
		DebuffsShown = {};
	end
	local debuff;
	for i=1, MAX_TARGET_DEBUFFS do
		debuff = UnitDebuff("target", i);
		if ( ( debuff ) and ( not DebuffsShown[debuff] ) ) then
			OneHitWonder_Print(debuff);
			DebuffsShown[debuff] = true;
		end
	end
end

function OneHitWonder_DumpTargetBuffs()
	local debuff;
	for i=1, MAX_TARGET_DEBUFFS do
		debuff = UnitBuff("target", i);
		if ( ( debuff ) ) then
			OneHitWonder_Print(debuff);
		end
	end
end

function OneHitWonder_DumpTargetDebuffs()
	local debuff;
	for i=1, MAX_TARGET_DEBUFFS do
		debuff = UnitDebuff("target", i);
		if ( ( debuff ) ) then
			OneHitWonder_Print(debuff);
		end
	end
end

function OneHitWonder_DumpOwnBuffs()
	local texture, buffIndex, untilCancelled;
	for i = 0, MAX_PARTY_TOOLTIP_BUFFS do
		buffIndex, untilCancelled = GetPlayerBuff(i, "HELPFUL|PASSIVE");
		if ( buffIndex >= 0 ) then
			texture = GetPlayerBuffTexture(buffIndex);
			OneHitWonder_Print(texture);
		end
	end
end

function OneHitWonder_GetBuffNameUsingBuffIndex(unitName, buffIndex, debuff)
	if (buffIndex ~= -1) then
		local tooltipName = "OneHitWonderTooltip";
		local tooltip = getglobal(tooltipName);
		local tooltiptext = getglobal(tooltipName.."TextLeft1");
		if ( tooltiptext ) then
			tooltiptext:SetText("");
		end
		OneHitWonder_ClearTooltip(tooltipName);
		if ( unitName == "player" ) then
			tooltip:SetPlayerBuff(buffIndex);
		else
			if ( not debuff ) then
				tooltip:SetUnitBuff(unitName, buffIndex);
			else
				tooltip:SetUnitDebuff(unitName, buffIndex);
			end
		end
		if ( tooltiptext ) then
			local name = tooltiptext:GetText();
			if ( ( name ~= nil ) and ( strlen(name) > 0 ) ) then
				return name;
			end
		end
	end
	return nil;
end

function OneHitWonder_DumpOwnBuffNames()
	local name, buffIndex, untilCancelled;
	for i = 0, MAX_PARTY_TOOLTIP_BUFFS do
		buffIndex, untilCancelled = GetPlayerBuff(i, "HELPFUL|PASSIVE");
		if ( buffIndex >= 0 ) then
			name = OneHitWonder_GetBuffNameUsingBuffIndex("player", buffIndex);
			if ( name ) then
				OneHitWonder_Print(name);
			end
		end
	end
end

function OneHitWonder_AddActionToQueue(actionId, actionParameter)
	local entry = { actionId, actionParameter};
	table.insert(OneHitWonder_ActionQueue, entry);
end

function OneHitWonder_RemoveActionFromQueue(actionId, actionParameter)
	local entry = table.remove(OneHitWonder_ActionQueue);
	return entry[1], entry[2];
end

-- /script PrintTable(OneHitWonder_ActionQueue);
function OneHitWonder_GetTimeRemaining(spellId, spellBook)
	spellBook = OneHitWonder_GetSpellBook(spellBook);
	local start, duration, enable = GetSpellCooldown(spellId, spellBook);
	if ( ( start > 0 ) and ( duration > 0 ) ) then
		return (( start + duration ) - GetTime());
	else
		return 0;
	end
end

function OneHitWonder_UseCountermeasures()
	if ( not OneHitWonder_IsEnabled() ) then return; end
	return OneHitWonder_HandleActionQueue();
end

function OneHitWonder_ShouldHandleActionQueue()
	local class = OneHitWonder_GetPlayerClass();
	local func = getglobal(format("OneHitWonder_ShouldHandleActionQueue_%s", class));
	if ( func ) then
		return func;
	else
		return true;
	end
end


function OneHitWonder_HandleActionQueue()
	if ( getn(OneHitWonder_ActionQueue) <= 0 ) then
		return false;
	end

	if ( not OneHitWonder_ShouldHandleActionQueue() ) then
		return false;
	end

	
	local actionId, actionParameter = OneHitWonder_RemoveActionFromQueue();
	
	if ( actionId == ONEHITWONDER_ACTIONID_SPELL ) then
		if ( OneHitWonder_CastSpell(actionParameter, ONEHITWONDER_BOOK_TYPE_SPELL ) ) then
			return true;
		else
			return false;
		end
	elseif ( actionId == ONEHITWONDER_ACTIONID_SPELL_TIMEOUT ) then
		local spellId = actionParameter[1];
		local timeout = actionParameter[2];
		if ( GetTime() >= timeout ) then
			return OneHitWonder_HandleActionQueue();
		else
			if ( OneHitWonder_IsSpellAvailable(spellId, ONEHITWONDER_BOOK_TYPE_SPELL) ) then
				if ( OneHitWonder_CastSpell(spellId, ONEHITWONDER_BOOK_TYPE_SPELL ) ) then
					return true;
				else
					return false;
				end
			else
				OneHitWonder_AddActionToQueue(actionId, actionParameter);
				local remainingTime = OneHitWonder_GetTimeRemaining(spellId, ONEHITWONDER_BOOK_TYPE_SPELL );
				if ( remainingTime <= 1 ) then
					return true;
				end
				return false;
			end
		end
	elseif ( actionId == ONEHITWONDER_ACTIONID_SPELL_BUFF ) then
		local unit = actionParameter[1];
		local timeout = actionParameter[2];
		if ( GetTime() >= timeout ) then
			return OneHitWonder_HandleActionQueue();
		else
			return OneHitWonder_BuffUnit(unit);
		end
	elseif ( actionId == ONEHITWONDER_ACTIONID_SPELL_DEBUFF ) then
		local unit = actionParameter[1];
		local timeout = actionParameter[2];
		if ( GetTime() >= timeout ) then
			return OneHitWonder_HandleActionQueue();
		else
			return OneHitWonder_DebuffUnit(unit);
		end
	else
		return false;
	end
end

function OneHitWonder_ClearTooltipStrings(tooltipName)
	local tooltip = getglobal(tooltipName);
	if ( tooltip ) then
		local textObj = nil;
		for i = 1, 15 do
			textObj = getglobal(tooltipName.."TextLeft"..i);
			if ( textObj ) then
				textObj:SetText("");
			end
			textObj = getglobal(tooltipName.."TextRight"..i);
			if ( textObj ) then
				textObj:SetText("");
			end
		end
	end
end
function OneHitWonder_GetTooltipStrings(tooltipName)
	local strings = {};
	local tooltip = getglobal(tooltipName);
	if ( tooltip ) then
		local textObj = nil;
		local textLeft = nil;
		local textRight = nil;
		for i = 1, 15 do
			strings[i] = {};
			textObj = getglobal(tooltipName.."TextLeft"..i);
			if ( textObj ) then
				textLeft = textObj:GetText();
			else
				textLeft = nil;
			end
			strings[i].left = textLeft;
			textObj = getglobal(tooltipName.."TextRight"..i);
			if ( textObj ) then
				textRight = textObj:GetText();
			else
				textRight = nil;
			end
			strings[i].right = textRight;
		end
	end
	return strings;
end

function OneHitWonder_GetItemTooltipInfo(bag, slot)
	local strings = nil;
	OneHitWonder_ClearTooltipStrings("OneHitWonderTooltip");
	if ( bag > -1 ) then
		OneHitWonderTooltip:SetBagItem(bag, slot);
		strings = OneHitWonder_GetTooltipStrings("OneHitWonderTooltip");
	else
		local hasItem, hasCooldown = OneHitWonderTooltip:SetInventoryItem("player", slot);
		strings = OneHitWonder_GetTooltipStrings("OneHitWonderTooltip");
		if ( not hasItem) then
			OneHitWonder_ClearTooltipStrings("OneHitWonderTooltip");
			if ( strings[1] ) then
				strings[1].left = "";
			end
		end
	end
	return strings;
end


-- Shamelessly stolen from SarfEquip - and modded by sarf.
-- http://www.fukt.bth.se/~k/wow/scripts/SarfEquip/Interface/AddOns/SarfEquip/SarfEquip.lua
function OneHitWonder_GetItemName(bag, slot)
	local name = "";
	local strings = OneHitWonder_GetItemTooltipInfo(bag, slot);
	if ( strings[1] ) then
		name = strings[1].left;
	end
	return name;
end

function OneHitWonder_Init()
	OneHitWonder_UpdateSpellInfo();
	OneHitWonder_RetrieveAllActionIdInfo();

	OneHitWonder_SetupStuffContinously();
	OneHitWonder_SetupOverrideBinding();
end

function OneHitWonder_AfterInit()
	if ( Cosmos_ScheduleByName ) then
		Cosmos_ScheduleByName("OHW_AI", 5, OneHitWonder_Init);
	end
end

function OneHitWonder_OnLoad()
	
	if ( ( DynamicData ) and ( DynamicData.item ) and ( DynamicData.item.addOnInventoryUpdateHandler ) ) then
		DynamicData.item.addOnInventoryUpdateHandler(OneHitWonder_Bag_Update);
	end
	
	OneHitWonder_TimeSpellStopped = GetTime();
	
	if ( Cosmos_AfterInit ) then
		Cosmos_AfterInit(OneHitWonder_AfterInit);
		-- TODO: add standalone OnUpdate code?
	end

	for k, v in ONEHITWONDER_QUEUE_INTERRUPT_SPELL_CHAT_TYPES do
		this:RegisterEvent("CHAT_MSG_"..v);
	end

	for k, v in ONEHITWONDER_QUEUE_INTERRUPT_SPELL_DODGEPARRYBLOCK_TYPES do
		this:RegisterEvent("CHAT_MSG_"..v);
	end
	
	this:RegisterEvent("PET_ATTACK_START");
	this:RegisterEvent("PET_ATTACK_STOP");
	this:RegisterEvent("PET_BAR_HIDEGRID");
	this:RegisterEvent("PET_BAR_SHOWGRID");
	this:RegisterEvent("UNIT_HEALTH");
	this:RegisterEvent("PLAYER_TARGET_CHANGED");
	this:RegisterEvent("CHARACTER_POINTS_CHANGED");
	this:RegisterEvent("ACTIONBAR_SLOT_CHANGED");
	this:RegisterEvent("LEARNED_SPELL_IN_TAB");
	this:RegisterEvent("SPELLS_CHANGED");
	this:RegisterEvent("VARIABLES_LOADED");
	
	this:RegisterEvent("PARTY_MEMBERS_CHANGED");
	this:RegisterEvent("PARTY_MEMBER_ENABLE");
	this:RegisterEvent("PARTY_MEMBER_DISABLE");

	this:RegisterEvent("PLAYER_PET_CHANGED");


	this:RegisterEvent("SPELLCAST_CHANNEL_START");
	--this:RegisterEvent("SPELLCAST_CHANNEL_UPDATE");
	this:RegisterEvent("SPELLCAST_DELAYED");
	this:RegisterEvent("SPELLCAST_FAILED");
	this:RegisterEvent("SPELLCAST_INTERRUPTED");
	this:RegisterEvent("SPELLCAST_START");
	this:RegisterEvent("SPELLCAST_STOP");

	RegisterForSave("OneHitWonder_OnlyShowCurrentClassSettings");

end

function OneHitWonder_SetShouldKeepBuffsUp(toggle)
	if ( OneHitWonder_ShouldKeepBuffsUp ~= toggle ) then
		OneHitWonder_ShouldKeepBuffsUp = toggle;
		OneHitWonder_SetupStuffContinously();
	end
end

function OneHitWonder_SetShouldKeepBuffsUpParty(toggle)
	if ( OneHitWonder_ShouldKeepBuffsUpParty ~= toggle ) then
		OneHitWonder_ShouldKeepBuffsUpParty = toggle;
		OneHitWonder_SetupStuffContinously();
	end
end


function OneHitWonder_AddStuffToCosmos()
	if ( Cosmos_RegisterConfiguration ) then
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER",
			"SECTION",
			TEXT(ONEHITWONDER_CONFIG_HEADER),
			TEXT(ONEHITWONDER_CONFIG_HEADER_INFO)
		);
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_HEADER",
			"SEPARATOR",
			TEXT(ONEHITWONDER_CONFIG_HEADER),
			TEXT(ONEHITWONDER_CONFIG_HEADER_INFO)
		);
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_ENABLED",
			"CHECKBOX",
			TEXT(ONEHITWONDER_ENABLED),
			TEXT(ONEHITWONDER_ENABLED_INFO),
			OneHitWonder_SetEnabled,
			OneHitWonder_Enabled
		);
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_KEEP_UP_BUFFS",
			"CHECKBOX",
			TEXT(ONEHITWONDER_KEEP_UP_BUFFS),
			TEXT(ONEHITWONDER_KEEP_UP_BUFFS_INFO),
			OneHitWonder_SetShouldKeepBuffsUp,
			OneHitWonder_ShouldKeepBuffsUp
		);
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_KEEP_UP_BUFFS_PARTY",
			"CHECKBOX",
			TEXT(ONEHITWONDER_KEEP_UP_BUFFS_PARTY),
			TEXT(ONEHITWONDER_KEEP_UP_BUFFS_PARTY_INFO),
			OneHitWonder_SetShouldKeepBuffsUpParty,
			OneHitWonder_ShouldKeepBuffsUpParty
		);

		if ( OneHitWonder_OnlyShowCurrentClassSettings == 1 ) then
			--(ugly hack)
			func = getglobal(format("OneHitWonder_%s_Cosmos", OneHitWonder_GetPlayerClass()));
			if ( func ) then
				func();
			end
		else
			OneHitWonder_Druid_Cosmos();
			OneHitWonder_Hunter_Cosmos();
			OneHitWonder_Mage_Cosmos();
			OneHitWonder_Paladin_Cosmos();
			OneHitWonder_Priest_Cosmos();
			OneHitWonder_Rogue_Cosmos();
			OneHitWonder_Shaman_Cosmos();
			OneHitWonder_Warlock_Cosmos();
			OneHitWonder_Warrior_Cosmos();
		end
	end
end

function OneHitWonder_OnEvent(event)
	OneHitWonder_RandomEventStuff();
	if ( event == "VARIABLES_LOADED" ) then
		if ( ( OneHitWonder_OnlyShowCurrentClassSettings == 1 ) and ( Cosmos_AfterInit ) ) then
			Cosmos_AfterInit(OneHitWonder_AddStuffToCosmos);
		else
			OneHitWonder_AddStuffToCosmos();
		end
		return;
	end
	if ( ( event == "LEARNED_SPELL_IN_TAB" ) or ( event == "SPELLS_CHANGED" ) ) then
		OneHitWonder_UpdateSpellInfo();
		OneHitWonder_SetupStuffContinously();
	end
	if ( event == "ACTIONBAR_SLOT_CHANGED" ) then
		OneHitWonder_UpdateActionIdInfo(arg1);
		return;
	end
	if ( event == "PLAYER_TARGET_CHANGED" ) then
		OneHitWonder_Attacking = false;
		TargetFrame.attemptsToBackstab = 0;
		TargetFrame.hasBeenPickPocketed = false;
		TargetFrame.isBeingSoulDrained = false;
		OneHitWonder_CursedTargetTime = 0;
		OneHitWonder_CurrentCurseTime = 0;
		OneHitWonder_LastCurse = nil;
		return;
	end
	if ( event == "CHARACTER_POINTS_CHANGED" ) then
		if ( OneHitWonder_GetPlayerClass() == ONEHITWONDER_CLASS_ROGUE ) then
			OneHitWonder_UpdateRageConsumptionWithTalents("ONEHITWONDER_ABILITY_ENERGYCOST", ONEHITWONDER_ROGUE_TALENT_ENERGY_REDUCERS);
		elseif ( OneHitWonder_GetPlayerClass() == ONEHITWONDER_CLASS_WARRIOR ) then
			OneHitWonder_UpdateRageConsumptionWithTalents("ONEHITWONDER_ABILITY_RAGECOST", ONEHITWONDER_WARRIOR_TALENT_RAGE_REDUCERS);
		end
		return;
	end
	if ( event == "UNIT_HEALTH" ) then
		if ( arg1 == "player" ) then
			local curTime = GetTime();
			if ( ( curTime - OneHitWonder_UnitHealthLastCalled ) > ONEHITWONDER_HEALTH_UPDATE_DELAY ) then
				OneHitWonder_UnitHealthCheck();
				OneHitWonder_UnitHealthLastCalled = curTime;
			end
		end
		return;
	end
	-- effects
	if ( event == "PARTY_MEMBER_ENABLE" or event == "PARTY_MEMBER_DISABLE" ) then
		local unit = arg1;
		if ( strfind(unit, "party") ) then
			OneHitWonder_CurrentAuras[unit] = {};
			if ( UnitExists(unit) ) then
				OneHitWonder_CheckEffect(unit);
			end
		end
		OneHitWonder_SetupStuffContinously();
		return;
	end
	if ( event == "PARTY_MEMBERS_CHANGED" ) then
		local unit = "party";
		for i = 1, 4 do
			unit = "party"..i;
			OneHitWonder_CurrentAuras[unit] = {};
			if ( UnitExists(unit) ) then
				OneHitWonder_CheckEffect(unit);
			end
		end
		OneHitWonder_SetupStuffContinously();
		return;
	end
	if ( event == "PLAYER_PET_CHANGED" ) then
		local unit = "pet";
		OneHitWonder_CurrentAuras[unit] = {};
		if ( UnitExists(unit) ) then
			OneHitWonder_CheckEffect(unit);
		end
	end	
	-- chat
	
	if ( strfind(event, "CHAT_MSG") ) then
		OneHitWonder_Chat_OnEvent(event);
	end

	if ( event == "PET_ATTACK_START" ) then
		OneHitWonder_PetIsAttacking = true;
	end
	
	if ( event == "PET_ATTACK_STOP" or event == "PET_BAR_HIDEGRID" or event == "PET_BAR_SHOWGRID" ) then
		OneHitWonder_PetIsAttacking = false;
	end

	--[[		
	if (strfind(event, "SPELLCAST_START")) then
		OneHitWonder_TimeSpellStarted = GetTime();
		OneHitWonder_Print("OneHitWonder_TimeSpellStarted="..OneHitWonder_TimeSpellStarted);
	end
	]]--
	
	if (event == "PLAYER_DEAD") then
		OneHitWonder_Warlock_SpellEnded();
		OneHitWonder_ChannelSpellRunning = false;
		OneHitWonder_RegularSpellRunning = false;
		OneHitWonder_TimeSpellStopped = GetTime();
	end

	if (event == "SPELLCAST_STOP") then
		OneHitWonder_Warlock_SpellEnded();
		OneHitWonder_ChannelSpellRunning = false;
		OneHitWonder_RegularSpellRunning = false;
		OneHitWonder_TimeSpellStopped = GetTime();	
	end
	if (event == "SPELLCAST_START") then
		OneHitWonder_RegularSpellRunning = true;	
	end
	if (event == "SPELLCAST_CHANNEL_START") then
		OneHitWonder_ChannelSpellRunning = true;		
	end
	if (event == "SPELLCAST_INTERRUPTED" or event == "SPELLCAST_FAILED") then
		OneHitWonder_Warlock_SpellEnded();
		OneHitWonder_RegularSpellRunning = false;
		OneHitWonder_ChannelSpellRunning = false;	
	end	
	if ( event == "UNIT_AURA" ) then
		local unit = arg1;
		OneHitWonder_CurrentAuras[unit] = {};
		if ( UnitExists(unit) ) then
			OneHitWonder_CheckEffect(unit);
		end
		return;
	end
end

function OneHitWonder_GetItemInfo(itemName)
	return OneHitWonder_Items[itemName];
end

function OneHitWonder_Bag_Update(bag)
	if ( OneHitWonder_GetPlayerClass() == ONEHITWONDER_CLASS_WARLOCK ) then
		OneHitWonder_Warlock_CountShards();
	end
end

-- should translate external names to internal OHW names
function OneHitWonder_TranslatePlayerRace(class)
	local translated = OneHitWonder_Translations_Race[class];
	if ( translated ) then
		return translated;
	end
	return class;
end

-- should translate external names to internal OHW names
function OneHitWonder_TranslatePlayerClass(class)
	local translated = OneHitWonder_Translations_Class[class];
	if ( translated ) then
		return translated;
	end
	return class;
end

function OneHitWonder_GetPlayerClass()
	if ( not OneHitWonder_PlayerClass ) then
		OneHitWonder_PlayerClass = UnitClass("player");
		if ( OneHitWonder_PlayerClass ) then
			local tmp = strlower(OneHitWonder_PlayerClass);
			if ( ( strfind(tmp, "being") ) and ( ( strfind(tmp, "uknown") ) or ( strfind(tmp, "unknown") ) ) ) then
				tmp = OneHitWonder_PlayerClass;
				OneHitWonder_PlayerClass = nil;
				return tmp;
			elseif ( ( tmp ) and ( strlen(tmp) > 0 ) ) then
				OneHitWonder_PlayerClass = OneHitWonder_TranslatePlayerClass(OneHitWonder_PlayerClass);
			end
		end
	end
	return OneHitWonder_PlayerClass;
end

function OneHitWonder_GetPlayerRace()
	if ( not OneHitWonder_PlayerRace ) then
		OneHitWonder_PlayerRace = UnitRace("player");
		if ( OneHitWonder_PlayerRace ) then
			local tmp = strlower(OneHitWonder_PlayerRace);
			if ( ( strfind(tmp, "being") ) and ( ( strfind(tmp, "uknown") ) or ( strfind(tmp, "unknown") ) ) ) then
				tmp = OneHitWonder_PlayerRace;
				OneHitWonder_PlayerRace = nil;
				return tmp;
			elseif ( ( tmp ) and ( strlen(tmp) > 0 ) ) then
				OneHitWonder_PlayerRace = OneHitWonder_TranslatePlayerRace(OneHitWonder_PlayerRace);
			end
		end
	end
	return OneHitWonder_PlayerRace;
end

function OneHitWonder_UnitHealthCheck()
	local class = OneHitWonder_GetPlayerClass();
	local hp = UnitHealth("player");
	local maxHP = UnitHealthMax("player");
	local spellId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_BERSERK_NAME);
	if ( ( spellId > -1 ) and ( OneHitWonder_IsSpellAvailable(spellId) ) ) then
		OneHitWonder_AddActionToQueue(ONEHITWONDER_ACTIONID_SPELL_TIMEOUT, { spellId, ( GetTime() + 2) }  );
	end
	if ( class == ONEHITWONDER_CLASS_MAGE ) then
		OneHitWonder_Mage_UnitHealthCheck();
	end
end

function OneHitWonder_RandomEventStuff()
	local spellId = OneHitWonder_GetSpellId(ONEHITWONDER_TALENT_RIPOSTE_NAME);
	if ( ( spellId > -1 ) and ( OneHitWonder_IsSpellAvailable(spellId) ) ) then
		OneHitWonder_AddActionToQueue(ONEHITWONDER_ACTIONID_SPELL_TIMEOUT, { spellId, ( GetTime() + 2) }  );
	end
end

function OneHitWonder_UpdateRageConsumptionWithTalents(costTableName, reducerTable)
	local costTable = getglobal(costTableName);
	local name, iconTexture, tier, column, rank, maxRank, isExceptional, meetsPrereq;
	local talentTable;
	local abilityName;
	local newCostTable;
	for k, v in reducerTable do
		talentTable = v[1];
		abilityName = v[2];
		newCostTable = v[3];
		name, iconTexture, tier, column, rank, maxRank = GetTalentInfo(talentTable[1], talentTable[2]);
		if ( ( rank > 0 ) and ( rank <= getn(newCostTable) ) ) then
			costTable[abilityName] = newCostTable[rank];
		end
	end
end

--OneHitWonder_Debug = true;

function OneHitWonder_DebugPrint(msg)
	if ( OneHitWonder_Debug ) then
		OneHitWonder_Print(msg, 1.0, 0.3, 0.3);
	end
end

-- Prints out text to a chat box.
function OneHitWonder_Print(msg,r,g,b,frame,id,unknown4th)
	if(unknown4th) then
		local temp = id;
		id = unknown4th;
		unknown4th = id;
	end
				
	if (not r) then r = 1.0; end
	if (not g) then g = 1.0; end
	if (not b) then b = 1.0; end
	if ( frame ) then 
		frame:AddMessage(msg,r,g,b,id,unknown4th);
	else
		if ( DEFAULT_CHAT_FRAME ) then 
			DEFAULT_CHAT_FRAME:AddMessage(msg, r, g, b,id,unknown4th);
		end
	end
end


function OneHitWonder_GetTimeLeft(buffTexture)
	local timeLeft, texture;
	local buffIndex, untilCancelled;
	for i = 0, MAX_PARTY_TOOLTIP_BUFFS do
		buffIndex, untilCancelled = GetPlayerBuff(i, "HELPFUL|PASSIVE");
		if ( buffIndex < 0 ) then
			return 0;
		end
		texture = GetPlayerBuffTexture(buffIndex);
		if ( texture == buffTexture ) then
			timeLeft = GetPlayerBuffTimeLeft(buffIndex);
			return timeLeft;
		end
	end
	return 0;
end

function OneHitWonder_ShouldCast(buffTexture, minimalTimeLeft)
	if ( not minimalTimeLeft ) then
		minimalTimeLeft = 0;
	end
	local timeLeft = OneHitWonder_GetTimeLeft(buffTexture);
	if ( minimalTimeLeft > 0 ) then
		timeLeft = GetPlayerBuffTimeLeft(buffIndex);
		if ( timeLeft < minimalTimeLeft ) then
			return true;
		else
			return false;
		end
	else
		return false;
	end
	return true;
end

OneHitWonder_Warrior_BattleShoutRageReservation = 0;
OneHitWonder_Warrior_BattleShoutStartRageReservation = 30;

function OneHitWonder_Warrior_BattleShoutRefresh()
	local timeLeft = OneHitWonder_GetTimeLeft(ONEHITWONDER_ABILITY_BATTLESHOUT_TEXTURE);
	OneHitWonder_RageReservation = OneHitWonder_RageReservation - OneHitWonder_Warrior_BattleShoutRageReservation;
	OneHitWonder_Warrior_BattleShoutRageReservation = 0;
	if ( timeLeft < OneHitWonder_Warrior_BattleShoutStartRageReservation ) then
		if ( OneHitWonder_HasEnoughRage(ONEHITWONDER_ABILITY_BATTLESHOUT_NAME, true) ) then
			local spellId = 0;
			spellId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_BATTLESHOUT_NAME);
			OneHitWonder_DebugPrint(format("Battleshout id = %d", spellId));
			if ( OneHitWonder_CastSpell(spellId, ONEHITWONDER_BOOK_TYPE_SPELL) ) then
				return true;
			end
		else
			OneHitWonder_DebugPrint("Not enough rage for BattleShout");
			OneHitWonder_DebugPrint("Allocating rage for BattleShout");
			OneHitWonder_Warrior_BattleShoutRageReservation = OneHitWonder_Warrior_BattleShoutStartRageReservation - timeLeft;
			local maxRageReserved = OneHitWonder_GetRageConsumption(ONEHITWONDER_ABILITY_BATTLESHOUT_NAME);
			if ( OneHitWonder_Warrior_BattleShoutRageReservation > maxRageReserved) then
				OneHitWonder_Warrior_BattleShoutRageReservation = maxRageReserved;
			end
			OneHitWonder_RageReservation = OneHitWonder_RageReservation + OneHitWonder_Warrior_BattleShoutRageReservation;
		end
	end
	return false;
end

function OneHitWonder_GiveMeWonder(removeDefense)
	if ( not OneHitWonder_IsEnabled() ) then return; end
	local class = OneHitWonder_GetPlayerClass();
	if ( class == ONEHITWONDER_CLASS_DRUID ) then
		OneHitWonder_Druid(removeDefense);
	elseif ( class == ONEHITWONDER_CLASS_HUNTER ) then
		OneHitWonder_Hunter(removeDefense);
	elseif ( class == ONEHITWONDER_CLASS_MAGE ) then
		OneHitWonder_Mage(removeDefense);
	elseif ( class == ONEHITWONDER_CLASS_PALADIN ) then
		OneHitWonder_Paladin(removeDefense);
	elseif ( class == ONEHITWONDER_CLASS_PRIEST ) then
		OneHitWonder_Priest(removeDefense);
	elseif ( class == ONEHITWONDER_CLASS_ROGUE ) then
		OneHitWonder_Rogue(removeDefense);
	elseif ( class == ONEHITWONDER_CLASS_SHAMAN ) then
		OneHitWonder_Shaman(removeDefense);
	elseif ( class == ONEHITWONDER_CLASS_WARLOCK ) then
		OneHitWonder_Warlock(removeDefense);
	elseif ( class == ONEHITWONDER_CLASS_WARRIOR ) then
		OneHitWonder_Warrior(removeDefense);
	else
		if ( not OneHitWonder_UseCountermeasures() ) then
			OneHitWonder_DoBuffs();
		end
		if ( not OneHitWonder_NoWonder ) then
			OneHitWonder_Print("Sorry, no wonder for you yet.");
			OneHitWonder_NoWonder = true;
		end
	end
end


OneHitWonder_Override_Binding_Pointers = {
	"MoveForwardStart",
	"MoveForwardStop",
	"MoveBackwardStart",
	"MoveBackwardStop",
	"TurnLeftStart",
	"TurnLeftStop",
	"TurnRightStart",
	"TurnRightStop",
	"StrafeLeftStart",
	"StrafeLeftStop",
	"StrafeRightStart",
	"StrafeRightStop",
	"ActionButtonDown",
	"ActionButtonUp",
	"BonusActionButtonDown",
	"BonusActionButtonUp",
	"CameraOrSelectOrMoveStart",
	"CameraOrSelectOrMoveStop",
	"TurnOrActionStart",
	"TurnOrActionStop"
};
OneHitWonder_Saved_Binding_Pointers = {};
-- /script OneHitWonder_SetupStuffContinously(); OneHitWonder_SetupOverrideBinding();
function OneHitWonder_SetupOverrideBinding()
	for k, v in OneHitWonder_Override_Binding_Pointers do
		if ( not OneHitWonder_Saved_Binding_Pointers[v] ) then
			OneHitWonder_Saved_Binding_Pointers[v] = getglobal(v);
			setglobal(v, getglobal("OneHitWonder_"..v));
		end
	end
end

function OneHitWonder_MoveForwardStart(...)
	OneHitWonder_Saved_Binding_Pointers["MoveForwardStart"](unpack(arg));
	OneHitWonder_DoStuffContinously();
end

function OneHitWonder_MoveForwardStop(...)
	OneHitWonder_Saved_Binding_Pointers["MoveForwardStop"](unpack(arg));
	OneHitWonder_DoStuffContinously();
end

function OneHitWonder_MoveBackwardStart(...)
	OneHitWonder_Saved_Binding_Pointers["MoveBackwardStart"](unpack(arg));
	OneHitWonder_DoStuffContinously();
end

function OneHitWonder_MoveBackwardStop(...)
	OneHitWonder_Saved_Binding_Pointers["MoveBackwardStop"](unpack(arg));
	OneHitWonder_DoStuffContinously();
end

function OneHitWonder_TurnLeftStart(...)
	OneHitWonder_Saved_Binding_Pointers["TurnLeftStart"](unpack(arg));
	OneHitWonder_DoStuffContinously();
end

function OneHitWonder_TurnLeftStop(...)
	OneHitWonder_Saved_Binding_Pointers["TurnLeftStop"](unpack(arg));
	OneHitWonder_DoStuffContinously();
end

function OneHitWonder_TurnRightStart(...)
	OneHitWonder_Saved_Binding_Pointers["TurnRightStart"](unpack(arg));
	OneHitWonder_DoStuffContinously();
end

function OneHitWonder_TurnRightStop(...)
	OneHitWonder_Saved_Binding_Pointers["TurnRightStop"](unpack(arg));
	OneHitWonder_DoStuffContinously();
end

function OneHitWonder_StrafeLeftStart(...)
	OneHitWonder_Saved_Binding_Pointers["StrafeLeftStart"](unpack(arg));
	OneHitWonder_DoStuffContinously();
end

function OneHitWonder_StrafeLeftStop(...)
	OneHitWonder_Saved_Binding_Pointers["StrafeLeftStop"](unpack(arg));
	OneHitWonder_DoStuffContinously();
end

function OneHitWonder_StrafeRightStart(...)
	OneHitWonder_Saved_Binding_Pointers["StrafeRightStart"](unpack(arg));
	OneHitWonder_DoStuffContinously();
end

function OneHitWonder_StrafeRightStop(...)
	OneHitWonder_Saved_Binding_Pointers["StrafeRightStop"](unpack(arg));
	OneHitWonder_DoStuffContinously();
end

function OneHitWonder_ActionButtonDown(...)
	OneHitWonder_Saved_Binding_Pointers["ActionButtonDown"](unpack(arg));
	OneHitWonder_DoStuffContinously();
end

function OneHitWonder_ActionButtonUp(...)
	OneHitWonder_Saved_Binding_Pointers["ActionButtonUp"](unpack(arg));
	OneHitWonder_DoStuffContinously();
end

function OneHitWonder_BonusActionButtonDown(...)
	OneHitWonder_Saved_Binding_Pointers["BonusActionButtonDown"](unpack(arg));
	OneHitWonder_DoStuffContinously();
end

function OneHitWonder_BonusActionButtonUp(...)
	OneHitWonder_Saved_Binding_Pointers["BonusActionButtonUp"](unpack(arg));
	OneHitWonder_DoStuffContinously();
end

function OneHitWonder_CameraOrSelectOrMoveStart(...)
	OneHitWonder_Saved_Binding_Pointers["CameraOrSelectOrMoveStart"](unpack(arg));
	OneHitWonder_DoStuffContinously();
end

function OneHitWonder_CameraOrSelectOrMoveStop(...)
	OneHitWonder_Saved_Binding_Pointers["CameraOrSelectOrMoveStop"](unpack(arg));
	OneHitWonder_DoStuffContinously();
end

function OneHitWonder_TurnOrActionStart(...)
	OneHitWonder_Saved_Binding_Pointers["TurnOrActionStart"](unpack(arg));
	OneHitWonder_DoStuffContinously();
end

function OneHitWonder_TurnOrActionStop(...)
	OneHitWonder_Saved_Binding_Pointers["TurnOrActionStop"](unpack(arg));
	OneHitWonder_DoStuffContinously();
end

OneHitWonder_ActionIdInfo = {};

OneHitWonder_SpellIdInfo = {};

function OneHitWonder_GetNumberOfSpellsInSpellBook(spellBook)
	local name, rankName;
	local i = 1;
	name, rankName = GetSpellName(i, spellBook)
	while ( name ) do
		i = i + 1;
		name, rankName = GetSpellName(i, spellBook)
	end
	return i - 1;
end

function OneHitWonder_UpdateSpellBookInfo(spellBook)
	local ok = true;
	local index = 1;
	OneHitWonder_SpellIdInfo[spellBook] = {};
	local strings = {};

	local numberOfSpells = OneHitWonder_GetNumberOfSpellsInSpellBook(spellBook);
	
	for index = 1, numberOfSpells do
		OneHitWonder_SpellIdInfo[spellBook][index] = OneHitWonder_GetSpellIdInfo(index, spellBook);
	end
end

function OneHitWonder_UpdateSpellInfo()
	OneHitWonder_UpdateSpellBookInfo("spell");
	OneHitWonder_UpdateSpellBookInfo("pet");
end



function OneHitWonder_RetrieveAllActionIdInfo()
	local strings = nil;
	for i = 1, ONEHITWONDER_MAXIMUM_NUMBER_OF_ACTION_IDS do
		OneHitWonder_ActionIdInfo[i] = OneHitWonder_GetActionIdInfo(i);
	end
end

function OneHitWonder_UpdateActionIdInfo(id)
	if ( id <= 0 ) then
		OneHitWonder_RetrieveAllActionIdInfo();
	else
		OneHitWonder_ActionIdInfo[id] = OneHitWonder_GetActionIdInfo(id);
	end
end

function OneHitWonder_GetActionIdFromSpellId(spellId, spellBook, doNotUseCache)
	if ( ( not spellId ) or ( spellId == -1 ) ) then return -1; end
	local name, rank = GetSpellName(spellId, OneHitWonder_GetSpellBook(spellBook));
	if ( not name ) then
		return -1;
	end
	
	local strings = nil;
	for i = 1, ONEHITWONDER_MAXIMUM_NUMBER_OF_ACTION_IDS do
		if ( doNotUseCache ) then
			strings = OneHitWonder_GetActionIdInfo(i);
		else
			strings = OneHitWonder_ActionIdInfo[i];
		end
		if ( ( strings ) and ( (getn(strings) >= 1) and ( name == strings[1].left ) ) 
			and ( ( not rank ) or ( (getn(strings) >= 2) and ( rank == strings[2].left ) ) ) ) then
			return i;
		end
	end
	return -1;
end

function OneHitWonder_AddStuffContinously(pBuffName, pOnlySelf, pIsBuff, options)
	local element = {};
	if ( not pOnlySelf ) then
		pOnlySelf = false;
	elseif ( pOnlySelf == 1 ) then
		pOnlySelf = true;
	elseif ( pOnlySelf == "yes" ) then
		pOnlySelf = true;
	elseif ( pOnlySelf == "no" ) then
		pOnlySelf = false;
	end
	element.buffName = pBuffName;
	element.onlySelf = pOnlySelf;
	element.isBuff = pIsBuff;
	if ( options ) then
		for k, v in options do
			element[k] = v;
		end
	end
	tinsert(OneHitWonder_BuffsToKeepUp, element);
end

function OneHitWonder_GetHighestBuffName(buffNames, doNotUseCache)
	local highestBuffName = nil;
	local buffId = nil;
	for k, v in buffNames do
		buffId = OneHitWonder_GetSpellId(v, nil, nil, doNotUseCache);
		if ( buffId > -1 ) then
			highestBuffName = v;
		end
	end
	return highestBuffName;
end

OneHitWonder_ManaClassesArray = {
	ONEHITWONDER_CLASS_HUNTER, ONEHITWONDER_CLASS_MAGE, ONEHITWONDER_CLASS_WARLOCK, 
	ONEHITWONDER_CLASS_PALADIN, ONEHITWONDER_CLASS_PRIEST, ONEHITWONDER_CLASS_SHAMAN 
};

OneHitWonder_HealerClassesArray = {
	ONEHITWONDER_CLASS_DRUID,
	ONEHITWONDER_CLASS_PALADIN, 
	ONEHITWONDER_CLASS_PRIEST, 
	ONEHITWONDER_CLASS_SHAMAN
};

OneHitWonder_MeleeClassesArray = {
	ONEHITWONDER_CLASS_PALADIN, 
	ONEHITWONDER_CLASS_ROGUE,
	ONEHITWONDER_CLASS_WARRIOR
};

OneHitWonder_RangedClassesArray = {
	ONEHITWONDER_CLASS_HUNTER 
};

OneHitWonder_CasterClassesArray = {
	ONEHITWONDER_CLASS_HUNTER, ONEHITWONDER_CLASS_MAGE, 
	ONEHITWONDER_CLASS_WARLOCK, ONEHITWONDER_CLASS_PRIEST, 
	ONEHITWONDER_CLASS_SHAMAN
};
OneHitWonder_FighterClassesArray =  {
	ONEHITWONDER_CLASS_WARRIOR, ONEHITWONDER_CLASS_ROGUE, 
	ONEHITWONDER_CLASS_PALADIN
};

ONEHITWONDER_POWERTYPE_MANA = 0;
ONEHITWONDER_POWERTYPE_RAGE = 1;
ONEHITWONDER_POWERTYPE_FOCUS = 2;
ONEHITWONDER_POWERTYPE_ENERGY = 3;
ONEHITWONDER_POWERTYPE_HAPPINESS = 4;

-- will be called when the spells of player or group changes
function OneHitWonder_SetupStuffContinously()
	local setup = false;
	OneHitWonder_BuffsToKeepUp = {};
	local currentClass = OneHitWonder_GetPlayerClass();
	if ( ( OneHitWonder_ShouldKeepBuffsUp == 0 ) or ( not OneHitWonder_ShouldKeepBuffsUp ) ) then
	elseif ( currentClass == ONEHITWONDER_CLASS_MAGE ) then
		setup = true;
		OneHitWonder_SetupStuffContinously_Mage();
	elseif ( currentClass == ONEHITWONDER_CLASS_DRUID ) then
		setup = true;
		OneHitWonder_SetupStuffContinously_Druid();
	elseif ( currentClass == ONEHITWONDER_CLASS_PALADIN ) then
		setup = true;
		OneHitWonder_SetupStuffContinously_Paladin();
	elseif ( currentClass == ONEHITWONDER_CLASS_PRIEST ) then
		setup = true;
		OneHitWonder_SetupStuffContinously_Priest();
	elseif ( currentClass == ONEHITWONDER_CLASS_SHAMAN ) then
		setup = true;
		OneHitWonder_SetupStuffContinously_Shaman();
	elseif ( currentClass == ONEHITWONDER_CLASS_WARLOCK ) then
		setup = true;
		OneHitWonder_SetupStuffContinously_Warlock();
	end
	if ( ( setup ) and ( not OneHitWonder_ContBuffSetup) ) then
		OneHitWonder_ContBuffSetup = true;
		OneHitWonder_Print("Continous Buffs setup for "..currentClass, 1.0, 1.0, 0);
	end
end

function OneHitWonder_IsItOkayToCastSpell(buffData)
	local hasTarget = true;
	local targetName = UnitName("target");
	if ( ( not targetName ) or ( strlen(targetName) <= 0 ) ) then
		hasTarget = false;
	end
	local isDead = OneHitWonder_IsPlayerDead();
	local isOnTaxi = UnitOnTaxi("player");
	
	local isOkay = false;

	local buffId = -1;
	if ( type(buffData.buffName) == "table") then
		for k, v in buffData.buffName do
			buffId = OneHitWonder_GetSpellId(v);
			if ( buffId > -1 ) then
				break;
			end
		end
	else
		buffId = OneHitWonder_GetSpellId(buffData.buffName);
	end
	if ( buffId <= -1 ) then
		return false;
	end
	local actionId = OneHitWonder_GetActionIdFromSpellId(buffId);
	
	--Print(format("%s %d %d", buffData.buffName, buffId, actionId));

	
	local timeSinceLastBuff = GetTime() - OneHitWonder_LastBuffed;

	if ( ( not isDead) and ( not isOnTaxi ) and (
		( ( buffData.onlySelf) or ( not hasTarget ) or ( actionId > -1 ) ) or 
			( 
				( buffData.needsTarget ) and ( ( hasTarget ) or ( actionId > -1 ) ) and 
				( ( not buffData.needsHostileTarget ) or ( UnitCanAttack("player", "target") ) ) 
			) 
		) 
		and (
		( ( buffData.useAtAnyMana) or ( ( UnitMana("player") >= UnitManaMax("player") ) or (timeSinceLastBuff <= ONEHITWONDER_MAXIMUM_TIME_SINCE_LAST_BUFF)) )
		and ( ( not buffData.isBuff ) or ( not OneHitWonder_HasPlayerEffect(nil, buffData.buffName) ) )
		)
		) then
		isOkay = true;
	end
	return isOkay;
end

function OneHitWonder_DoHunterStuffContinously()
	if ( not OneHitWonder_IsEnabled() ) then return false; end
	local hasAnyAspect = false;
	local aspectName, aspectNameLower;
	local buffIndex, untilCancelled;
	local texture, name, isActive, isCastable;
	for i = 1, 10 do
		texture, aspectName, isActive, isCastable = GetShapeshiftFormInfo(i);
		aspectNameLower = strlower(buffName);
		if ( isActive ) then
			if ( strfind(aspectNameLower, "aspect") ) then
				hasAnyAspect = true;
				break;
			end
		end
	end
	if ( ( not hasAnyAspect ) and ( not OneHitWonder_IsPlayerDead() ) and ( not OneHitWonder_IsPlayerOnTaxi() ) ) then
		local aspectId = nil;
		for k, v in OneHitWonder_HunterAspects do
			aspectId = OneHitWonder_GetSpellId(v);
			if ( ( OneHitWonder_IsSpellAvailable(aspectId) ) and ( not OneHitWonder_HasPlayerEffect(nil, v) ) ) then
				OneHitWonder_CastSpell(aspectId);
				return true;
			end
		end
	end
	return false;
end

function OneHitWonder_DoPaladinStuffContinously()
	if ( not OneHitWonder_IsEnabled() ) then return false; end
	local hasAnyAura = false;
	local hasAnyBlessing = false;
	local buffIndex, untilCancelled;
	for i = 0, MAX_PARTY_TOOLTIP_BUFFS do
		buffIndex, untilCancelled = GetPlayerBuff(i, "HELPFUL|PASSIVE");
		if ( buffIndex >= 0 ) then
			buffName = OneHitWonder_GetBuffNameUsingBuffIndex("player", buffIndex);
			if ( strfind(buffName, ONEHITWONDER_SPELL_AURA_SUBSTRING) ) then
				hasAnyAura = true;
			end
			if ( strfind(buffName, ONEHITWONDER_SPELL_BLESSING_SUBSTRING) ) then
				hasAnyBlessing = true;
			end
		end
	end
	if ( ( not OneHitWonder_IsPlayerDead() ) and ( not OneHitWonder_IsPlayerOnTaxi() ) ) then
		if ( not hasAnyAura ) then
			local auraId = OneHitWonder_GetSpellId(ONEHITWONDER_SPELL_DEVOTION_AURA_NAME);
			if ( OneHitWonder_IsSpellAvailable(auraId) ) then
				OneHitWonder_CastSpell(auraId);
				--[[
				local castBuff, shouldQuit = OneHitWonder_CastBuff(ONEHITWONDER_SPELL_DEVOTION_AURA_NAME, nil, "player");
				if ( castBuff or shouldQuit ) then
					return true;
				end
				]]--
			end
		end
		if ( not hasAnyBlessing ) then
			local blessingId = OneHitWonder_GetSpellId(ONEHITWONDER_SPELL_BLESSING_OF_MIGHT_NAME);
			if ( OneHitWonder_IsSpellAvailable(blessingId) ) then
				local castBuff, shouldQuit = OneHitWonder_CastBuff(ONEHITWONDER_SPELL_BLESSING_OF_MIGHT_NAME, nil, "player");
				if ( castBuff or shouldQuit ) then
					return true;
				end
			end
		end
	end
	return false;
end

function OneHitWonder_IsPlayerDead()
	local isDead = OneHitWonder_HasPlayerEffect(nil, "Ghost");
	if ( ( not isDead ) and ( UnitIsDead("player") ) ) then
		isDead = true;
	end
	return isDead;
end

function OneHitWonder_IsPlayerOnTaxi()
	return UnitOnTaxi("player");
end

OneHitWonder_DoBuffsList = {"target", "party1", "party2", "party3", "party4"};
function OneHitWonder_DoBuffs()
	for k, v in OneHitWonder_DoBuffsList do
		if ( OneHitWonder_BuffUnit(v) ) then
			return true;
		end
	end
	return false;
end

function OneHitWonder_IsStringInList(param1, param2)
	local str = param1;
	local list = param2;
	if ( type(param1) == "table" ) then
		str = param2;
		list = param1;
	end
	for k, v in list do
		if ( v == str ) then
			return true;
		end
	end
	return false;
end

function OneHitWonder_CastBuff(castBuffName, v, unit, destroyTarget)
	local targetName = UnitName("target");
	local hasTarget = true;
	if ( ( not targetName ) or ( strlen(targetName) <= 0 ) ) then
		hasTarget = false;
	end
	local ok = true;
	local buffId = nil;
	local effectName = castBuffName;
	if ( ( v) and (  v.effectName ) ) then
		effectName = v.effectName;
	end
	if ( ( UnitIsDead(unit) ) or ( UnitCanAttack(unit, "player") ) ) then
		ok = false;
	elseif ( ( ( not v ) and ( not OneHitWonder_HasUnitEffect(unit, nil, effectName) ) )
		or ( ( v ) and ( not v.onlySelf ) and ( v.isBuff ) 
		and ( ( not OneHitWonder_HasUnitEffect(unit, nil, effectName) ) or ( v.canOverrideEffect ) ) ) ) then
		if ( v ) then
			if ( v.doNotBuffClass ) then
				local class = UnitClass(unit);
				if ( OneHitWonder_IsStringInList(class, v.doNotBuffClass) ) then
					ok = false;
				end
			end
			if ( v.onlyBuffClass ) then
				local class = UnitClass(unit);
				if ( not OneHitWonder_IsStringInList(class, v.onlyBuffClass) ) then
					ok = false;
				end
			end
			if ( v.validTarget ) then
				if ( not OneHitWonder_IsStringInList(unit, v.validTarget) ) then
					ok = false;
				end
			end
			if ( v.invalidTarget ) then
				if ( OneHitWonder_IsStringInList(unit, v.invalidTarget) ) then
					ok = false;
				end
			end
			if ( v.powerType ) then
				if ( not OneHitWonder_IsStringInList(UnitPowerType(unit), v.powerType) ) then
					ok = false;
				end
			end
			if ( v.notPowerType ) then
				if ( OneHitWonder_IsStringInList(UnitPowerType(unit), v.notPowerType) ) then
					ok = false;
				end
			end
		end
		buffId = OneHitWonder_GetSpellId(castBuffName);
		if ( not OneHitWonder_IsSpellAvailable(buffId) ) then
			ok = false;
		end
		if ( ( ok ) and ( hasTarget ) and ( unit ~= "target" ) and ( not UnitCanAttack("target", "player") ) ) then
			if ( not destroyTarget ) then
				ok = false;
			else
				if ( UnitName(unit) ~= targetName ) then
					TargetUnit(unit);
				end
			end
		end
		if ( ok ) then
			local buffName, buffRank = OneHitWonder_GetBuffName(UnitLevel(unit), castBuffName);
			buffId = OneHitWonder_GetSpellId(buffName, buffRank);
			if ( OneHitWonder_IsSpellAvailable(buffId) ) then
				if ( unit == "player" ) then
					local actionId = OneHitWonder_GetActionIdFromSpellId(buffId);
					if ( actionId > -1 ) then
						UseAction(actionId, 0, 1);
						return ok, true;
					end
				end
				OneHitWonder_CastSpell(buffId);
				if( SpellIsTargeting() ) then
					SpellTargetUnit(unit);
				end
				OneHitWonder_LastBuffed = GetTime();
				return ok, true;
			end
		end
	end
	return false, false;
end

function OneHitWonder_GetBuffName(unitLevel, buffName)
	local index = strfind(buffName, "%(");
	if ( index ) then
		buffName = strsub(buffName, index-1);
	end
	return OneHitWonder_GetAppropriateBuff(unitLevel, buffName);
end

OneHitWonder_RecentBuffees = {};

function OneHitWonder_CleanRecentBuffee()
	local curTime = GetTime();
	local removeIndices = {};
	for k, v in OneHitWonder_RecentBuffees do
		if ( v.time < curTime ) then
			table.insert(removeIndices, k);
		end
	end
	for k, v in removeIndices do
		table.remove(OneHitWonder_RecentBuffees, v);
	end
end

function OneHitWonder_GetRecentBuffee(buffeeName)
	OneHitWonder_CleanRecentBuffee();
	for k, v in OneHitWonder_RecentBuffees do
		if ( v.name == buffeeName ) then
			return v;
		end
	end
	return nil;
end

function OneHitWonder_IsRecentBuffee(buffeeName)
	if ( OneHitWonder_GetRecentBuffee(buffeeName) ) then
		return true;
	else
		return false;
	end
end

function OneHitWonder_AddRecentBuffee(buffeeName, extraTime)
	local buffee = OneHitWonder_CleanRecentBuffee();
	local newTime = GetTime() + extraTime;
	if ( not buffee ) then
		table.insert(OneHitWonder_RecentBuffees, { name = buffeeName, time = newTime } );
	else
		buffee.time = newTime;
	end
end

-- TODO: should add the amount of time before reapplying a buff to the same person

OneHitWonder_BuffTime = {
};

function OneHitWonder_GetBuffTime(buffName)
	local value = OneHitWonder_BuffTime[buffName];
	if ( not value ) then value = 30; end
	return value;
end

function OneHitWonder_DebuffUnit(unit)
	if ( OneHitWonder_IsPlayerDead() ) then
		return false;
	end
	if ( OneHitWonder_IsPlayerOnTaxi() ) then
		return false;
	end
	return false;
end

function OneHitWonder_RemoveDebuffs(unit)
	local funcName = format("OneHitWonder_RemoveDebuffs_%s", OneHitWonder_GetPlayerClass());
	local func = getglobal(funcName);
	if( func ) then
		return func;
	else
		return false;
	end
end

function OneHitWonder_IsUnitOffline(unit)
	if ( not UnitExists(unit) ) then
		return true;
	end
	OneHitWonderTooltip:SetUnit(unit);
	local strings = OneHitWonder_ScanTooltip("OneHitWonderTooltip");
	if ( strings ) then
	for k, v in strings do
		if ( v.left ) then
			if ( strfind(v.left, TEXT(PLAYER_OFFLINE)) ) then
				return true;
			end
		end
	end
	end
	return false;
end

function OneHitWonder_BuffUnit(unit, destroyTarget)
	if ( OneHitWonder_IsPlayerDead() ) then
		return false;
	end
	if ( OneHitWonder_IsPlayerOnTaxi() ) then
		return false;
	end
	if ( strfind(unit, "party") ) then
		if ( not OneHitWonder_IsUnitInRange(unit) ) then
			return false;
		end
	end
	local unitName = UnitName(unit);
	if ( ( not unitName ) or ( strlen(unitName) <= 0 ) ) then
		return false;
	end
	if ( OneHitWonder_IsUnitOffline(unit) ) then
		return false;
	end
	local targetName = UnitName("target");
	local hasTarget = true;
	if ( ( not targetName ) or ( strlen(targetName) <= 0 ) ) then
		hasTarget = false;
	end
	local ok = true;
	local currentBuffName = nil;
	local castBuff, shouldQuit;
	if ( OneHitWonder_RemoveDebuffs(unit) ) then
		return true;
	end
	for k, v in OneHitWonder_BuffsToKeepUp do
		ok = true;
		if ( type(v.buffName) == "table" ) then
			local actualBuffs = {};
			for key, value in v.buffName do
				if ( OneHitWonder_GetSpellId(value) > 0 ) then
					table.insert(actualBuffs, value);
				end
			end
			local mx = OneHitWonder_GetNumberOfClassInParty(OneHitWonder_GetPlayerClass());
			local cur = 1;
			local buffId = -1;
			local hasAnyBuff = false;
			for key, value in actualBuffs do
				if ( OneHitWonder_HasUnitEffect(unit, nil, value) ) then
					hasAnyBuff = true;
					break;
				end
			end
			local numBuffs = getn(actualBuffs);
			for key, value in actualBuffs do
				currentBuffName = value;
				buffId = OneHitWonder_GetSpellId(currentBuffName);
				if ( buffId > -1 ) then
					if (hasAnyBuff) then
						if ( ( v.canOverrideEffect ) and ( numBuffs > 1 ) ) then
							if ( OneHitWonder_IsRecentBuffee(unitName) ) then
								return false;
							end
						else
							return false;
						end
					end
					castBuff, shouldQuit = OneHitWonder_CastBuff(currentBuffName, v, unit, destroyTarget)
					if ( castBuff ) then
						OneHitWonder_AddRecentBuffee(unitName, OneHitWonder_GetBuffTime(currentBuffName));
					end
					if ( shouldQuit ) then
						return castBuff;
					end
					if ( castBuff ) then
						return castBuff;
					end
					cur = cur + 1;
					--[[
					if ( cur > mx) then
						break;
					end
					]]--
				end
			end
		else
			castBuff, shouldQuit = OneHitWonder_CastBuff(v.buffName, v, unit, destroyTarget);
			if ( shouldQuit ) then
				return castBuff;
			end
			if ( castBuff ) then
				return castBuff;
			end
		end
	end
	return false;
end


function OneHitWonder_DoStuffContinously()
	if ( not OneHitWonder_IsEnabled() ) then return false; end
	local targetName = UnitName("target");
	local isDead = OneHitWonder_IsPlayerDead();
	if ( ( not isDead ) and ( UnitRace("player") == ONEHITWONDER_RACE_TROLL ) ) then
		local berserkId = OneHitWonder_GetSpellId(ONEHITWONDER_ABILITY_BERSERK_NAME);
		if ( OneHitWonder_IsSpellAvailable(berserkId) ) then
			OneHitWonder_CastSpell(berserkId);
			return;
		end
	end
	if ( OneHitWonder_GetPlayerClass() == ONEHITWONDER_CLASS_PALADIN ) then
		if ( OneHitWonder_DoPaladinStuffContinously() ) then
			return;
		end
	end
	if ( OneHitWonder_GetPlayerClass() == ONEHITWONDER_CLASS_HUNTER ) then
		if ( OneHitWonder_DoHunterStuffContinously() ) then
			return;
		end
	end
	local fullMana = false;
	if ( UnitMana("player") >= UnitManaMax("player") ) then
		fullMana = true;
	end
	local isOKToBuff = false;
	local timeSinceLastBuff = GetTime() - OneHitWonder_LastBuffed;
	if ( (not isDead) and ( ( fullMana ) or ( timeSinceLastBuff <= 5 ) ) and ( not PlayerFrame.inCombat ) ) then
		isOKToBuff = true;
	end
	local buffId;
	if ( isOKToBuff ) then
		for k, v in OneHitWonder_BuffsToKeepUp do
			if ( OneHitWonder_IsItOkayToCastSpell(v) ) then
				buffId = OneHitWonder_GetSpellId(v.buffName);
				if ( OneHitWonder_IsSpellAvailable(buffId) ) then
					local actionId = OneHitWonder_GetActionIdFromSpellId(buffId);
					if ( actionId > -1 ) then
						UseAction(actionId, 0, 1);
					else
						OneHitWonder_CastSpell(buffId);
						if( SpellIsTargeting() ) then
							SpellTargetUnit("player");
						end
					end
					OneHitWonder_LastBuffed = GetTime();
					return;
				end
			end
		end
	end
	if ( ( OneHitWonder_ShouldKeepFindOn ) and ( (not isDead) ) )then
		local trackBuffName = OneHitWonder_GetPlayerTrackingBuffName();
		
		if ( not trackBuffName ) then
			local spellId = -1;
			for k, v in OneHitWonder_TrackingSpellsList do
				spellId = OneHitWonder_GetSpellId(v);
				if ( spellId > 0 ) then
					if ( OneHitWonder_CastSpell(spellId) ) then
						return;
					end
				end
			end
		end
	end
	if ( ( PlayerFrame.inCombat ~= 1 ) and ( OneHitWonder_ShouldKeepBuffsUpParty == 1 ) ) then
		if ( ( not targetName ) or ( strlen(targetName) <= 0 ) ) then
			if ( OneHitWonder_DoBuffs() ) then
				return;
			end
		end
	end
	OneHitWonder_HandleActionQueue();
end

function OneHitWonder_GetSpellIdInfo(spellId, spellBook, tooltipName)
	if ( ( not spellId ) or ( spellId <= -1 ) ) then
		return nil;
	end
	if ( not spellBook ) then
		spellBook = OneHitWonder_GetSpellBook(spellBook);
	end
	if ( not tooltipName ) then
		tooltipName = "OneHitWonderTooltip";
	end
	local tooltip = getglobal(tooltipName);
	if ( not tooltip ) then
		tooltipName = "OneHitWonderTooltip";
		tooltip = getglobal(tooltipName);
		if ( not tooltip ) then
			OneHitWonder_Print("OHW: Could not find tooltip to extract spell ID info from "..tooltipName, 1.0, 0.2, 0.2);
			return nil;
		end
	end
	OneHitWonder_ClearTooltip(tooltipName);
	tooltip:SetSpell(spellId, spellBook);
	
	local strings = OneHitWonder_ScanTooltip(tooltipName);
	
	local name, rankName = GetSpellName(spellId, spellBook);
	strings["rank"] = rankName;
	
	return strings;
end

function OneHitWonder_GetActionIdInfo(actionId, tooltipName)
	if ( ( not actionId ) or ( actionId <= -1 ) ) then
		return nil;
	end
	if ( not tooltipName ) then
		tooltipName = "OneHitWonderTooltip";
	end
	local tooltip = getglobal(tooltipName);
	if ( not tooltip ) then
		tooltipName = "OneHitWonderTooltip";
		tooltip = getglobal(tooltipName);
		if ( not tooltip ) then
			OneHitWonder_Print("OHW: Could not find tooltip to extract action ID info from.", 1.0, 0.2, 0.2);
			return nil;
		end
	end
	OneHitWonder_ClearTooltip(tooltipName);
	tooltip:SetAction(actionId);
	
	local strings = OneHitWonder_ScanTooltip(tooltipName);
	
	return strings;
end

-- Thanks to Cosmos for this one!
function OneHitWonder_ScanTooltip(TooltipNameBase)
	if ( not TooltipNameBase  ) then 
		TooltipNameBase = "OneHitWonderTooltip";
	end
	
	local strings = {};
	local ttext = nil;
	local textLeft = nil;
	local textRight = nil;
	for idx = 1, 20 do
		textLeft = nil;
		textRight = nil;
		ttext = getglobal(TooltipNameBase.."TextLeft"..idx);
		if(ttext and ttext:IsVisible() and ttext:GetText() ~= nil)
		then
			textLeft = ttext:GetText();
		end
		ttext = getglobal(TooltipNameBase.."TextRight"..idx);
		if(ttext and ttext:IsVisible() and ttext:GetText() ~= nil)
		then
			textRight = ttext:GetText();
		end
		if (textLeft or textRight)
		then
			strings[idx] = {};
			strings[idx].left = textLeft;
			strings[idx].right = textRight;
		end
	end

	return strings;
end

function OneHitWonder_ClearTooltip(TooltipNameBase)
	if ( not TooltipNameBase  ) then 
		TooltipNameBase = "OneHitWonderTooltip";
	end
	
	local textLeft = nil;
	local textRight = nil;
	for idx = 1, 20 do
		textLeft = nil;
		textRight = nil;
		textLeft = getglobal(TooltipNameBase.."TextLeft"..idx);
		if ( textLeft ) then
			textLeft:SetText("");
		end
		textRight = getglobal(TooltipNameBase.."TextRight"..idx);
		if ( textRight ) then
			textRight:SetText("");
		end
	end
	
	local tooltip = getglobal(TooltipNameBase);
	if ( tooltip ) then
		tooltip:SetText("");
	end

end


OneHitWonder_PartyUnits = { "player", "party1", "party2", "party3", "party4"};


function OneHitWonder_GetClassesInParty()
	local classes = {};
	local class = "";
	for k, v in OneHitWonder_PartyUnits do
		class = UnitClass(v);
		if ( ( class ) and ( strlen(class) > 0 ) ) then
			if ( classes[class] ) then
				classes[class] = classes[class] + 1;
			else
				classes[class] = 1;
			end
		end
	end
	return classes;
end

function OneHitWonder_IsEnabled()
	if ( OneHitWonder_Enabled == 1 ) then
		return true;
	else
		return false;
	end
end

function OneHitWonder_SetEnabled(toggle)
	if ( OneHitWonder_Enabled ~= toggle ) then
		OneHitWonder_Enabled = toggle;
	end
end

function OneHitWonder_OverloadedCastSpell(spellId, spellBook)
	OneHitWonder_HandleSpellCast(OneHitWonder_GetSpellName(spellId, spellBook));
	return OneHitWonder_Saved_CastSpell(spellId, spellBook)
end

OneHitWonder_Saved_CastSpell = CastSpell;
CastSpell = OneHitWonder_OverloadedCastSpell;

function OneHitWonder_OverloadedUseAction(actionId, param1, param2)
	local arr = OneHitWonder_ActionIdInfo[actionId];
	if ( ( arr ) and ( arr[1] ) ) then
		OneHitWonder_HandleSpellCast(arr[1].left);
	end
	return OneHitWonder_Saved_UseAction(actionId, param1, param2);
end

OneHitWonder_Saved_UseAction = UseAction;
UseAction = OneHitWonder_OverloadedUseAction;

function OneHitWonder_HandleSpellCast(spellName)
	if ( OneHitWonder_GetPlayerClass() == ONEHITWONDER_CLASS_WARLOCK ) then
		OneHitWonder_HandleSpellCast_Warlock(spellName);
	end
end


function OneHitWonder_GetNumberOfClassInParty(class)
	local classes = OneHitWonder_GetClassesInParty();
	local nr = 0;
	local tmp = 0;
	if ( type(class) == "table" ) then
		for k, v in class do
			tmp = classes[v];
			if ( tmp ) then
				nr = nr + tmp;
			end
		end
	elseif ( type(class) == "string" ) then
		nr = classes[v];
	end
	if ( ( nr ) and ( nr >= 1 ) ) then
		return nr;
	else
		return 0;
	end
end

function OneHitWonder_GetNumberOfClassInGroup(class)
	return OneHitWonder_GetNumberOfClassInParty(class);
end

ONEHITWONDER_PETMODE_UNKNOWN = -1;
ONEHITWONDER_PETMODE_AGGRESSIVE = 0;
ONEHITWONDER_PETMODE_DEFENSIVE = 1;
ONEHITWONDER_PETMODE_PASSIVE = 2;

function OneHitWonder_GetPetMode()
	for i=1, NUM_PET_ACTION_SLOTS, 1 do
		petActionButton = getglobal("PetActionButton"..i);
		petActionIcon = getglobal("PetActionButton"..i.."Icon");
		petAutoCastableTexture = getglobal("PetActionButton"..i.."AutoCastable");
		petAutoCastModel = getglobal("PetActionButton"..i.."AutoCast");
		local name, subtext, texture, isToken, isActive, autoCastAllowed, autoCastEnabled = GetPetActionInfo(i);
		if ( name ~= nil and isActive ) then
			if ( strfind(name, "MODE") ) then
				if ( strfind(name, "PET_MODE_AGGRESSIVE") ) then
					return ONEHITWONDER_PETMODE_AGGRESSIVE;
				elseif ( strfind(name, "PET_MODE_DEFENSIVE") ) then		
					return ONEHITWONDER_PETMODE_DEFENSIVE;
				elseif ( strfind(name, "PET_MODE_PASSIVE") ) then
					return ONEHITWONDER_PETMODE_PASSIVE;
				end
			end
		end
	end
	return ONEHITWONDER_PETMODE_UNKNOWN;
end

function OneHitWonder_SmartPetAttack(shouldAttack)
	if ( shouldAttack == 1 ) then
		if (OneHitWonder_PetIsAttacking == false) then
			local petMode = OneHitWonder_GetPetMode();
			if ( ( petMode == ONEHITWONDER_PETMODE_AGGRESSIVE ) or ( petMode == ONEHITWONDER_PETMODE_DEFENSIVE ) ) then
				PetAttack();
			end
		end
	end
end

function OneHitWonder_MeleeAttack()
	if ( (OneHitWonder_Attacking == false) or ( PlayerFrame.inCombat ~= 1 ) ) then
		AttackTarget();
		-- use auto attack blink on attack button
		OneHitWonder_Attacking = true;
	end
end

function OneHitWonder_GetBuffData(unit, buffIndex, debuff)
	if (buffIndex ~= -1) then
		local texture = nil;
		if ( debuff ) then
			texture = UnitDebuff(unit, buffIndex);
		else
			texture = UnitBuff(unit, buffIndex);
		end
		if ( not texture ) then
			return nil;
		end
		local tooltipName = "OneHitWonderTooltip";
		local tooltip = getglobal(tooltipName);
		OneHitWonder_ClearTooltip(tooltipName);
		if ( unit == "player" ) then
			tooltip:SetPlayerBuff(buffIndex);
		else
			if ( not debuff ) then
				tooltip:SetUnitBuff(unit, buffIndex);
			else
				tooltip:SetUnitDebuff(unit, buffIndex);
			end
		end
		local element = {};
		element.name = name;
		element.buffIndex = buffIndex;
		element.texture = texture;
		if ( DynamicData.util.getTooltipStrings ) then
			element.strings = DynamicData.util.getTooltipStrings(tooltipName);
		else
			element.strings = {};
			for i = 1, 15 do
				element.strings[i] = {};
			end
		end
		if ( ( element.strings ) and ( element.strings[1] ) and ( element.strings[1].left ) ) then
			element.name = element.strings[1].left;
		else
			element.name = "";
		end
		element.expires = ONEHITWONDER_BUFF_EXPIRES_UNKNOWN;
		return element;
	end
	return nil;
end

ONEHITWONDER_BUFF_EXPIRES_NEVER = -2;
ONEHITWONDER_BUFF_EXPIRES_UNKNOWN = -1;

function OneHitWonder_GetPlayerBuffData(buffIndex, untilCancelled, tooltipName)
	local tooltip = getglobal(tooltipName);
	if ( ( not tooltipName ) or ( not tooltip ) ) then
		tooltipName = "OneHitWonderTooltip";
		tooltip = getglobal(tooltipName);
	end
	if ( not tooltip ) then
		return nil;
	end

	local texture = GetPlayerBuffTexture(buffIndex);
	if ( not texture ) then
		return nil;
	end

	local element = {};
	element.texture = texture;
	element.buffIndex = buffIndex;
	OneHitWonder_ClearTooltip(tooltipName);
	tooltip:SetPlayerBuff(buffIndex);
	if ( untilCancelled == 1 ) then
		element.expires = ONEHITWONDER_BUFF_EXPIRES_NEVER;
	else
		element.expires = GetTime()+GetPlayerBuffTimeLeft(buffIndex);
	end
	if ( DynamicData.util.getTooltipStrings ) then
		element.strings = DynamicData.util.getTooltipStrings(tooltipName);
	else
		element.strings = {};
		for i = 1, 15 do
			element.strings[i] = {};
		end
	end
	if ( ( element.strings ) and ( element.strings[1] ) and ( element.strings[1].left ) ) then
		element.name = element.strings[1].left;
	else
		element.name = "";
	end
	return element;
end

function OneHitWonder_GetPlayerEffects(tooltipName)
	local currentBuffs = {};
	local currentDebuffs = {};
	local isDebuff = false;
	local id = 0;
	local buffIndex, untilCancelled;
	local buffFilter = "HELPFUL|PASSIVE";
	for id = 0, 15 do
		buffIndex, untilCancelled = GetPlayerBuff(id, buffFilter);
		if ( buffIndex >= 0 ) then
			element = OneHitWonder_GetPlayerBuffData(buffIndex, untilCancelled, tooltipName);
			if ( element ) then
				element.effectType = ONEHITWONDER_EFFECTTYPE_BUFF;
				table.insert(currentBuffs, element);
			end
		end
	end
	local buffFilter = "HARMFUL";
	for id = 0, 7 do
		buffIndex, untilCancelled = GetPlayerBuff(id, buffFilter);
		if ( buffIndex >= 0 ) then
			element = OneHitWonder_GetPlayerBuffData(buffIndex, untilCancelled, tooltipName);
			if ( element ) then
				element.effectType = ONEHITWONDER_EFFECTTYPE_DEBUFF;
				table.insert(currentDebuffs, element, tooltipName);
			end
		end
	end
	local icon = GetTrackingTexture();
	if ( icon ) then
		local strings = OneHitWonder_GetPlayerTrackingBuffStrings();
		local trackBuffName = "";
		if ( ( strings ) and ( strings[1] ) and ( strings[1].left ) ) then
			trackBuffName = strings[1].left;
		end
		buffData = {};
		buffData.texture = icon;
		buffData.name = trackBuffName;
		buffData.strings = strings;
		buffData.expires = ONEHITWONDER_BUFF_EXPIRES_NEVER;
		table.insert(currentBuffs, buffData);
	end
	return currentBuffs, currentDebuffs;
end

ONEHITWONDER_EFFECTTYPE_BUFF = "Buff";
ONEHITWONDER_EFFECTTYPE_DEBUFF = "Debuff";

function OneHitWonder_CheckEffect()
end

function OneHitWonder_CheckEffectOld(unit)
	if ( ( not unit ) or ( type(unit) ~= "string" ) ) then
		return;
	end
	if ( DynamicData.util.safeToUseTooltips ) then
		if ( not DynamicData.util.safeToUseTooltips() ) then
			if ( Cosmos_ScheduleByName ) then
				Cosmos_ScheduleByName("ONEHITWONDER_CHECK_BUFFS_"..unit, 1, OneHitWonder_CheckEffects, unit);
			end
			return;
		end
	end
	local timeout = 3;
	
	local buffData = nil;
	
	OneHitWonder_CurrentAuras[unit] = {};
	
	local currentBuffs = {};
	local currentDebuffs = {};

	if ( unit ~= "player" ) then
		for i = 0, MAX_PARTY_TOOLTIP_BUFFS do
			buffData = OneHitWonder_GetBuffData(unit, i);
			if ( buffData ) then
				buffData.effectType = ONEHITWONDER_EFFECTTYPE_BUFF;
				table.insert(currentBuffs, buffData);
			end
		end
		for i = 0, MAX_PARTY_TOOLTIP_DEBUFFS do
			buffData = OneHitWonder_GetBuffData(unit, i, debuff);
			if ( buffData ) then
				buffData.effectType = ONEHITWONDER_EFFECTTYPE_DEBUFF;
				table.insert(currentDebuffs, buffData);
			end
		end
	else
		currentBuffs, currentDebuffs = OneHitWonder_GetPlayerEffects();
	end
	
	OneHitWonder_CurrentAuras[unit].buffs = currentBuffs;
	OneHitWonder_CurrentAuras[unit].debuffs = currentDebuffs;
	
	if ( ( unit == "player" ) or ( unit == "pet") or ( strsub(unit, 1, 5) == "party") ) then
		local parameters = { unit, GetTime() + timeout};
		OneHitWonder_AddActionToQueue(ONEHITWONDER_ACTIONID_BUFF, parameters);
	elseif ( unit == "target" ) then
		if ( ( PlayerFrame.inCombat == 1 ) and ( UnitCanAttackTarget("target", "player" ) ) ) then
			local parameters = { unit, GetTime() + timeout};
			OneHitWonder_AddActionToQueue(ONEHITWONDER_ACTIONID_DEBUFF, parameters);
		end
	end
end

function OneHitWonder_IsUnitInRange(unit)
	local playerPos = OneHitWonder_GetUnitPosition("player");
	local partyPos = OneHitWonder_GetUnitPosition(unit);
	if ( ( playerPos ) and ( partyPos ) ) then
		local diffX = math.abs(playerPos.x - partyPos.x)*100;
		local diffY = math.abs(playerPos.y - partyPos.y)*100;
		if ( diffX > 5 ) or ( diffY > 5 ) then
			return false;
		else
			return true;
		end
	else
		return false;
	end
end


function OneHitWonder_GetUnitPosition(unit)
	local unitX, unitY = GetPlayerMapPosition(unit);
	if ( ( unitX == 0 ) and ( unitY == 0 ) ) then
		return nil;
	else
		local pos = {};
		pos.x = unitX;
		pos.y = unitY;
		return pos;
	end
	
end