
function OneHitWonder_SetupStuffContinously_Druid()
	OneHitWonder_BuffTime[ONEHITWONDER_ABILITY_MARK_OF_THE_WILD_NAME] = 25*60;
	OneHitWonder_BuffTime[ONEHITWONDER_ABILITY_THORNS_NAME] = 9*60;

	OneHitWonder_AddStuffContinously(ONEHITWONDER_ABILITY_MARK_OF_THE_WILD_NAME, false, true);
	OneHitWonder_AddStuffContinously(ONEHITWONDER_ABILITY_THORNS_NAME, false, true);
end

function OneHitWonder_Druid_Cosmos()
	if ( Cosmos_RegisterConfiguration ) then
		Cosmos_RegisterConfiguration(
			"COS_ONEHITWONDER_DRUID_SEPARATOR",
			"SEPARATOR",
			TEXT(ONEHITWONDER_DRUID_SEPARATOR),
			TEXT(ONEHITWONDER_DRUID_SEPARATOR_INFO)
		);
	end
end

function OneHitWonder_Druid(removeDefense)
	local targetName = UnitName("target");

	if ( not removeDefense ) then removeDefense = false; end
	
	if ( OneHitWonder_ChannelSpellRunning ) then
		return;
	end
	
	if ( (not targetName) or ( strlen(targetName) <= 0 ) ) then
		if ( not OneHitWonder_UseCountermeasures() ) then
			OneHitWonder_DoBuffs();
		end
		return;
	end
	
	if ( not UnitCanAttack("player", "target") ) then
		if ( not OneHitWonder_UseCountermeasures() ) then
			OneHitWonder_DoBuffs();
		end
		return;
	end
	
	OneHitWonder_CheckFriendlies();
	
	if ( OneHitWonder_HandleActionQueue() ) then
		return;
	end

	if ( PlayerFrame.inCombat ~= 1 ) then
		AttackTarget();
	end

	if ( not OneHitWonder_DoBuffs() ) then
		if ( OneHitWonder_CastIfTargetNotHasEffect(ONEHITWONDER_ABILITY_SHOOT, ONEHITWONDER_ABILITY_SHOOT) ) then
			return;
		end
	end
end


function OneHitWonder_CheckEffect_Druid(unit)
	if ( ( strfind(unit, "party" ) ) or ( unit == "player" ) ) then
		if ( OneHitWonder_ShouldRemoveDebuffs == 1 ) then
			local removeCurseId = OneHitWonder_GetSpellId(ONEHITWONDER_SPELL_REMOVE_CURSE_NAME);
			if ( removeCurseId > -1 ) then
				local debuffsByType = OneHitWonder_GetDebuffsByType(unit);
				local hasCurse = ( debuffsByType[ONEHITWONDER_DEBUFF_TYPE_CURSE] ) and ( table.getn(debuffsByType[ONEHITWONDER_DEBUFF_TYPE_CURSE]) > 0 );
				if ( hasCurse ) then
					local parameters = { removeCurseId, unit };
					OneHitWonder_AddActionToQueue(ONEHITWONDER_ACTIONID_SPELL_TARGET, parameters);
					return true;
				end
			end
		end
	end
	return false;
end
