function PopupHandler_HookedFunctions_CreateAutoHideUIFunctions(funcNames, prefix)
	if ( not funcNames ) then return false; end
	if ( not prefix ) then prefix = "HookedFunctions"; end
	for k, funcName in pairs(funcNames) do
		PopupHandler_HookedFunctions_CreateAutoHideUIFunction(funcName, prefix, false);
	end
	return true;
end

-- This function creates a function that autohides
function PopupHandler_HookedFunctions_CreateAutoHideUIFunction(funcName, prefix, cannotDelay)
	local executeFuncStr = "return PopupHandler_Saved_"..prefix.."_"..funcName.."(p1,p2,p3,p4,p5,p6,p7,p8,p9);";
	local prefixFuncName = prefix.."_"..funcName;
	-- TODO: this may be an advanced option
	local delay = PopupHandler_Options.autoHideUIDelay;
	if ( not delay ) or ( delay <= 0 ) or ( cannotDelay ) then
		executeFuncStr = "return PopupHandler_Saved_"..prefixFuncName.."(p1,p2,p3,p4,p5,p6,p7,p8,p9);";
	else
		executeFuncStr = "PopupHandler_ScheduleByName(\""..prefixFuncName.."\", "..delay..", PopupHandler_Saved_"..prefixFuncName..", p1,p2,p3,p4,p5,p6,p7,p8,p9);\nreturn;";
	end
	RunScript("function PopupHandler_"..prefixFuncName.."(p1,p2,p3,p4,p5,p6,p7,p8,p9)\n local po = PopupHandler_Options;\nif ( po.enabled ) and ( po.autoHideUIAtLocationChange ) then PopupHandler_Util_HideUI(); end\n"..executeFuncStr.."\nend");
end

function PopupHandler_HookedFunctions_HookFunctions(funcNames)
	local func = nil;
	local name = nil;
	for k, funcName in pairs(funcNames) do
		name = "PopupHandler_HookedFunctions_"..funcName;
		func = getglobal(name);
		if ( func ) then
			setglobal("PopupHandler_Saved_HookedFunctions_"..funcName, getglobal(funcName));
			setglobal(funcName, func);
		else
			error("PopupHandler: function '"..name.."' was not found.");
		end
	end
end

function PopupHandler_HookedFunctions_LeaveBattlefield(p1, p2, p3, p4, p5)
	if ( PopupHandler_Options.enabled ) and ( PopupHandler_Options.autoLeaveBattlegroundGroup ) then
		if ( PopupHandler_IsInPartyOrRaid() ) then
			local delay = PopupHandler_Options.autoHideUIDelay;
			local shouldDelay = ( delay ) and ( delay > 0 );
			if ( shouldDelay ) then
				PopupHandler_ScheduleByName("HookedFunctions_LeaveBattlefield", delay, PopupHandler_Saved_HookedFunctions_LeaveBattlefield, p1, p2, p3, p4, p5);
			end
			LeaveParty();
			if ( shouldDelay ) then
				return;
			end
		end
	end
	return PopupHandler_Saved_HookedFunctions_LeaveBattlefield(p1, p2, p3, p4, p5);
end

function PopupHandler_HookedFunctions_AcceptBattlefieldPort(p1, p2, p3, p4, p5)
	if ( PopupHandler_Options.enabled ) and ( PopupHandler_Options.autoLeaveGroupBeforeBattleground ) then
		local shouldDelay = false;
		if ( PopupHandler_Options.autoHideUIAtLocationChange ) then 
			PopupHandler_Util_HideUI();
			shouldDelay = true;
		end
		if ( PopupHandler_IsInPartyOrRaid() ) then
			LeaveParty();
			shouldDelay = true;
		end
		if ( shouldDelay ) then
			local delay = PopupHandler_Options.autoHideUIDelay;
			shouldDelay = ( delay ) and ( delay > 0 );
			if ( shouldDelay ) then
				PopupHandler_ScheduleByName("HookedFunctions_AcceptBattlefieldPort", delay, PopupHandler_Saved_HookedFunctions_AcceptBattlefieldPort, p1, p2, p3, p4, p5);
			end
		end
		if ( shouldDelay ) then
			return;
		end
	end
	return PopupHandler_Saved_HookedFunctions_AcceptBattlefieldPort(p1, p2, p3, p4, p5);
end



function PopupHandler_HookedFunctions_WorldStateScoreFrame_Update(p1, p2, p3, p4, p5)
	if ( PopupHandler_Options.autoLeaveBattleground ) and ( GetBattlefieldWinner() ) then
		LeaveBattlefield();
	end;
	return PopupHandler_Saved_HookedFunctions_WorldStateScoreFrame_Update(p1, p2, p3, p4, p5);
end

function PopupHandler_HookedFunctions_OnLoad()

	local funcNames = {
		"ConfirmSummon";
		"RepopMe";
	};
	
	PopupHandler_HookedFunctions_CreateAutoHideUIFunctions(funcNames);

	table.insert(funcNames, "AcceptBattlefieldPort");
	table.insert(funcNames, "LeaveBattlefield");
	table.insert(funcNames, "WorldStateScoreFrame_Update");

	PopupHandler_HookedFunctions_HookFunctions(funcNames);
	
	local option1 = {
		id = "autoHideUIDelaySlider";
		key = "autoHideUIDelay";
		text = POPUPHANDLER_OPTION_AUTO_HIDE_UI_DELAY;
		helptext = POPUPHANDLER_OPTION_AUTO_HIDE_UI_DELAY_INFO;
		callback = function (state) PopupHandler_UpdateSliderOption("autoHideUIDelay", state.slider, "Khaos"); end;
		difficulty = 3;
		type = K_SLIDER;
		setup = {
			sliderMin = 0;
			sliderMax = 2;
			sliderStep = .1;
			sliderSignificantDigits = 1;
			sliderText = POPUPHANDLER_OPTION_AUTO_HIDE_UI_DELAY_SLIDER_TEXT;
			sliderLow = POPUPHANDLER_OPTION_AUTO_HIDE_UI_DELAY_SLIDER_LOWEST;
			sliderHigh = POPUPHANDLER_OPTION_AUTO_HIDE_UI_DELAY_SLIDER_HIGHEST;
			sliderDisplayFunc = function ( value ) return format(POPUPHANDLER_OPTION_AUTO_HIDE_UI_DELAY_FEEDBACK_FORMAT, value);  end;
		};
		feedback = function(state) if ( state.slider > 0 ) then return string.format(POPUPHANDLER_OPTION_AUTO_HIDE_UI_DELAY_FEEDBACK_FORMAT, state.slider); else return POPUPHANDLER_OPTION_AUTO_HIDE_UI_DELAY_FEEDBACK_DISABLED; end; end;
		default = {
			slider = 0.5;
		};
		disabled = {
			slider = 0.0;
		};
	};
	table.insert(PopupHandler_Khaos_Options_Easy, option1);
end


PopupHandler_Keys_To_Cosmos.autoHideUIDelay = "COS_POPUPHANDLER_AUTO_HIDE_UI_DELAY";
table.insert(PopupHandler_HandlersOnLoad, PopupHandler_HookedFunctions_OnLoad);
