function PopupHandler_Summon_OnLoad()
	PopupHandler_AddPopupHandler("CONFIRM_SUMMON", PopupHandler_Summon_Popup);

	local option1 = PopupHandler_Get_Khaos_CheckBox(
		"autoAcceptSummonCheckBox", 
		"autoAcceptSummon", 
		POPUPHANDLER_OPTION_ACCEPT_SUMMON_NAME,
		POPUPHANDLER_OPTION_ACCEPT_SUMMON_INFO,
		false,
		function (state) PopupHandler_UpdateBooleanOption("autoAcceptSummon", state.checked, "Khaos"); end
	);
	table.insert(PopupHandler_Khaos_Options_Easy, option1);

	PopupHandler_AddSlashCommand(POPUPHANDLER_CHAT_ACCEPT_SUMMON_CMDS, "autoAcceptSummon", POPUPHANDLER_CHAT_ACCEPT_SUMMON_FORMAT, POPUPHANDLER_OPTION_ACCEPT_SUMMON_NAME, POPUPHANDLER_OPTION_ACCEPT_SUMMON_INFO);

	PopupHandler_AddCosmosBooleanOption("autoAcceptSummon", false, 
		POPUPHANDLER_OPTION_ACCEPT_SUMMON_NAME, 
		POPUPHANDLER_OPTION_ACCEPT_SUMMON_INFO,
		function(toggle) PopupHandler_CosmosBooleanOptionUpdate("autoAcceptSummon", toggle, "Cosmos"); end
	);
	
	local option2 = PopupHandler_Get_Khaos_CheckBox(
		"autoDeclineSummonCheckBox", 
		"autoDeclineSummon", 
		POPUPHANDLER_OPTION_DECLINE_SUMMON_NAME,
		POPUPHANDLER_OPTION_DECLINE_SUMMON_INFO,
		false,
		function (state) PopupHandler_UpdateBooleanOption("autoDeclineSummon", state.checked, "Khaos"); end
	);
	table.insert(PopupHandler_Khaos_Options_Easy, option2);

	PopupHandler_AddSlashCommand(POPUPHANDLER_CHAT_DECLINE_SUMMON_CMDS, "autoDeclineSummon", POPUPHANDLER_CHAT_DECLINE_SUMMON_FORMAT, POPUPHANDLER_OPTION_DECLINE_SUMMON_NAME, POPUPHANDLER_OPTION_DECLINE_SUMMON_INFO);

	PopupHandler_AddCosmosBooleanOption("autoDeclineSummon", false, 
		POPUPHANDLER_OPTION_DECLINE_SUMMON_NAME, 
		POPUPHANDLER_OPTION_DECLINE_SUMMON_INFO,
		function(toggle) PopupHandler_CosmosBooleanOptionUpdate("autoDeclineSummon", toggle, "Cosmos"); end
	);
	
	local option3 = PopupHandler_Get_Khaos_CheckBox(
		"autoAcceptFriendSummonCheckBox", 
		"autoAcceptFriendSummon", 
		POPUPHANDLER_OPTION_ACCEPT_FRIEND_SUMMON_NAME,
		POPUPHANDLER_OPTION_ACCEPT_FRIEND_SUMMON_INFO,
		false,
		function (state) PopupHandler_UpdateBooleanOption("autoAcceptFriendSummon", state.checked, "Khaos"); end
	);
	table.insert(PopupHandler_Khaos_Options_Easy, option3);

	PopupHandler_AddSlashCommand(POPUPHANDLER_CHAT_ACCEPT_FRIEND_SUMMON_CMDS, "autoAcceptFriendSummon", POPUPHANDLER_CHAT_ACCEPT_FRIEND_SUMMON_FORMAT, POPUPHANDLER_OPTION_ACCEPT_FRIEND_SUMMON_NAME, POPUPHANDLER_OPTION_ACCEPT_FRIEND_SUMMON_INFO);

	PopupHandler_AddCosmosBooleanOption("autoAcceptFriendSummon", false, 
		POPUPHANDLER_OPTION_ACCEPT_FRIEND_SUMMON_NAME, 
		POPUPHANDLER_OPTION_ACCEPT_FRIEND_SUMMON_INFO,
		function(toggle) PopupHandler_CosmosBooleanOptionUpdate("autoAcceptFriendSummon", toggle, "Cosmos"); end
	);
	
	local option4 = PopupHandler_Get_Khaos_CheckBox(
		"autoAcceptGuildSummonCheckBox", 
		"autoAcceptGuildSummon", 
		POPUPHANDLER_OPTION_ACCEPT_GUILD_SUMMON_NAME,
		POPUPHANDLER_OPTION_ACCEPT_GUILD_SUMMON_INFO,
		false,
		function (state) PopupHandler_UpdateBooleanOption("autoAcceptGuildSummon", state.checked, "Khaos"); end
	);
	table.insert(PopupHandler_Khaos_Options_Easy, option4);

	PopupHandler_AddSlashCommand(POPUPHANDLER_CHAT_ACCEPT_GUILD_SUMMON_CMDS, "autoAcceptGuildSummon", POPUPHANDLER_CHAT_ACCEPT_GUILD_SUMMON_FORMAT, POPUPHANDLER_OPTION_ACCEPT_GUILD_SUMMON_NAME, POPUPHANDLER_OPTION_ACCEPT_GUILD_SUMMON_INFO);

	PopupHandler_AddCosmosBooleanOption("autoAcceptGuildSummon", false, 
		POPUPHANDLER_OPTION_ACCEPT_GUILD_SUMMON_NAME, 
		POPUPHANDLER_OPTION_ACCEPT_GUILD_SUMMON_INFO,
		function(toggle) PopupHandler_CosmosBooleanOptionUpdate("autoAcceptGuildSummon", toggle, "Cosmos"); end
	);
	
	local option5 = PopupHandler_Get_Khaos_CheckBox(
		"autoDeclineIgnoreSummonCheckBox", 
		"autoDeclineIgnoreSummon", 
		POPUPHANDLER_OPTION_DECLINE_IGNORE_SUMMON_NAME,
		POPUPHANDLER_OPTION_DECLINE_IGNORE_SUMMON_INFO,
		false,
		function (state) PopupHandler_UpdateBooleanOption("autoDeclineIgnoreSummon", state.checked, "Khaos"); end
	);
	table.insert(PopupHandler_Khaos_Options_Easy, option5);

	PopupHandler_AddSlashCommand(POPUPHANDLER_CHAT_DECLINE_IGNORE_SUMMON_CMDS, "autoDeclineIgnoreSummon", POPUPHANDLER_CHAT_DECLINE_IGNORE_SUMMON_FORMAT, POPUPHANDLER_OPTION_DECLINE_IGNORE_SUMMON_NAME, POPUPHANDLER_OPTION_DECLINE_IGNORE_SUMMON_INFO);

	PopupHandler_AddCosmosBooleanOption("autoDeclineIgnoreSummon", false, 
		POPUPHANDLER_OPTION_DECLINE_IGNORE_SUMMON_NAME, 
		POPUPHANDLER_OPTION_DECLINE_IGNORE_SUMMON_INFO,
		function(toggle) PopupHandler_CosmosBooleanOptionUpdate("autoDeclineIgnoreSummon", toggle, "Cosmos"); end
	);
	
	local option6 = PopupHandler_Get_Khaos_CheckBox(
		"autoAcceptPartySummonCheckBox", 
		"autoAcceptPartySummon", 
		POPUPHANDLER_OPTION_ACCEPT_PARTY_SUMMON_NAME,
		POPUPHANDLER_OPTION_ACCEPT_PARTY_SUMMON_INFO,
		false,
		function (state) PopupHandler_UpdateBooleanOption("autoAcceptPartySummon", state.checked, "Khaos"); end
	);
	table.insert(PopupHandler_Khaos_Options_Easy, option6);

	PopupHandler_AddSlashCommand(POPUPHANDLER_CHAT_ACCEPT_PARTY_SUMMON_CMDS, "autoAcceptPartySummon", POPUPHANDLER_CHAT_ACCEPT_PARTY_SUMMON_FORMAT, POPUPHANDLER_OPTION_ACCEPT_PARTY_SUMMON_NAME, POPUPHANDLER_OPTION_ACCEPT_PARTY_SUMMON_INFO);

	PopupHandler_AddCosmosBooleanOption("autoAcceptPartySummon", false, 
		POPUPHANDLER_OPTION_ACCEPT_PARTY_SUMMON_NAME, 
		POPUPHANDLER_OPTION_ACCEPT_PARTY_SUMMON_INFO,
		function(toggle) PopupHandler_CosmosBooleanOptionUpdate("autoAcceptPartySummon", toggle, "Cosmos"); end
	);
	
end

StaticPopupDialogs["CONFIRM_AUTOSUMMON"] = {
	text = TEXT(POPUPHANDLER_DIALOG_SUMMON_COUNTDOWN),
	button1 = TEXT(OKAY),
	button2 = TEXT(CANCEL),
	OnAccept = function()
		ConfirmSummon();
	end,
	OnCancel = function(data, reason)
		if ( reason == "timeout" ) then
			StaticPopupDialogs["CONFIRM_AUTOSUMMON"].OnAccept();
			return;
		end
	end,
	OnUpdate = function(elapsed)
		this.timeleft = this.timeleft - elapsed;
		getglobal(this:GetName().."Text"):SetText(format(this.text, ceil(this.timeLeft)));
	end,
	OnShow = function()
		this.timeleft = 5;
		this.OnUpdate(0);
	end,
	timeleft = 0,
	timeout = 5,
	whileDead = 1,
	hideOnEscape = 1
};

function PopupHandler_Summon_Countdown(number, func)
	if ( number > 0 ) then
		UIErrorsFrame:AddMessage(format(POPUPHANDLER_MSG_SUMMON_COUNTDOWN, number), 1, 1, 0, 1, 1);
		PopupHandler_ScheduleByName("POPUPHANDLER_SUMMON_IMMINENT", 1, PopupHandler_Summon_Countdown, number-1, func);
	else
		if ( not func ) then
			ConfirmSummon();
		else
			func();
		end
	end
end

function PopupHandler_Summon_Popup(which, text_arg1, text_arg2)
	if ( PopupHandler_Summon_IgnoreNextOffer ) then
		PopupHandler_Summon_IgnoreNextOffer = false;
		PopupHandler_StaticPopup_Show_ReturnDialog = PopupHandler_Saved_StaticPopup_Show(which, text_arg1, text_arg2);
		return;
	end
	local popup = StaticPopupDialogs[which];
	local state = 0;
	local summoner = GetSummonConfirmSummoner();
	if ( summoner ) then
		state = PopupHandler_Summon_GetState(summoner);
	end
	if ( state == 1 ) then
		-- accept
		PopupHandler_ScheduleByName("POPUPHANDLER_SUMMON_IMMINENT", 1, PopupHandler_Summon_Countdown, 3, popup.OnAccept);
	elseif ( state == 2 ) then
		-- silent decline
		popup.OnCancel();
	elseif ( state == 3 ) then
		-- verbose decline
		popup.OnCancel();
		PopupHandler_Print(string.format(POPUPHANDLER_CHAT_DENIED_SUMMON_USER, summoner));
	else
		PopupHandler_StaticPopup_Show_ReturnDialog = PopupHandler_Saved_StaticPopup_Show(which, text_arg1, text_arg2);
		return;
	end
	PopupHandler_StaticPopup_Show_ReturnNow = true;
	PopupHandler_StaticPopup_Show_ReturnDialog = nil;
end

function PopupHandler_Summon_GetState(name)
	if ( not PopupHandler_Options.enabled ) then
		return 0;
	end 
	if ( PopupHandler_Options.autoAcceptFriendSummon ) then
		for k, v in PopupHandler_FriendList do
			if ( v == name ) then
				return 1;
			end
		end
	end
	if ( PopupHandler_Options.autoAcceptGuildSummon ) then
		for k, v in PopupHandler_GuildList do
			if ( v == name ) then
				return 1;
			end
		end
	end
	if ( PopupHandler_Options.autoAcceptPartySummon ) then
		for k, v in PopupHandler_UnitsInParty do
			if ( UnitName(v) == name ) then
				return 1;
			end
		end
	end
	if ( PopupHandler_Options.autoDeclineIgnoreSummon ) then
		for k, v in PopupHandler_IgnoreList do
			if ( v == name ) then
				return 2;
			end
		end
	end
	if ( PopupHandler_Options.autoAcceptPvPSummon ) then
		if ( UnitIsPVPFreeForAll("player") ) then
			return 1;
		end
		if ( UnitIsPVP("player") ) then
			return 1;
		end
	end
	if ( PopupHandler_Options.autoAcceptAreaSummon ) then
		local zone = GetRealZoneText();
		for k, v in POPUPHANDLER_AUTO_ACCEPT_SUMMON_AREAS do
			if ( v == zone ) then
				return 1;
			end
		end
	end
	if ( PopupHandler_Options.autoAcceptSummon ) then
		return 1;
	end
	if ( PopupHandler_Options.autoDeclineSummon ) then
		if ( PopupHandler_Options.verbosePartyDeclines ) then
			return 3;
		else
			return 2;
		end
	end
	return 0;
end


PopupHandler_Options.autoAcceptSummon = false;
PopupHandler_Options.autoDeclineSummon = false;
PopupHandler_Options.autoAcceptFriendSummon = false;
PopupHandler_Options.autoAcceptGuildSummon = false;
PopupHandler_Options.autoDeclineIgnoreSummon = false;
PopupHandler_Options.autoAcceptPartySummon = false;

PopupHandler_Keys_To_Cosmos.autoAcceptSummon = "COS_POPUPHANDLER_AUTO_ACCEPT_SUMMON";
PopupHandler_Keys_To_Cosmos.autoDeclineSummon = "COS_POPUPHANDLER_AUTO_DECLINE_SUMMON";
PopupHandler_Keys_To_Cosmos.autoAcceptFriendSummon = "COS_POPUPHANDLER_AUTO_ACCEPT_FRIEND_SUMMON";
PopupHandler_Keys_To_Cosmos.autoAcceptGuildSummon = "COS_POPUPHANDLER_AUTO_ACCEPT_GUILD_SUMMON";
PopupHandler_Keys_To_Cosmos.autoDeclineIgnoreSummon = "COS_POPUPHANDLER_AUTO_DECLINE_IGNORE_SUMMON";
PopupHandler_Keys_To_Cosmos.autoAcceptPartySummon = "COS_POPUPHANDLER_AUTO_ACCEPT_PARTY_SUMMON";

table.insert(PopupHandler_HandlersOnLoad, PopupHandler_Summon_OnLoad);
