PopupHandler_GuildList = {};
PopupHandler_FriendList = {};
PopupHandler_IgnoreList = {};

PopupHandler_UnitsInParty = {
};


function PopupHandler_Util_RegisterOptions()
	local option1 = PopupHandler_Get_Khaos_CheckBox(
		"autoHideUIAtLocationChangeCheckBox", 
		"autoHideUIAtLocationChange", 
		POPUPHANDLER_OPTION_AUTO_HIDE_UI_CHANGED_LOCATION,
		POPUPHANDLER_OPTION_AUTO_HIDE_UI_CHANGED_LOCATION_INFO,
		false,
		function (state) PopupHandler_UpdateBooleanOption("autoHideUIAtLocationChange", state.checked, "Khaos"); end
	);
	table.insert(PopupHandler_Khaos_Options_Easy, option1);

	PopupHandler_AddCosmosBooleanOption("autoHideUIAtLocationChange", false, 
		POPUPHANDLER_OPTION_AUTO_HIDE_UI_CHANGED_LOCATION, 
		POPUPHANDLER_OPTION_AUTO_HIDE_UI_CHANGED_LOCATION_INFO,
		function(toggle) PopupHandler_CosmosBooleanOptionUpdate("autoHideUIAtLocationChange", toggle, "Cosmos"); end
	);
end

function PopupHandler_Util_OnLoad()

	PopupHandler_Util_RegisterOptions();

	PopupHandler_UpdateGuildList();
	PopupHandler_UpdateFriendsList();
	PopupHandler_UpdateIgnoreList();
	
	for i = 1, 4 do
		table.insert(PopupHandler_UnitsInParty, "party"..i);
	end
	for i = 1, 40 do
		table.insert(PopupHandler_UnitsInParty, "raid"..i);
	end
	
	PopupHandler_AddEventListener("FRIENDLIST_SHOW", PopupHandler_UpdateFriendsList);
	PopupHandler_AddEventListener("FRIENDLIST_UPDATE", PopupHandler_UpdateFriendsList);

	PopupHandler_AddEventListener("GUILD_ROSTER_SHOW", PopupHandler_UpdateGuildList);
	PopupHandler_AddEventListener("GUILD_ROSTER_UPDATE", PopupHandler_UpdateGuildList);
	PopupHandler_AddEventListener("PLAYER_GUILD_UPDATE", PopupHandler_UpdateGuildList);
	PopupHandler_AddEventListener("IGNORELIST_UPDATE", PopupHandler_UpdateIgnoreList);
end


function PopupHandler_UpdateFriendsList()
	local numFriends = GetNumFriends();
	local name, level, class, area, connected;
	local size = table.getn(PopupHandler_FriendList);
	local entry = 1;
	for friendIndex = 1, numFriends do
		name, level, class, area, connected = GetFriendInfo(friendIndex);
		if ( connected ) then
			PopupHandler_FriendList[entry] = name;
			entry = entry + 1;
		end
	end
	for i = size, entry, -1 do
		PopupHandler_FriendList[i] = nil;
	end
end

function PopupHandler_UpdateIgnoreList()
	local numIgnores = GetNumIgnores();
	local name;
	local size = table.getn(PopupHandler_IgnoreList);
	for ignoreIndex = 1, numIgnores do
		name = GetIgnoreName(ignoreIndex);
		PopupHandler_IgnoreList[ignoreIndex] = name;
	end
	for i = size, numIgnores, -1 do
		PopupHandler_IgnoreList[i] = nil;
	end
end

function PopupHandler_UpdateGuildList()
	if ( IsInGuild() ) then
		local numGuildMembers = GetNumGuildMembers();
		local name, rank, rankIndex, level, class, zone, group, note, officernote, online;
		local size = table.getn(PopupHandler_GuildList);
		local entry = 1;
		
		for guildIndex = 1, numGuildMembers do
			name, rank, rankIndex, level, class, zone, group, note, officernote, online = GetGuildRosterInfo(guildIndex);
			if ( online ) then
				PopupHandler_GuildList[entry] = name;
				entry = entry + 1;
			end
		end
		for i = size, entry, -1 do
			PopupHandler_GuildList[i] = nil;
		end
	end
end

function PopupHandler_Util_HideUI()
	if ( UIParent:IsVisible() ) then
		CloseAllWindows();
		UIParent:Hide();
		return true;
	else
		return false;
	end
end


table.insert(PopupHandler_HandlersOnLoad, PopupHandler_Util_OnLoad);

PopupHandler_Options.autoHideUIAtLocationChange = false;
PopupHandler_Keys_To_Cosmos.autoHideUIAtLocationChange = "COS_POPUPHANDLER_AUTO_HIDE_UI_AT_LOCATION_CHANGE";



function PopupHandler_ScheduleByName_CosmosSchedule(name, when, handler, p1, p2, p3, p4, p5, p6, p7, p8, p9)
	Cosmos_ScheduleByName(name, when, handler, p1, p2, p3, p4, p5, p6, p7, p8, p9);
	return true;
end

function PopupHandler_ScheduleByName_Chronos(name, when, handler, p1, p2, p3, p4, p5, p6, p7, p8, p9)
	Chronos.scheduleByName(name, when, handler, p1, p2, p3, p4, p5, p6, p7, p8, p9);
	return true;
end

PopupHandler_HasScheduleByName = true;

function PopupHandler_ScheduleByName_Fail(name, when, handler, p1, p2, p3, p4, p5, p6, p7, p8, p9)
	handler(p1, p2, p3, p4, p5, p6, p7, p8, p9);
	return false;
end

function PopupHandler_ScheduleByName(name, when, handler, p1, p2, p3, p4, p5, p6, p7, p8, p9)
	local foundScheduleFunc = false;
	if ( type(Chronos) == "table" ) and ( Chronos.scheduleByName ) then
		PopupHandler_ScheduleByName = PopupHandler_ScheduleByName_Chronos;
		foundScheduleFunc = true;
	elseif ( Cosmos_ScheduleByName ) then
		PopupHandler_ScheduleByName = PopupHandler_ScheduleByName_CosmosSchedule;
		foundScheduleFunc = true;
	end
	if ( foundScheduleFunc ) then
		PopupHandler_ScheduleByName(name, when, handler, p1, p2, p3, p4, p5, p6, p7, p8, p9);
	else
		PopupHandler_ScheduleByName = PopupHandler_ScheduleByName_Fail;
	end
	return foundScheduleFunc;
end


function PopupHandler_Schedule_CosmosSchedule(when, handler, p1, p2, p3, p4, p5, p6, p7, p8, p9)
	Cosmos_Schedule(when, handler, p1, p2, p3, p4, p5, p6, p7, p8, p9);
	return true;
end

function PopupHandler_Schedule_Chronos(when, handler, p1, p2, p3, p4, p5, p6, p7, p8, p9)
	Chronos.schedule(when, handler, p1, p2, p3, p4, p5, p6, p7, p8, p9);
	return true;
end

function PopupHandler_Schedule_Fail()
	return false;
end

function PopupHandler_Schedule(when, handler, p1, p2, p3, p4, p5, p6, p7, p8, p9)
	local foundScheduleFunc = false;
	if ( type(Chronos) == "table" ) and ( Chronos.schedule ) then
		PopupHandler_Schedule = PopupHandler_Schedule_Chronos;
		foundScheduleFunc = true;
	elseif ( Cosmos_Schedule ) then
		PopupHandler_Schedule = PopupHandler_Schedule_CosmosSchedule;
		foundScheduleFunc = true;
	end
	if ( foundScheduleFunc ) then
		PopupHandler_Schedule(when, handler, p1, p2, p3, p4, p5, p6, p7, p8, p9);
	else
		PopupHandler_Schedule = PopupHandler_Schedule_Fail;
	end
	return foundScheduleFunc;
end

function PopupHandler_IsInPartyOrRaid()
	if ( ( GetNumPartyMembers() > 0 ) or ( GetNumRaidMembers() > 0  ) ) then
		return true;
	else
		return false;
	end
end

