--[[

	QuestLog Level Patch
	
	by sarf
	
	Adds level of quest to the quest log, so that Smurf becomes [15] Smurf.
	
]]--

QuestLogLevelPatch_Options = {
	enabled = true;
};

function QuestLogLevelPatch_ShouldPatch()
	if ( this ) and ( this.GetName ) then
		local name = this:GetName();
		return string.find(name, "QuestLog");
	end
	return false;
end

function QuestLogLevelPatch_GetQuestLogTitle(questIndex)
	local questLogTitleText, level, questTag, isHeader, isCollapsed, isComplete = QuestLogLevelPatch_Saved_GetQuestLogTitle(questIndex);
	if ( QuestLogLevelPatch_Options.enabled ) and ( not isHeader ) and ( level ) and ( QuestLogLevelPatch_ShouldPatch() ) then
		local formatStr = QuestLogLevelPatch_Format;
		if ( questTag ) then
			local newFormatStr = QuestLogLevelPatch_Format_Tags[questTag];
			if ( newFormatStr ) then
				formatStr = newFormatStr;
			end
		end
		questLogTitleText = string.format(formatStr, level, questLogTitleText);
	end
	return questLogTitleText, level, questTag, isHeader, isCollapsed, isComplete;
end

function QuestLogLevelPatch_OnLoad()
	QuestLogLevelPatch_Saved_GetQuestLogTitle = GetQuestLogTitle;
	GetQuestLogTitle = QuestLogLevelPatch_GetQuestLogTitle;
	
	QuestLogLevelPatch_Register_Cosmos();
	QuestLogLevelPatch_Register_Khaos();
end

function QuestLogLevelPatch_SetEnabled(toggle)
	if ( toggle == 1 ) then
		QuestLogLevelPatch_Options.enabled = true;
	else
		QuestLogLevelPatch_Options.enabled = false;
	end
end

function QuestLogLevelPatch_EnabledValue_Cosmos()
	if ( QuestLogLevelPatch_Options.enabled ) then
		return 1;
	else
		return 0;
	end
end

function QuestLogLevelPatch_Register_Cosmos()
	if ( not Cosmos_RegisterConfiguration ) then
		return;
	end
	Cosmos_RegisterConfiguration(
		"COS_QUESTLEVEL",
		"SECTION",
		TEXT(QUESTLEVEL_CONFIG_HEADER),
		TEXT(QUESTLEVEL_CONFIG_HEADER_INFO)
	);
	Cosmos_RegisterConfiguration(
		"COS_QUESTLEVEL_HEADER",
		"SEPARATOR",
		TEXT(QUESTLEVEL_CONFIG_HEADER),
		TEXT(QUESTLEVEL_CONFIG_HEADER_INFO)
	);
	Cosmos_RegisterConfiguration(
		"COS_QUESTLEVEL_ENABLED",
		"CHECKBOX",
		TEXT(QUESTLEVEL_ENABLED),
		TEXT(QUESTLEVEL_ENABLED_INFO),
		QuestLogLevelPatch_SetEnabled,
		QuestLogLevelPatch_EnabledValue_Cosmos()
	);
end

function QuestLogLevelPatch_Register_Khaos()
	if ( not Khaos ) then
		return;
	end
	local optionSetEasy = {
		id = QUESTLEVEL_KHAOS_SET_EASY_ID;
		text = QUESTLEVEL_KHAOS_EASYSET_TEXT;
		helptext = QUESTLEVEL_KHAOS_EASYSET_HELP;
		difficulty = 1;
		options = {};
		default = true;
	};
	local optionEnabled = {
		id = "questLevelCheckBoxEnabled";
		key = "enabled";
		text = QUESTLEVEL_KHAOS_ENABLED_TEXT;
		helptext = QUESTLEVEL_KHAOS_ENABLED_HELPTEXT;
		check = true;
		callback = function(state) QuestLogLevelPatch_Options.enabled = state.checked; end;
		type = K_TEXT;
		feedback = function(state) local s = QUESTLEVEL_KHAOS_STATE_ENABLED; if ( not state.checked ) then s = QUESTLEVEL_KHAOS_STATE_DISABLED; end return QUESTLEVEL_KHAOS_STATE_TEXT.." "..s; end;
		default = {
			checked = true;
		};
		disabled = {
			checked = false;
		};
	};
	table.insert(optionSetEasy.options, optionEnabled);
	Khaos.registerOptionSet( "quest", optionSetEasy);
end

function QuestLogLevelPatch_OnEvent(event)
end


