--[[
	ReplyTarget

	By sarf

	This mod allows you to target the last person who sent a /whisper to you.

	Thanks goes to pertie on the CosmosUI boards for suggesting this!
	
	CosmosUI URL:
	http://www.cosmosui.org/forums/viewtopic.php?p=366
	
   ]]


-- Constants

-- Variables
ReplyTarget_Cosmos_Registered = 0;

-- executed on load, calls general set-up functions
function ReplyTarget_OnLoad()
	ReplyTarget_Register();
end

-- registers the mod with Cosmos
function ReplyTarget_Register_Cosmos()
	if ( ( Cosmos_RegisterConfiguration ) and ( ReplyTarget_Cosmos_Registered == 0 ) ) then
		ReplyTarget_Cosmos_Registered = 1;
	end
end

-- registers the mod with the system, integrating it with slash commands and "master" AddOns
function ReplyTarget_Register()
	if ( Cosmos_RegisterConfiguration ) then
		ReplyTarget_Register_Cosmos();
	else
		this:RegisterEvent("VARIABLES_LOADED");
	end
end

-- Handles events
function ReplyTarget_OnEvent(event)
	if ( event == "VARIABLES_LOADED" ) then
		if ( ReplyTarget_Cosmos_Registered == 0 ) then
		end
	end
end

function ReplyTarget_TargetLastWhisperer()
	local chatframe = DEFAULT_CHAT_FRAME;
	if ( chatframe == null ) then
		chatframe = getglobal("ChatFrame1");
	end
	if ( chatframe ~= null ) then
		local username = ChatEdit_GetLastTellTarget(chatframe.editBox)
		if ( strlen(username) > 0 ) then
			TargetByName(username);
		else
			ReplyTarget_Print("RT: Can not find a reply entry to target.");
		end
	end
end

-- Prints out text to a chat box.
function ReplyTarget_Print(msg,r,g,b,frame,id,unknown4th)
	if(unknown4th) then
		local temp = id;
		id = unknown4th;
		unknown4th = id;
	end
				
	if (not r) then r = 1.0; end
	if (not g) then g = 1.0; end
	if (not b) then b = 1.0; end
	if ( frame ) then 
		frame:AddMessage(msg,r,g,b,id,unknown4th);
	else
		if ( DEFAULT_CHAT_FRAME ) then 
			DEFAULT_CHAT_FRAME:AddMessage(msg, r, g, b,id,unknown4th);
		end
	end
end
