-- Run when the addon is loaded
function RightClickIgnore_OnLoad()
	-- Adds a popupbutton "action" with information.
	UnitPopupButtons["IGNORE"] = { text = TEXT(IGNORE), dist = 0 };
	RightClickIgnore_AddButton()

	-- Hooks the UnitPopup_OnClick function so we can interpret the new action
	RightClickIgnore_Saved_UnitPopup_OnClick = UnitPopup_OnClick;
	UnitPopup_OnClick = RightClickIgnore_UnitPopup_OnClick;
end

-- Inserts the popupbutton action into the FRIEND menu
-- which is used when we rightclick someone in chat window, too.
function RightClickIgnore_AddButton()
	
	-- Tries to find the INVITE action, and add the IGNORE action below that one.
	local n,i,index;
	n = table.getn(UnitPopupMenus["FRIEND"]);
	for i = 1, n do
		if ( UnitPopupMenus["FRIEND"][i] == "INVITE" ) then
			index = i;
			break;
		end
	end
	if ( index ) then
		table.insert(UnitPopupMenus["FRIEND"], "IGNORE");
		local tmp;
		for i = n+1, index+1, -1 do
			tmp = UnitPopupMenus["FRIEND"][i-1];
			UnitPopupMenus["FRIEND"][i-1] = UnitPopupMenus["FRIEND"][i];
			UnitPopupMenus["FRIEND"][i] = tmp;
		end
	else
		table.insert(UnitPopupMenus["FRIEND"], "IGNORE");
	end

end

-- Handles the IGNORE action.
function RightClickIgnore_UnitPopup_OnClick()
	local index = this.value;
	local dropdownFrame = getglobal(UIDROPDOWNMENU_INIT_MENU);
	local button = UnitPopupMenus[this.owner][index];
	local unit = dropdownFrame.unit;
	local name = dropdownFrame.name;
	
	if ( button == "IGNORE" ) then
		-- Toggles the ignored status of someone.
		AddOrDelIgnore(name);
		return;
	end
	return RightClickIgnore_Saved_UnitPopup_OnClick();
end

-- Runs the OnLoad function when the addon is, you know... loaded. :)
RightClickIgnore_OnLoad();
