RogueButton_Options_Default = {
	useExposeArmor = true;
	useRupture = false;
	useHemorrhage = true;
	useSliceDice = true;
	exposeArmorMinimumComboPoints = 3;
	exposeArmorMaximumComboPoints = MAX_COMBO_POINTS;
	exposeArmorMinimumHealth = 0.50;
	exposeArmorMinimumHealthMaxComboPoints = 0.25;
	ruptureMinimumComboPoints = 3;
	ruptureMaximumComboPoints = MAX_COMBO_POINTS;
	ruptureMinimumHealth = 0.50;
	sliceDiceMinimumComboPoints = 2;
	sliceDiceMaximumComboPoints = MAX_COMBO_POINTS;
	onlyEviscerateLevel = 20;
};

RogueButton_Options = {};

function RogueButton_OnLoad()
	if ( Khaos ) then
		RogueButton_Options_Khaos_OnLoad();
	end
	RogueButton_UpdateAura();
	RogueButton_UpdateEquipped();
	
	local f = RogueButtonFrame;
	f:RegisterEvent("UNIT_INVENTORY_CHANGED");
	f:RegisterEvent("PLAYER_AURAS_CHANGED");
	f:RegisterEvent("UNIT_AURA");
	f:RegisterEvent("VARIABLES_LOADED");
	f:RegisterEvent("PLAYER_TARGET_CHANGED");
end

function RogueButton_InStealth()
	local buff = nil;
	for i = 0, 15 do
		buff = GetPlayerBuffTexture(i);
		if ( buff ) and ( buff == "Interface\\Icons\\Ability_Stealth" ) then
			return true;
		end
	end
	return false;
end



RogueButton_GetSpellId = DynamicData.spell.getHighestSpellId;
RogueButton_Data = {};

function RogueButton_IsBoss()
	local isBoss = ( UnitClassification("target") == ONEHITWONDER_MOB_CLASSIFICATION_WORLDBOSS );
	if ( UnitLevel("target") == -1 ) then
		isBoss = true;
	end
	return isBoss;
end

function RogueButton_HandleStealth()
	local id = nil;
	if ( RogueButton_Data.hasDagger ) then
		if ( not id ) then
			id = RogueButton_GetSpellId(RB_AMBUSH);
		end
		if ( not id ) and ( not RogueButton_Data.isBoss ) then
			id = RogueButton_GetSpellId(RB_CHEAPSHOT);
		end
		if ( not id ) then
			id = RogueButton_GetSpellId(RB_GARROTE);
		end
		if ( not id ) then
			id = RogueButton_GetSpellId(RB_BACKSTAB);
		end
	else
		if ( not id ) and ( not RogueButton_Data.isBoss ) then
			id = RogueButton_GetSpellId(RB_CHEAPSHOT);
		end
		if ( not id ) then
			id = RogueButton_GetSpellId(RB_GARROTE);
		end
	end
	if ( id ) and ( RogueButton_IsSpellAvailable(id) ) then
		CastSpell(id, "spell");
		return true;
	else
		return false;
	end
end

function RogueButton_HasTargetDebuff(texture)
	if ( not texture ) then
		return false;
	end
	local debuff;
	if ( type(texture) == "table" ) then
		for i=1, MAX_TARGET_DEBUFFS do
			debuff = UnitDebuff("target", i);
			if ( debuff ) then 
				for k, v in texture do
					if ( v == debuff ) then
						return true;
					end
				end
			end
		end
	else
		for i=1, MAX_TARGET_DEBUFFS do
			debuff = UnitDebuff("target", i);
			if ( debuff ) and ( debuff == texture ) then
				return true;
			end
		end
	end
	return false;
end

RogueButton_TooltipLeftTexts = {
	RogueButtonTooltipTextLeft1,
	RogueButtonTooltipTextLeft2,
	RogueButtonTooltipTextLeft3,
	RogueButtonTooltipTextLeft4,
	RogueButtonTooltipTextLeft5,
	RogueButtonTooltipTextLeft6,
	RogueButtonTooltipTextLeft7,
	RogueButtonTooltipTextLeft8,
	RogueButtonTooltipTextLeft9,
	RogueButtonTooltipTextLeft10
};

RogueButton_TooltipRightTexts = {
	RogueButtonTooltipTextRight1,
	RogueButtonTooltipTextRight2,
	RogueButtonTooltipTextRight3,
	RogueButtonTooltipTextRight4,
	RogueButtonTooltipTextRight5,
	RogueButtonTooltipTextRight6,
	RogueButtonTooltipTextRight7,
	RogueButtonTooltipTextRight8,
	RogueButtonTooltipTextRight9,
	RogueButtonTooltipTextRight10
};

function RogueButton_HasDagger()
	local protTooltip = false;
	local hasDagger = false;
	if ( Sea ) and ( Sea.wow ) and ( Sea.wow.tooltip ) and ( Sea.wow.tooltip.protectTooltipMoney ) then
		protTooltip = true;
		Sea.wow.tooltip.protectTooltipMoney();
	end
	local hasItem, hasCooldown, repairCost = RogueButtonTooltip:SetInventoryItem("player", 16);
	if ( hasItem ) then
		local obj, str = nil;
		for i = 2, 4 do 
			obj = RogueButton_TooltipRightTexts[i];
			if ( obj ) and ( obj.GetText ) then
				str = obj:GetText();
				if ( str ) and ( strlen(str) > 0 ) then
					if ( str == RB_ITEM_TYPE_DAGGER ) then
						hasDagger = true;
					end
					break;
				end
			end
		end
	end
	if ( protTooltip ) then
		Sea.wow.tooltip.unprotectTooltipMoney();
	end
	return hasDagger;
end

function RogueButton_DoMaxComboPointsAction()
	local id = nil;
	local percHealth = UnitHealth("target")/UnitHealthMax("target");
	if ( not id ) and ( RogueButton_Options.useExposeArmor ) and ( not RogueButton_Data.isArmorReduced ) then 
		if ( percHealth > RogueButton_Options.exposeArmorMinimumHealthMaxComboPoints ) or ( RogueButton_Data.isBoss ) then
			id = RogueButton_GetSpellId(RB_EXPOSEARMOR);
		end
	end
	if ( not id ) and ( RogueButton_Options.useRupture ) and ( RogueButton_Options.ruptureMaximumComboPoints >= MAX_COMBO_POINTS ) and ( not RogueButton_Data.isRuptured ) and ( RogueButton_Data.isBoss ) then 
		if ( percHealth > RogueButton_Options.ruptureMinimumHealth ) then
			id = RogueButton_GetSpellId(RB_RUPTURE);
		end
	end
	if ( not id ) then 
		id = RogueButton_GetSpellId(RB_EVISCERATE);
	end
	if ( id ) then
		CastSpell(id, "spell");
		return true;
	end
	return false;
end

RogueButton_Last_DoPress = nil;

function RogueButton_DoPress()
	local curTime = GetTime();
	if ( RogueButton_Last_DoPress ) and ( curTime - RogueButton_Last_DoPress < 0.5 ) then
		return false;
	end
	local ret = RogueButton_HandlePress();
	if ( ret ) then
		RogueButton_Last_DoPress = curTime;
	end
	return ret;
end

RogueButton_IsSpellAvailable_Info = nil;

function RogueButton_IsSpellAvailable(spellId)
	if ( not spellId ) then
		return false;
	end
	RogueButton_IsSpellAvailable_Info = DynamicData.spell.getSpellInfo(spellId);
	local actionId = DynamicData.action.getSpellAsActionId(RogueButton_IsSpellAvailable_Info.name);
	if ( actionId ) and ( actionId > 0 ) then
		local isUsable, notEnoughMana = IsUsableAction(actionId);
		if ( ( isUsable ) and ( not notEnoughMana ) ) then
			return true;
		else
			return false;
		end
	end
	return true;
end

function RogueButton_Riposte()
	local id = RogueButton_GetSpellId(RB_RIPOSTE);
	if ( id ) then
		local start, duration, enable = GetSpellCooldown(id, "spell");
		if ( enable == 1 ) and ( start + duration <= 0 ) then
			CastSpell(id, "spell");
			return true;
		end
	end
	return false;
end

function RogueButton_JustRiposteSS()
	if ( not UnitExists("target") ) then
		return false;
	end
	if ( not UnitCanAttack("target", "player") ) then
		return false;
	end
	if ( RogueButton_Riposte() ) then
		return true;
	end
	local spellId = RogueButton_GetSpellId(RB_SINISTERSTRIKE);
	if ( spellId ) and ( RogueButton_IsSpellAvailable(spellId) ) then
		CastSpell(spellId, "spell");
		return true;
	end
	RogueButton_MeleeAttack();
	return false;
end


function RogueButton_HandlePress()
	if ( not UnitExists("target") ) then
		return false;
	end
	if ( not UnitCanAttack("target", "player") ) then
		return false;
	end
	local percHealth = UnitHealth("target")/UnitHealthMax("target");
	RogueButton_Data.isBoss = RogueButton_IsBoss();
	RogueButton_UpdateAura();
	if ( RogueButton_Data.inStealth ) then
		return RogueButton_HandleStealth();
	end
	if ( RogueButton_Riposte() ) then
		return true;
	end
	local spellId = nil;
	local cps = GetComboPoints();
	if ( cps >= MAX_COMBO_POINTS ) then
		if ( RogueButton_DoMaxComboPointsAction() ) then
			return true;
		end
		spellId = RogueButton_GetSpellId(RB_EVISCERATE);
	end
	if ( not spellId ) and ( cps >= 1 ) and ( UnitHealth("target")/UnitHealthMax("target") <= 0.10 ) then
		spellId = RogueButton_GetSpellId(RB_EVISCERATE);
	end
	local levelDiff = UnitLevel("target") - UnitLevel("player");


	if ( not spellId ) and ( levelDiff + RogueButton_Options.onlyEviscerateLevel <= 0 ) then
		if ( cps >= 2 ) then
			spellId = RogueButton_GetSpellId(RB_EVISCERATE);
		end
	end
	if ( not spellId ) and ( cps >= RogueButton_Options.sliceDiceMinimumComboPoints ) and ( cps <= RogueButton_Options.sliceDiceMaximumComboPoints ) and ( RogueButton_Options.useSliceDice ) and ( not RogueButton_Data.hasSliceDice ) and ( not RogueButton_Data.isBoss )then
		spellId = RogueButton_GetSpellId(RB_SLICEDICE);
	end
	if ( not spellId ) and ( cps >= RogueButton_Options.exposeArmorMinimumComboPoints ) and ( cps <= RogueButton_Options.exposeArmorMaximumComboPoints ) and ( RogueButton_Options.useExposeArmor ) and ( not RogueButton_Data.isBoss ) then
		if ( percHealth > RogueButton_Options.exposeArmorMinimumHealth ) and ( levelDiff > -5 ) then
			spellId = RogueButton_GetSpellId(RB_EXPOSEARMOR);
		end
	end
	if ( not spellId ) and ( cps >= RogueButton_Options.ruptureMinimumComboPoints ) and ( cps <= RogueButton_Options.ruptureMaximumComboPoints ) and ( RogueButton_Options.useRupture ) and ( not RogueButton_Data.isRuptured ) and ( not RogueButton_Data.isBoss ) then 
		if ( percHealth > RogueButton_Options.ruptureMinimumHealth ) and ( levelDiff > -5 ) then
			spellId = RogueButton_GetSpellId(RB_RUPTURE);
		end
	end
	if ( not spellId ) and ( RogueButton_Options.useHemorrhage ) then
		spellId = RogueButton_GetSpellId(RB_HEMORRHAGE);
	end
	if ( not spellId ) then
		spellId = RogueButton_GetSpellId(RB_SINISTERSTRIKE);
	end
	if ( spellId ) and ( RogueButton_IsSpellAvailable(spellId) ) then
		CastSpell(spellId, "spell");
		return true;
	end
	RogueButton_MeleeAttack();
	return false;
end

function RogueButton_UpdateEquipped()
	if ( RogueButton_Data.oldDaggerLink ) then
		local link = GetInventoryItemLink("player", 16);
		if ( link ~= RogueButton_Data.oldDaggerLink ) then
			RogueButton_Data.hasDagger = RogueButton_HasDagger();
			RogueButton_Data.oldDaggerLink = link;
		end
	else
		RogueButton_Data.hasDagger = RogueButton_HasDagger();
		RogueButton_Data.oldDaggerLink = GetInventoryItemLink("player", 16);
	end
end


RogueButton_UpdateAura_List = {
	hasSliceDice = RB_SLICEDICE_T,
	inStealth = RB_STEALTH_T,
};

function RogueButton_UpdateAura()
	for k, v in RogueButton_UpdateAura_List do
		RogueButton_Data[k] = false;
	end
	local buff = nil;
	for i = 0, 15 do
		buff = GetPlayerBuffTexture(i);
		if ( buff ) then
			for k, v in RogueButton_UpdateAura_List do
				if ( v == buff ) then
					RogueButton_Data[k] = true;
					break;
				end
			end
		end
	end
end

RogueButton_UpdateTargetAura_List = {
	isArmorReduced = RB_EXPOSE_ARMOR_TS,
	isRuptured = RB_RUPTURE_T,
};

function RogueButton_UpdateTargetAura()
	for k, v in RogueButton_UpdateAura_List do
		RogueButton_Data[k] = false;
	end
	local debuff = nil;			
	for i=1, MAX_TARGET_DEBUFFS do
		debuff = UnitDebuff("target", i);
		if ( debuff ) then 
			for k, v in RogueButton_UpdateAura_List do
				if ( type(v) == "table" ) then
					for key, texture in v do
						if ( texture == debuff ) then
							RogueButton_Data[k] = true;
							break
						end
					end
					if ( RogueButton_Data[k] ) then
						break;
					end
				else
					if ( v == debuff ) then
						RogueButton_Data[k] = true;
						break
					end
				end
			end
		end
	end
end


function RogueButton_OnEvent(event)
	if ( event == "PLAYER_TARGET_CHANGED" ) then
		RogueButton_Attacking = false;
		return;
	end
	if ( event == "UNIT_INVENTORY_CHANGED" ) then
		if ( arg1 == "player" ) then
			RogueButton_UpdateEquipped();
		end
		return;
	end
	if ( event == "UNIT_AURA" ) then
		if ( arg1 == "target" ) then
			RogueButton_UpdateTargetAura();
		end
		return;
	end
	if ( event == "PLAYER_AURAS_CHANGED" ) then
		RogueButton_UpdateAura();
		return;
	end
	if ( event == "VARIABLES_LOADED" ) then
		for k, v in RogueButton_Options_Default do
			if ( RogueButton_Options[k] == nil ) then
				RogueButton_Options[k] = v;
			end
		end
	end
end

RogueButton_AttackAction = nil;

function RogueButton_MeleeAttack()
	if ( RogueButton_AttackAction ) then
		if ( not IsAttackAction(RogueButton_AttackAction) ) then
			RogueButton_AttackAction = nil;
		end
	end
	local actionId = RogueButton_AttackAction;
	if ( not actionId ) then
		if ( DynamicData ) and ( DynamicData.action ) and ( DynamicData.action.getMatchingActionId ) then
			actionId = DynamicData.action.getMatchingActionId(RB_ATTACK_ACTION_NAME);
		else
			for i = 1, 120 do
				if ( IsAttackAction(i) ) then
					actionId = i;
					break;
				end
			end
		end
	end
	if ( actionId ) and ( IsAttackAction(actionId) ) then
		RogueButton_AttackAction = actionId;
		if ( IsCurrentAction(actionId) ) then
			RogueButton_Attacking = true;
		end
	end
	if ( not RogueButton_Attacking ) then
		AttackTarget();
		RogueButton_Attacking = true;
	end
end

