function RogueButton_UpdateValue(name, value, cosName)
	if ( not name ) then
		return false;
	end
	RogueButton_Options[name] = value;
	if ( cosName ) and ( AddOnHelper ) then
		if ( value == true ) then
			AddOnHelper_Generic_CosmosUpdateCheckOnOff(cosName, 1);
		elseif ( value == false ) or ( value == nil ) then
			AddOnHelper_Generic_CosmosUpdateCheckOnOff(cosName, 0);
		else
			AddOnHelper_Generic_CosmosUpdateValue(cosName, value);
		end
	end
end

function RogueButton_Get_Khaos_CheckBox(pid, pkey, ptext, phelptext, pcheck, cb)
	local option1 = {
		id = pid;
		key = pkey;
		text = ptext;
		helptext = phelptext;
		check = true;
		callback = cb;
		type = K_TEXT;
		feedback = function(state) local s = ROGUEBUTTON_STATE_ENABLED; if ( not state.checked ) then s = ROGUEBUTTON_STATE_DISABLED; end return s; end;
		default = {
			checked = pcheck;
		};
		disabled = {
			checked = false;
		};
	};
	return option1;
end

RogueButton_Folder = {
	id = "RogueButtonFolderID";
	text = "Rogue Button";
	helptext = "Rogue Button allows a button to work like Sinister Strike, Hemorrhage, Riposte, Eviscerate, Rupture, Expose Armor, Backstab, Ambush, Garrote and Cheap Shot";
	default = true,
	difficulty = 1;
};
function RogueButton_Register_Khaos()
	if ( not Khaos ) then
		return false;
	end
	Khaos.registerFolder(RogueButton_Folder);

	local optionSetEasy = {
		id = "RogueButtonEasyOptionsID";
		text = "Basic";
		helptext = "Basic options";
		difficulty = 1;
		options = {};
		default = true;
	};

	local cb = function(state) RogueButton_UpdateValue("useExposeArmor", state.checked, "COS_ROGUEBUTTON_USE_EXPOSE_ARMOR"); end;
	table.insert(optionSetEasy.options, RogueButton_Get_Khaos_CheckBox("CheckBoxUseExposeArmor", "useExposeArmor", "Allow Expose Armor", "Allows Expose Armor to be used by the RogueButton", true, cb));
	local cb2 = function(state) RogueButton_UpdateValue("useRupture", state.checked, "COS_ROGUEBUTTON_USE_RUPTURE"); end;
	table.insert(optionSetEasy.options, RogueButton_Get_Khaos_CheckBox("CheckBoxUseRupture", "useRupture", "Allow Rupture", "Allows Rupture to be used by the RogueButton", false, cb2));
	local cb3 = function(state) RogueButton_UpdateValue("useHemorrhage", state.checked, "COS_ROGUEBUTTON_USE_HEMORRHAGE"); end;
	table.insert(optionSetEasy.options, RogueButton_Get_Khaos_CheckBox("CheckBoxUseHemorrhage", "useHemorrhage", "Allow Hemorrhage", "Allows Hemorrhage to be used by the RogueButton", true, cb3));
	Khaos.registerOptionSet( RogueButton_Folder.id, optionSetEasy );
	return true;
end


function RogueButton_Options_Khaos_OnLoad()
	RogueButton_Register_Khaos();
end