-- SmartBuff_Sarf.lua patch
-- Version 1.1

-- Casts a spell
function SMARTBUFF_doCast(unit, id, actionSlot, levels, type)
  if (id == nil) then return 9; end
  if (type == SMARTBUFF_CONST_GROUP and actionSlot == nil) then return 8; end
  if (type == SMARTBUFF_CONST_TRACK and GetTrackingTexture()) then 
    local iconTrack = GetTrackingTexture();
    --SMARTBUFF_AddMsgD("Track already enabled: " .. iconTrack);
    return 7; 
  end
  	
	-- check if spell has cooldown
	local _, cd = GetSpellCooldown(id, SMARTBUFF_BOOK_TYPE_SPELL)
	if ( not cd ) then
	elseif (cd > maxSkipCoolDown) then
	  return 4;
  elseif (cd > 0) then 
    return 1;
  end
    -- Rangecheck
	if ( not UnitIsVisible(unit) ) or ( not CheckInteractDistance(unit, 4) ) then
		return 3;
	end
	id = SMARTBUFF_CheckUnitLevel(unit, id, levels);
	-- check if target is to low for this spell
	if (id == nil) then
	  return 5;
	end
  
  if (actionSlot ~= nil) then
    -- check if you have enough mana to cast
    local isUsable, notEnoughMana = IsUsableAction(actionSlot);
    if (notEnoughMana) then
      return 6;
    end
  end
  
  local oldTarget = nil;
  local oldTargetWasPlayer = nil;
  if (type == SMARTBUFF_CONST_GROUP ) then
    if ( ( unit~="player" ) ) and ( not UnitIsUnit("target", unit) ) and ( not UnitIsEnemy("player", "target") ) then
    	oldTargetWasPlayer = UnitIsPlayer("target");
    	oldTarget=UnitName("target");
    	SmartBuff_InhibitTargetCasting();
    	ClearTarget();
    	SmartBuff_RestoreTargetCasting();
    end
  end

  local onSelf = nil;
  if ( ( unit == "player" ) or ( type == SMARTBUFF_CONST_FORCESELF ) ) then
  	onSelf = 1;
  end
  if ( actionSlot ) then
  	UseAction(actionSlot, 0, onSelf);
  else
   	CastSpell(id, SMARTBUFF_BOOK_TYPE_SPELL, onSelf);
  end
  if ( not onSelf ) and ( SpellIsTargeting() ) then 
  	SpellTargetUnit(unit);
    --return 10;
  end
  if (oldTarget) then
  	SmartBuff_InhibitTargetCasting();
  	if ( oldTargetWasPlayer ) then
  		TargetByName(oldTarget, 1);
  	else
  		TargetLastTarget();
	  	--TargetUnit("playertarget")
  	end
	SmartBuff_RestoreTargetCasting();
  	oldTarget = nil;
  end
  
  return 0;
end

function SmartBuff_InhibitTargetCasting()
	if ( not SMARTBUFF_Options ) then return; end
	if ( SMARTBUFF_Options.OldTargetSwitch == nil ) then
		SMARTBUFF_Options.OldTargetSwitch = SMARTBUFF_Options.TargetSwitch;
	end
end

function SmartBuff_RestoreTargetCasting()
	if ( not SMARTBUFF_Options ) then return; end
	if ( SMARTBUFF_Options.OldTargetSwitch ~= nil ) then
		SMARTBUFF_Options.TargetSwitch = SMARTBUFF_Options.OldTargetSwitch;
		SMARTBUFF_Options.OldTargetSwitch = nil;
	end
end

SMARTBUFF_Options_Init_Old = SMARTBUFF_Options_Init;
function SMARTBUFF_Options_Init()
	local a,b,c = SMARTBUFF_Options_Init_Old();
	local timer = SMARTBUFF_Options.BlacklistTimer;
	if ( timer == nil ) or ( timer == 30 ) then SMARTBUFF_Options.BlacklistTimer = 10; end
	return a,b,c;
end
