--[[
	Weapon Buttons

	By sarf

	This mod ...

	Thanks goes to 
	
	CosmosUI URL:
	http://www.cosmosui.org/forums/viewtopic.php?t=
	
   ]]


-- Constants

-- Variables
WeaponButtons_Enabled = 0;

WeaponButtons_Cosmos_Registered = 0;

-- executed on load, calls general set-up functions
function WeaponButtons_OnLoad()
	WeaponButtons_Register();
end

-- registers the mod with Cosmos
function WeaponButtons_Register_Cosmos()
	if ( ( Cosmos_RegisterConfiguration ) and ( WeaponButtons_Cosmos_Registered == 0 ) ) then
		Cosmos_RegisterConfiguration(
			"COS_WEAPONBUTTONS",
			"SECTION",
			TEXT(WEAPONBUTTONS_CONFIG_HEADER),
			TEXT(WEAPONBUTTONS_CONFIG_HEADER_INFO)
		);
		Cosmos_RegisterConfiguration(
			"COS_WEAPONBUTTONS_HEADER",
			"SEPARATOR",
			TEXT(WEAPONBUTTONS_CONFIG_HEADER),
			TEXT(WEAPONBUTTONS_CONFIG_HEADER_INFO)
		);
		Cosmos_RegisterConfiguration(
			"COS_WEAPONBUTTONS_ENABLED",
			"CHECKBOX",
			TEXT(WEAPONBUTTONS_ENABLED),
			TEXT(WEAPONBUTTONS_ENABLED_INFO),
			WeaponButtons_Toggle_Enabled,
			WeaponButtons_Enabled
		);
		WeaponButtons_Cosmos_Registered = 1;
	end
end

-- registers the mod with the system, integrating it with slash commands and "master" AddOns
function WeaponButtons_Register()
	if ( Cosmos_RegisterConfiguration ) then
		WeaponButtons_Register_Cosmos();
	else
		SlashCmdList["WEAPONBUTTONSSLASHENABLE"] = WeaponButtons_Enable_ChatCommandHandler;
		SLASH_WEAPONBUTTONSSLASHENABLE1 = "/modnametoggle";
		SLASH_WEAPONBUTTONSSLASHENABLE2 = "/mntoggle";
		SLASH_WEAPONBUTTONSSLASHENABLE3 = "/modnameenable";
		SLASH_WEAPONBUTTONSSLASHENABLE4 = "/mnenable";
		SLASH_WEAPONBUTTONSSLASHENABLE5 = "/modnamedisable";
		SLASH_WEAPONBUTTONSSLASHENABLE6 = "/mndisable";
		this:RegisterEvent("VARIABLES_LOADED");
	end

	if ( Cosmos_RegisterChatCommand ) then
		local WeaponButtonsEnableCommands = {"/modnametoggle","/mntoggle","/modnameenable","/mnenable","/modnamedisable","/mndisable"};
		Cosmos_RegisterChatCommand (
			"WEAPONBUTTONS_ENABLE_COMMANDS", -- Some Unique Group ID
			WeaponButtonsEnableCommands, -- The Commands
			WeaponButtons_Enable_ChatCommandHandler,
			WEAPONBUTTONS_CHAT_COMMAND_ENABLE_INFO -- Description String
		);
	end
end

-- Handles chat - e.g. slashcommands - enabling/disabling the WeaponButtons
function WeaponButtons_Enable_ChatCommandHandler(msg)
	msg = string.lower(msg);
	
	-- Toggle appropriately
	if ( (string.find(msg, 'on')) or ((string.find(msg, '1')) and (not string.find(msg, '-1')) ) ) then
		WeaponButtons_Toggle_Enabled(1);
	else
		if ( (string.find(msg, 'off')) or (string.find(msg, '0')) ) then
			WeaponButtons_Toggle_Enabled(0);
		else
			WeaponButtons_Toggle_Enabled(-1);
		end
	end
end

-- Handles events
function WeaponButtons_OnEvent(event)
	if ( event == "VARIABLES_LOADED" ) then
		if ( WeaponButtons_Cosmos_Registered == 0 ) then
			local value = getglobal("COS_WEAPONBUTTONS_ENABLED_X");
			if (value == nil ) then
				-- defaults to off
				value = 0;
			end
			WeaponButtons_Toggle_Enabled(value);
		end
	end
end

-- Toggles the enabled/disabled state of an option and returns the new state
--  if toggle is 1, it's enabled
--  if toggle is 0, it's disabled
--   otherwise, it's toggled
function WeaponButtons_Generic_Toggle(toggle, variableName, CVarName, enableMessage, disableMessage, CosmosVarName)
	local oldvalue = getglobal(variableName);
	local newvalue = toggle;
	if ( ( toggle ~= 1 ) and ( toggle ~= 0 ) ) then
		if (oldvalue == 1) then
			newvalue = 0;
		elseif ( oldvalue == 0 ) then
			newvalue = 1;
		else
			newvalue = 0;
		end
	end
	setglobal(variableName, newvalue);
	setglobal(CVarName, newvalue);
	if ( newvalue ~= oldvalue ) then
		if ( newvalue == 1 ) then
			WeaponButtons_Print(TEXT(getglobal(enableMessage)));
		else
			WeaponButtons_Print(TEXT(getglobal(disableMessage)));
		end
	end
	WeaponButtons_Register_Cosmos();
	if ( WeaponButtons_Cosmos_Registered == 0 ) then 
		RegisterForSave(variableName);
	else
		if ( CosmosVarName ) then
			Cosmos_UpdateValue(strsub(CVarName, 1, strlen(CVarName)-2), CSM_CHECKONOFF, newvalue);
		end
	end
	return newvalue;
end

-- Toggles the enabled/disabled state of the WeaponButtons
--  if toggle is 1, it's enabled
--  if toggle is 0, it's disabled
--   otherwise, it's toggled
function WeaponButtons_Toggle_Enabled(toggle)
	local newvalue = WeaponButtons_Generic_Toggle(toggle, "WeaponButtons_Enabled", "COS_WEAPONBUTTONS_ENABLED_X", "WEAPONBUTTONS_CHAT_ENABLED", "WEAPONBUTTONS_CHAT_DISABLED");
	if ( newvalue == 1 ) then
		WeaponButtonsFrame:Show();
	else
		WeaponButtonsFrame:Hide();
	end
end

-- Prints out text to a chat box.
function WeaponButtons_Print(msg,r,g,b,frame,id,unknown4th)
	if(unknown4th) then
		local temp = id;
		id = unknown4th;
		unknown4th = id;
	end
				
	if (not r) then r = 1.0; end
	if (not g) then g = 1.0; end
	if (not b) then b = 1.0; end
	if ( frame ) then 
		frame:AddMessage(msg,r,g,b,id,unknown4th);
	else
		if ( DEFAULT_CHAT_FRAME ) then 
			DEFAULT_CHAT_FRAME:AddMessage(msg, r, g, b,id,unknown4th);
		end
	end
end

function WeaponButton_GetInventoryInfoSlotName(slotName)
	local inventorySlotInfoName = slotName;
	local charIndex = strfind(inventorySlotInfoName, "Character");
	if ( charIndex ) then inventorySlotInfoName = strsub(inventorySlotInfoName, charIndex); end
	inventorySlotInfoName = strsub(inventorySlotInfoName,10);
	return inventorySlotInfoName;
end

function WeaponButtonPaperDollItemSlotButton_OnLoad()
	this:RegisterEvent("UNIT_INVENTORY_CHANGED");
	this:RegisterEvent("ITEM_LOCK_CHANGED");
	this:RegisterEvent("CURSOR_UPDATE");
	this:RegisterEvent("BAG_UPDATE_COOLDOWN");
	this:RegisterEvent("SHOW_COMPARE_TOOLTIP");
	this:RegisterEvent("UPDATE_INVENTORY_ALERTS");
	this:RegisterForDrag("LeftButton");
	this:RegisterForClicks("LeftButtonUp", "RightButtonUp");
	local slotName = this:GetName();
	local id;
	local textureName;

	id, textureName = GetInventorySlotInfo(WeaponButton_GetInventoryInfoSlotName(slotName));
	
	this:SetID(id);
	local texture = getglobal(slotName.."IconTexture");
	texture:SetTexture(textureName);
	this.backgroundTextureName = textureName;
	PaperDollItemSlotButton_Update();
end


function WeaponButtonPaperDollItemSlotButton_OnEnter()
	GameTooltip:SetOwner(this, "ANCHOR_RIGHT");
	local hasItem, hasCooldown, repairCost = GameTooltip:SetInventoryItem("player", this:GetID());
    if ( not hasItem ) then
		GameTooltip:SetText(TEXT(getglobal(strupper(WeaponButton_GetInventoryInfoSlotName(this:GetName())))));
	end
	if ( hasCooldown ) then
		this.updateTooltip = TOOLTIP_UPDATE_TIME;
	else
		this.updateTooltip = nil;
	end
--	if ( MerchantFrame:IsVisible() ) then
--		ShowInventorySellCursor(this:GetID());
--	end
	if ( InRepairMode() and repairCost and (repairCost > 0) ) then
		GameTooltip:AddLine(TEXT(REPAIR_COST), "", 1, 1, 1);
		SetTooltipMoney(GameTooltip, repairCost);
		GameTooltip:Show();
	end
end

